<?php

namespace App\Events;

use Illuminate\Broadcasting\Channel;
use Illuminate\Queue\SerializesModels;
use Illuminate\Broadcasting\PrivateChannel;
use Illuminate\Broadcasting\PresenceChannel;
use Illuminate\Foundation\Events\Dispatchable;
use Illuminate\Broadcasting\InteractsWithSockets;
use Illuminate\Contracts\Broadcasting\ShouldBroadcast;

class DiscussChatEvent implements ShouldBroadcast
{
    use Dispatchable, InteractsWithSockets, SerializesModels;

		public $alldata;
		public $meetid;
    /**
     * Create a new event instance.
     *
     * @return void
     */
    public function __construct($meetid,$alldata)
    {
        $this->alldata = $alldata;
		$this->meetid = $meetid;
        $this->dontBroadcastToCurrentUser();
    }

    /**
     * Get the channels the event should broadcast on.
     *
     * @return \Illuminate\Broadcasting\Channel|array
     */
    public function broadcastOn()
    {
		$meetid =  $this->meetid;
		$channelname = "discusmeetchat.".$meetid;
        return new Channel($channelname);
		 
       /* return new PrivateChannel('channel-name');*/
    }
}
