<?php
date_default_timezone_set("Asia/Kolkata");
?>
<html>
<head>
<title>Pareto Chart - <?php echo e(ucfirst($meeting_by->meeting_name)); ?></title>
<link rel="stylesheet" href="<?php echo e(url('user/css/bootstrap.min.css')); ?>">
<link rel="stylesheet" href="<?php echo e(url('user/css/style.css')); ?>">
<link rel="stylesheet" href="<?php echo e(url('user/css/responsive.css')); ?>">
<link rel="stylesheet" href="<?php echo e(url('user/css/font-awesome.min.css')); ?>">
<link type="text/css" rel="stylesheet" href="<?php echo e(url('user/css/barchart.css')); ?>"/>

<style>
.chart-container {
      font-family: 'Open Sans Condensed', sans-serif;
      background-color: #fafafa;
    }
.titlebg {
	background-color:#CCCCCC;
	text-transform:uppercase;
	color:#000000;
}
table#fishbone, table#fishbone td {
	border: none;
}



/** 
                Set the margins of the page to 0, so the footer and the header
                can be of the full height and width !
             **/
            @page  {
 margin: 0cm 0cm;
}
/** Define now the real margins of every page in the PDF **/
            body {
}
/** Define the header rules **/
            header {
	position: fixed;
	top: 0cm;
	left: 0cm;
	right: 0cm;
	height: 2cm;
	/** Extra personal styles **/
                background-color: #ffffff;
	color: white;
	text-align: center;
	line-height: 1.5cm;
	text-align: left;
	padding-left:80px;
}
/** Define the footer rules **/
            footer {
	position: fixed;
	bottom: 0cm;
	left: 0cm;
	right: 0cm;
	height: 3cm;
	/** Extra personal styles **/
                background-color: #F60;
	color: #ffffff;
	text-align: left;
	padding-left:80px;
	/*border-top: 1px solid #000000;*/ font-size:16px;
}
#footer .page:after {
	content: counter(page, upper-roman);
}
.page-break {
	page-break-inside: auto;
}
td {
	font-size:16px;
}
p {
	color:#000000;
}
.content2 {
	word-wrap:break-word; /*old browsers*/
	overflow-wrap:break-word;
}
.overflow-wrap-hack {
	max-width:1px;
}
table {
	table-layout: fixed;
}
table td {
	word-wrap:break-word;
}
</style>
</head>
<body>
<?php if($alltopicvotes_count != 0): ?>
<input type="text" name="p_meeting_name" id="p_meeting_name" value="Fish Bone - <?php echo e(ucfirst($meeting_by->meeting_name)); ?>" style="display:none"/>
<p align="right"><a id="btn-Convert-Html2Image" href="javascript:void(0);" style="color:#ffffff;" class="btn"><strong>Download as Image</strong></a></p>
<div id="previewImage" style="display:none"></div><?php endif; ?>

<table width="100%" border="0" cellspacing="0" cellpadding="0" id="html-content-holder">
<?php if($alltopicvotes_count != 0): ?>
<tr>
<td align="center"><div id="chart-example-1"></div></td>
</tr>
<?php else: ?>
<tr>
<td align="center">Sorry no details available.</td>
</tr>
<?php endif; ?>
</table>
<script src="<?php echo e(url('user/js/jquery.js')); ?>"></script>
<script src="<?php echo e(url('user/js/html2canvas.js')); ?>"></script>
<script src="<?php echo e(url('user/js/barchart.js')); ?>"></script>
<script>
  $( document ).ready(function() {

  const chart1 = document.getElementById('chart-example-1');
  const data1 =  <?php echo $forchart; ?>;

  createBarChart(data1, chart1);

  var element = $("#html-content-holder"); // global variable
  var getCanvas; // global variable
 
  html2canvas(element, {
    onrendered: function (canvas) {
      $("#previewImage").append(canvas);
      getCanvas = canvas;
    }
  });

	$("#btn-Convert-Html2Image").on('click', function () {
	var mn = $('#p_meeting_name').val()+'.png';
	
    var imgageData = getCanvas.toDataURL("image/png");
    // Now browser starts downloading it instead of just showing it
    var newData = imgageData.replace(/^data:image\/png/, "data:application/octet-stream");
    $("#btn-Convert-Html2Image").attr("download", mn).attr("href", newData);
	});

});
</script>
</body>
</html>
<?php /**PATH /home/bwjqfxmy/public_html/staging/resources/views/user/paretoanalysis.blade.php ENDPATH**/ ?>