<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use App\Http\Controllers\Controller;
use DB;
use Mail;
use Carbon\Carbon;
use net\authorize\api\contract\v1 as AnetAPI;
use net\authorize\api\controller as AnetController;

class FacilitatorsController extends Controller
{

public function choice(Request $request)
	{
		$user_info = $this->userdetails();
		if($user_info->user_status != 0)
		{
			if(session('lcbuser_status') == 2)
			{
				return redirect('/beforeyoustart');
			}
			else if(session('lcbuser_status') == 3)
			{
				return redirect('/subscription');
			}										
			else if(session('lcbuser_status') == 1)
			{
				return redirect('/verification');
			}
			else
			{
				return redirect('/home');
			}			
		}
		if($request->id != '')
		{
			$vcode = $this->VerificationCode(5);
			if($request->id == 'Facilitator')
			{
/*			$values = array('user_type' => '1','user_token' => $vcode,'user_status' => '2');
			DB::table('siteusers')->where([["user_id","=",session('lcbuser_id')]])->update($values);*/
			DB::update('CALL updateUser (?,?,?,?)',array(1,$vcode,2,session('lcbuser_id')));
			return redirect('beforeyoustart');				
			}
			else
			{
			/*$values = array('user_type' => '2','user_token' => $vcode,'user_status' => '1');
			DB::table('siteusers')->where([["user_id","=",session('lcbuser_id')]])->update($values);*/
			DB::update('CALL updateUser (?,?,?,?)',array(2,$vcode,1,session('lcbuser_id')));
			
			//$userinfo = DB::table('siteusers')->where([["user_id","=",session('lcbuser_id')]])->first();	
			
			$user_info1 =  DB::select('CALL  getUserByID(?)',array(session('lcbuser_id')));	
			$userinfo = $user_info1[0];			
			// send mail
			$sdata2['m_name'] = $userinfo->user_name;
			$sdata2['m_emailid'] = $userinfo->user_emailid;
			$sdata2['m_code'] = $vcode;
			
			Mail::send('mail.mail_register', $sdata2, function($message) use ($sdata2) {
			$subject = "Use ".$sdata2['m_code']." to validate your Lean Coffee Brew email address";
			$message->to($sdata2['m_emailid'],$sdata2['m_name'])->subject($subject);
			});					
			// send mail			
			return redirect('verification');									
			}
		}
		return view('user/choice');
	}
	
	
	public function beforeyoustart()
	{
		$user_info = $this->userdetails();
		if($user_info->user_status != 2)
		{
			if(session('lcbuser_status') == 0)
			{
				return redirect('/choice');
			}
			else if(session('lcbuser_status') == 3)
			{
				return redirect('/subscription');
			}										
			else if(session('lcbuser_status') == 1)
			{
				return redirect('/verification');
			}
			else
			{
				return redirect('/home');
			}			
		}	
		return view('user/beforeyoustart');
	}
	
	public function attendeesubscription(Request $request)
	{
		if($request->isMethod("post"))
		{
			$user_info = $this->userdetails();
			// 30 days free trail date informations
			$startdate = date("Y-m-d");
			$enddate = date('Y-m-d', strtotime('+30 days'));
			// 30 days free trail date informations		
			
			if($request->pcount == '' and $request->pprice == '')
			{
				$fcount = 1;
				$fprice = 10;
			}
			else
			{
				$fcount = $request->pcount;
				$fprice = $request->pprice;				
			}
			
			$values = array('user_ftype' => '0','user_type' => '1');
			DB::table('siteusers')->where([["user_id","=",session('lcbuser_id')]])->update($values);
			session()->put('lcbuser_ftype',0);	
				
			//DB::table('subscription')->insert(['suserid' => session('lcbuser_id'),'snofacilitators' => $fcount,'stotalprice' => $fprice,'sbilling' => $request->billing,'sstart_date' => $startdate,'send_date' => $enddate,'trial_end_date' => $enddate,'sstatus' => '1','activefacilitator_count' => '1']);
			
			DB::insert('CALL addSubscription(?,?,?,?,?,?,?,?,?)',array(session('lcbuser_id'),$fcount,$fprice,$request->billing,$startdate,$enddate,$enddate,'1','1'));
						
			return redirect('home');							
		}
		$data['allsubscriptions'] = DB::table('prices')->where('pstatus','1')->orderBy('pid','ASC')->get();
		$data['pinfo'] = DB::table('prices')->where('pstatus','1')->where('pid','1')->first();		
		return view('user/attendeesubscription',$data);
	}
	
	public function customersubscription(Request $request)
	{
		if($request->isMethod("post"))
		{
			$user_info = $this->userdetails();
			// 30 days free trail date informations
			$startdate = date("Y-m-d");
			$enddate = date('Y-m-d', strtotime('+30 days'));
			// 30 days free trail date informations		
			
			if($request->pcount == '' and $request->pprice == '')
			{
				$fcount = 1;
				$fprice = 10;
			}
			else
			{
				$fcount = $request->pcount;
				$fprice = $request->pprice;				
			}
			
			$us_type = $user_info->user_ftype;
			$us_subscription_count = DB::table('subscription')->where('suserid',$us_type)->count();
			if($us_subscription_count != 0)
			{
			$us_subscription = DB::table('subscription')->where('suserid',$us_type)->first();
			$activefacilitator_count = $us_subscription->activefacilitator_count;
			$new_activefacilitator_count = $activefacilitator_count - 1;

			$values = array('activefacilitator_count' => $new_activefacilitator_count);
			DB::table('subscription')->where("suserid","=",$us_type)->update($values);
			}			
			
			$values = array('user_ftype' => '0');
			DB::table('siteusers')->where([["user_id","=",session('lcbuser_id')]])->update($values);
			session()->put('lcbuser_ftype',0);
						
			//DB::table('subscription')->insert(['suserid' => session('lcbuser_id'),'snofacilitators' => $fcount,'stotalprice' => $fprice,'sbilling' => $request->billing,'sstart_date' => $startdate,'send_date' => $enddate,'trial_end_date' => $enddate,'sstatus' => '1','activefacilitator_count' => '1']);
			
			DB::insert('CALL addSubscription(?,?,?,?,?,?,?,?,?)',array(session('lcbuser_id'),$fcount,$fprice,$request->billing,$startdate,$enddate,$enddate,'1','1'));
			
			// remove from request table
			DB::table('facilitators_request')->where('remailid',$user_info->user_emailid)->delete();
			// remove from request table
			
			// add to deleted table
			$todaydate = date("Y-m-d");
			DB::table('facilitators_deleted_request')->insert(['ruserid' => $user_info->user_ftype,'remailid' => $user_info->user_emailid,'rdate' => $todaydate]);			
			// add to deleted table
			
			return redirect('home');
				
				
		}
		
		$data['allsubscriptions'] = DB::table('prices')->where('pstatus','1')->orderBy('pid','ASC')->get();
		$data['pinfo'] = DB::table('prices')->where('pstatus','1')->where('pid','1')->first();		
		return view('user/customersubscription',$data);
	}
	

	public function upgrade_subscription(Request $request)
	{
	

		$this->updateusertime();
		$user_info = $this->userdetails();
		if($request->isMethod("post"))
		{
		

			$data['subscription_info'] = $this->subscriptiondetails();
			
			if($data['subscription_info']->sbilling != 1)
			{
				$data['pinfo'] = DB::table('prices')->where('pcount','>=',$data['subscription_info']->snofacilitators)->first();
			}
			else
			{
				$data['pinfo'] = DB::table('prices')->where('pcount','>',$data['subscription_info']->snofacilitators)->first();
			}

			if($request->pcount == '' and $request->pprice == '')
			{
				
				$fcount = $data['pinfo']->pcount;
				$fprice = $request->wrefprice;				
				//$onedayprice =  number_format(($fprice/30),3); // one day price					
			}
			else
			{
				$fcount = $request->pcount;
				$fprice = $request->pprice;
				//$onedayprice =  number_format(($fprice/30),3); // one day price					
			}

			// to find new price

				if($data['subscription_info']->sbilling == 1)
				{
					$onedayprice =  $data['subscription_info']->stotalprice/365;
				}
				else
				{
					
					if($data['subscription_info']->sbilling == 0)
					{
						$onedayprice =  $data['subscription_info']->stotalprice/30;
					}
					if($data['subscription_info']->sbilling == 3)
					{
						$onedayprice =  $data['subscription_info']->stotalprice/90;
					}
					if($data['subscription_info']->sbilling == 6)
					{
						$onedayprice =  $data['subscription_info']->stotalprice/180;
					}										
					if($data['subscription_info']->sbilling == 9)
					{
						$onedayprice =  $data['subscription_info']->stotalprice/270;
					}					
					
				}
				
				
				
				$start_date = date("Y-m-d");
				$trial_checking = DB::table('subscription')->where([["suserid","=",session('lcbuser_id')]])->where('trial_end_date', '>', $start_date)->count();
				if($trial_checking == 0)
				{
					$start_date1 = date("Y-m-d");
					$end_date = $data['subscription_info']->send_date;
				}
				else
				{
					$start_date1 = $data['subscription_info']->trial_end_date;
					$end_date = $data['subscription_info']->send_date;
				}
				
				
 				
 				$dateDiff = $this->dateDifference($start_date1, $end_date);	


				
				
				$to_minus_price2 = number_format(($dateDiff * $onedayprice),2);
				
				$to_minus_price = str_replace(",","",$to_minus_price2);
				
				$final_price2 = number_format(($fprice - $to_minus_price),2);

				$final_price = str_replace(",","",$final_price2);
				
				
			// to find new price
			
			
		$data['new_price'] = $final_price;
		
		$em = explode("___",$request->no_facilitators);
		
		$data['ord_no'] = $this->VerificationCode(10);
		session()->put('authord_no',$data['ord_no']);		
				DB::table('upgrade_subscription_payment')->insert(['pay_user_id' => session('lcbuser_id'),'pay_order_number' => $data['ord_no'],'pay_payment_date' => '',
		'pay_status' => '0','pay_trans_id' => '','pay_current_suscription' => $data['subscription_info']->snofacilitators,'pay_no_baristas' => $em[0],'pay_billed_choice' => $request->billing,'pay_count' => $fcount,'pay_paid_amount' => $data['new_price'],'pay_amount' => $fprice]);	
		
		if($request->upgradepayviatype_new == 1)
		{	
		

		
		
		return view('user/upgradepaypalpayment',$data);
		}
		else
		{
			// authorise.net payment starts here
			
			


        $input = $request->input();
        
        /* Create a merchantAuthenticationType object with authentication details
          retrieved from the constants file */
        $merchantAuthentication = new AnetAPI\MerchantAuthenticationType();
        $merchantAuthentication->setName('6uy6eQ2UVa2');
        $merchantAuthentication->setTransactionKey('525de4649MKjzFA5');

        // Set the transaction's refId
        $refId = $data['ord_no'];
        $cardNumber = $input['cardNumber'];
        
        // Create the payment data for a credit card
        $creditCard = new AnetAPI\CreditCardType();
        $creditCard->setCardNumber($cardNumber);
        $creditCard->setExpirationDate($input['expiration-year'] . "-" .$input['expiration-month']);
        $creditCard->setCardCode($input['cvv']);

        // Add the payment data to a paymentType object
        $paymentOne = new AnetAPI\PaymentType();
        $paymentOne->setCreditCard($creditCard);

        // Create a TransactionRequestType object and add the previous objects to it
        $transactionRequestType = new AnetAPI\TransactionRequestType();
        $transactionRequestType->setTransactionType("authCaptureTransaction");
        $transactionRequestType->setAmount($final_price);
        $transactionRequestType->setPayment($paymentOne);

        // Assemble the complete transaction request
        $requests = new AnetAPI\CreateTransactionRequest();
        $requests->setMerchantAuthentication($merchantAuthentication);
        $requests->setRefId($refId);
        $requests->setTransactionRequest($transactionRequestType);

        // Create the controller and get the response
        $controller = new AnetController\CreateTransactionController($requests);
        $response = $controller->executeWithApiResponse(\net\authorize\api\constants\ANetEnvironment::SANDBOX);

        if ($response != null) {
		
		
            // Check to see if the API request was successfully received and acted upon
            if ($response->getMessages()->getResultCode() == "Ok") {
                // Since the API request was successful, look for a transaction response
                // and parse it to display the results of authorizing the card
                $tresponse = $response->getTransactionResponse();

                if ($tresponse != null && $tresponse->getMessages() != null) {
                    
                    $msg_type = "success_msg";
					    
                    // when successful payment
					
				$payment_date = date("Y-m-d");	


				$payment_date = date("Y-m-d");	
			$values = array('pay_trans_id' => $tresponse->getTransId(),'pay_payment_date' => $payment_date,'pay_status' => '1');
			DB::table('upgrade_subscription_payment')->where([["pay_order_number","=",session('authord_no')]])->update($values);	
			$ptime = time();

			

		
					
			
			// to change upgrade subscription
			$sub_details = DB::table('upgrade_subscription_payment')->where("pay_order_number","=",session('authord_no'))->first();
			$st_date = date("Y-m-d");
			if($sub_details->pay_billed_choice != 1)
			{
				$last_enddate = DB::table('subscription')->where([["suserid","=",session('lcbuser_id')]])->first();
				
				// find user in trial or not
				$trial_checking = DB::table('subscription')->where([["suserid","=",session('lcbuser_id')]])->where('trial_end_date', '>', $st_date)->count();
				// find user in trial or not
				if($trial_checking == 0)
				{
					$start_date1 = date("Y-m-d");
					if($sub_details->pay_billed_choice == 0)
					{
						$hdays = '+30 days';$hdayinfo = 30;
					}
					if($sub_details->pay_billed_choice == 3)
					{
						$hdays = '+90 days';$hdayinfo = 90;
					}
					if($sub_details->pay_billed_choice == 6)
					{
						$hdays = '+180 days';$hdayinfo = 180;
					}
					if($sub_details->pay_billed_choice == 9)
					{
						$hdays = '+270 days';$hdayinfo = 270;
					}										
					
				}
				else
				{
					$start_date1 = date("Y-m-d");
 					$end_date1 = $last_enddate->trial_end_date;
 					$dateDiff = $this->dateDifference($start_date1, $end_date1);
					
					if($sub_details->pay_billed_choice == 0)
					{
						$finaldate = 30+$dateDiff;
					}
					if($sub_details->pay_billed_choice == 3)
					{
						$finaldate = 90+$dateDiff;
					}
					if($sub_details->pay_billed_choice == 6)
					{
						$finaldate = 180+$dateDiff;
					}
					if($sub_details->pay_billed_choice == 9)
					{
						$finaldate = 270+$dateDiff;
					}															
					
					$hdays = '+'.$finaldate.' days';$hdayinfo = $finaldate;
										
				}
				$enddate = date('Y-m-d',strtotime($hdays,strtotime($start_date1)));			
			}
			else
			{
				$last_enddate = DB::table('subscription')->where([["suserid","=",session('lcbuser_id')]])->first();
				// find user in trial or not
				$trial_checking = DB::table('subscription')->where([["suserid","=",session('lcbuser_id')]])->where('trial_end_date', '>', $st_date)->count();
				// find user in trial or not
				if($trial_checking == 0)
				{
					$start_date1 = date("Y-m-d");
					$hdays = '+365 days';$hdayinfo = 365;
				}
				else
				{
					$start_date1 = date("Y-m-d");
 					$end_date1 = $last_enddate->trial_end_date;
 					$dateDiff = $this->dateDifference($start_date1, $end_date1);
					$finaldate = 365+$dateDiff;
					$hdays = '+'.$finaldate.' days'; $hdayinfo = $finaldate;
										
				}
				$enddate = date('Y-m-d',strtotime($hdays,strtotime($start_date1)));					
			}
			
			// update in payment history table
		/*DB::table('paymenthistory')->insert(['pay_user_id' => session('lcbuser_id'),'pay_order_number' => session('authord_no'),'pay_payment_date' => $request->payment_date,
		'pay_status' => '1','pay_trans_id' => $request->txn_id]);	*/			
			// update in payment history table
			
			
		
		
			
		$values = array('sstart_date' => $start_date1,'send_date' => $enddate,'sstatus' => '1','six_day_status' => '0','after_trial_status' => '0','two_day_status' => '0','four_day_status' => '0','sbilling' => $sub_details->pay_billed_choice,'snofacilitators' => $sub_details->pay_count,'stotalprice' => $sub_details->pay_amount,'advance_done' => '0');
		DB::table('subscription')->where([["suserid","=",session('lcbuser_id')]])->update($values);	
		
		
	$sub_details_new = DB::table('upgrade_subscription_payment')->where("pay_order_number","=",session('authord_no'))->first();	
// insert into paymenthistory table
$st_date = date("Y-m-d")."T";
if($sub_details_new->pay_billed_choice == 1)
{
	$cmonth = "1 year";
}
else
{
	$cmonth = $sub_details_new->pay_billed_choice." months";
}


$subscription_message = $sub_details_new->pay_count.' Barista upgraded for '.$cmonth;
DB::table('paymenthistory')->insert(['pay_user_id' => session('lcbuser_id'),'pay_order_number' => session('authord_no'),'pay_trans_id' => $tresponse->getTransId(),
'pay_status' => '1','pay_payment_date' => $payment_date,'pay_type' => 'Credit Card','pay_amount' => $final_price,'pay_description' => $subscription_message,'pay_time' => $ptime]);	
// insert into paymenthistory table


		
		
					
			// to change upgrade subscription
			
			$s_details = DB::table('subscription')->where([["suserid","=",session('lcbuser_id')]])->first();
			
		// sending email notification regarding payment
		
				$userinfo = DB::table('siteusers')->where([["user_id","=",session('lcbuser_id')]])->first();
				$details['m_name'] = $userinfo->user_name;
				$details['m_emailid'] = $userinfo->user_emailid;
				$details['m_message'] = "Your payment to upgrade your LeanCoffeeBrew Subscription was successful.";	
				$details['m_content'] = "You now have ".$s_details->snofacilitators." Barista pack for ".$hdayinfo." days.";		
				Mail::send('mail.mail_advance_payment_notification', $details, function($message) use ($details) {
				$subject = 'Thanks for your subscription - Lean Coffee Brew';
				$message->to($details["m_emailid"] , $details["m_name"])->subject($subject);
				});		
							
		// sending email notification regarding payment	
session()->put('authord_no','');	
			
			return redirect('/home')->with("success","Your subscription upgraded successfully");					
		
								
					// when successful payment
                  
                } else {
                    $message_text = 'There were some issue with the payment. Please try again later.';
                    $msg_type = "error_msg";                                    

                    if ($tresponse->getErrors() != null) {
                        $message_text = $tresponse->getErrors()[0]->getErrorText();
                        $msg_type = "error_msg";                                    
                    }
                }
                // Or, print errors if the API request wasn't successful
            } else {
                $message_text = 'There were some issue with the payment. Please try again later.';
                $msg_type = "error_msg";                                    

                $tresponse = $response->getTransactionResponse();

                if ($tresponse != null && $tresponse->getErrors() != null) {
                    $message_text = $tresponse->getErrors()[0]->getErrorText();
                    $msg_type = "error_msg";                    
                } else {
                    $message_text = $response->getMessages()->getMessage()[0]->getText();
                    $msg_type = "error_msg";
                }                
            }
        } else {
            $message_text = "No response returned";
            $msg_type = "error_msg";
        }
        return back()->with($msg_type, $message_text);
    
	
				
			// authorize.net payment ends here
		}
						
				
		}
		
		
		$data['subscription_info'] = $this->subscriptiondetails();
		$currentprice = $data['subscription_info']->stotalprice;
		if($data['subscription_info']->advance_done == 1)
		{
		// if any advance payment done
		$ad_pay_done = DB::table('paymenthistory')->where('pay_user_id',$user_info->user_id)->where('pay_status','1')->where('pay_description','Advance subscription')->count();
		if($ad_pay_done >= 2)
		{
			//$ad_pay_done = DB::table('paymenthistory')->where('pay_user_id',$user_info->user_id)->where('pay_status','1')->where('pay_description','Advance subscription')->
			
			$advancesum = DB::table('paymenthistory')->where('pay_user_id',$user_info->user_id)->where('pay_status','1')->where('pay_description','Advance subscription')->sum('pay_amount');
			$currentpricefinal = 2 * $currentprice;

		}
		else
		{
			$currentpricefinal = $currentprice;
		}
		
		}
		else
		{
			$currentpricefinal = $currentprice;
		}
		
		//echo $currentpricefinal;
		$userpaymentprice = $this->gefinalprice($currentpricefinal);
		
		
		
// find 
			$data['pinfoall'] = DB::table('prices')->where('pcount','>=',$data['subscription_info']->snofacilitators)->get();
			
			foreach($data['pinfoall'] as $dpinfo)
			{
				$sel_count = $dpinfo->pcount;				
				$cprice = $dpinfo->pprice;
				$allmonths = DB::table('months')->orderBy("mid","asc")->get();
				$a=array();
				foreach($allmonths as $am)
				{
					if($am->mmain == 1)
					{
						$tot_price2 = $am->mcount * $cprice;
						$perc = ($tot_price2 * 5)/100;
						$tot_price = $tot_price2 - $perc;
					}
					else
					{
						$tot_price = $am->mcount * $cprice;
					}
					
					/*echo $tot_price;
					echo "<br>";*/
					if($data['subscription_info']->sbilling == 0)
					{
						if($tot_price > $userpaymentprice  and $am->mmain > $data['subscription_info']->sbilling)
						{/*	echo "1"."<br>";	*/
							array_push($a,$am->mid);
						}							
					}
					else
					{
						if($tot_price > $userpaymentprice  and $am->mcount > $data['subscription_info']->sbilling)
						{/*	echo "1"."<br>";	*/
							array_push($a,$am->mid);
						}
					}
									
				}
				$data['selmonths'] = $a;
				if(count($data['selmonths']) != 0)
				{
					break;
				}
				
			}
			
			if(count($data['selmonths']) == 0)
			{
				return redirect('/home')->with("error","Sorry! You cannot upgrade.");
			}
			// find		
		$data['subscription_details'] = DB::table('subscription')->where('suserid',session('lcbuser_id'))->orderBy('sid','DESC')->first();	
		
		if($data['subscription_details']->sbilling == 1)
		{
			$data['subscription_details_info'] = 12;
		}
		else
		{
			$data['subscription_details_info'] = $data['subscription_details']->sbilling;
		}
		
		$nextmonthinfocount = DB::table('months')->where('mcount','>',$data['subscription_details']->sbilling)->count();	
		$data['nextmonthinfo'] = DB::table('months')->where('mcount','>',$data['subscription_details']->sbilling)->first();	
			if($data['subscription_details']->sbilling != 1)
			{
				$data['allsubscriptions'] = DB::table('prices')->where('pstatus','1')->where('pcount','>=',$sel_count)->orderBy('pid','ASC')->get();
				$data['allsubscriptions_one'] = DB::table('prices')->where('pstatus','1')->where('pcount','>=',$sel_count)->orderBy('pid','ASC')->first();			
			}
			else
			{
				$data['allsubscriptions'] = DB::table('prices')->where('pstatus','1')->where('pcount','>=',$sel_count)->orderBy('pid','ASC')->get();
				$data['allsubscriptions_one'] = DB::table('prices')->where('pstatus','1')->where('pcount','>=',$sel_count)->orderBy('pid','ASC')->first();	
			}
			
			$data['selectedmonths'] = DB::table('months')->whereIn('mid',$data['selmonths'])->get();
			$data['selectedmonths_first'] = DB::table('months')->whereIn('mid',$data['selmonths'])->first();
			$data['selectedmonths_first']->mcount;
			
			if($data['selectedmonths_first']->mcount == 1)
			{
				$data['nprice'] = $data['allsubscriptions_one']->pprice ;
			}
						
			if($data['selectedmonths_first']->mcount == 3)
			{
				$data['nprice'] = $data['allsubscriptions_one']->pprice * 3;
			}
						
			
			if($data['selectedmonths_first']->mcount == 6)
			{
				$data['nprice'] = $data['allsubscriptions_one']->pprice * 6;
			}
			
						
			if($data['selectedmonths_first']->mcount == 9)
			{
				$data['nprice'] = $data['allsubscriptions_one']->pprice * 9;
			}
			
			if($data['selectedmonths_first']->mcount == 12)
			{
				$data['nprice'] = $data['allsubscriptions_one']->pprice * 12;
				
			$fortmonth = $data['allsubscriptions_one']->pprice * 12;
			$perc = ($fortmonth * 5)/100;
			$fprice = $fortmonth - $perc;			
			$data['yinfo'] = "$".$fprice." every year";
			$data['permessage'] = "(Includes 5% discount - normal price $".$fortmonth.")";
			$finalprice=$fprice;
			$data['nprice'] = $fprice;				
			}
			
		$pinfos = DB::table('prices')->where('pstatus','1')->where('pcount','>',$data['subscription_details']->snofacilitators)->count();
		if($pinfos != 0)
		{
			$data['pinfo'] = DB::table('prices')->where('pstatus','1')->where('pcount','>',$data['subscription_details']->snofacilitators)->first();
		}
		else
		{
			$data['pinfo'] = DB::table('prices')->where('pstatus','1')->where('pcount','>=',$data['subscription_details']->snofacilitators)->first();
		}
		$data['curmonth'] =  date("m");
		$data['current_user_info'] = $this->userdetails();
		return view('user/upgrade_subscription',$data);									
	
		
	}	
	
public function upgrade_subscription12345(Request $request)
	{
	
	
		$this->updateusertime();
		$user_info = $this->userdetails();

		if($request->isMethod("post"))
		{
			$data['subscription_info'] = $this->subscriptiondetails();
			
			if($data['subscription_info']->sbilling != 1)
			{
				$data['pinfo'] = DB::table('prices')->where('pcount','>=',$data['subscription_info']->snofacilitators)->first();
			}
			else
			{
				$data['pinfo'] = DB::table('prices')->where('pcount','>',$data['subscription_info']->snofacilitators)->first();
			}

			if($request->pcount == '' and $request->pprice == '')
			{
				
				$fcount = $data['pinfo']->pcount;
				$fprice = $request->wrefprice;				
				//$onedayprice =  number_format(($fprice/30),3); // one day price					
			}
			else
			{
				$fcount = $request->pcount;
				$fprice = $request->pprice;
				//$onedayprice =  number_format(($fprice/30),3); // one day price					
			}

			// to find new price

				if($data['subscription_info']->sbilling == 1)
				{
					$onedayprice =  $data['subscription_info']->stotalprice/365;
				}
				else
				{
					
					if($data['subscription_info']->sbilling == 0)
					{
						$onedayprice =  $data['subscription_info']->stotalprice/30;
					}
					if($data['subscription_info']->sbilling == 3)
					{
						$onedayprice =  $data['subscription_info']->stotalprice/90;
					}
					if($data['subscription_info']->sbilling == 6)
					{
						$onedayprice =  $data['subscription_info']->stotalprice/180;
					}										
					if($data['subscription_info']->sbilling == 9)
					{
						$onedayprice =  $data['subscription_info']->stotalprice/270;
					}					
					
				}
				
				
				
				$start_date = date("Y-m-d");
				$trial_checking = DB::table('subscription')->where([["suserid","=",session('lcbuser_id')]])->where('trial_end_date', '>', $start_date)->count();
				if($trial_checking == 0)
				{
					$start_date1 = date("Y-m-d");
					$end_date = $data['subscription_info']->send_date;
				}
				else
				{
					$start_date1 = $data['subscription_info']->trial_end_date;
					$end_date = $data['subscription_info']->send_date;
				}
				
				
 				
 				$dateDiff = $this->dateDifference($start_date1, $end_date);	


				
				
				$to_minus_price2 = number_format(($dateDiff * $onedayprice),2);
				
				$to_minus_price = str_replace(",","",$to_minus_price2);
				
				$final_price2 = number_format(($fprice - $to_minus_price),2);

				$final_price = str_replace(",","",$final_price2);
				
				
			// to find new price
			
			
		$data['new_price'] = $final_price;
		
		$em = explode("___",$request->no_facilitators);
		
		$data['ord_no'] = $this->VerificationCode(10);
		DB::table('upgrade_subscription_payment')->insert(['pay_user_id' => session('lcbuser_id'),'pay_order_number' => $data['ord_no'],'pay_payment_date' => '',
		'pay_status' => '0','pay_trans_id' => '','pay_current_suscription' => $data['subscription_info']->snofacilitators,'pay_no_baristas' => $em[0],'pay_billed_choice' => $request->billing,'pay_count' => $fcount,'pay_paid_amount' => $data['new_price'],'pay_amount' => $fprice]);		
		return view('user/upgradepaypalpayment',$data);
						
		}
		// post ended
		
		$data['subscription_details'] = DB::table('subscription')->where('suserid',session('lcbuser_id'))->orderBy('sid','DESC')->first();	
		
		if($data['subscription_details']->sbilling == 1)
		{
			$data['subscription_details_info'] = 12;
		}
		else
		{
			$data['subscription_details_info'] = $data['subscription_details']->sbilling;
		}
		
		$nextmonthinfocount = DB::table('months')->where('mcount','>',$data['subscription_details']->sbilling)->count();	
		$data['nextmonthinfo'] = DB::table('months')->where('mcount','>',$data['subscription_details']->sbilling)->first();	
		

		
		
		
		// to find price
		$data['subscription_info'] = $this->subscriptiondetails();
		$currentprice = $data['subscription_info']->stotalprice;
		$cuserinfo = $this->userdetails();
		
		if($data['subscription_info']->advance_done == 1)
		{
		// if any advance payment done
		$ad_pay_done = DB::table('paymenthistory')->where('pay_user_id',$cuserinfo->user_id)->where('pay_status','1')->where('pay_description','Advance subscription')->count();
		if($ad_pay_done >= 2)
		{
			// get final amount paid
			$ad_pay_done_info = DB::table('paymenthistory')->where('pay_user_id',$cuserinfo->user_id)->where('pay_status','1')->where('pay_description','Advance subscription')->orderBy('pay_order_id','DESC')->first();
			
			$currentpricefinal = 2 * $currentprice;
			// get final amount paid
		}
		else
		{
			$currentpricefinal = $currentprice;
		}
		
		}
		else
		{
			$currentpricefinal = $currentprice;
		}

			// find 
			$data['pinfoall'] = DB::table('prices')->where('pcount','>=',$data['subscription_info']->snofacilitators)->get();
			
			foreach($data['pinfoall'] as $dpinfo)
			{
				$sel_count = $dpinfo->pcount;				
				$cprice = $dpinfo->pprice;
				$allmonths = DB::table('months')->orderBy("mid","asc")->get();
				$a=array();
				foreach($allmonths as $am)
				{
					if($am->mmain == 1)
					{
						$tot_price2 = $am->mcount * $cprice;
						$perc = ($tot_price2 * 5)/100;
						$tot_price = $tot_price2 - $perc;
					}
					else
					{
						$tot_price = $am->mcount * $cprice;
					}
					if($tot_price > $currentpricefinal)
					{					
						array_push($a,$am->mid);
					}					
				}
				$data['selmonths'] = $a;
				if(count($data['selmonths']) != 0)
				{
					break;
				}
				
			}
			
			//dd($data['selmonths']);
			// find
			
/*			$data['pinfo'] = DB::table('prices')->where('pcount','=',$data['subscription_info']->snofacilitators)->first();
			
			
			$cprice = $data['pinfo']->pprice;
			$allmonths = DB::table('months')->orderBy("mid","asc")->get();
			$a=array();
			foreach($allmonths as $am)
			{
				if($am->mmain == 1)
				{
					$tot_price2 = $am->mcount * $cprice;
					$perc = ($tot_price2 * 5)/100;
					$tot_price = $tot_price2 - $perc;
				}
				else
				{
					$tot_price = $am->mcount * $cprice;
				}
				if($tot_price > $currentpricefinal)
				{					
					array_push($a,$am->mid);
				}
			}
			$data['selmonths'] = $a;

			$du_va = 0;
			if(count($data['selmonths']) == 0)
			{
				$du_va = 1;
				$data['pinfonew'] = DB::table('prices')->where('pcount','>',$data['subscription_info']->snofacilitators)->first();
				
			$cprice = $data['pinfonew']->pprice;
			$allmonthsnew = DB::table('months')->orderBy("mid","asc")->get();
			$b=array();
			foreach($allmonthsnew as $am)
			{
				if($am->mmain == 1)
				{
					$tot_price2 = $am->mcount * $cprice;
					$perc = ($tot_price2 * 5)/100;
					$tot_price = $tot_price2 - $perc;
				}
				else
				{
					$tot_price = $am->mcount * $cprice;
				}
				if($tot_price > $currentpricefinal)
				{					
					array_push($b,$am->mid);
				}
			}
			$data['selmonths'] = $b;

			}*/
				
				
if($data['subscription_details']->sbilling != 1)
{

/*	if($du_va == 0)
	{
	$data['allsubscriptions'] = DB::table('prices')->where('pstatus','1')->where('pcount','>=',$data['subscription_details']->snofacilitators)->orderBy('pid','ASC')->get();
	$data['allsubscriptions_one'] = DB::table('prices')->where('pstatus','1')->where('pcount','>=',$data['subscription_details']->snofacilitators)->orderBy('pid','ASC')->first();		
	}
	else
	{
	$data['allsubscriptions'] = DB::table('prices')->where('pstatus','1')->where('pcount','>',$data['subscription_details']->snofacilitators)->orderBy('pid','ASC')->get();
	$data['allsubscriptions_one'] = DB::table('prices')->where('pstatus','1')->where('pcount','>',$data['subscription_details']->snofacilitators)->orderBy('pid','ASC')->first();		
	}*/
	
	$data['allsubscriptions'] = DB::table('prices')->where('pstatus','1')->where('pcount','>=',$sel_count)->orderBy('pid','ASC')->get();
	$data['allsubscriptions_one'] = DB::table('prices')->where('pstatus','1')->where('pcount','>=',$sel_count)->orderBy('pid','ASC')->first();
		
	
}
else
{
	$data['allsubscriptions'] = DB::table('prices')->where('pstatus','1')->where('pcount','>=',$sel_count)->orderBy('pid','ASC')->get();
	$data['allsubscriptions_one'] = DB::table('prices')->where('pstatus','1')->where('pcount','>=',$sel_count)->orderBy('pid','ASC')->first();	
}
		
		
						
			
			$data['selectedmonths'] = DB::table('months')->whereIn('mid',$data['selmonths'])->get();
			$data['selectedmonths_first'] = DB::table('months')->whereIn('mid',$data['selmonths'])->first();
			$data['selectedmonths_first']->mcount;
			
			
			if($data['selectedmonths_first']->mcount == 1)
			{
				$data['nprice'] = $data['allsubscriptions_one']->pprice ;
			}
						
			if($data['selectedmonths_first']->mcount == 3)
			{
				$data['nprice'] = $data['allsubscriptions_one']->pprice * 3;
			}
						
			
			if($data['selectedmonths_first']->mcount == 6)
			{
				$data['nprice'] = $data['allsubscriptions_one']->pprice * 6;
			}
			
						
			if($data['selectedmonths_first']->mcount == 9)
			{
				$data['nprice'] = $data['allsubscriptions_one']->pprice * 9;
			}
			
			if($data['selectedmonths_first']->mcount == 12)
			{
				$data['nprice'] = $data['allsubscriptions_one']->pprice * 12;
				
			$fortmonth = $data['allsubscriptions_one']->pprice * 12;
			$perc = ($fortmonth * 5)/100;
			$fprice = $fortmonth - $perc;			
			$data['yinfo'] = "$".$fprice." every year";
			$data['permessage'] = "(Includes 5% discount - normal price $".$fortmonth.")";
			$finalprice=$fprice;
			$data['nprice'] = $fprice;				
			}			
					
		
		// if any advance payment done
		// to find price
		
		
		/*if($data['subscription_details']->sbilling == 0)
		{
			$data['nprice'] = $data['allsubscriptions_one']->pprice * 3;		
		}
				
		if($data['subscription_details']->sbilling == 3)
		{
			$data['nprice'] = $data['allsubscriptions_one']->pprice * 6;
		}
		if($data['subscription_details']->sbilling == 6)
		{
			$data['nprice'] = $data['allsubscriptions_one']->pprice * 9;
		}		
		if($data['selectedmonths_first']->sbilling == 9 || $data['subscription_details']->sbilling == 1)
		{
			//$data['nprice'] = $data['allsubscriptions_one']->pprice * 12;
			

			$fortmonth = $data['allsubscriptions_one']->pprice * 12;
			$perc = ($fortmonth * 5)/100;
			$fprice = $fortmonth - $perc;			
			$data['yinfo'] = "$".$fprice." every year";
			$data['permessage'] = "(Includes 5% discount - normal price $".$fortmonth.")";
			$finalprice=$fprice;
			$data['nprice'] = $fprice;
						
		}		*/
		
		
		//$data['nprice'] = $data['allsubscriptions_one']->pcount * $data['subscription_details']->stotalprice;
		//$data['pinfo'] = DB::table('prices')->where('pstatus','1')->where('pprice','>',$data['subscription_details']->stotalprice)->first();
		$pinfos = DB::table('prices')->where('pstatus','1')->where('pcount','>',$data['subscription_details']->snofacilitators)->count();
		if($pinfos != 0)
		{
			$data['pinfo'] = DB::table('prices')->where('pstatus','1')->where('pcount','>',$data['subscription_details']->snofacilitators)->first();
		}
		else
		{
			$data['pinfo'] = DB::table('prices')->where('pstatus','1')->where('pcount','>=',$data['subscription_details']->snofacilitators)->first();
		}
		
		return view('user/upgrade_subscription',$data);
	
	
	
	}	
	
	
	public function upgrade_subscriptionlastonedontedit(Request $request)
	{
	
	
		$this->updateusertime();
		$user_info = $this->userdetails();

		if($request->isMethod("post"))
		{
			$data['subscription_info'] = $this->subscriptiondetails();
			
			if($data['subscription_info']->sbilling != 1)
			{
				$data['pinfo'] = DB::table('prices')->where('pcount','>=',$data['subscription_info']->snofacilitators)->first();
			}
			else
			{
				$data['pinfo'] = DB::table('prices')->where('pcount','>',$data['subscription_info']->snofacilitators)->first();
			}

			if($request->pcount == '' and $request->pprice == '')
			{
				$sel_pcount = explode("___",$request->no_facilitators);
				$fcount = $sel_pcount[1];
				$fprice = $request->wrefprice;				
				//$onedayprice =  number_format(($fprice/30),3); // one day price					
			}
			else
			{
				$fcount = $request->pcount;
				$fprice = $request->pprice;
				//$onedayprice =  number_format(($fprice/30),3); // one day price					
			}

			// to find new price

				if($data['subscription_info']->sbilling == 1)
				{
					$onedayprice =  $data['subscription_info']->stotalprice/365;
				}
				else
				{
					
					if($data['subscription_info']->sbilling == 0)
					{
						$onedayprice =  $data['subscription_info']->stotalprice/30;
					}
					if($data['subscription_info']->sbilling == 3)
					{
						$onedayprice =  $data['subscription_info']->stotalprice/90;
					}
					if($data['subscription_info']->sbilling == 6)
					{
						$onedayprice =  $data['subscription_info']->stotalprice/180;
					}										
					if($data['subscription_info']->sbilling == 9)
					{
						$onedayprice =  $data['subscription_info']->stotalprice/270;
					}					
					
				}
				
				
				
				$start_date = date("Y-m-d");
				$trial_checking = DB::table('subscription')->where([["suserid","=",session('lcbuser_id')]])->where('trial_end_date', '>', $start_date)->count();
				if($trial_checking == 0)
				{
					$start_date1 = date("Y-m-d");
					$end_date = $data['subscription_info']->send_date;
				}
				else
				{
					$start_date1 = $data['subscription_info']->trial_end_date;
					$end_date = $data['subscription_info']->send_date;
				}
				
				
 				
 				$dateDiff = $this->dateDifference($start_date1, $end_date);	


				
				
				$to_minus_price2 = number_format(($dateDiff * $onedayprice),2);
				
				$to_minus_price = str_replace(",","",$to_minus_price2);
				
				$final_price2 = number_format(($fprice - $to_minus_price),2);

				$final_price = str_replace(",","",$final_price2);
				
				
			// to find new price
			
			
		$data['new_price'] = $final_price;
		//echo  exit();
		
		$em = explode("___",$request->no_facilitators);
		
		$data['ord_no'] = $this->VerificationCode(10);
		DB::table('upgrade_subscription_payment')->insert(['pay_user_id' => session('lcbuser_id'),'pay_order_number' => $data['ord_no'],'pay_payment_date' => '',
		'pay_status' => '0','pay_trans_id' => '','pay_current_suscription' => $data['subscription_info']->snofacilitators,'pay_no_baristas' => $em[0],'pay_billed_choice' => $request->billing,'pay_count' => $fcount,'pay_paid_amount' => $data['new_price'],'pay_amount' => $fprice]);		
		return view('user/upgradepaypalpayment',$data);
						
		}
		// post ended
		
		
		
		$data['subscription_details'] = DB::table('subscription')->where('suserid',session('lcbuser_id'))->orderBy('sid','DESC')->first();	
		
		if($data['subscription_details']->sbilling == 1)
		{
			$data['subscription_details_info'] = 12;
		}
		else
		{
			$data['subscription_details_info'] = $data['subscription_details']->sbilling;
		}
		
		$nextmonthinfocount = DB::table('months')->where('mcount','>',$data['subscription_details']->sbilling)->count();	
		$data['nextmonthinfo'] = DB::table('months')->where('mcount','>',$data['subscription_details']->sbilling)->first();	

		// to find price
		$data['subscription_info'] = $this->subscriptiondetails();
		$currentprice = $data['subscription_info']->stotalprice;
		$cuserinfo = $this->userdetails();
		
		if($data['subscription_info']->advance_done == 1)
		{
		// if any advance payment done
		$ad_pay_done = DB::table('paymenthistory')->where('pay_user_id',$cuserinfo->user_id)->where('pay_status','1')->where('pay_description','Advance subscription')->count();
		if($ad_pay_done >= 2)
		{
			// get final amount paid
			$ad_pay_done_info = DB::table('paymenthistory')->where('pay_user_id',$cuserinfo->user_id)->where('pay_status','1')->where('pay_description','Advance subscription')->orderBy('pay_order_id','DESC')->first();
			
			$ad_pay_done_info_count = DB::table('paymenthistory')->where('pay_user_id',$cuserinfo->user_id)->where('pay_status','1')->where('pay_description','Advance subscription')->orderBy('pay_order_id','DESC')->count();
			
			$ad_pay_done_info_val = $ad_pay_done_info_count - 1;
			
			$currentpricefinal = $ad_pay_done_info_val * $currentprice;
			
			// get final amount paid
		}
		else
		{
			$currentpricefinal = $currentprice;
		}
		
		}
		else
		{
			$currentpricefinal = $currentprice;
		}
		
			
				
				
if($data['subscription_details']->sbilling != 1)
{

/*	if($du_va == 0)
	{
	$data['allsubscriptions'] = DB::table('prices')->where('pstatus','1')->where('pcount','>=',$data['subscription_details']->snofacilitators)->orderBy('pid','ASC')->get();
	$data['allsubscriptions_one'] = DB::table('prices')->where('pstatus','1')->where('pcount','>=',$data['subscription_details']->snofacilitators)->orderBy('pid','ASC')->first();		
	}
	else
	{
	$data['allsubscriptions'] = DB::table('prices')->where('pstatus','1')->where('pcount','>',$data['subscription_details']->snofacilitators)->orderBy('pid','ASC')->get();
	$data['allsubscriptions_one'] = DB::table('prices')->where('pstatus','1')->where('pcount','>',$data['subscription_details']->snofacilitators)->orderBy('pid','ASC')->first();		
	}*/
	
	$data['allsubscriptions'] = DB::table('prices')->where('pstatus','1')->where('pcount','>=',$sel_count)->orderBy('pid','ASC')->get();
	$data['allsubscriptions_one'] = DB::table('prices')->where('pstatus','1')->where('pcount','>=',$sel_count)->orderBy('pid','ASC')->first();
		
	
}
else
{
	$data['allsubscriptions'] = DB::table('prices')->where('pstatus','1')->where('pcount','>=',$sel_count)->orderBy('pid','ASC')->get();
	$data['allsubscriptions_one'] = DB::table('prices')->where('pstatus','1')->where('pcount','>=',$sel_count)->orderBy('pid','ASC')->first();	
}
		
		
						
			
			$data['selectedmonths'] = DB::table('months')->whereIn('mid',$data['selmonths'])->get();
			$data['selectedmonths_first'] = DB::table('months')->whereIn('mid',$data['selmonths'])->first();
			$data['selectedmonths_first']->mcount;
			
			
			if($data['selectedmonths_first']->mcount == 1)
			{
				$data['nprice'] = $data['allsubscriptions_one']->pprice ;
			}
						
			if($data['selectedmonths_first']->mcount == 3)
			{
				$data['nprice'] = $data['allsubscriptions_one']->pprice * 3;
			}
						
			
			if($data['selectedmonths_first']->mcount == 6)
			{
				$data['nprice'] = $data['allsubscriptions_one']->pprice * 6;
			}
			
						
			if($data['selectedmonths_first']->mcount == 9)
			{
				$data['nprice'] = $data['allsubscriptions_one']->pprice * 9;
			}
			
			if($data['selectedmonths_first']->mcount == 12)
			{
				$data['nprice'] = $data['allsubscriptions_one']->pprice * 12;
				
			$fortmonth = $data['allsubscriptions_one']->pprice * 12;
			$perc = ($fortmonth * 5)/100;
			$fprice = $fortmonth - $perc;			
			$data['yinfo'] = "$".$fprice." every year";
			$data['permessage'] = "(Includes 5% discount - normal price $".$fortmonth.")";
			$finalprice=$fprice;
			$data['nprice'] = $fprice;				
			}			
				
		$data['nprice2'] = $this->gefinalprice($data['nprice']);
		
		// if any advance payment done
		// to find price
		
		
		/*if($data['subscription_details']->sbilling == 0)
		{
			$data['nprice'] = $data['allsubscriptions_one']->pprice * 3;		
		}
				
		if($data['subscription_details']->sbilling == 3)
		{
			$data['nprice'] = $data['allsubscriptions_one']->pprice * 6;
		}
		if($data['subscription_details']->sbilling == 6)
		{
			$data['nprice'] = $data['allsubscriptions_one']->pprice * 9;
		}		
		if($data['selectedmonths_first']->sbilling == 9 || $data['subscription_details']->sbilling == 1)
		{
			//$data['nprice'] = $data['allsubscriptions_one']->pprice * 12;
			

			$fortmonth = $data['allsubscriptions_one']->pprice * 12;
			$perc = ($fortmonth * 5)/100;
			$fprice = $fortmonth - $perc;			
			$data['yinfo'] = "$".$fprice." every year";
			$data['permessage'] = "(Includes 5% discount - normal price $".$fortmonth.")";
			$finalprice=$fprice;
			$data['nprice'] = $fprice;
						
		}		*/
		
		
		//$data['nprice'] = $data['allsubscriptions_one']->pcount * $data['subscription_details']->stotalprice;
		//$data['pinfo'] = DB::table('prices')->where('pstatus','1')->where('pprice','>',$data['subscription_details']->stotalprice)->first();
		$pinfos = DB::table('prices')->where('pstatus','1')->where('pcount','>',$data['subscription_details']->snofacilitators)->count();
		if($pinfos != 0)
		{
			$data['pinfo'] = DB::table('prices')->where('pstatus','1')->where('pcount','>',$data['subscription_details']->snofacilitators)->first();
		}
		else
		{
			$data['pinfo'] = DB::table('prices')->where('pstatus','1')->where('pcount','>=',$data['subscription_details']->snofacilitators)->first();
		}
		
		return view('user/upgrade_subscription',$data);
	
	
	
	}
	
	
	public function upgrade_subscription_before_homechanges(Request $request)
	{
	
		$this->updateusertime();
		$user_info = $this->userdetails();

		if($request->isMethod("post"))
		{
			$data['subscription_info'] = $this->subscriptiondetails();
			
			if($data['subscription_info']->sbilling != 1)
			{
				$data['pinfo'] = DB::table('prices')->where('pcount','>=',$data['subscription_info']->snofacilitators)->first();
			}
			else
			{
				$data['pinfo'] = DB::table('prices')->where('pcount','>',$data['subscription_info']->snofacilitators)->first();
			}

			if($request->pcount == '' and $request->pprice == '')
			{
				
				$fcount = $data['pinfo']->pcount;
				$fprice = $request->wrefprice;				
				//$onedayprice =  number_format(($fprice/30),3); // one day price					
			}
			else
			{
				$fcount = $request->pcount;
				$fprice = $request->pprice;
				//$onedayprice =  number_format(($fprice/30),3); // one day price					
			}

			// to find new price

				if($data['subscription_info']->sbilling == 1)
				{
					$onedayprice =  $data['subscription_info']->stotalprice/365;
				}
				else
				{
					
					if($data['subscription_info']->sbilling == 0)
					{
						$onedayprice =  $data['subscription_info']->stotalprice/30;
					}
					if($data['subscription_info']->sbilling == 3)
					{
						$onedayprice =  $data['subscription_info']->stotalprice/90;
					}
					if($data['subscription_info']->sbilling == 6)
					{
						$onedayprice =  $data['subscription_info']->stotalprice/180;
					}										
					if($data['subscription_info']->sbilling == 9)
					{
						$onedayprice =  $data['subscription_info']->stotalprice/270;
					}					
					
				}
				
				
				
				$start_date = date("Y-m-d");
				$trial_checking = DB::table('subscription')->where([["suserid","=",session('lcbuser_id')]])->where('trial_end_date', '>', $start_date)->count();
				if($trial_checking == 0)
				{
					$start_date1 = date("Y-m-d");
					$end_date = $data['subscription_info']->send_date;
				}
				else
				{
					$start_date1 = $data['subscription_info']->trial_end_date;
					$end_date = $data['subscription_info']->send_date;
				}
				
				
 				
 				$dateDiff = $this->dateDifference($start_date1, $end_date);	


				
				
				$to_minus_price2 = number_format(($dateDiff * $onedayprice),2);
				
				$to_minus_price = str_replace(",","",$to_minus_price2);
				
				$final_price2 = number_format(($fprice - $to_minus_price),2);

				$final_price = str_replace(",","",$final_price2);
				
				
			// to find new price
			
			
		$data['new_price'] = $final_price;
		
		$em = explode("___",$request->no_facilitators);
		
		$data['ord_no'] = $this->VerificationCode(10);
		DB::table('upgrade_subscription_payment')->insert(['pay_user_id' => session('lcbuser_id'),'pay_order_number' => $data['ord_no'],'pay_payment_date' => '',
		'pay_status' => '0','pay_trans_id' => '','pay_current_suscription' => $data['subscription_info']->snofacilitators,'pay_no_baristas' => $em[0],'pay_billed_choice' => $request->billing,'pay_count' => $fcount,'pay_paid_amount' => $data['new_price'],'pay_amount' => $fprice]);		
		return view('user/upgradepaypalpayment',$data);
						
		}
		// post ended
		
		$data['subscription_details'] = DB::table('subscription')->where('suserid',session('lcbuser_id'))->orderBy('sid','DESC')->first();	
		
		if($data['subscription_details']->sbilling == 1)
		{
			$data['subscription_details_info'] = 12;
		}
		else
		{
			$data['subscription_details_info'] = $data['subscription_details']->sbilling;
		}
		
		$nextmonthinfocount = DB::table('months')->where('mcount','>',$data['subscription_details']->sbilling)->count();	
		$data['nextmonthinfo'] = DB::table('months')->where('mcount','>',$data['subscription_details']->sbilling)->first();	
		

		
		
		
		// to find price
		$data['subscription_info'] = $this->subscriptiondetails();
		$currentprice = $data['subscription_info']->stotalprice;
		$cuserinfo = $this->userdetails();
		
		if($data['subscription_info']->advance_done == 1)
		{
		// if any advance payment done
		$ad_pay_done = DB::table('paymenthistory')->where('pay_user_id',$cuserinfo->user_id)->where('pay_status','1')->where('pay_description','Advance subscription')->count();
		if($ad_pay_done >= 2)
		{
			// get final amount paid
			$ad_pay_done_info = DB::table('paymenthistory')->where('pay_user_id',$cuserinfo->user_id)->where('pay_status','1')->where('pay_description','Advance subscription')->orderBy('pay_order_id','DESC')->first();
			
			$currentpricefinal = 2 * $currentprice;
			// get final amount paid
		}
		else
		{
			$currentpricefinal = $currentprice;
		}
		
		}
		else
		{
			$currentpricefinal = $currentprice;
		}

			$data['pinfo'] = DB::table('prices')->where('pcount','=',$data['subscription_info']->snofacilitators)->first();
			
			
			$cprice = $data['pinfo']->pprice;
			$allmonths = DB::table('months')->orderBy("mid","asc")->get();
			$a=array();
			foreach($allmonths as $am)
			{
				$tot_price = $am->mcount * $cprice;echo "<br>";
				if($tot_price > $currentpricefinal)
				{					
					array_push($a,$am->mid);
				}
			}
			$data['selmonths'] = $a;
			$du_va = 0;
			if(count($data['selmonths']) == 0)
			{
				$du_va = 1;
				$data['pinfonew'] = DB::table('prices')->where('pcount','>',$data['subscription_info']->snofacilitators)->first();
				
			$cprice = $data['pinfonew']->pprice;
			$allmonthsnew = DB::table('months')->orderBy("mid","asc")->get();
			$b=array();
			foreach($allmonthsnew as $am)
			{
				$tot_price = $am->mcount * $cprice;echo "<br>";
				if($tot_price > $currentpricefinal)
				{					
					array_push($b,$am->mid);
				}
			}
			$data['selmonths'] = $b;

			}
				
				
if($data['subscription_details']->sbilling != 1)
{

	if($du_va == 0)
	{
	$data['allsubscriptions'] = DB::table('prices')->where('pstatus','1')->where('pcount','>=',$data['subscription_details']->snofacilitators)->orderBy('pid','ASC')->get();
	$data['allsubscriptions_one'] = DB::table('prices')->where('pstatus','1')->where('pcount','>=',$data['subscription_details']->snofacilitators)->orderBy('pid','ASC')->first();		
	}
	else
	{
	$data['allsubscriptions'] = DB::table('prices')->where('pstatus','1')->where('pcount','>',$data['subscription_details']->snofacilitators)->orderBy('pid','ASC')->get();
	$data['allsubscriptions_one'] = DB::table('prices')->where('pstatus','1')->where('pcount','>',$data['subscription_details']->snofacilitators)->orderBy('pid','ASC')->first();		
	}
	
}
else
{
	$data['allsubscriptions'] = DB::table('prices')->where('pstatus','1')->where('pcount','>',$data['subscription_details']->snofacilitators)->orderBy('pid','ASC')->get();
	$data['allsubscriptions_one'] = DB::table('prices')->where('pstatus','1')->where('pcount','>',$data['subscription_details']->snofacilitators)->orderBy('pid','ASC')->first();	
}
		
		
						
			
			$data['selectedmonths'] = DB::table('months')->whereIn('mid',$data['selmonths'])->get();
			$data['selectedmonths_first'] = DB::table('months')->whereIn('mid',$data['selmonths'])->first();
			$data['selectedmonths_first']->mcount;
			
			
			if($data['selectedmonths_first']->mcount == 1)
			{
				$data['nprice'] = $data['allsubscriptions_one']->pprice ;
			}
						
			if($data['selectedmonths_first']->mcount == 3)
			{
				$data['nprice'] = $data['allsubscriptions_one']->pprice * 3;
			}
						
			
			if($data['selectedmonths_first']->mcount == 6)
			{
				$data['nprice'] = $data['allsubscriptions_one']->pprice * 6;
			}
			
						
			if($data['selectedmonths_first']->mcount == 9)
			{
				$data['nprice'] = $data['allsubscriptions_one']->pprice * 9;
			}
			
			if($data['selectedmonths_first']->mcount == 12)
			{
				$data['nprice'] = $data['allsubscriptions_one']->pprice * 12;
				
			$fortmonth = $data['allsubscriptions_one']->pprice * 12;
			$perc = ($fortmonth * 5)/100;
			$fprice = $fortmonth - $perc;			
			$data['yinfo'] = "$".$fprice." every year";
			$data['permessage'] = "(Includes 5% discount - normal price $".$fortmonth.")";
			$finalprice=$fprice;
			$data['nprice'] = $fprice;				
			}			
					
		
		// if any advance payment done
		// to find price
		
		
		/*if($data['subscription_details']->sbilling == 0)
		{
			$data['nprice'] = $data['allsubscriptions_one']->pprice * 3;		
		}
				
		if($data['subscription_details']->sbilling == 3)
		{
			$data['nprice'] = $data['allsubscriptions_one']->pprice * 6;
		}
		if($data['subscription_details']->sbilling == 6)
		{
			$data['nprice'] = $data['allsubscriptions_one']->pprice * 9;
		}		
		if($data['selectedmonths_first']->sbilling == 9 || $data['subscription_details']->sbilling == 1)
		{
			//$data['nprice'] = $data['allsubscriptions_one']->pprice * 12;
			

			$fortmonth = $data['allsubscriptions_one']->pprice * 12;
			$perc = ($fortmonth * 5)/100;
			$fprice = $fortmonth - $perc;			
			$data['yinfo'] = "$".$fprice." every year";
			$data['permessage'] = "(Includes 5% discount - normal price $".$fortmonth.")";
			$finalprice=$fprice;
			$data['nprice'] = $fprice;
						
		}		*/
		
		
		//$data['nprice'] = $data['allsubscriptions_one']->pcount * $data['subscription_details']->stotalprice;
		//$data['pinfo'] = DB::table('prices')->where('pstatus','1')->where('pprice','>',$data['subscription_details']->stotalprice)->first();
		$pinfos = DB::table('prices')->where('pstatus','1')->where('pcount','>',$data['subscription_details']->snofacilitators)->count();
		if($pinfos != 0)
		{
			$data['pinfo'] = DB::table('prices')->where('pstatus','1')->where('pcount','>',$data['subscription_details']->snofacilitators)->first();
		}
		else
		{
			$data['pinfo'] = DB::table('prices')->where('pstatus','1')->where('pcount','>=',$data['subscription_details']->snofacilitators)->first();
		}
		
		return view('user/upgrade_subscription',$data);
	
	
	}
	
	
	public function upgrade_subscription_mybeforechange(Request $request)
	{
		$this->updateusertime();
		$user_info = $this->userdetails();

		if($request->isMethod("post"))
		{
			$data['subscription_info'] = $this->subscriptiondetails();
			
			if($data['subscription_info']->sbilling != 1)
			{
				$data['pinfo'] = DB::table('prices')->where('pcount','>=',$data['subscription_info']->snofacilitators)->first();
			}
			else
			{
				$data['pinfo'] = DB::table('prices')->where('pcount','>',$data['subscription_info']->snofacilitators)->first();
			}

			if($request->pcount == '' and $request->pprice == '')
			{
				
				$fcount = $data['pinfo']->pcount;
				$fprice = $request->wrefprice;				
				//$onedayprice =  number_format(($fprice/30),3); // one day price					
			}
			else
			{
				$fcount = $request->pcount;
				$fprice = $request->pprice;
				//$onedayprice =  number_format(($fprice/30),3); // one day price					
			}

			// to find new price

				if($data['subscription_info']->sbilling == 1)
				{
					$onedayprice =  $data['subscription_info']->stotalprice/365;
				}
				else
				{
					
					if($data['subscription_info']->sbilling == 0)
					{
						$onedayprice =  $data['subscription_info']->stotalprice/30;
					}
					if($data['subscription_info']->sbilling == 3)
					{
						$onedayprice =  $data['subscription_info']->stotalprice/90;
					}
					if($data['subscription_info']->sbilling == 6)
					{
						$onedayprice =  $data['subscription_info']->stotalprice/180;
					}										
					if($data['subscription_info']->sbilling == 9)
					{
						$onedayprice =  $data['subscription_info']->stotalprice/270;
					}					
					
				}
				
				
				
				$start_date = date("Y-m-d");
				$trial_checking = DB::table('subscription')->where([["suserid","=",session('lcbuser_id')]])->where('trial_end_date', '>', $start_date)->count();
				if($trial_checking == 0)
				{
					$start_date1 = date("Y-m-d");
					$end_date = $data['subscription_info']->send_date;
				}
				else
				{
					$start_date1 = $data['subscription_info']->trial_end_date;
					$end_date = $data['subscription_info']->send_date;
				}
				
				
 				
 				$dateDiff = $this->dateDifference($start_date1, $end_date);	


				
				
				$to_minus_price2 = number_format(($dateDiff * $onedayprice),2);
				
				$to_minus_price = str_replace(",","",$to_minus_price2);
				
				$final_price2 = number_format(($fprice - $to_minus_price),2);

				$final_price = str_replace(",","",$final_price2);
				
				
			// to find new price
			
			
		$data['new_price'] = $final_price;
		
		
		
		
		
		$em = explode("___",$request->no_facilitators);
		
		$data['ord_no'] = $this->VerificationCode(10);
		DB::table('upgrade_subscription_payment')->insert(['pay_user_id' => session('lcbuser_id'),'pay_order_number' => $data['ord_no'],'pay_payment_date' => '',
		'pay_status' => '0','pay_trans_id' => '','pay_current_suscription' => $data['subscription_info']->snofacilitators,'pay_no_baristas' => $em[0],'pay_billed_choice' => $request->billing,'pay_count' => $fcount,'pay_paid_amount' => $data['new_price'],'pay_amount' => $fprice]);		
		return view('user/upgradepaypalpayment',$data);
						
		}
		$data['subscription_details'] = DB::table('subscription')->where('suserid',session('lcbuser_id'))->orderBy('sid','DESC')->first();	
		
		if($data['subscription_details']->sbilling == 1)
		{
			$data['subscription_details_info'] = 12;
		}
		else
		{
			$data['subscription_details_info'] = $data['subscription_details']->sbilling;
		}
		
		$nextmonthinfocount = DB::table('months')->where('mcount','>',$data['subscription_details']->sbilling)->count();	
		$data['nextmonthinfo'] = DB::table('months')->where('mcount','>',$data['subscription_details']->sbilling)->first();	
		

		
		
		if($data['subscription_details']->sbilling != 1)
		{
			$data['allsubscriptions'] = DB::table('prices')->where('pstatus','1')->where('pcount','>=',$data['subscription_details']->snofacilitators)->orderBy('pid','ASC')->get();
			$data['allsubscriptions_one'] = DB::table('prices')->where('pstatus','1')->where('pcount','>=',$data['subscription_details']->snofacilitators)->orderBy('pid','ASC')->first();		
		}
		else
		{
			$data['allsubscriptions'] = DB::table('prices')->where('pstatus','1')->where('pcount','>',$data['subscription_details']->snofacilitators)->orderBy('pid','ASC')->get();
			$data['allsubscriptions_one'] = DB::table('prices')->where('pstatus','1')->where('pcount','>',$data['subscription_details']->snofacilitators)->orderBy('pid','ASC')->first();	
		}
		
		
		
		if($data['subscription_details']->sbilling == 0)
		{
			$data['nprice'] = $data['allsubscriptions_one']->pprice * 3;		
		}
				
		if($data['subscription_details']->sbilling == 3)
		{
			$data['nprice'] = $data['allsubscriptions_one']->pprice * 6;
		}
		if($data['subscription_details']->sbilling == 6)
		{
			$data['nprice'] = $data['allsubscriptions_one']->pprice * 9;
		}		
		if($data['subscription_details']->sbilling == 9 || $data['subscription_details']->sbilling == 1)
		{
			//$data['nprice'] = $data['allsubscriptions_one']->pprice * 12;
			

			$fortmonth = $data['allsubscriptions_one']->pprice * 12;
			$perc = ($fortmonth * 5)/100;
			$fprice = $fortmonth - $perc;			
			$data['yinfo'] = "$".$fprice." every year";
			$data['permessage'] = "(Includes 5% discount - normal price $".$fortmonth.")";
			$finalprice=$fprice;
			$data['nprice'] = $fprice;
						
		}		
		
		
		//$data['nprice'] = $data['allsubscriptions_one']->pcount * $data['subscription_details']->stotalprice;
		//$data['pinfo'] = DB::table('prices')->where('pstatus','1')->where('pprice','>',$data['subscription_details']->stotalprice)->first();
		$pinfos = DB::table('prices')->where('pstatus','1')->where('pcount','>',$data['subscription_details']->snofacilitators)->count();
		if($pinfos != 0)
		{
			$data['pinfo'] = DB::table('prices')->where('pstatus','1')->where('pcount','>',$data['subscription_details']->snofacilitators)->first();
		}
		else
		{
			$data['pinfo'] = DB::table('prices')->where('pstatus','1')->where('pcount','>=',$data['subscription_details']->snofacilitators)->first();
		}
		
		return view('user/upgrade_subscription',$data);
	
	}
	
	public function subscription(Request $request)
	{	
	
		$user_info = $this->userdetails();
/*		if($user_info->user_status != 3)
		{
			if(session('lcbuser_status') == 0)
			{
				return redirect('/choice');
			}
			else if(session('lcbuser_status') == 2)
			{
				return redirect('/beforeyoustart');
			}										
			else if(session('lcbuser_status') == 1)
			{
				return redirect('/verification');
			}
			else
			{
				return redirect('/home');
			}			
		}*/	
		if($request->isMethod("post"))
		{
			// 30 days free trail date informations
			$startdate = date("Y-m-d");
			$enddate = date('Y-m-d', strtotime('+30 days'));

			// 30 days free trail date informations		
			
			if($request->pcount == '' and $request->pprice == '')
			{
				$fcount = 1;
				$fprice = 20;
			}
			else
			{
				$fcount = $request->pcount;
				$fprice = $request->pprice;				
			}
			
			//DB::table('subscription')->insert(['suserid' => session('lcbuser_id'),'snofacilitators' => $fcount,'stotalprice' => $fprice,'sbilling' => $request->billing_first,'sstart_date' => $startdate,'send_date' => $enddate,'trial_end_date' => $enddate,'sstatus' => '1','activefacilitator_count' => '1']);
			
			DB::insert('CALL addSubscription(?,?,?,?,?,?,?,?,?)',array(session('lcbuser_id'),$fcount,$fprice,$request->billing_first,$startdate,$enddate,$enddate,'1','1'));
			
			
			//$userinfo = DB::table('siteusers')->where([["user_id","=",session('lcbuser_id')]])->first();
			
			$user_info1 =  DB::select('CALL getUserByID(?)',array(session('lcbuser_id')));	
			$userinfo = $user_info1[0];
			
						
			$values = array('user_status' => '1');
			DB::table('siteusers')->where([["user_id","=",session('lcbuser_id')]])->update($values);		
			$sdata2['m_name'] = $userinfo->user_name;
			$sdata2['m_emailid'] = $userinfo->user_emailid;
			$sdata2['m_code'] = $userinfo->user_token;	
			Mail::send('mail.mail_register', $sdata2, function($message) use ($sdata2) {
			$subject = "Use ".$sdata2['m_code']." to validate your Lean Coffee Brew email address";
			$message->to($sdata2['m_emailid'],$sdata2['m_name'])->subject($subject);
			});	
						
			return redirect('verification');
				
		}
		$values = array('user_status' => '3');
		DB::table('siteusers')->where([["user_id","=",session('lcbuser_id')]])->update($values);		
		$data['allsubscriptions'] = DB::table('prices')->where('pstatus','1')->orderBy('pid','ASC')->get();
		$data['pinfo'] = DB::table('prices')->where('pstatus','1')->where('pid','1')->first();
		return view('user/subscription',$data);
	}
	
	
	public function verification(Request $request)
	{
		$user_info = $this->userdetails();
		if($user_info->user_status != 1)
		{
			if(session('lcbuser_status') == 0)
			{
				return redirect('/choice');
			}
			else if(session('lcbuser_status') == 3)
			{
				return redirect('/subscription');
			}										
			else if(session('lcbuser_status') == 2)
			{
				return redirect('/beforeyoustart');
			}
			else
			{
				if($user_info->user_type == 1)
				{
					if($user_info->user_ftype == 0)
					{
						return redirect('/home');
					}
					else
					{
						return redirect('/customerhome');
					}
				}
				else
				{
					return redirect('/attendeehome');
				}
			}		
		}
		
		
		if($request->isMethod("post"))
		{
			$vcodevalid = DB::table('siteusers')->where([["user_id","=",session('lcbuser_id')]])->where([["user_token","=",$request->vcode]])->count();
			if($vcodevalid == 0)
			{
				return redirect('/verification')->with("error","Sorry your verification code is invalid");
			}
			else
			{
				// to send welcome email to the user			
				$sdata2['m_name'] = $user_info->user_name;
				$sdata2['m_emailid'] = $user_info->user_emailid;
			
				if($user_info->user_type != '3')
				{	
				Mail::send('mail.mail_welcome', $sdata2, function($message) use ($sdata2) {
				$subject = "Welcome to LeanCoffeeBrew";
				$message->to($sdata2['m_emailid'],$sdata2['m_name'])->subject($subject);
				});		
				}			
				// to send welcome email to the user
				
				
				$values = array('user_status' => '4');
				DB::table('siteusers')->where([["user_id","=",session('lcbuser_id')]])->update($values);	
				if($user_info->user_type == 1)
				{		
				
					// to check user comes from request
					$requ_count =  DB::table('attendees_request')->where('rtoken',session('dummy_token'))->where('remailid',session('dummy_emailid'))->count();
					if($requ_count == 1)
					{
						DB::table('attendees_request')->where('rtoken',session('dummy_token'))->where('remailid',session('dummy_emailid'))->delete();	
						session()->put('dummy_token','');			
						session()->put('dummy_emailid','');											
					}
					// to check user comes from request							
					if($user_info->user_ftype == 0)
					{						
						return redirect('/home');
					}
					else
					{
						return redirect('/customerhome');
					}
				}
				else
				{
					// to check user comes from request
					$requ_count =  DB::table('attendees_request')->where('rtoken',session('dummy_token'))->where('remailid',session('dummy_emailid'))->count();
					if($requ_count == 1)
					{
						$values = array('rstatus' => '1');
						DB::table('attendees_request')->where([["rtoken","=",session('dummy_token')]])->where([["remailid","=",session('dummy_emailid')]])->update($values);	
						session()->put('dummy_token','');			
						session()->put('dummy_emailid','');											
					}
					// to check user comes from request
					
					return redirect('/attendeehome');
				}			
			}
		}
		return view('user/verification');
	}
	
	public function sendanothercode()
	{
		$vcode = $this->VerificationCode(5);
		$values = array('user_token' => $vcode);
		DB::table('siteusers')->where([["user_id","=",session('lcbuser_id')]])->update($values);
		//$userinfo = DB::table('siteusers')->where([["user_id","=",session('lcbuser_id')]])->first();	
		
		$user_info1 =  DB::select('CALL  getUserByID(?)',array(session('lcbuser_id')));	
		$userinfo = $user_info1[0];
		
				
			// send mail
			$sdata2['m_name'] = $userinfo->user_name;
			$sdata2['m_emailid'] = $userinfo->user_emailid;
			$sdata2['m_code'] = $vcode;
			
			Mail::send('mail.mail_register', $sdata2, function($message) use ($sdata2) {
			$subject = "Use ".$sdata2['m_code']." to validate your Lean Coffee Brew email address";
			$message->to($sdata2['m_emailid'],$sdata2['m_name'])->subject($subject);
			});					
			// send mail
					
		return 1;		
	}
	
	public function checkeuseralready(Request $request)
	{
		$ucount = DB::table('siteusers')->where([["user_emailid","=",$request->emid]])->where("user_type","1")->count();
		/*$user_info = $this->userdetails(); 
		if($request->emid != $user_info->user_emailid)		
		{*/
		if($ucount == 0) 
		{
			// to check in deleted table
					$reqdelcount = DB::table('facilitators_deleted_request')->where([["remailid","=",$request->emid]])->where('ruserid',session('lcbuser_id'))->count();
					
					// to check in deleted table
					if($reqdelcount == 1)
					{
						$retcount = 4;
						$results=array("findcount"=>$retcount);
     					return response()->json($results);
					}
					
					
			$reqcount = DB::table('facilitators_request')->where([["remailid","=",$request->emid]])->where('ruserid',session('lcbuser_id'))->count();
			if($reqcount == 0)
			{				
				// check subscription limit reached
				$current_count = DB::table('subscription')->where('suserid',session('lcbuser_id'))->first();
				$ccount = $current_count->activefacilitator_count;
				$acount = $current_count->snofacilitators;
				if($acount == $ccount)
				{
					$retcount = 3;
				}
				else
				{
					// to check in deleted table
					$reqdelcount = DB::table('facilitators_deleted_request')->where([["remailid","=",$request->emid]])->where('ruserid',session('lcbuser_id'))->count();
					// to check in deleted table
					if($reqdelcount == 0)
					{
						$retcount = 0;
					}
					else
					{
						$retcount = 4;
					}
				}
				// check subscription limit reached
			}
			else
			{
				$retcount = 2;
			}
		}
		else
		{
			$retcount = 1;
		}
		
		$results=array("findcount"=>$retcount);
     	return response()->json($results);
	}
	
	public function removefacilitators(Request $request)
	{
	
		$req_info = DB::table('facilitators_request')->where('rid',$request->id)->first();
			
		// add from delete table
		$todaydate = date("Y-m-d");
		DB::table('facilitators_deleted_request')->insert(['ruserid' => $req_info->ruserid,'remailid' => $req_info->remailid,'rdate' => $todaydate]);
		// add from delete table
		
		
		
		// remove the user also suppose he registered in the website
		$tcount = DB::table('siteusers')->where('user_emailid',$req_info->remailid)->count();
		if($tcount == 1)
		{
			DB::table('siteusers')->where('user_emailid',$req_info->remailid)->delete();
		}
		// remove the user also suppose he registered in the website
		
				
		// remove from request table
		DB::table('facilitators_request')->where('rid',$request->id)->delete();
		// remove from request table	
		

		
		$current_count = DB::table('subscription')->where('suserid',session('lcbuser_id'))->first();
		$ccount = $current_count->activefacilitator_count;
		$newcount = $ccount - 1;
		$values = array('activefacilitator_count' => $newcount);
		DB::table('subscription')->where([["suserid","=",session('lcbuser_id')]])->update($values);		
		
			
	 	$results=array("status"=>'1');
     	return response()->json($results);	
	}
	
	public function addrequest(Request $request)
	{
		$todaydate = date("Y-m-d");
		DB::table('facilitators_request')->insert(['ruserid' => session('lcbuser_id'),'remailid' =>$request->emid,'rdate' => $todaydate]);
		$user_info = $this->userdetails();
		$fac_info = $this->fac_lists();
		// create table
		$htmlmsg = "<table class='table table-bordered'>";
		$htmlmsg.="<tr><td>";
		$htmlmsg.=$user_info->user_emailid."</td><td>";
		$htmlmsg.=$user_info->user_name."</td></tr>";
		
		foreach($fac_info as $fs)
		{
		$uid = "user_id_".$fs->rid;
		$did = $fs->rid;
		$htmlmsg.="<tr id=".$uid."><td>";
		$htmlmsg.=$fs->remailid."</td>";
		$htmlmsg.="<td></td>";
		$htmlmsg.="<td><a class='re_btn btn-danger btn-sm delete-facilitators' data-id='$did' href='javascript:void(0)' alt='Delete' title='Delete'>REMOVE</a></td></tr>";
		}
		$htmlmsg.="</table>";
		// create table
		
		$current_count = DB::table('subscription')->where('suserid',session('lcbuser_id'))->first();
		$ccount = $current_count->activefacilitator_count;
		$newcount = $ccount + 1;
		$values = array('activefacilitator_count' => $newcount);
		DB::table('subscription')->where([["suserid","=",session('lcbuser_id')]])->update($values);				
		$results=array("message"=>'success',"htmlinfo"=>$htmlmsg);
		
			// send mail
			//$userinfo = DB::table('siteusers')->where([["user_id","=",session('lcbuser_id')]])->first();				
			
			$user_info1 =  DB::select('CALL  getUserByID(?)',array(session('lcbuser_id')));	
			$userinfo = $user_info1[0];
			
						
			$sdata2['m_name'] = $userinfo->user_name;
			$sdata2['m_emailid'] = $request->emid;			
			Mail::send('mail.mail_request', $sdata2, function($message) use ($sdata2) {
			$subject = $sdata2['m_name']." has invited you to a Lean Coffee Brew!";
			$message->to($sdata2['m_emailid'])->subject($subject);
			});					
			// send mail
					
     	return response()->json($results);
	}
	
	
	
	
	public function showrelatedpricedetails_update(Request $request)
	{
		
		$selpid = $request->id;
		$selmid = $request->mid;
		
		if($selmid == 1)
		{

			$fc_count = DB::table('prices')->where('pid',$selpid)->first();
			$fortmonth = $fc_count->pprice * 12;
			$perc = ($fortmonth * 5)/100;
			$fprice = $fortmonth - $perc;			
			$final_price = "$".$fprice." every year";
			$permessage = "(Includes 5% discount - normal price $".$fortmonth.")";
			$finalprice=$fprice;
			
		}
		else
		{
			$fc_count = DB::table('prices')->where('pid',$selpid)->first();
			if($selmid == 0)
			{
				$fprice = $fc_count->pprice;
				$final_price = "$".$fprice."/month";				
			}
			else
			{
				$fprice = $fc_count->pprice * $selmid;
				$final_price = "$".$fprice." for ".$selmid." months";				
			}
			
			

			$perc = 0;$permessage=0;$finalprice=0;		

		}
		
		
		$newimage = url('/user/images/People-').$selpid.".png";
		$sts=1;
	 	$results=array("no_fac"=>$fc_count->pcount,"name"=>$fc_count->pname,"tprice"=>$final_price,"timage"=>$newimage,"extmessage"=>$permessage,"extra"=>$perc,"onlyprice"=>$fc_count->pprice,"finalprice"=>$finalprice,"singledayprice"=>$sprice);
     	return response()->json($results);
	}	
	
	public function showrelatedpricedetails(Request $request)
	{
		
		$selpid = $request->id;
		$selmid = $request->mid;
		
		if($selmid == 1 || $selmid == 12)
		{

			
			$fc_count = DB::table('prices')->where('pid',$selpid)->first();
			$fortmonth = $fc_count->pprice * 12;
			$perc = ($fortmonth * 5)/100;
			$fprice = $fortmonth - $perc;			
			$final_price = "$".$fprice." every year";
			$permessage = "(Includes 5% discount - normal price $".$fortmonth.")";
			$finalprice=$fprice;			
		}
		else
		{
			$fc_count = DB::table('prices')->where('pid',$selpid)->first();
			if($selmid == 0)
			{
				$fprice = $fc_count->pprice;
				$final_price = "$".$fprice."/month";
			}
			else
			{
				$fprice = $fc_count->pprice * $selmid;
				$final_price = "$".$fprice." for ".$selmid." months";
			}
			
					
			
			
			$perc = 0;$permessage=0;$finalprice=0;
		}
		
		
		$newimage = url('/user/images/People-').$selpid.".png";
		$sts=1;
	 	$results=array("no_fac"=>$fc_count->pcount,"name"=>$fc_count->pname,"tprice"=>$final_price,"timage"=>$newimage,"extmessage"=>$permessage,"extra"=>$perc,"onlyprice"=>$fprice,"finalprice"=>$finalprice);
     	return response()->json($results);
	}	
	
	public function leavethisgroup(Request $request)
	{	
		$req_info = DB::table('facilitators_request')->where('remailid',$request->emid)->first();
			
		// add to delete table
		$todaydate = date("Y-m-d");
		DB::table('facilitators_deleted_request')->insert(['ruserid' => $req_info->ruserid,'remailid' => $req_info->remailid,'rdate' => $todaydate]);
		// add to delete table
		
		 	
		
		
		// find who added
		//$parent_facilitator_info = DB::table('siteusers')->where('user_id',session('lcbuser_id'))->first();
		
		$parent_facilitator_info1 =  DB::select('CALL  getUserByID(?)',array(session('lcbuser_id')));	
		$parent_facilitator_info = $parent_facilitator_info1[0];
		
				
		// find who added
		
		$current_count = DB::table('subscription')->where('suserid',$parent_facilitator_info->user_ftype)->first();
		
		
		
		//remove from request table
		 DB::table('facilitators_request')->where('remailid',$request->emid)->where('ruserid',$parent_facilitator_info->user_ftype)->delete();
		 //remove from request table	
		 
		 		
		$ccount = $current_count->activefacilitator_count;
		$newcount = $ccount - 1;
		$values = array('activefacilitator_count' => $newcount);
		DB::table('subscription')->where([["suserid","=",$parent_facilitator_info->user_ftype]])->update($values);	
		
		$values = array('user_ftype' => '0');
		DB::table('siteusers')->where([["user_id","=",session('lcbuser_id')]])->update($values);		
		
		// remove if any meeting created by this user
		DB::table('attendees_request')->where('ruserid',session('lcbuser_id'))->delete();	
		DB::table('boards')->where('meeting_by',session('lcbuser_id'))->delete();		
		// remove if any meeting created by this user
		
		
		// for this user add first subscription details
$startdate = date("Y-m-d");
$enddate = date('Y-m-d', strtotime('+30 days'));
$fcount = 1;
$fprice = 20;

/*DB::table('subscription')->insert(['suserid' => session('lcbuser_id'),'snofacilitators' => $fcount,'stotalprice' => $fprice,'sbilling' => '0','sstart_date' => $startdate,'send_date' => $enddate,'trial_end_date' => $enddate,'sstatus' => '1','activefacilitator_count' => '1']);*/

DB::insert('CALL addSubscription(?,?,?,?,?,?,?,?,?)',array(session('lcbuser_id'),$fcount,$fprice,0,$startdate,$enddate,$enddate,'1','1'));

		
		// for this user add first subscription details		
				//$userinfo_new = DB::table('siteusers')->where([["user_id","=",session('lcbuser_id')]])->first();
				
				$user_info1 =  DB::select('CALL  getUserByID(?)',array(session('lcbuser_id')));	
				$userinfo_new = $user_info1[0];
				
								
				
					session()->put('lcbuser_id',$userinfo_new->user_id);			
				 	session()->put('lcbuser_name',$userinfo_new->user_name);
					session()->put('lcbuser_ftype',$userinfo_new->user_ftype);
					
									
	 	$results=array("status"=>'1');
     	return response()->json($results);		
		
	}
	
	public function updatelcbvalue(Request $request)
	{
		$values = array('user_ccbname' => $request->newvalue);
		DB::table('siteusers')->where([["user_id","=",session('lcbuser_id')]])->update($values);
		return 1;
	}					
		   
}
