<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class CreateAgendaDiscussionTable extends Migration
{
    public function up()
    {
        Schema::create('agenda_discussion', function (Blueprint $table) {

		$table->bigIncrements('agenda_discussion_id');
		$table->integer('agenda_for_item_id');
		$table->integer('agenda_user_id');
		$table->string('agenda_title',255);
		$table->text('agenda_url')->nullable();
		$table->integer('agenda_lna');
		$table->timestamp('agenda_time')->default(DB::raw('CURRENT_TIMESTAMP'));
		$table->integer('agenda_meeting_id');
		$table->integer('agenda_meeting_created_by');

        });
    }

    public function down()
    {
        Schema::dropIfExists('agenda_discussion');
    }
}