<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class CreateNewsTable extends Migration
{
    public function up()
    {
        Schema::create('news', function (Blueprint $table) {

		$table->bigIncrements('news_id');
		$table->string('news_title',255);
		$table->text('news_sinfo');
		$table->longtext('news_info');
		$table->string('news_image');
		$table->date('news_date');
		$table->integer('news_status');
		$table->string('slug')->nullable();

        });
    }

    public function down()
    {
        Schema::dropIfExists('news');
    }
}