<?php

use Illuminate\Database\Seeder;

class WhatislcbTableSeeder extends Seeder
{
    /**
     * Run the database seeds.
     *
     * @return void
     */
    public function run()
    {


		DB::table('whatislcb')->truncate();
		$whatislcbarray = array(

			array('wid' => 1,'wtitle' => 'LeanCoffeeBrew','wvideo' => '','wcontents' => '<p>Lean Coffee started in Seattle in 2009. Not Surprising, since this is where Starbucks started. Jim Benson and Jeremy Lightsmith wanted to start a group that would use Lean techniques to discuss topics of interest with like-minded people  instead of starting a whole new cumbersome organization with steering committees, speakers, and such. They wanted a group that did not rely on anything other than open-minded people showing up and wanting to learn or create.</p>

<p>While nothing can improve upon a Lean Coffee with physical post-it notes and markers at a table  we want to enable distributed teams to use virtual Personal Kanban to conduct rapid and effective conversations.</p>','whowitworks' => "<h3>Board Setup</h3>
<ul>
      <li>Coffee House Baristas can set up a Lean Coffee and invite participants by email.</li>
      <li>Participants click on the email link in the invitation to join the group, and then can add topics they would like to discuss to the board.</li>
    </ul>
<p>&nbsp;</p>
    <h3>Running A Virtual Lean Coffee</h3>
    <ul>
  <li>The Barista who set up the board will facilitate the session.</li>
  <li>Each&nbsp;participant&nbsp;writes topics they want the meeting to consider discussing.</li>
  <li>Participants&nbsp;vote on the topics they would like to discuss.</li>
  <li>Topics are voted on, and then moved into the 'To Discuss' column in ranking order.</li>
  <li>The Barista then selects the highest voted topic from the    To Discuss' column, and moves it to the 'Discussing' column, and starts the timer.</li>
  <li>Once the allotted time is up,&nbsp;participants decide if they want to continue discussing the topic by clicking   on the 'thumbs up' or 'thumbs down' buttons.</li>
  <li>If there are more 'ups' than 'downs', then the Barista restarts the timer and the discussion continues. If not, the group moves onto the next ranked topic from the 'To Discuss' column.</li>
  <li>This continues until the end of the timebox, typically forty-five minutes to one hour.</li>
  <li>During the session, the Baristas may add follow-ups and notes to each topic card.</li>
  <li>Once the session has finished, the Barista can download a summary report detailing the session participants, topics discussed, and associated follow-ups and notes.</li>
</ul>",'woriginscontent' => "<p>We use Lean Coffee with our clients to facilitate retrospectives, communities of practice, open spaces, etc. We have found it is a great way to drive energized, effective discussions on topics that are high priority and interest for the participants.</p>
  <p>However, in today's world, more and more people are working from different locations or remote. Face-to-Face collaboration is becoming increasingly challenging and expensive. We tried tools like WebEx, Skype, and other online meeting tools, but all of them are more suited for presentations and providing updates. So, we decided to write our own cloud application based on the effective Lean Coffee method. If you have suggestions on how to improve the tool, please contact us and share your thoughts.</p>"),
	
			);
		DB::table('whatislcb')->insert($whatislcbarray);
    
    
    
    }
}
