<meta name="csrf-token" content="{{ csrf_token() }}">
@include('common.adminheader')
<div class="content-wrapper">
    <!-- Content Header (Page header) -->
    <section class="content-header">
      <div class="container-fluid">
        <div class="row mb-2">
          <div class="col-sm-6">
            <h1>Change Password</h1>
          </div>
          <div class="col-sm-6">
            <ol class="breadcrumb float-sm-right">
              <li class="breadcrumb-item"><a href="{{url('admin/home')}}">Home</a></li>
              <li class="breadcrumb-item active">Change Password</li>
            </ol>
          </div>
        </div>
      </div><!-- /.container-fluid -->
    </section>

    <!-- Main content -->
    <section class="content">
      <form method="post" action="" name="change_pwd_form" id="change_pwd_form">{{ csrf_field() }}      
      <div class="row">
        <div class="col-md-12">
          <div class="card card-primary">
            <div class="card-header"></div>
            <div class="card-body">
            
              <div class="form-group">
                <label for="inputName">Current Password</label>
                <input type="password" id="old_pwd" name="old_pwd" class="form-control">
              </div>
              <div class="form-group">
                <label for="inputName">New Password</label>
                <input type="password" id="new_pwd" name="new_pwd" class="form-control">
              </div>
              <div class="form-group">
                <label for="inputName">Confirm New Password</label>
                <input type="password" id="cnew_pwd" name="cnew_pwd" class="form-control">
              </div>              
                                 
              
            </div>
            <!-- /.card-body -->
          </div>
          <!-- /.card -->
        </div>
        
      </div>
      <div class="row">
        <div class="col-12">
          <a href="{{url('admin/home')}}" class="btn btn-secondary">CANCEL</a>
          <input type="submit" value="Change Password" class="btn btn-success float-right">
        </div>
      </div>
      <div>&nbsp;</div>
      </form>
    </section>
    <!-- /.content -->
  </div>
@include('common.adminfooter')
<!-- Form validation starts here -->
<script type="text/javascript" src="{{url('admin/dist/js/jquery.validate.min.js')}}"></script>
<script type="text/javascript">

$(document).ready(function() {	

$.validator.addMethod("pwdcheck", function(value) {
   return /^[A-Za-z0-9\d=!\-@._*]*$/.test(value) // consists of only these
       && /[A-Z]/.test(value) // has a uppercase letter
       && /[a-z]/.test(value) // has a lowercase letter
       && /[^\w+$]/.test(value) // has a special letter
       && /\d/.test(value) // has a digit
});


$("#change_pwd_form").validate({		
rules: {
old_pwd: {
required: true
},
new_pwd: {
required:true,
pwdcheck: true,
minlength: 6		
},
cnew_pwd:{
required: true,
equalTo:"#new_pwd"
}		
},	
messages: {
old_pwd: {
required: '<span class="myerror">Please enter your current password</span>'
},
new_pwd: {
required: '<span class="myerror">Please enter your new password</span>',
pwdcheck: '<span class="myerror">Password must contains atleast one Uppercase,one Lowercase,one Special character and one number</span>',
minlength: '<span class="myerror">Password length must be atleas 6 characters</span>'
},
cnew_pwd: {
required: '<span class="myerror">Please confirm your new password</span>',
equalTo: '<span class="myerror">Password mismatch</span>'
}
}
});

// form submit



// form submit

});
</script>
<!-- Form validation ends here -->