<?php
/**
 * Plugin Name: WP Logo Showcase Responsive Slider
 * Plugin URI: http://www.wponlinesupport.com/
 * Description: Easy to add and display Logo Showcase Responsive Slider on your website. 
 * Author: WP Online Support 
 * Version: 1.2.3
 * Author URI: http://www.wponlinesupport.com/
 *
 * @package WordPress
 * @author SP Technolab
 */

if( !defined( 'WPLS_VERSION' ) ) {
    define( 'WPLS_VERSION', '1.2.3' ); // Version of plugin
}
if( !defined( 'WPLS_DIR' ) ) {
    define( 'WPLS_DIR', dirname( __FILE__ ) ); // Plugin dir
}
if( !defined( 'WPLS_URL' ) ) {
    define( 'WPLS_URL', plugin_dir_url( __FILE__ ) ); // Plugin url
}

/**
 * Function to get plugin image sizes array
 * 
 * @package WP Logo Showcase Responsive Slider
 * @since 1.2.1
 */
function wplss_get_unique() {
	static $unique = 0;
	$unique++;
	
	return $unique;
}

add_action( 'wp_enqueue_scripts','wplss_logoshowcase_style_css' );
function wplss_logoshowcase_style_css() {
	
	// Registring slick slider script
	if( !wp_script_is( 'wpos-slick-jquery', 'registered' ) ) {
		wp_register_script( 'wpos-slick-jquery', WPLS_URL.'assets/js/slick.min.js', array('jquery'), WPLS_VERSION, true );
		wp_enqueue_script( 'wpos-slick-jquery' );
	}
	
	wp_enqueue_style( 'logo_showcase_slick_style',  WPLS_URL . 'assets/css/slick.css', array(), WPLS_VERSION);
	wp_enqueue_style( 'logo_showcase_style',  WPLS_URL . 'assets/css/logo-showcase.css', array(), WPLS_VERSION);
}
require_once( 'includes/logo-showcase-functions.php' );