<?php
	global $wpdb, $pmpro_msg, $pmpro_msgt, $pmpro_levels, $current_user, $levels, $pmpro_currency_symbol;
	
	//if a member is logged in, show them some info here (1. past invoices. 2. billing information with button to update.)
	if($current_user->membership_level->ID)
	{
	?>	
	<div id="pmpro_account">		
		<div id="pmpro_account-membership" class="pmpro_box">
			<div class="message"><p><?php _e("Your membership is <strong>active</strong>.", "vibe");?></p></div>
			<hr />
			<ul class="pmpro_account_list">
				<li><strong><?php _e("Level", "vibe");?>:</strong> <?php echo $current_user->membership_level->name?></li>
			<?php if($current_user->membership_level->billing_amount > 0) { ?>
				<li><strong><?php _e("Membership Fee", "vibe");?>:</strong>
				<?php
					$level = $current_user->membership_level;
					if($current_user->membership_level->cycle_number > 1) {
						printf(_x('%s every %d %s.', 'Recurring payment in cost text generation. E.g., $5 every 2 months.', 'vibe'), $pmpro_currency_symbol . $level->billing_amount, $level->cycle_number, pmpro_translate_billing_period($level->cycle_period, $level->cycle_number));
					} elseif($current_user->membership_level->cycle_number == 1) {
						printf(_x('%s per %s.', 'Recurring payment in cost text generation. E.g. $5 every month.', 'vibe'), $pmpro_currency_symbol . $level->billing_amount, pmpro_translate_billing_period($level->cycle_period));
					} else { 
						echo $pmpro_currency_symbol, $current_user->membership_level->billing_amount;
					}
				?>
				</li>
			<?php } ?>						
			
			<?php if($current_user->membership_level->billing_limit) { ?>
				<li><strong><?php _e("Duration", "vibe");?>:</strong> <?php echo $current_user->membership_level->billing_limit.' '.sornot($current_user->membership_level->cycle_period,$current_user->membership_level->billing_limit)?></li>
			<?php } ?>
			
			<?php if($current_user->membership_level->enddate) { ?>
				<li><strong><?php _e("Membership Expires", "vibe");?>:</strong> <?php echo date_i18n(get_option('date_format'), $current_user->membership_level->enddate)?></li>
			<?php } ?>
			
			<?php if($current_user->membership_level->trial_limit == 1) 
			{ 
				printf(__("Your first payment will cost %s.", "vibe"), $pmpro_currency_symbol . $current_user->membership_level->trial_amount);
			}
			elseif(!empty($current_user->membership_level->trial_limit)) 
			{
				printf(__("Your first %d payments will cost %s.", "vibe"), $current_user->membership_level->trial_limit, $pmpro_currency_symbol . $current_user->membership_level->trial_amount);
			}
			?>
			</ul>
		</div> <!-- end pmpro_account-membership -->
		
		<div id="pmpro_account-profile" class="pmpro_box">	
			<?php get_currentuserinfo(); ?> 
			<h3 class="heading"><?php _e("My Account", "vibe");?></h3>
			<?php if($current_user->user_firstname) { ?>
				<p><?php echo $current_user->user_firstname?> <?php echo $current_user->user_lastname?></p>
			<?php } ?>
			<ul class="pmpro_account_list">
				<li><strong><?php _e("Username", "vibe");?>:</strong> <?php echo $current_user->user_login?></li>
				<li><strong><?php _e("Email", "vibe");?>:</strong> <?php echo $current_user->user_email?></li>
			</ul>
		</div> <!-- end pmpro_account-profile -->
	
		<?php
			//last invoice for current info
			//$ssorder = $wpdb->get_row("SELECT *, UNIX_TIMESTAMP(timestamp) as timestamp FROM $wpdb->pmpro_membership_orders WHERE user_id = '$current_user->ID' AND membership_id = '" . $current_user->membership_level->ID . "' AND status = 'success' ORDER BY timestamp DESC LIMIT 1");				
			$ssorder = new MemberOrder();
			$ssorder->getLastMemberOrder();
			$invoices = $wpdb->get_results("SELECT *, UNIX_TIMESTAMP(timestamp) as timestamp FROM $wpdb->pmpro_membership_orders WHERE user_id = '$current_user->ID' ORDER BY timestamp DESC LIMIT 6");				
			if(!empty($ssorder->id) && $ssorder->gateway != "check" && $ssorder->gateway != "paypalexpress" && $ssorder->gateway != "paypalstandard" && $ssorder->gateway != "twocheckout")
			{
				//default values from DB (should be last order or last update)
				$bfirstname = get_user_meta($current_user->ID, "pmpro_bfirstname", true);
				$blastname = get_user_meta($current_user->ID, "pmpro_blastname", true);
				$baddress1 = get_user_meta($current_user->ID, "pmpro_baddress1", true);
				$baddress2 = get_user_meta($current_user->ID, "pmpro_baddress2", true);
				$bcity = get_user_meta($current_user->ID, "pmpro_bcity", true);
				$bstate = get_user_meta($current_user->ID, "pmpro_bstate", true);
				$bzipcode = get_user_meta($current_user->ID, "pmpro_bzipcode", true);
				$bcountry = get_user_meta($current_user->ID, "pmpro_bcountry", true);
				$bphone = get_user_meta($current_user->ID, "pmpro_bphone", true);
				$bemail = get_user_meta($current_user->ID, "pmpro_bemail", true);
				$bconfirmemail = get_user_meta($current_user->ID, "pmpro_bconfirmemail", true);
				$CardType = get_user_meta($current_user->ID, "pmpro_CardType", true);
				$AccountNumber = hideCardNumber(get_user_meta($current_user->ID, "pmpro_AccountNumber", true), false);
				$ExpirationMonth = get_user_meta($current_user->ID, "pmpro_ExpirationMonth", true);
				$ExpirationYear = get_user_meta($current_user->ID, "pmpro_ExpirationYear", true);	
				?>	
				
				<div id="pmpro_account-billing" class="pmpro_box">
					<h3 class="heading"><?php _e("Billing Information", "vibe");?></h3>
					<?php if(!empty($baddress1)) { ?>
					<p>
						<strong><?php _e("Billing Address", "vibe");?></strong><br />
						<?php echo $bfirstname . " " . $blastname?>
						<br />		
						<?php echo $baddress1?><br />
						<?php if($baddress2) echo $baddress2 . "<br />";?>
						<?php if($bcity && $bstate) { ?>
							<?php echo $bcity?>, <?php echo $bstate?> <?php echo $bzipcode?> <?php echo $bcountry?>
						<?php } ?>                         
						<br />
						<?php echo formatPhone($bphone)?>
					</p>
					<?php } ?>
					
					<?php if(!empty($AccountNumber)) { ?>
					<p>
						<strong><?php _e("Payment Method", "vibe");?></strong><br />
						<?php echo $CardType?>: <?php echo last4($AccountNumber)?> (<?php echo $ExpirationMonth?>/<?php echo $ExpirationYear?>)
					</p>
					<?php } ?>
					
					<?php 
						if((isset($ssorder->status) && $ssorder->status == "success") && (isset($ssorder->gateway) && in_array($ssorder->gateway, array("authorizenet", "paypal", "stripe", "braintree", "payflow", "cybersource")))) 
						{ 
							?>
							<p><a href="<?php echo pmpro_url("billing", "")?>"><?php _e("Edit Billing Information", "vibe"); ?></a></p>
							<?php 
						} 
					?>
				</div> <!-- end pmpro_account-billing -->				
			<?php
			}
		?>
		
		<?php if(!empty($invoices)) { ?>
		<div id="pmpro_account-invoices" class="pmpro_box">
			<h3 class="heading"><?php _e("Past Invoices", "vibe");?></h3>
			<ul class="pmpro_account_list">
				<?php 
					$count = 0;
					foreach($invoices as $invoice)
					{ 
						if($count++ > 5)
							break;
						?>
						<li><a href="<?php echo pmpro_url("invoice", "?invoice=" . $invoice->code)?>"><?php echo date_i18n(get_option("date_format"), $invoice->timestamp)?> (<?php echo $pmpro_currency_symbol?><?php echo $invoice->total?>)</a></li>
						<?php
					}
				?>
			</ul>
			<?php if($count == 6) { ?>
				<p><a href="<?php echo pmpro_url("invoice"); ?>"><?php _e("View All Invoices", "vibe");?></a></p>
			<?php } ?>
		</div> <!-- end pmpro_account-billing -->
		<?php } ?>
		
		<div id="pmpro_account-links" class="pmpro_box">
			<h3 class="heading"><?php _e("Member Links", "vibe");?></h3>
			<ul class="pmpro_account_list">
				<?php 
					do_action("pmpro_member_links_top");
				?>
				<?php if((isset($ssorder->status) && $ssorder->status == "success") && (isset($ssorder->gateway) && in_array($ssorder->gateway, array("authorizenet", "paypal", "stripe", "braintree", "payflow", "cybersource")))) { ?>
					<li><a href="<?php echo pmpro_url("billing", "", "https")?>"><?php _e("Update Billing Information", "vibe");?></a></li>
				<?php } ?>
				<?php if(count($pmpro_levels) > 1 && !defined("PMPRO_DEFAULT_LEVEL")) { ?>
					<li><a href="<?php echo pmpro_url("levels")?>"><?php _e("Change Membership Level", "vibe");?></a></li>
				<?php } ?>
				<li><a href="<?php echo pmpro_url("cancel")?>"><?php _e("Cancel Membership", "vibe");?></a></li>
				<?php 
					do_action("pmpro_member_links_bottom");
				?>
			</ul>
		</div> <!-- end pmpro_account-links -->		
	</div> <!-- end pmpro_account -->		
	<?php
	}
?>
