<?php
    get_header(vibe_get_header());
    global $wp_query;
    $total_results = $wp_query->found_posts; 
?>
<section id="title">
    <div class="<?php echo vibe_get_container(); ?>">
        <div class="row">
            <div class="col-md-12">
                <div class="pagetitle">
                    <?php vibe_breadcrumbs(); ?>  
                    <h1><?php _e('Search Results for "', 'vibe'); the_search_query(); ?>"</h1>
                    <h5><?php echo $total_results.__(' results found','vibe');  ?></h5>
                </div>
            </div>
        </div>
    </div>
</section>

<section id="content">
    <div class="<?php echo vibe_get_container(); ?>">
        <div class="scontent">
            <?php
                $select_boxes = apply_filters('wplms_course_search_selects','instructors=1&cats=1&location=1&level=1');
               echo the_widget('BP_Course_Search_Widget',$select_boxes,array()); 
            ?>
        </div>
        <?php
            do_action('wplms_course_sidebar_hook');
        ?>
        <div class="search_results">
            <?php
                if ( have_posts() ) : while ( have_posts() ) : the_post();
                //if($post->post_type == 'course'){
                    if(function_exists('thumbnail_generator')){
                        echo '<div class="col-md-3 clear4">'.thumbnail_generator($post,'course','medium',0,0,0).'</div>';
                    }else{
                       echo '<div class="blg_cnt">
<div class="post-type"><i class="fa fa-file-text"></i></div>
<div class="post-author"> <img alt="" src="http://2.gravatar.com/avatar/eb7bacb7c19cdee1f5645ca8e01d8a58?s=70&amp;d=mm&amp;r=g" srcset="http://2.gravatar.com/avatar/eb7bacb7c19cdee1f5645ca8e01d8a58?s=140&amp;d=mm&amp;r=g 2x" class="avatar avatar-70 photo" height="70" width="70"> </div>
<div class="post-head">
  <h3><a itemprop="url" href="'.get_permalink().'" title="'.get_the_title().'" rel="bookmark">'.get_the_title().'</a></h3>
  <div class="post-meta">
    <div><i class="fa fa-user"></i>by : <a href="'.get_author_posts_url( get_the_author_meta( 'ID' ) ).'" title="Posts by '.get_the_author_meta( 'display_name' ).'" rel="author">'.get_the_author_meta( 'display_name' ).'</a></div>
    <div><i class="fa fa-clock-o"></i>'.get_the_time('F  n , Y').'</div>
    <div><i class="fa fa-comments"></i>'.get_comments_number( $post_id ).'Comments</div>
    <meta itemprop="interactionCount" content="UserComments: 0">
    <div><i class="fa fa-folder-open"></i>in : '.get_the_category_list(' , ').'</div>
    <div><a class="post-like " title="Love" id="post-like-152"><i class="fa fa-heart-o"></i><span>0</span></a></div>
  </div>
  <div class="clearfix"></div>
</div>
<div class="post-wrap">
  <div class="post-img post-img-8"> </div>
  <div class="post-inner">
    <p>'.get_the_excerpt().'</p>
    <div class="clearfix"></div>
    <div class="post-share-view">
      <div class="post-meta">
        <div><i class="fa fa-eye"></i><span>'.getCrunchifyPostViews(get_the_ID()).' </span></div>
        <div class="post-meta-share"> <i class="fa fa-share-alt"></i> <a href="#">Share This</a>
          <div class="share-social">
            '.echo do_shortcode('[Social9_Share]').'
            <i class="fa fa-caret-down"></i> </div>
        </div>
        <a href="'.get_permalink().'" title="" rel="bookmark" class="button post-more">Continue Reading</a> </div>
    </div>
    <div class="clearfix"></div>
  </div>
</div>
</div>';
                    }
                //}   
                endwhile;
                else:
                    echo '<h3>'.__('Sorry, No results found.','vibe').'</h3>';
                endif;
                pagination();
                wp_reset_postdata();
            ?>
        </div>
    </div>
</section>
<?php
get_footer(vibe_get_footer());
?>