<?php

namespace App\Http\Controllers\Admin;

use Illuminate\Http\Request;
use App\Http\Controllers\Controller;
use Illuminate\Support\Facades\DB;
use App\Services\Slug;
use Storage;



class AboutusController extends Controller
{


    public function __construct()
    {
        
    }

    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index()
    {
			 

        $recordToShow = 20;
        $aboutusList = DB::table('aboutus')->orderBy('created_at','desc')->paginate($recordToShow);
        return view('back.aboutus.aboutus',compact('aboutusList','recordToShow'));
    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {
        
        // return view('back.aboutus.aboutus-add')->withaboutuscategory($aboutuscategory);
        // return view('back.aboutus.aboutus-add',compact('aboutuscategory','anothervar'));
        return view('back.aboutus.aboutus-add');
    }

    
    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {
        $dateTime = date('Y-m-d H:i:s');
        $userId = auth()->user()->id;


        $request->validate([
            'aboutus_title' => 'required',
            'aboutus_description' => 'required',
            'aboutus_image' => 'nullable|image|max:1999|mimes:jpeg,jpg,png',
        ]);


        if($request->hasFile('aboutus_image')){
            $n_image = $request->aboutus_image;
            $imgOrigname = $n_image->getClientOriginalName();
            $imgOrigname_arr = explode('.',$imgOrigname);
            $img_name_first = str_replace(' ','_',$imgOrigname_arr[0]);
            $img_name_first = preg_replace('/[^A-Za-z0-9\-]/','',$img_name_first);

            $ext = $n_image->getClientOriginalExtension();
            $img_name = date('YmdH').$img_name_first.uniqid().'.'.$ext;
            $n_image->storeAs('public/aboutus',$img_name);
            //Storage::delete("public/aboutus/{$user->image}");
           
        }else{
            $img_name='';
        }


$meta_title = ($request->meta_title!="")? $request->meta_title : '';
            $meta_description = ($request->meta_description!="")? $request->meta_description : '';
            $meta_keywords = ($request->meta_keywords!="")? $request->meta_keywords : '';
        
            $aboutus_date = ($request->aboutus_date)? date('Y-m-d H:i:s',strtotime($request->aboutus_date)) : NULL;

      

           
        $insrec = DB::table('aboutus')->insertGetId(
            [
                'title' => $request->aboutus_title,
                'description' => $request->aboutus_description,
                'aboutus_image' => $img_name,
                'aboutus_date' => $aboutus_date,
                'publisher' => $request->aboutus_publisher,
                'status' => $request->aboutus_status,
                'created_at' => $dateTime,
                'updated_at' => $dateTime,
                'created_by' => $userId,
                'updated_by' => $userId,               
                'meta_title' => $meta_title,
                'meta_description' => $meta_description,
                'meta_keywords' => $meta_keywords
            ]);
            
            if($insrec > 0)
            {
                return redirect()->route('aboutus-list')->with('success', 'Record added successfully.');
            }else{
                return redirect()->route('aboutus-list')->with('error', 'Error occurred.Please Try Again Later.');
            }
         }

    /**
     * Display the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function show($id)
    {
        $getRow = DB::table('aboutus')->where('id',$id)->first();
        return view('back.aboutus.aboutus-view',['currentRecord'=>$getRow]);
                   
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function edit(Request $request)
    {
        $pageNumber = $request->input('page','1');
        $getRow = DB::table('aboutus')->first();        
        return view('back.aboutus.aboutus',['currentRecord'=>$getRow,'page'=>$pageNumber]);
            }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, $id)
    {
        
        $dateTime = date('Y-m-d H:i:s');
        $userId = auth()->user()->id;
        $getRow = DB::table('aboutus')->where('id',$id)->first();
        
        

        $request->validate([
            'contenttitle' => 'required',
            'videoimage' => 'nullable|image|max:1999|mimes:jpeg,jpg,png',
            'contentdesc' => 'required' ,
            'videolink'=>'required'           
        ]);


        if($request->hasFile('videoimage')){
            $n_image = $request->videoimage;
            $imgOrigname = $n_image->getClientOriginalName();
            $imgOrigname_arr = explode('.',$imgOrigname);
            $img_name_first = str_replace(' ','_',$imgOrigname_arr[0]);
            $img_name_first = preg_replace('/[^A-Za-z0-9\-]/','',$img_name_first);

            $ext = $n_image->getClientOriginalExtension();
            $img_name1 = date('YmdH').$img_name_first.uniqid().'.'.$ext;
            $n_image->storeAs('public/aboutus',$img_name);
            //Storage::delete("public/aboutus/{$user->image}");
           
        }else{
            $img_name1= $getRow->videoimage;
        }

               
           

        $updaterec = DB::table('aboutus')->where('id', $id)
            ->update(
            [
                'contenttitle' => $request->contenttitle,
                'videoimage' => $img_name1,
                'contentdesc' => $request->contentdesc,
                'videolink'=> $request->videolink,
                'status' => $request->aboutus_status,
                'created_at' => $dateTime,
                'updated_at' => $dateTime,
                'created_by' => $userId,
                'updated_by' => $userId             
                
            ]);
            
            $pageNumber = $request->input('page','1');

            if($updaterec > 0)
            {
                return redirect()->route('aboutus',['page'=>$pageNumber])->with('success', 'Record updated successfully.');
            }else{
                return redirect()->route('aboutus',['page'=>$pageNumber])->with('error', 'Error occurred.Please Try Again Later.');
            }
       }


    public function updateStatus(Request $request)
    {
       if($request->has('chid') && $request->has('chtyp'))
       {
        if($request->chid > 0 && $request->chtyp >= 0 && ($request->chtyp == 1 || $request->chtyp == 2 || $request->chtyp == 0) ) 
        {
            
            $update = DB::update('update aboutus set status = ? where id = ?', [$request->chtyp, $request->chid]);
            if($update > 0)
            {
                $msg = "Successfully updated";
                $sts = 200;
            }else{
                $msg = "Error occured.";
                $sts = 201;
            }
        }else{
            $msg = "Error occured.";
            $sts = 201;
        }   
       }else
       {
            $msg = "Error occured.";
            $sts = 201;
       }

       $results=array("msg"=>$msg,"status"=>$sts);
       return response()->json($results);

    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function destroy($id)
    {   
        if($id > 0)
        {
            $getRow = DB::table('aboutus')->where('id',$id)->first();

            Storage::delete("public/aboutus/{$getRow->aboutus_image}");
            

            //$updateorder = DB::table('aboutus')->where('aboutus_order','>',$getRow->aboutus_order)->update(['aboutus_order' => DB::raw('aboutus_order-1')]);

            $delete = DB::table('aboutus')->where('id',$id)->delete();
            if($delete > 0)
            {
                $msg = "Successfully updated";
                $sts = 200;
            }else{
                $msg = "Error occured.";
                $sts = 201;
            }
        }else{
            $msg = "Error occured.";
            $sts = 201;
        }
        $results=array("msg"=>$msg,"status"=>$sts);
        return response()->json($results);
 
    }


    static function checkAndStoreaboutusCat($catArr)
    {
        $dateTime = date('Y-m-d H:i:s');
        $userId = auth()->user()->id;

       

        $catArrCount = count($catArr);
        $catIds = array();
        $newcatIds = array();

        if($catArrCount > 0)
        {

            for($i = 0; $i < $catArrCount; $i++)
            {
                
                if(trim($catArr[$i])!="")
                {
                    $catname = ucfirst(strtolower(trim($catArr[$i])));
                    $catexistance = DB::table('aboutus_categories')->where('name','=',$catname)->count();
                
                    if($catexistance==0)
                    {
                        $minimumorderId = 1;

                        $getmaxOrderId = DB::table('aboutus_categories')->max('name_order');
                        $getmaxOrderId = ($getmaxOrderId >= $minimumorderId)? $getmaxOrderId : $minimumorderId;
                        $getmaxOrderId = $getmaxOrderId + 1;
                        

                        $catInsId = DB::table('aboutus_categories')->insertGetId([
                            'name' => $catname,
                            'status' => '1',
                            'name_order' => $getmaxOrderId,
                            'created_at' => $dateTime,
                            'updated_at' => $dateTime,
                            'created_by' => $userId,
                            'updated_by' => $userId
                        ]);
                        
                        if($catInsId > 0)
                        {
                            $newcatIds[] = $catInsId;
                            $catIds[] = $catInsId;
                        }


                    }else{
                       
                        
                        $catselId = DB::table('aboutus_categories')->where('name','=',$catname)->select('id')->pluck('id')->first();
                            
                        $catIds[] = $catselId;
    
                    }
                }
                
            }
        }
       
        $result['all'] = $catIds;
        $result['new'] = $newcatIds;

        return $result;

       
    }
}
