<?php



namespace App\Http\Controllers\Admin;



use Illuminate\Http\Request;

use App\Http\Controllers\Controller;

use Illuminate\Support\Facades\DB;

use App\Services\Slug;

use Storage;







class CbdrecipeController extends Controller

{





    public function __construct()

    {

        

    }

	

	

	

	  public function index()

    {

			



        $recordToShow = 5;

        $recipeList = DB::table('cbdrecipe')->orderBy('id','desc')->orderBy('created_at','desc')->paginate($recordToShow);

     

        return view('back.cbdrecipe.cbdrecipe',compact('recipeList','recordToShow'));

    }

	

 public function create()

    {

      

		

        return view('back.cbdrecipe.cbdrecipe-add');

    }	

	

	public function store(Request $request)

    {

	

        $dateTime = date('Y-m-d H:i:s');

       $userId = auth()->user()->id;

		

               $title=$request->title;

                $desc = ($request->description!="")? $request->description : "";  

             	$food=($request->food!="")? $request->food : "";

				 $drinks=($request->drinks!="")? $request->drinks : "";

		         $status=$request->status;

	
$m_title=$request->meta_title;
	$m_key=$request->meta_keywords;
	$m_des=$request->meta_description;
		

		if($request->hasFile('cbdimage'))

		{

		

			$cbdimage = $request->file('cbdimage');

            $imgOrigname = $cbdimage->getClientOriginalName();

            $imgOrigname_arr = explode('.',$imgOrigname);

            $img_name_first = str_replace(' ','_',$imgOrigname_arr[0]);

            $img_name_first = preg_replace('/[^A-Za-z0-9\-]/','',$img_name_first);

            $ext = $cbdimage->getClientOriginalExtension();

             $img_name1 = date('YmdH').$img_name_first.uniqid().'.'.$ext;

               $cbdimage->storeAs('public/cbdrecipe',$img_name1);

			

		

		}  		





           

        $insrec = DB::table('cbdrecipe')->insertGetId(

            [

                'title' => $title,

				'description'=>$desc,

				'food'=>$food,

				'drinks'=>$drinks,

                'status' =>$status,

			'image'=>$img_name1,
          'meta_title'=>$m_title,
			'meta_keywords'=>$m_key,
			'meta_description'=>$m_des,

                'created_at' =>$dateTime,

                'updated_at' =>$dateTime,

                'created_by' =>$userId,

                'updated_by' =>$userId

                  ]);

            

            if($insrec > 0)

            {

		

                return redirect()->route('cbdrecipe-list')->with('success', 'Record added successfully.');

            }else{

                return redirect()->route('cbdrecipe-list')->with('error', 'Error occurred.Please Try Again Later.');

            }

       



    }



	

	

	

	    public function show($id)



    {



        $getRow = DB::table('cbdrecipe')->where('id',$id)->first();

	

        return view('back.cbdrecipe.cbdrecipe-view',['currentRecord'=>$getRow]);



                   



    }







    /**



     * Show the form for editing the specified resource.



     *



     * @param  int  $id



     * @return \Illuminate\Http\Response



     */



    public function edit($id, Request $request)



    {



        $pageNumber = $request->input('page','1');



        $getRow = DB::table('cbdrecipe')->where('id',$id)->first();   

		

		

		

        return view('back.cbdrecipe.cbdrecipe-edit',['currentRecord'=>$getRow,'page'=>$pageNumber]);



            }







public function destroy($id)



    {   



        if($id > 0)



        {



            $getRow = DB::table('cbdrecipe')->where('id',$id)->first();



            $delete = DB::table('cbdrecipe')->where('id',$id)->delete();



            if($delete > 0)



            {



                $msg = "Successfully updated";



                $sts = 200;



            }else{



                $msg = "Error occured.";



                $sts = 201;



            }



        }else{



            $msg = "Error occured.";



            $sts = 201;



        }



        $results=array("msg"=>$msg,"status"=>$sts);



        return response()->json($results);



 



    }

	

	public function updateStatus(Request $request)



    {



       if($request->has('chid') && $request->has('chtyp'))



       {



        if($request->chid > 0 && $request->chtyp >= 0 && ($request->chtyp == 1 || $request->chtyp == 2 || $request->chtyp == 0) ) 



        {



            



            $update = DB::update('update cbdrecipe set status = ? where id = ?', [$request->chtyp, $request->chid]);



            if($update > 0)



            {



                $msg = "Successfully updated";



                $sts = 200;



            }else{



                $msg = "Error occured.";



                $sts = 201;



            }



        }else{



            $msg = "Error occured.";



            $sts = 201;



        }   



       }else



       {



            $msg = "Error occured.";



            $sts = 201;



       }







       $results=array("msg"=>$msg,"status"=>$sts);



       return response()->json($results);







    }













public function update(Request $request, $id)



    {





        $dateTime = date('Y-m-d H:i:s');



        $userId = auth()->user()->id;



        $getRow = DB::table('cbdrecipe')->where('id',$id)->first();



        if($request->hasFile('image')){



            $n_image = $request->image;



            $imgOrigname = $n_image->getClientOriginalName();



            $imgOrigname_arr = explode('.',$imgOrigname);



            $img_name_first = str_replace(' ','_',$imgOrigname_arr[0]);



            $img_name_first = preg_replace('/[^A-Za-z0-9\-]/','',$img_name_first);







            $ext = $n_image->getClientOriginalExtension();



            $img_name = date('YmdH').$img_name_first.uniqid().'.'.$ext;



            $n_image->storeAs('public/cbdrecipe',$img_name);



        }else{



            $img_name= $getRow->image;



        }

		  

		

          $title=$request->title;

         



            $description = ($request->description!="")? $request->description : '';

			 $food = ($request->food!="")? $request->food : '';

			  $drinks = ($request->drinks!="")? $request->drinks : '';

			  
$m_title=$request->meta_title;
	$m_key=$request->meta_keywords;
	$m_des=$request->meta_description;


        $updaterec = DB::table('cbdrecipe')->where('id', $id)



            ->update(



            [



                'title' =>$title,

'image'=> $img_name,

                'description' => $description,

				 'food' => $food,

				  'drinks' => $drinks,

				  

                'status' => $request->status,
'meta_title'=>$m_title,
			'meta_keywords'=>$m_key,
			'meta_description'=>$m_des,
				

                'created_at' =>$dateTime,



                'updated_at' =>$dateTime,



                'created_by' =>$userId,



                'updated_by' =>$userId,               





            ]);



           

            $pageNumber = $request->input('page','1');







            if($updaterec > 0)



            {



                return redirect()->route('cbdrecipe-list',['page'=>$pageNumber])->with('success', 'Record updated successfully.');



            }else{



                return redirect()->route('cbdrecipe-list',['page'=>$pageNumber])->with('error', 'Error occurred.Please Try Again Later.');



            }



       }





    }

    

    

    

?>