<?php

namespace App\Http\Controllers\Admin;

use Illuminate\Http\Request;
use App\Http\Controllers\Controller;
use Illuminate\Support\Facades\DB;
use App\Services\Slug;
use Storage;



class ClientController extends Controller
{


    public function __construct()
    {
        
    }

    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index()
    {
			 

        $recordToShow = 20;
        $clientList = DB::table('client')->orderBy('created_at','desc')->paginate($recordToShow);
        return view('back.client.client',compact('clientList','recordToShow'));
    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {
        
        // return view('back.client.client-add')->withclientcategory($clientcategory);
        // return view('back.client.client-add',compact('clientcategory','anothervar'));
        return view('back.client.client-add');
    }

    
    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {
        $dateTime = date('Y-m-d H:i:s');
        $userId = auth()->user()->id;


        $request->validate([
            'client_name' => 'required',
            'client_link' => 'required',
            'client_logo' => 'nullable|image|max:1999|mimes:jpeg,jpg,png',
        ]);


        if($request->hasFile('client_logo')){
            $n_image = $request->client_logo;
            $imgOrigname = $n_image->getClientOriginalName();
            $imgOrigname_arr = explode('.',$imgOrigname);
            $img_name_first = str_replace(' ','_',$imgOrigname_arr[0]);
            $img_name_first = preg_replace('/[^A-Za-z0-9\-]/','',$img_name_first);

            $ext = $n_image->getClientOriginalExtension();
            $img_name = date('YmdH').$img_name_first.uniqid().'.'.$ext;
            $n_image->storeAs('public/client',$img_name);
            //Storage::delete("public/client/{$user->image}");
           
        }else{
            $img_name='';
        }




      

           
        $insrec = DB::table('client')->insertGetId(
            [
                'client_name' => $request->client_name,
                'link' => $request->client_link,
                'logo' => $img_name,
                'status' => $request->client_status,
                'created_at' => $dateTime,
                'updated_at' => $dateTime,
                'created_by' => $userId,
                'updated_by' => $userId,               
                
            ]);
            
            if($insrec > 0)
            {
                return redirect()->route('client-list')->with('success', 'Record added successfully.');
            }else{
                return redirect()->route('client-list')->with('error', 'Error occurred.Please Try Again Later.');
            }
         }

    /**
     * Display the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function show($id)
    {
        $getRow = DB::table('client')->where('id',$id)->first();
        return view('back.client.client-view',['currentRecord'=>$getRow]);
                   
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function edit($id, Request $request)
    {
        $pageNumber = $request->input('page','1');
        $getRow = DB::table('client')->where('id',$id)->first();        
        return view('back.client.client-edit',['currentRecord'=>$getRow,'page'=>$pageNumber]);
            }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, $id)
    {
        
        $dateTime = date('Y-m-d H:i:s');
        $userId = auth()->user()->id;
        $getRow = DB::table('client')->where('id',$id)->first();
        
        

        $request->validate([
            'client_name' => 'required',
            'client_link' => 'required',
            'client_logo' => 'nullable|image|max:1999|mimes:jpeg,jpg,png',
        ]);


        if($request->hasFile('client_logo')){
            $n_image = $request->client_logo;
            $imgOrigname = $n_image->getClientOriginalName();
            $imgOrigname_arr = explode('.',$imgOrigname);
            $img_name_first = str_replace(' ','_',$imgOrigname_arr[0]);
            $img_name_first = preg_replace('/[^A-Za-z0-9\-]/','',$img_name_first);

            $ext = $n_image->getClientOriginalExtension();
            $img_name = date('YmdH').$img_name_first.uniqid().'.'.$ext;
            $n_image->storeAs('public/client',$img_name);
            //Storage::delete("public/client/{$user->image}");
           
        }else{
            $img_name= $getRow->logo;
        }


        

               
            

        $updaterec = DB::table('client')->where('id', $id)
            ->update(
            [
                'client_name' => $request->client_name,
                'link' => $request->client_link,
                'logo' => $img_name,                       
                'status' => $request->client_status,
                'created_at' => $dateTime,
                'updated_at' => $dateTime,
                'created_by' => $userId,
                'updated_by' => $userId,            
                
            ]);
            
            $pageNumber = $request->input('page','1');

            if($updaterec > 0)
            {
                return redirect()->route('client-list',['page'=>$pageNumber])->with('success', 'Record updated successfully.');
            }else{
                return redirect()->route('client-list',['page'=>$pageNumber])->with('error', 'Error occurred.Please Try Again Later.');
            }
       }


    public function updateStatus(Request $request)
    {
       if($request->has('chid') && $request->has('chtyp'))
       {
        if($request->chid > 0 && $request->chtyp >= 0 && ($request->chtyp == 1 || $request->chtyp == 2 || $request->chtyp == 0) ) 
        {
            
            $update = DB::update('update client set status = ? where id = ?', [$request->chtyp, $request->chid]);
            if($update > 0)
            {
                $msg = "Successfully updated";
                $sts = 200;
            }else{
                $msg = "Error occured.";
                $sts = 201;
            }
        }else{
            $msg = "Error occured.";
            $sts = 201;
        }   
       }else
       {
            $msg = "Error occured.";
            $sts = 201;
       }

       $results=array("msg"=>$msg,"status"=>$sts);
       return response()->json($results);

    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function destroy($id)
    {   
        if($id > 0)
        {
            $getRow = DB::table('client')->where('id',$id)->first();

            Storage::delete("public/client/{$getRow->client_image}");
            

            //$updateorder = DB::table('client')->where('client_order','>',$getRow->client_order)->update(['client_order' => DB::raw('client_order-1')]);

            $delete = DB::table('client')->where('id',$id)->delete();
            if($delete > 0)
            {
                $msg = "Successfully updated";
                $sts = 200;
            }else{
                $msg = "Error occured.";
                $sts = 201;
            }
        }else{
            $msg = "Error occured.";
            $sts = 201;
        }
        $results=array("msg"=>$msg,"status"=>$sts);
        return response()->json($results);
 
    }


    static function checkAndStoreclientCat($catArr)
    {
        $dateTime = date('Y-m-d H:i:s');
        $userId = auth()->user()->id;

       

        $catArrCount = count($catArr);
        $catIds = array();
        $newcatIds = array();

        if($catArrCount > 0)
        {

            for($i = 0; $i < $catArrCount; $i++)
            {
                
                if(trim($catArr[$i])!="")
                {
                    $catname = ucfirst(strtolower(trim($catArr[$i])));
                    $catexistance = DB::table('client_categories')->where('name','=',$catname)->count();
                
                    if($catexistance==0)
                    {
                        $minimumorderId = 1;

                        $getmaxOrderId = DB::table('client_categories')->max('name_order');
                        $getmaxOrderId = ($getmaxOrderId >= $minimumorderId)? $getmaxOrderId : $minimumorderId;
                        $getmaxOrderId = $getmaxOrderId + 1;
                        

                        $catInsId = DB::table('client_categories')->insertGetId([
                            'name' => $catname,
                            'status' => '1',
                            'name_order' => $getmaxOrderId,
                            'created_at' => $dateTime,
                            'updated_at' => $dateTime,
                            'created_by' => $userId,
                            'updated_by' => $userId
                        ]);
                        
                        if($catInsId > 0)
                        {
                            $newcatIds[] = $catInsId;
                            $catIds[] = $catInsId;
                        }


                    }else{
                       
                        
                        $catselId = DB::table('client_categories')->where('name','=',$catname)->select('id')->pluck('id')->first();
                            
                        $catIds[] = $catselId;
    
                    }
                }
                
            }
        }
       
        $result['all'] = $catIds;
        $result['new'] = $newcatIds;

        return $result;

       
    }
}
