<?php

namespace App\Http\Controllers\Admin;

use Illuminate\Http\Request;
use App\Http\Controllers\Controller;
use Illuminate\Support\Facades\DB;
use App\Services\Slug;
use Storage;



class CourseController extends Controller
{


    public function __construct()
    {
        
    }

    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index()
    {
			   

        $recordToShow = 20;
        $courseList = DB::table('course')->orderBy('id','desc')->orderBy('created_at','desc')->paginate($recordToShow);
        $catList = DB::table('category')->orderBy('category_name','asc')->pluck('category_name','id');
                $subcatList = DB::table('subcategory')->orderBy('subcategory_name','asc')->pluck('subcategory_name','id');

        return view('back.course.course',compact('courseList','catList','subcatList','recordToShow'));
    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {
        $coursecategory = DB::table('category')->where('id','>','0')->orderBy('category_name','asc')->get();
        $coursesubcategory = DB::table('subcategory')->where('id','>','0')->orderBy('subcategory_name','asc')->get();
        // return view('back.course.course-add')->withcoursecategory($coursecategory);
        // return view('back.course.course-add',compact('coursecategory','anothervar'));
        return view('back.course.course-add',['coursecategory'=>$coursecategory,'coursesubcategory'=>$coursesubcategory]);
    }

    
    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {
        $dateTime = date('Y-m-d H:i:s');
        $userId = auth()->user()->id;


        $request->validate([
            'course_category' => 'required',
            'course_subcategory' => 'required',
            'course_title' => 'required',
            'course_description' => 'required',
            'courseimage' => 'nullable|image|max:1999|mimes:jpeg,jpg,png',
        ]);


        if($request->hasFile('courseimage')){
            $n_image = $request->course_image;
            $imgOrigname = $n_image->getClientOriginalName();
            $imgOrigname_arr = explode('.',$imgOrigname);
            $img_name_first = str_replace(' ','_',$imgOrigname_arr[0]);
            $img_name_first = preg_replace('/[^A-Za-z0-9\-]/','',$img_name_first);

            $ext = $n_image->getClientOriginalExtension();
            $img_name = date('YmdH').$img_name_first.uniqid().'.'.$ext;
            $n_image->storeAs('public/course',$img_name);            //Storage::delete("public/course/{$user->image}");
           
        }else{
            $img_name='';
        }



       
        $n_category = $request->course_category;
        $n_subcategory = $request->course_subcategory;
        $n_title = $request->course_title;
        $n_desc = $request->course_description;
        $n_img = $img_name;
$catid=$n_category;
$subcatid=$n_subcategory;
            $course_title = $n_title;
            $course_description = $n_desc;
            $course_image = $n_img;
            $course_status = $request->course_status;
         
        $insrec = DB::table('course')->insertGetId(
            [
                'coursename' => $course_title,
                'course_description' => $course_description,
                'courseimage' => $course_image,
                'status' => $course_status,
                'catid' => $catid,
                'subcatid'=>$subcatid,
                'created_at' => $dateTime,
                'updated_at' => $dateTime,
                'created_by' => $userId,
                'updated_by' => $userId                
            ]);
            
            if($insrec > 0)
            {
                return redirect()->route('course-list')->with('success', 'Record added successfully.');
            }else{
                return redirect()->route('course-list')->with('error', 'Error occurred.Please Try Again Later.');
            }
        }      
        


        



    

    /**
     * Display the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function show($id)
    {
        $getRow = DB::table('course')->where('id',$id)->first();
        $coursecategory = DB::table('category')->where('id','>','0')->orderBy('category_name','asc')->get();
        $coursesubcategory = DB::table('subcategory')->where('id','>','0')->orderBy('subcategory_name','asc')->get();
        return view('back.course.course-view',['coursecategory'=>$coursecategory,'coursesubcategory'=>$coursesubcategory,'currentRecord'=>$getRow]);
                   
    }

    /**-
     * S-how the form for editing the specified resource.
     *-
     * -@param  int  $id
     * @-return \Illuminate\Http\Res-ponse
     */
    public function edit($id, Request $request)
    {
        $pageNumber = $request->input('page','1');
        $getRow = DB::table('course')->where('id',$id)->first();
        $coursecategory = DB::table('category')->where('id','>','0')->orderBy('category_name','asc')->get();
        $coursesubcategory = DB::table('subcategory')->where('id','>','0')->orderBy('subcategory_name','asc')->get();
        return view('back.course.course-edit',['coursecategory'=>$coursecategory,'coursesubcategory'=>$coursesubcategory,'currentRecord'=>$getRow,'page'=>$pageNumber]);
            }

    /**-
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, $id)
    {
        
        $dateTime = date('Y-m-d H:i:s');
        $userId = auth()->user()->id;
        $getRow = DB::table('course')->where('id',$id)->first();
        
        

        $request->validate([
            'course_category' => 'required',
            'course_subcategory'=>'required',
            'course_title' => 'required',
            'course_description' => 'required',
            'course_image' => 'nullable|image|max:1999|mimes:jpeg,jpg,png',
        ]);


        if($request->hasFile('course_image')){
            $n_image = $request->course_image;
            $imgOrigname = $n_image->getClientOriginalName();
            $imgOrigname_arr = explode('.',$imgOrigname);
            $img_name_first = str_replace(' ','_',$imgOrigname_arr[0]);
            $img_name_first = preg_replace('/[^A-Za-z0-9\-]/','',$img_name_first);

            $ext = $n_image->getClientOriginalExtension();
            $img_name = date('YmdH').$img_name_first.uniqid().'.'.$ext;
            $n_image->storeAs('public/course',$img_name);
            //Storage::delete("public/course/{$user->image}");
           
        }else{
            $img_name= $getRow->course_image;
        }


        $catid = $request->course_category;
        $subcatid = $request->course_subcategory;
        $n_title = $request->course_title;
        $n_desc = $request->course_description;
        $n_img = $img_name;

        
            $course_title = $n_title;
            $course_description = $n_desc;
            $course_image = $n_img;
            $course_status = $request->course_status;
           

        $updaterec = DB::table('course')->where('id', $id)
            ->update(
            [
                 'coursename' => $course_title,
                'course_description' => $course_description,
                'courseimage' => $course_image,
                'status' => $course_status,
                'catid' => $catid,
                'subcatid'=>$subcatid,
                'created_at' => $dateTime,
                'updated_at' => $dateTime,
                'created_by' => $userId,
                'updated_by' => $userId 
            ]);
            
            $pageNumber = $request->input('page','1');

            if($updaterec > 0)
            {
                return redirect()->route('course-list',['page'=>$pageNumber])->with('success', 'Record updated successfully.');
            }else{
                return redirect()->route('course-list',['page'=>$pageNumber])->with('error', 'Error occurred.Please Try Again Later.');
            }
        }

    


    public function updateStatus(Request $request)
    {
       if($request->has('chid') && $request->has('chtyp'))
       {
        if($request->chid > 0 && $request->chtyp >= 0 && ($request->chtyp == 1 || $request->chtyp == 2 || $request->chtyp == 0) ) 
        {
            
            $update = DB::update('update course set status = ? where id = ?', [$request->chtyp, $request->chid]);
            if($update > 0)
            {
                $msg = "Successfully updated";
                $sts = 200;
            }else{
                $msg = "Error occured.";
                $sts = 201;
            }
        }else{
            $msg = "Error occured.";
            $sts = 201;
        }   
       }else
       {
            $msg = "Error occured.";
            $sts = 201;
       }

       $results=array("msg"=>$msg,"status"=>$sts);
       return response()->json($results);

    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function destroy($id)
    {   
        if($id > 0)
        {
            $getRow = DB::table('course')->where('id',$id)->first();

            Storage::delete("public/course/{$getRow->course_image}");
            
            

            $delete = DB::table('course')->where('id',$id)->delete();
            if($delete > 0)
            {
                $msg = "Successfully updated";
                $sts = 200;
            }else{
                $msg = "Error occured.";
                $sts = 201;
            }
        }else{
            $msg = "Error occured.";
            $sts = 201;
        }
        $results=array("msg"=>$msg,"status"=>$sts);
        return response()->json($results);
 
    }


    static function checkAndStorecourseCat($catArr)
    {
        $dateTime = date('Y-m-d H:i:s');
        $userId = auth()->user()->id;

       

        $catArrCount = count($catArr);
        $catIds = array();
        $newcatIds = array();

        if($catArrCount > 0)
        {

            for($i = 0; $i < $catArrCount; $i++)
            {
                
                if(trim($catArr[$i])!="")
                {
                    $catname = ucfirst(strtolower(trim($catArr[$i])));
                    $catexistance = DB::table('category')->where('name','=',$catname)->count();
                
                    if($catexistance==0)
                    {
                        $minimumorderId = 1;

                        $getmaxOrderId = DB::table('category')->max('name_order');
                        $getmaxOrderId = ($getmaxOrderId >= $minimumorderId)? $getmaxOrderId : $minimumorderId;
                        $getmaxOrderId = $getmaxOrderId + 1;
                        

                        $catInsId = DB::table('category')->insertGetId([
                            'name' => $catname,
                            'status' => '1',
                            'name_order' => $getmaxOrderId,
                            'created_at' => $dateTime,
                            'updated_at' => $dateTime,
                            'created_by' => $userId,
                            'updated_by' => $userId
                        ]);
                        
                        if($catInsId > 0)
                        {
                            $newcatIds[] = $catInsId;
                            $catIds[] = $catInsId;
                        }


                    }else{
                       
                        
                        $catselId = DB::table('category')->where('name','=',$catname)->select('id')->pluck('id')->first();
                            
                        $catIds[] = $catselId;
    
                    }
                }
                
            }
        }
       
        $result['all'] = $catIds;
        $result['new'] = $newcatIds;

        return $result;

       
    }
}
