<?php



namespace App\Http\Controllers\Admin;



use Illuminate\Http\Request;

use App\Http\Controllers\Controller;

use Illuminate\Support\Facades\DB;

use App\Services\Slug;

use Storage;







class NewsController extends Controller

{





    public function __construct()

    {

        

    }



    /**

     * Display a listing of the resource.

     *

     * @return \Illuminate\Http\Response

     */

    public function index()

    {

		$common = DB::table('settings')->where('id','1')->first();	 



        $recordToShow = 10;

        $newsList = DB::table('news')->orderBy('news_date','desc')->orderBy('updated_at','desc')->paginate($recordToShow);

      

        return view('back.news.news',compact('newsList','recordToShow','common'));

    }



    /**

     * Show the form for creating a new resource.

     *

     * @return \Illuminate\Http\Response

     */

    public function create()

    {

       

        return view('back.news.news-add');

    }



    

    /**

     * Store a newly created resource in storage.

     *

     * @param  \Illuminate\Http\Request  $request

     * @return \Illuminate\Http\Response

     */

    public function store(Request $request)

    {

        $dateTime = date('Y-m-d H:i:s');

        $userId = auth()->user()->id;

         $n_title = $request->news_title;

        $n_desc =($request->news_description!="")? $request->news_description : '';

		

		$ititle=$request->news_ititle;

		$i_desc=($request->news_idescription!="")? $request->news_idescription : '';

	

        $slugClass = new Slug();

        $createdSlug = $slugClass->createSlug('news', 'slug', $n_title);

      $news_link=$request->news_link;

      $news_publisher=$request->news_publisher;

     $status=$request->news_status;

  

            $meta_title = ($request->meta_title!="")? $request->meta_title : '';

            $meta_description = ($request->meta_description!="")? $request->meta_description : '';

            $meta_keywords = ($request->meta_keywords!="")? $request->meta_keywords : '';

$news_status=$request->news_date;



           if($request->hasFile('n_image'))

		{

		

			$n_images = $request->file('n_image');



            $imgOrigname = $n_images->getClientOriginalName();



            $imgOrigname_arr = explode('.',$imgOrigname);



            $img_name_first = str_replace(' ','_',$imgOrigname_arr[0]);



            $img_name_first = preg_replace('/[^A-Za-z0-9\-]/','',$img_name_first);



            $ext = $n_images->getClientOriginalExtension();



            $img_name1 = date('YmdH').$img_name_first.uniqid().'.'.$ext;



            $n_images->storeAs('public/blog',$img_name1);

	}  	



	   if($request->hasFile('news_banner_image'))

		{

		

			$n_images = $request->file('news_banner_image');



            $imgOrigname = $n_images->getClientOriginalName();



            $imgOrigname_arr = explode('.',$imgOrigname);



            $img_name_first = str_replace(' ','_',$imgOrigname_arr[0]);



            $img_name_first = preg_replace('/[^A-Za-z0-9\-]/','',$img_name_first);



            $ext = $n_images->getClientOriginalExtension();



            $img_name2 = date('YmdH').$img_name_first.uniqid().'.'.$ext;



            $n_images->storeAs('public/blog',$img_name2);

	}  		



        $insrec = DB::table('news')->insertGetId(

            [

                

                'slug' => $createdSlug,

                'name' => $n_title,

                'description' =>$n_desc,

                'news_image'=>$img_name1,

				'inner_title'=>$ititle,

				'inner_description'=>$i_desc,

 'news_banner_image'=>$img_name2,

                'news_link' => $news_link,

               

             'news_date' => $dateTime,

                'news_publisher' => $news_publisher,

                'status' => $status,

              

                'created_at' => $dateTime,

                'updated_at' => $dateTime,

                'created_by' => $userId,

                'updated_by' => $userId,

                

                'meta_title' => $meta_title,

                'meta_description' => $meta_description,

                'meta_keywords' => $meta_keywords

            ]);

            

            if($insrec > 0)

            {

                return redirect()->route('news-list')->with('success', 'Record added successfully.');

            }else{

                return redirect()->route('news-list')->with('error', 'Error occurred.Please Try Again Later.');

            }

        

        



        

        





        







    }



    /**

     * Display the specified resource.

     *

     * @param  int  $id

     * @return \Illuminate\Http\Response

     */

    public function show($id)

    {

        $getRow = DB::table('news')->where('id',$id)->first();

        $newscategory = DB::table('news_categories')->where('id','>','0')->orderBy('name','asc')->get();

        return view('back.news.news-view',['newscategory'=>$newscategory,'currentRecord'=>$getRow]);

                   

    }



    /**

     * Show the form for editing the specified resource.

     *

     * @param  int  $id

     * @return \Illuminate\Http\Response

     */

    public function edit($id, Request $request)

    {

        $pageNumber = $request->input('page','1');

        $getRow = DB::table('news')->where('id',$id)->first();

        return view('back.news.news-edit',['currentRecord'=>$getRow,'page'=>$pageNumber]);

            }



    /**

     * Update the specified resource in storage.

     *

     * @param  \Illuminate\Http\Request  $request

     * @param  int  $id

     * @return \Illuminate\Http\Response

     */

    public function update(Request $request, $id)

    {

        

        $dateTime = date('Y-m-d H:i:s');

        $userId = auth()->user()->id;

        $getRow = DB::table('news')->where('id',$id)->first();

        

        





        if($request->hasFile('news_image')){

            $n_image = $request->news_image;

            $imgOrigname = $n_image->getClientOriginalName();

            $imgOrigname_arr = explode('.',$imgOrigname);

            $img_name_first = str_replace(' ','_',$imgOrigname_arr[0]);

            $img_name_first = preg_replace('/[^A-Za-z0-9\-]/','',$img_name_first);



            $ext = $n_image->getClientOriginalExtension();

            $img_name = date('YmdH').$img_name_first.uniqid().'.'.$ext;

            $n_image->storeAs('public/blog',$img_name);

            //Storage::delete("public/news/{$user->image}");

           

        }else{

            $img_name= $getRow->news_image;

        }



if($request->hasFile('news_banner_image')){

            $n_image = $request->news_banner_image;

            $imgOrigname = $n_image->getClientOriginalName();

            $imgOrigname_arr = explode('.',$imgOrigname);

            $img_name_first = str_replace(' ','_',$imgOrigname_arr[0]);

            $img_name_first = preg_replace('/[^A-Za-z0-9\-]/','',$img_name_first);



            $ext = $n_image->getClientOriginalExtension();

            $img_name1 = date('YmdH').$img_name_first.uniqid().'.'.$ext;

            $n_image->storeAs('public/blog',$img_name1);

            //Storage::delete("public/news/{$user->image}");

           

        }else{

            $img_name1= $getRow->news_banner_image;

        }

      

        $n_title = $request->news_title;

        $n_desc = ($request->news_description!="")? $request->news_description : '';

		$inner_title=$request->news_ititle;

		$inner_desc=($request->news_idescription!="")? $request->news_idescription : '';

       

		$news_link=$request->news_link;

      $news_date = ($request->news_date)? date('Y-m-d H:i:s',strtotime($request->news_date)) : NULL;

	   $news_publisher=$request->news_publisher;

	   $news_status=$request->news_status;

            $meta_title = ($request->meta_title!="")? $request->meta_title : '';

            $meta_description = ($request->meta_description!="")? $request->meta_description : '';

            $meta_keywords = ($request->meta_keywords!="")? $request->meta_keywords : '';





        $updaterec = DB::table('news')->where('id', $id)

            ->update(

            [

              

                

                'name' => $n_title,

                'description' => $n_desc,

				'inner_title'=>$inner_title,

				'inner_description'=>$inner_desc,

                'news_image' => $img_name,

				'news_banner_image'=>$img_name1,

                'news_link' => $news_link,

               

                'news_date' => $news_date,

                'news_publisher' => $news_publisher,

                'status' => $news_status,

                'updated_at' => $dateTime,

                'updated_by' => $userId,

               

                'meta_title' => $meta_title,

                'meta_description' => $meta_description,

                'meta_keywords' => $meta_keywords

            ]);

            

            $pageNumber = $request->input('page','1');



            if($updaterec > 0)

            {

                return redirect()->route('news-list',['page'=>$pageNumber])->with('success', 'Record updated successfully.');

            }else{

                return redirect()->route('news-list',['page'=>$pageNumber])->with('error', 'Error occurred.Please Try Again Later.');

            }

        }

		    





    public function updateStatus(Request $request)

    {

       if($request->has('chid') && $request->has('chtyp'))

       {

        if($request->chid > 0 && $request->chtyp >= 0 && ($request->chtyp == 1 || $request->chtyp == 2 || $request->chtyp == 0) ) 

        {

            

            $update = DB::update('update news set status = ? where id = ?', [$request->chtyp, $request->chid]);

            if($update > 0)

            {

                $msg = "Successfully updated";

                $sts = 200;

            }else{

                $msg = "Error occured.";

                $sts = 201;

            }

        }else{

            $msg = "Error occured.";

            $sts = 201;

        }   

       }else

       {

            $msg = "Error occured.";

            $sts = 201;

       }



       $results=array("msg"=>$msg,"status"=>$sts);

       return response()->json($results);



    }



    /**

     * Remove the specified resource from storage.

     *

     * @param  int  $id

     * @return \Illuminate\Http\Response

     */

    public function destroy($id)

    {   

        if($id > 0)

        {

            $getRow = DB::table('news')->where('id',$id)->first();



            Storage::delete("public/blog/{$getRow->news_image}");

          

          //  $updateorder = DB::table('news')->where('news_order','>',$getRow->news_order)->update(['news_order' => DB::raw('news_order-1')]);



            $delete = DB::table('news')->where('id',$id)->delete();

            if($delete > 0)

            {

                $msg = "Successfully updated";

                $sts = 200;

            }else{

                $msg = "Error occured.";

                $sts = 201;

            }

        }else{

            $msg = "Error occured.";

            $sts = 201;

        }

        $results=array("msg"=>$msg,"status"=>$sts);

        return response()->json($results);

 

    }





    static function checkAndStoreNewsCat($catArr)

    {

        $dateTime = date('Y-m-d H:i:s');

        $userId = auth()->user()->id;



       



        $catArrCount = count($catArr);

        $catIds = array();

        $newcatIds = array();



        if($catArrCount > 0)

        {



            for($i = 0; $i < $catArrCount; $i++)

            {

                

                if(trim($catArr[$i])!="")

                {

                    $catname = ucfirst(strtolower(trim($catArr[$i])));

                    $catexistance = DB::table('news_categories')->where('name','=',$catname)->count();

                

                    if($catexistance==0)

                    {

                        $minimumorderId = 1;



                        $getmaxOrderId = DB::table('news_categories')->max('name_order');

                        $getmaxOrderId = ($getmaxOrderId >= $minimumorderId)? $getmaxOrderId : $minimumorderId;

                        $getmaxOrderId = $getmaxOrderId + 1;

                        



                        $catInsId = DB::table('news_categories')->insertGetId([

                            'name' => $catname,

                            'status' => '1',

                            'name_order' => $getmaxOrderId,

                            'created_at' => $dateTime,

                            'updated_at' => $dateTime,

                            'created_by' => $userId,

                            'updated_by' => $userId

                        ]);

                        

                        if($catInsId > 0)

                        {

                            $newcatIds[] = $catInsId;

                            $catIds[] = $catInsId;

                        }





                    }else{

                       

                        

                        $catselId = DB::table('news_categories')->where('name','=',$catname)->select('id')->pluck('id')->first();

                            

                        $catIds[] = $catselId;

    

                    }

                }

                

            }

        }

       

        $result['all'] = $catIds;

        $result['new'] = $newcatIds;



        return $result;



       

    }

}

