<?php



namespace App\Http\Controllers\Admin;



use Illuminate\Http\Request;

use App\Http\Controllers\Controller;

use Illuminate\Support\Facades\DB;

use App\Services\Slug;

use Storage;







class ProductController extends Controller

{





    public function __construct()

    {

        

    }



    /**

     * Display a listing of the resource.

     *

     * @return \Illuminate\Http\Response

     */

    public function index()

    {

			 
$common = DB::table('settings')->where('id','1')->first();


        $recordToShow = 50;
		
	//$productList = DB::table('product_management')->orderBy('product_date','desc')->orderBy('updated_at','desc')->paginate($recordToShow);

		
  
$productList = DB::table('product_management')->orderBy('updated_at','desc')->paginate($recordToShow);	

		
  

        
        return view('back.product.product',compact('productList','recordToShow','common'));

    }



    /**

     * Show the form for creating a new resource.

     *

     * @return \Illuminate\Http\Response

     */

    public function create()

    {

          $category = DB::table('subcategory')->where('id','>','0')->orderBy('subcategory_name','asc')->get();

        // return view('back.blog.blog-add')->withblogcategory($blogcategory);

        // return view('back.blog.blog-add',compact('blogcategory','anothervar'));

        return view('back.product.product-add',['category'=>$category]);;

    }



    

    /**

     * Store a newly created resource in storage.

     *

     * @param  \Illuminate\Http\Request  $request

     * @return \Illuminate\Http\Response

     */

     public function store(Request $request)

    {
	 $dateTime = date('Y-m-d H:i:s');
	  $userId = auth()->user()->id;
	  
	   $request->validate([
			
            'title' => 'required',
            'category' => 'required',
			'price'=>'required',
			'product_image' => 'nullable|image|max:10000|mimes:jpeg,jpg,png',
		
            ]);
			
			
		$traindom_id = $request->category;
        $title=$request->title;
		  $slugClass = new Slug();
        $createdSlug = $slugClass->createSlug('product_management', 'product_slug', $title);
		$price=$request->price;
        $n_subcategoryname = $request->product_title;
		//$link=$request->p_link;
		
        $n_desc = ($request->product_description!="")? $request->product_description : "";   
		$summary = ($request->summary!="")? $request->summary: "";   
		 $sup_des = ($request->supplement_facts!="")? $request->supplement_facts : "";   
		  $faq = ($request->faq!="")? $request->faq: "";   
		  
		$meta_title= $request->meta_title;
			$meta_description= $request->meta_description;
				$meta_keywords= $request->meta_keywords;
		
        $product_status = $request->product_status;
		
		$oldprice=$request->oldprice;
		$offer=$request->offer;
		$Buynow=$request->Buynow;
		/*$fb=$request->fb;
		$pinterest=$request->pinterest;
		$twitter=$request->twitter;
		$linked=$request->linked;*/
		
		if($request->hasFile('bimages'))
		{
		
			$n_images = $request->file('bimages');

            
			

            $imgOrigname = $n_images->getClientOriginalName();

            $imgOrigname_arr = explode('.',$imgOrigname);

            $img_name_first = str_replace(' ','_',$imgOrigname_arr[0]);

            $img_name_first = preg_replace('/[^A-Za-z0-9\-]/','',$img_name_first);



            $ext = $n_images->getClientOriginalExtension();

            $img_name1 = date('YmdH').$img_name_first.uniqid().'.'.$ext;

            $n_images->storeAs('public/product banner',$img_name1);
			
		
			
            //Storage::delete("public/blog/{$user->image}");
	
           

        
		
				
		}  		


 $insrec = DB::table('product_management')->insertGetId(
            [
	
                'catid'=>$traindom_id,
			'product_slug'=>$createdSlug,
			'banner_image'=>$img_name1,
				'summary'=>$summary,
                'title' => $title,
				'price'=>$price,
                'description' => $n_desc,
				'supplement_facts'=> $sup_des,
				'faq'=> $faq,
	        'status' => $product_status,
				'product_date'=>$dateTime,
				'meta_title'=>$meta_title,
				'meta_keywords'=>$meta_keywords,
				'meta_description'=>$meta_description,
				'old_price'=>$oldprice,
		'offer_percentage'=>$offer,
		'buynow_link'=>$Buynow,
		
                'created_at' => $dateTime,
                'updated_at' => $dateTime,
                'created_by' => $userId,
                'updated_by' => $userId
                  ]);
				  
				
		
if($request->hasFile('images'))
		{
		
			$n_images = $request->file('images');
			
			foreach($n_images as $n_image)
			{
		//	$existancecheck = DB::table('product_images')->where('product_id',$insrec)->count();
		//	$main_img = ($existancecheck > 0)? 0 : 1;

            $imgOrigname = $n_image->getClientOriginalName();

            $imgOrigname_arr = explode('.',$imgOrigname);

            $img_name_first = str_replace(' ','_',$imgOrigname_arr[0]);

            $img_name_first = preg_replace('/[^A-Za-z0-9\-]/','',$img_name_first);



            $ext = $n_image->getClientOriginalExtension();

            $img_name = date('YmdH').$img_name_first.uniqid().'.'.$ext;

            $n_image->storeAs('public/product',$img_name);
			
			DB::table('product_images')->insert(['product_id' => $insrec,'product_image'=>$img_name]);
			
            //Storage::delete("public/blog/{$user->image}"); => $img_name,'main_img' => $main_img
	}
           

        
		
				
		}
		
		//$insrec = DB::table('product_management')->insertGetId([
			 //'product_image' => implode("|",$images)]);
       // return back()->with('success', 'Successfully Save Your Image file');
		
		
		

            
            if($insrec > 0)
            {
                return redirect()->route('product-list')->with('success', 'Record added successfully.');
            }else{
                return redirect()->route('product-list')->with('error', 'Error occurred.Please Try Again Later.');
            }
       


















         }


  
    public function show($id)

    {

        $getRow = DB::table('product_management')->where('id',$id)->first();
		$getimage= DB::table('product_images')->where('product_id',$id)->get();
	//	dd($getimage);

        return view('back.product.product-view',['currentRecord'=>$getRow],['subproductimage'=>$getimage]);

                   

    }



    /**

     * Show the form for editing the specified resource.

     *

     * @param  int  $id

     * @return \Illuminate\Http\Response

     */

    public function edit($id, Request $request)

    {

        $pageNumber = $request->input('page','1');

        $getRow = DB::table('product_management')->where('id',$id)->first();   
		
		 $getRow_productimages = DB::table('product_images')->where('product_id',$id)->get();       
		
        return view('back.product.product-edit',['currentProductimages'=>$getRow_productimages,'currentRecord'=>$getRow,'page'=>$pageNumber]);

            }



    /**

     * Update the specified resource in storage.

     *

     * @param  \Illuminate\Http\Request  $request

     * @param  int  $id

     * @return \Illuminate\Http\Response

     */

    public function update(Request $request, $id)

    {

$getRow_productimages = DB::table('product_images')->where('product_id',$id)->get(); 






$v = $request->img_id;






if($request->hasFile('product_image'))
{

$n_images = $request->file('product_image');


			$i=0;
			foreach($n_images as $n_image)
			{
				$imgOrigname = $n_image->getClientOriginalName();
				if($imgOrigname != '')
				{
				
					$imgOrigname = $n_image->getClientOriginalName();
		
					$imgOrigname_arr = explode('.',$imgOrigname);
		
					$img_name_first = str_replace(' ','_',$imgOrigname_arr[0]);
		
					$img_name_first = preg_replace('/[^A-Za-z0-9\-]/','',$img_name_first);
		
		
		
					$ext = $n_image->getClientOriginalExtension();
		
					$img_name = date('YmdH').$img_name_first.uniqid().'.'.$ext;
		
					$n_image->storeAs('public/product',$img_name);
					
					
					DB::table('product_images')->where('product_image_id', $v[$i])->update(['product_image'=> $img_name]);
								
								
				}
				$i=$i+1;
			}
        
	}	 
		

        $dateTime = date('Y-m-d H:i:s');

        $userId = auth()->user()->id;

        $getRow = DB::table('product_management')->where('id',$id)->first();

        

        



        $request->validate([

            'product_title' => 'required',

            'product_description' => 'nullable'

        ]);


		

        if($request->hasFile('banner_image')){

            $n_image = $request->banner_image;

            $imgOrigname = $n_image->getClientOriginalName();

            $imgOrigname_arr = explode('.',$imgOrigname);

            $img_name_first = str_replace(' ','_',$imgOrigname_arr[0]);

            $img_name_first = preg_replace('/[^A-Za-z0-9\-]/','',$img_name_first);



            $ext = $n_image->getClientOriginalExtension();

            $img_name = date('YmdH').$img_name_first.uniqid().'.'.$ext;

            $n_image->storeAs('public/product banner',$img_name);

            //Storage::delete("public/blog/{$user->image}");

           

        }else{

            $img_name= $getRow->banner_image;

        }
		  
		
          $product_title=$request->product_title;
		
		
		
              $price=$request->price;
              $old_price=$request->old_price;
			  $offer_percentage=$request->offer_percentage;
                  $buynow_link=$request->buynow_link;
				  /*$fb_link=$request->fb_link;
				  $twitter_link=$request->twitter_link;
				  $pinterest_link=$request->pinterest_link;
				  $linkedin_link=$request->linkedin_link;*/


             //  $link=$request->product_link;

            $meta_title = ($request->meta_title!="")? $request->meta_title : '';

            $meta_description = ($request->meta_description!="")? $request->meta_description : '';
			 $supplement_facts = ($request->supplement_facts!="")? $request->supplement_facts : '';
			  $faq = ($request->faq!="")? $request->faq : '';
			  
$summary = ($request->summary!="")? $request->summary : '';
            $meta_keywords = ($request->meta_keywords!="")? $request->meta_keywords : '';



            $product_date = ($request->product_date)? date('Y-m-d H:i:s',strtotime($request->product_date)) : NULL;

		$desc = ($request->product_description!="")?$request->product_description : "";	

        $updaterec = DB::table('product_management')->where('id', $id)

            ->update(

            [

                'title' =>$product_title,
'banner_image'=> $img_name,
                'description' => $desc,
				'summary'=>$summary,
				'supplement_facts'=>$supplement_facts,
				'faq'=>$faq,
                'price'=>$price,
                'old_price'=>$old_price,
				'offer_percentage'=>$offer_percentage,
				'buynow_link'=>$buynow_link,
				

                'product_date' => $product_date,

                'status' => $request->product_status,
				  'created_at' => $dateTime,

                'updated_at' => $dateTime,

                'created_by' => $userId,

                'updated_by' => $userId,               

                'meta_title' => $meta_title,

                'meta_description' => $meta_description,

                'meta_keywords' => $meta_keywords

            ]);

           
            $pageNumber = $request->input('page','1');



            if($updaterec > 0)

            {

                return redirect()->route('product-list',['page'=>$pageNumber])->with('success', 'Record updated successfully.');

            }else{

                return redirect()->route('product-list',['page'=>$pageNumber])->with('error', 'Error occurred.Please Try Again Later.');

            }

       }





    public function updateStatus(Request $request)

    {

       if($request->has('chid') && $request->has('chtyp'))

       {

        if($request->chid > 0 && $request->chtyp >= 0 && ($request->chtyp == 1 || $request->chtyp == 2 || $request->chtyp == 0) ) 

        {

            

            $update = DB::update('update product_management set status = ? where id = ?', [$request->chtyp, $request->chid]);

            if($update > 0)

            {

                $msg = "Successfully updated";

                $sts = 200;

            }else{

                $msg = "Error occured.";

                $sts = 201;

            }

        }else{

            $msg = "Error occured.";

            $sts = 201;

        }   

       }else

       {

            $msg = "Error occured.";

            $sts = 201;

       }



       $results=array("msg"=>$msg,"status"=>$sts);

       return response()->json($results);



    }



    /**

     * Remove the specified resource from storage.

     *

     * @param  int  $id

     * @return \Illuminate\Http\Response

     */

    public function destroy($id)

    {   

        if($id > 0)

        {

            $getRow = DB::table('product_management')->where('id',$id)->first();



            //Storage::delete("public/product/{$getRow->product_image}");

            



            //$updateorder = DB::table('blog')->where('blog_order','>',$getRow->blog_order)->update(['blog_order' => DB::raw('blog_order-1')]);



            $delete = DB::table('product_management')->where('id',$id)->delete();
$delproduct=DB::table('product_images')->where('product_id',$id)->delete();
            if($delete > 0 && $delproduct>0)

            {

                $msg = "Successfully updated";

                $sts = 200;

            }else{

                $msg = "Error occured.";

                $sts = 201;

            }

        }else{

            $msg = "Error occured.";

            $sts = 201;

        }

        $results=array("msg"=>$msg,"status"=>$sts);

        return response()->json($results);

 

    }





    static function checkAndStoreblogCat($catArr)

    {

        $dateTime = date('Y-m-d H:i:s');

        $userId = auth()->user()->id;



       



        $catArrCount = count($catArr);

        $catIds = array();

        $newcatIds = array();



        if($catArrCount > 0)

        {



            for($i = 0; $i < $catArrCount; $i++)

            {

                

                if(trim($catArr[$i])!="")

                {

                    $catname = ucfirst(strtolower(trim($catArr[$i])));

                    $catexistance = DB::table('blog_categories')->where('name','=',$catname)->count();

                

                    if($catexistance==0)

                    {

                        $minimumorderId = 1;



                        $getmaxOrderId = DB::table('blog_categories')->max('name_order');

                        $getmaxOrderId = ($getmaxOrderId >= $minimumorderId)? $getmaxOrderId : $minimumorderId;

                        $getmaxOrderId = $getmaxOrderId + 1;

                        



                        $catInsId = DB::table('blog_categories')->insertGetId([

                            'name' => $catname,

                            'status' => '1',

                            'name_order' => $getmaxOrderId,

                            'created_at' => $dateTime,

                            'updated_at' => $dateTime,

                            'created_by' => $userId,

                            'updated_by' => $userId

                        ]);

                        

                        if($catInsId > 0)

                        {

                            $newcatIds[] = $catInsId;

                            $catIds[] = $catInsId;

                        }





                    }else{

                       

                        

                        $catselId = DB::table('blog_categories')->where('name','=',$catname)->select('id')->pluck('id')->first();

                            

                        $catIds[] = $catselId;

    

                    }

                }

                

            }

        }

       

        $result['all'] = $catIds;

        $result['new'] = $newcatIds;



        return $result;



       

    }
	
	
	public function search(Request $request)
	{
	$common = DB::table('settings')->where('id','1')->first();


        $recordToShow = 50;
	$search=$request->search;

	//$productdata=DB::table('product_management')->select('title','like','%'.$search.'%')->get();
	
	
	
	 $productList=DB::table('product_management')->where('title', 'like', '%' . $search . '%')->paginate($recordToShow);
	 //dd($productList);
	 //$productList->appends(['search' => $search]);
	   return view('back.product.product',compact('productList','common','recordToShow'));
	}
	
	
	

}

