<?php

namespace App\Http\Controllers\Admin;

use Illuminate\Http\Request;
use App\Http\Controllers\Controller;
use Illuminate\Support\Facades\DB;
use App\Services\Slug;
use Storage;



class ReviewController extends Controller
{


    public function __construct()
    {
        
    }

    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index()
    {
			//   $common = DB::table('onew_common')->where('id','1')->first();

        $recordToShow = 20;
        $reviewList = DB::table('reviewproduct')->orderBy('id','desc')->orderBy('created_at','desc')->paginate($recordToShow);
        //$catList = DB::table('news_categories')->orderBy('name','asc')->pluck('name','id');
        return view('back.review.review',compact('reviewList','recordToShow'));
    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {
        //$newscategory = DB::table('review')->where('id','>','0')->orderBy('name','asc')->get();
        // return view('back.news.news-add')->withNewscategory($newscategory);
        // return view('back.news.news-add',compact('newscategory','anothervar'));
		$products=DB::table('product_management')->get();
        return view('back.review.review-add',compact('products'));
    }

    
    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {
	
        $dateTime = date('Y-m-d H:i:s');
        $userId = auth()->user()->id;


       

$pid=$request->product;
       
        $name=$request->name;
         $mail= $request->email;
		 $phno= $request->phno;
		$review= $request->review;
	     $rating=$request->rating;
		 $rstatus=$request->rstatus;
		
        $review_status = $request->review_status;

           
        $insrec = DB::table('reviewproduct')->insertGetId(
            [
                'name' => $name,
				'product_id'=>$request->product,
            'mail'=>$mail,
			'phno'=> $phno,
                'review' => $review,
				'rating'=>$rating,
                'status' => $review_status,
				'rstatus' =>$rstatus,
                'created_at' => $dateTime,
                'updated_at' => $dateTime,
                'created_by' => $userId,
                'updated_by' => $userId
                  ]);
            
            if($insrec > 0)
            {
                return redirect()->route('review-list')->with('success', 'Record added successfully.');
            }else{
                return redirect()->route('review-list')->with('error', 'Error occurred.Please Try Again Later.');
            }
       

        

        
        


        



    }

    /**
     * Display the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function show($id)
    {
        $getRow = DB::table('reviewproduct')->where('id',$id)->first();
        return view('back.review.review-view',['currentRecord'=>$getRow]);
                   
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function edit($id, Request $request)
    {
        $pageNumber = $request->input('page','1');
        $getRow = DB::table('reviewproduct')->where('id',$id)->first();
        return view('back.review.review-edit',['currentRecord'=>$getRow,'page'=>$pageNumber]);
            }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, $id)
    {
        //echo $id;die();
        $dateTime = date('Y-m-d H:i:s');
        $userId = auth()->user()->id;
        $getRow = DB::table('reviewproduct')->where('id',$id)->first();
        
       
        $review_status = $request->review_status;


       
        $updaterec = DB::table('reviewproduct')->where('id', $id)
            ->update(
            [
                'name' => $request->name,
				'mail' => $request->email,
                'phno' => $request->phno,
				'rstatus'=>$request->rstatus,
                'rating' => $request->rating,
                'review' => $request->review,
                'status' => $review_status,
                'updated_at' => $dateTime,
                'updated_by' => $userId,
           ]);
            
            $pageNumber = $request->input('page','1');

            if($updaterec > 0)
            {
                return redirect()->route('review-list',['page'=>$pageNumber])->with('success', 'Record updated successfully.');
            }else{
                return redirect()->route('review-list',['page'=>$pageNumber])->with('error', 'Error occurred.Please Try Again Later.');
            }
        

    }


      public function rstatus(Request $request)
    {
       if($request->has('chid') && $request->has('chtyp'))
       {
        if($request->chid > 0 && $request->chtyp >= 0 && ($request->chtyp == 1 || $request->chtyp == 2 || $request->chtyp == 0) ) 
        {
            
            $update = DB::update('update reviewproduct set rstatus = ? where id = ?', [$request->chtyp, $request->chid]);
            if($update > 0)
            {
                $msg = "Successfully updated";
                $sts = 200;
            }else{
                $msg = "Error occured.";
                $sts = 201;
            }
        }else{
            $msg = "Error occured.";
            $sts = 201;
        }   
       }else
       {
            $msg = "Error occured.";
            $sts = 201;
       }

       $results=array("msg"=>$msg,"status"=>$sts);
       return response()->json($results);

    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function destroy($id)
    {   
        if($id > 0)
        {
            $getRow = DB::table('reviewproduct')->where('id',$id)->first();

                     

            $delete = DB::table('reviewproduct')->where('id',$id)->delete();
            if($delete > 0)
            {
                $msg = "Successfully updated";
                $sts = 200;
            }else{
                $msg = "Error occured.";
                $sts = 201;
            }
        }else{
            $msg = "Error occured.";
            $sts = 201;
        }
        $results=array("msg"=>$msg,"status"=>$sts);
        return response()->json($results);
 
    }


    static function checkAndStoreNewsCat($catArr)
    {
        $dateTime = date('Y-m-d H:i:s');
        $userId = auth()->user()->id;

       

        $catArrCount = count($catArr);
        $catIds = array();
        $newcatIds = array();

        if($catArrCount > 0)
        {

            for($i = 0; $i < $catArrCount; $i++)
            {
                
                if(trim($catArr[$i])!="")
                {
                    $catname = ucfirst(strtolower(trim($catArr[$i])));
                    $catexistance = DB::table('news_categories')->where('name','=',$catname)->count();
                
                    if($catexistance==0)
                    {
                        $minimumorderId = 1;

                        $getmaxOrderId = DB::table('news_categories')->max('name_order');
                        $getmaxOrderId = ($getmaxOrderId >= $minimumorderId)? $getmaxOrderId : $minimumorderId;
                        $getmaxOrderId = $getmaxOrderId + 1;
                        

                        $catInsId = DB::table('news_categories')->insertGetId([
                            'name' => $catname,
                            'status' => '1',
                            'name_order' => $getmaxOrderId,
                            'created_at' => $dateTime,
                            'updated_at' => $dateTime,
                            'created_by' => $userId,
                            'updated_by' => $userId
                        ]);
                        
                        if($catInsId > 0)
                        {
                            $newcatIds[] = $catInsId;
                            $catIds[] = $catInsId;
                        }


                    }else{
                       
                        
                        $catselId = DB::table('news_categories')->where('name','=',$catname)->select('id')->pluck('id')->first();
                            
                        $catIds[] = $catselId;
    
                    }
                }
                
            }
        }
       
        $result['all'] = $catIds;
        $result['new'] = $newcatIds;

        return $result;

       
    }
	
	
	    public function updateStatus(Request $request)
    {
       if($request->has('chid') && $request->has('chtyp'))
       {
        if($request->chid > 0 && $request->chtyp >= 0 && ($request->chtyp == 1 || $request->chtyp == 2 || $request->chtyp == 0) ) 
        {
            
            $update = DB::update('update reviewproduct set status = ? where id = ?', [$request->chtyp, $request->chid]);
            if($update > 0)
            {
                $msg = "Successfully updated";
                $sts = 200;
            }else{
                $msg = "Error occured.";
                $sts = 201;
            }
        }else{
            $msg = "Error occured.";
            $sts = 201;
        }   
       }else
       {
            $msg = "Error occured.";
            $sts = 201;
       }

       $results=array("msg"=>$msg,"status"=>$sts);
       return response()->json($results);

    }


}
