<?php



namespace App\Http\Controllers\Admin;



use Illuminate\Http\Request;

use App\Http\Controllers\Controller;

use Illuminate\Support\Facades\DB;

use App\Services\Slug;

use Storage;







class SubcategoryController extends Controller

{





    public function __construct()

    {

        

    }



  

    public function index()

    {

            



        $recordToShow = 10;

        $subcategoryList = DB::table('subcategory')->orderBy('updated_at','desc')->paginate($recordToShow);

        return view('back.subcategory.subcategory',compact('subcategoryList','recordToShow'));

    }





    public function create()

    {

        $category = DB::table('category')->where('id','>','0')->orderBy('category_name','asc')->get();

        

        return view('back.subcategory.subcategory-add',['category'=>$category]);

    }



    

 

    public function store(Request $request)

    {

        $dateTime = date('Y-m-d H:i:s');

        $userId = auth()->user()->id;





        $request->validate([

			

            'subcategory_name' => 'required',

           

			'subcategory_ev_banner' => 'nullable|image|max:10000|mimes:jpeg,jpg,png',

            ]);





		

        $n_subcategoryname = $request->subcategory_name;

		//create slug 

		$slugClass = new Slug();

        $createdSlug = $slugClass->createSlug('content_management', 'slug', $n_subcategoryname);

		

		

		

        $n_desc = ($request->description!="")? $request->description : "";   

		       

		

		

        $category_status = $request->category_status;



        if($request->hasFile('subcategory_ev_banner')){

            $n_image = $request->subcategory_ev_banner;

            $imgOrigname = $n_image->getClientOriginalName();

            $imgOrigname_arr = explode('.',$imgOrigname);

            $img_name_first = str_replace(' ','_',$imgOrigname_arr[0]);

			$crsnamef = str_replace(' ','_',$n_subcategoryname);

			$crsnamef = preg_replace('/[^A-Za-z0-9\-]/','',$crsnamef);

			$img_name_first = $crsnamef.$img_name_first;

            $img_name_first = preg_replace('/[^A-Za-z0-9\-]/','',$img_name_first);

            $ext = $n_image->getClientOriginalExtension();

            $img_name = date('YmdH').$img_name_first.uniqid().'.'.$ext;

            $n_image->storeAs('public/category',$img_name);            //Storage::delete("public/event/{$user->image}");

        }else{

          

            $img_name='';



        }

   

		   

		   

		   

		   

		   echo 1;

		   

		   

		   

		   

        $insrec = DB::table('subcategory')->insertGetId(

            [

               

				'subcategory_ev_banner' => $img_name,

                'subcategory_name' => $n_subcategoryname,

				'slug'=>$createdSlug,

                'description' => $n_desc,

				

                'status' => $category_status,

                'created_at' => $dateTime,

                'updated_at' => $dateTime,

                'created_by' => $userId,

                'updated_by' => $userId

                  ]);

            

            if($insrec > 0)

            {

                return redirect()->route('subcategory-list')->with('success', 'Record added successfully.');

            }else{

                return redirect()->route('subcategory-list')->with('error', 'Error occurred.Please Try Again Later.');

            }

       



        



        

        





        







    }



    /**

     * Display the specified resource.

     *

     * @param  int  $id

     * @return \Illuminate\Http\Response

     */

    public function show($id)

    {

      // $category = DB::table('category')->where('id','>','0')->orderBy('category_name','asc')->get();



        $getRow = DB::table('subcategory')->where('id',$id)->get();//print_r($getRow);//die();

        

   

        return view('back.subcategory.subcategory-view',['currentRecord'=>$getRow[0]]);

                   

    }



    /**

     * Show the form for editing the specified resource.

     *

     * @param  int  $id

     * @return \Illuminate\Http\Response

     */

    public function edit($id, Request $request)

    {

         $category = DB::table('category')->where('id','>','0')->orderBy('category_name','asc')->get();



        $pageNumber = $request->input('page','1');

        $getRow = DB::table('subcategory')->where('id',$id)->first();

		$cattracklist = DB::table('categorytrack')->where('cat_id',$getRow->catid)->select('id','category_name')->get();

        return view('back.subcategory.subcategory-edit',['category'=>$category,'currentRecord'=>$getRow,'page'=>$pageNumber,'cattracklist'=>$cattracklist]);

            }



    /**

     * Update the specified resource in storage.

     *

     * @param  \Illuminate\Http\Request  $request

     * @param  int  $id

     * @return \Illuminate\Http\Response

     */

    public function update(Request $request, $id)

    {

        //echo $id;die();

        $dateTime = date('Y-m-d H:i:s');

        $userId = auth()->user()->id;

        $getRow = DB::table('subcategory')->where('id',$id)->first();

        

        



        $request->validate([

			

            'subcategory_name' => 'required',

            

			//'subcategory_ev_banner' => 'nullable|image|max:10000|mimes:jpeg,jpg,png',

        ]);





		

   

		   



        

		

        $n_subcategoryname = $request->subcategory_name;

		

		

		$n_desc = ($request->description!="")? $request->description : ""; 

		    

        $category_status = $request->category_status;



 if($request->hasFile('subcategory_ev_banner')){

            $n_image = $request->subcategory_ev_banner;

            $imgOrigname = $n_image->getClientOriginalName();

            $imgOrigname_arr = explode('.',$imgOrigname);

            $img_name_first = str_replace(' ','_',$imgOrigname_arr[0]);

			$crsnamef = str_replace(' ','_',$n_subcategoryname);

			$crsnamef = preg_replace('/[^A-Za-z0-9\-]/','',$crsnamef);

			$img_name_first = $crsnamef.$img_name_first;

            $img_name_first = preg_replace('/[^A-Za-z0-9\-]/','',$img_name_first);

            $ext = $n_image->getClientOriginalExtension();

            $img_name = date('YmdH').$img_name_first.uniqid().'.'.$ext;

            $n_image->storeAs('public/category',$img_name);            //Storage::delete("public/event/{$user->image}");

        }else{

          

            $img_name=$getRow->subcategory_ev_banner;



        }









        $updaterec = DB::table('subcategory')->where('id', $id)

            ->update(

            [

               

				'subcategory_ev_banner' => $img_name,

                'subcategory_name' => $n_subcategoryname,

                'description' => $n_desc,

				

                'status' => $category_status,

                'updated_at' => $dateTime,

                'updated_by' => $userId,

           ]);

            

            $pageNumber = $request->input('page','1');



            if($updaterec > 0)

            {

                return redirect()->route('subcategory-list',['page'=>$pageNumber])->with('success', 'Record updated successfully.');

            }else{

                return redirect()->route('subcategory-list',['page'=>$pageNumber])->with('error', 'Error occurred.Please Try Again Later.');

            }

        



    }





    public function updateStatus(Request $request)

    {

       if($request->has('chid') && $request->has('chtyp'))

       {

        if($request->chid > 0 && $request->chtyp >= 0 && ($request->chtyp == 1 || $request->chtyp == 2 || $request->chtyp == 0) ) 

        {

            

            $update = DB::update('update subcategory set status = ? where id = ?', [$request->chtyp, $request->chid]);

            if($update > 0)

            {

                $msg = "Successfully updated";

                $sts = 200;

            }else{

                $msg = "Error occured.";

                $sts = 201;

            }

        }else{

            $msg = "Error occured.";

            $sts = 201;

        }   

       }else

       {

            $msg = "Error occured.";

            $sts = 201;

       }



       $results=array("msg"=>$msg,"status"=>$sts);

       return response()->json($results);



    }



    /**

     * Remove the specified resource from storage.

     *

     * @param  int  $id

     * @return \Illuminate\Http\Response

     */

    public function destroy($id)

    {   

        if($id > 0)

        {

            $getRow = DB::table('subcategory')->where('id',$id)->first();



                     



            $delete = DB::table('subcategory')->where('id',$id)->delete();

            if($delete > 0)

            {

                $msg = "Successfully updated";

                $sts = 200;

            }else{

                $msg = "Error occured.";

                $sts = 201;

            }

        }else{

            $msg = "Error occured.";

            $sts = 201;

        }

        $results=array("msg"=>$msg,"status"=>$sts);

        return response()->json($results);

 

    }





    static function checkAndStoreNewsCat($catArr)

    {

        $dateTime = date('Y-m-d H:i:s');

        $userId = auth()->user()->id;



       



        $catArrCount = count($catArr);

        $catIds = array();

        $newcatIds = array();



        if($catArrCount > 0)

        {



            for($i = 0; $i < $catArrCount; $i++)

            {

                

                if(trim($catArr[$i])!="")

                {

                    $catname = ucfirst(strtolower(trim($catArr[$i])));

                    $catexistance = DB::table('news_categories')->where('name','=',$catname)->count();

                

                    if($catexistance==0)

                    {

                        $minimumorderId = 1;



                        $getmaxOrderId = DB::table('news_categories')->max('name_order');

                        $getmaxOrderId = ($getmaxOrderId >= $minimumorderId)? $getmaxOrderId : $minimumorderId;

                        $getmaxOrderId = $getmaxOrderId + 1;

                        



                        $catInsId = DB::table('news_categories')->insertGetId([

                            'name' => $catname,

                            'status' => '1',

                            'name_order' => $getmaxOrderId,

                            'created_at' => $dateTime,

                            'updated_at' => $dateTime,

                            'created_by' => $userId,

                            'updated_by' => $userId

                        ]);

                        

                        if($catInsId > 0)

                        {

                            $newcatIds[] = $catInsId;

                            $catIds[] = $catInsId;

                        }





                    }else{

                       

                        

                        $catselId = DB::table('news_categories')->where('name','=',$catname)->select('id')->pluck('id')->first();

                            

                        $catIds[] = $catselId;

    

                    }

                }

                

            }

        }

       

        $result['all'] = $catIds;

        $result['new'] = $newcatIds;



        return $result;



       

    }

	

	

	

	public function getcoursebycatdomain(Request $request)

	{

		$sts = 201;

		$msg = "Error occured.";

		$data = array();

		/*$request->validate([

			'catval' => 'required',

			'cattrack' => 'required',

            ]);*/

			

		if($request->catval > 0 && $request->cattrack > 0 )

		{	

		    $subcategoryList = DB::table('subcategory')->where('status','2')->where('catid',$request->catval)->where('cattrackid',$request->cattrack)->select('id','subcategory_name')->orderBy('subcategory_name','asc')->get();

			$msg = "Success";

			$sts = 200;

			$data = $subcategoryList;

		}

		 $results=array("msg"=>$msg, "status"=>$sts, "data"=>$data);

         return response()->json($results);

	}

	

	

	public function getcoursebyid(Request $request)

	{

		$sts = 201;

		$msg = "Error occured.";

		$data = array();

		/*$request->validate([

			'catval' => 'required',

			'cattrack' => 'required',

            ]);*/

			

		if($request->subcatval > 0)

		{	

		    $subcategoryList = DB::table('subcategory')->where('id',$request->subcatval)->select('id','subcategory_name as name','subcategory_code as code','subcategory_ev_banner as banner','description as desc','summary as summary')->orderBy('subcategory_name','asc')->first();

			$msg = "Success";

			$sts = 200;

			$data = $subcategoryList;

		}

		 $results=array("msg"=>$msg, "status"=>$sts, "data"=>$data);

         return response()->json($results);

	}

}

