<?php



namespace App\Providers;



use Illuminate\Support\ServiceProvider;

use App\Permission;

use Illuminate\Support\Facades\Gate;

use Illuminate\Support\Facades\Blade;

use Illuminate\Support\Facades\Auth;

use DB;



class PermissionsServiceProvider extends ServiceProvider

{

    /**

     * Register services.

     *

     * @return void

     */

    public function register()

    {

        //

    }



    /**

     * Bootstrap services.

     *

     * @return void

     */

    public function boot()

    {



        Permission::get()->map(function($permission){

                Gate::define($permission->slug, function($user) use ($permission){

                return $user->hasPermissionTo($permission);

                });

            });





            

        Blade::directive('role', function ($role){

            return "<?php if(auth()->check() && auth()->user()->hasRole({$role})) :";

            });

            Blade::directive('endrole', function ($role){

            return "<?php endif; ?>";

            });



            view()->composer('*', function ($view)

            {

                //$user = request()->user();

                /*$admin_submenucount = DB::table('manage_permissions')->select(DB::raw('count(*) as user_count, c_id'))->groupBy('c_id')->where('status','1')->where('c_id','!=','0')->orderBy('menu_order','asc')->get();

				

				

		$admin_mainmenu1 = DB::table('manage_permissions')

        ->leftJoinSub($admin_submenucount, 'submenu', function ($join) {

            $join->on('manage_permissions.id', '=', 'submenu.c_id');

        })->get();

		*/

        

		 $front_submenucount = DB::table('content_management')->select(DB::raw('count(*) as sub_count, cid'))->groupBy('cid')->where('status','2')->where('typ','1')->orderBy('showorder','asc')->pluck('sub_count','cid')->toArray();



         $front_mainmenu = DB::table('content_management')->where('status','2')->where('cid','0')->where('typ','1')->orderBy('showorder','asc')->get();

         

         $front_submainmenu = DB::table('content_management')->where('status','2')->where('cid','!=','0')->where('typ','1')->orderBy('showorder','asc')->get();

       



		 $admin_submenucount = DB::table('manage_permissions')->select(DB::raw('count(*) as user_count, c_id'))->groupBy('c_id')->where('status','1')->orderBy('menu_order','asc')->pluck('user_count','c_id')->toArray();



         $admin_mainmenu = DB::table('manage_permissions')->where('status','1')->where('c_id','0')->orderBy('menu_order','asc')->get();

		 $admin_submainmenu = DB::table('manage_permissions')->where('status','1')->where('c_id','!=','0')->orderBy('menu_order','asc')->get();



         $menudata = array("frnt_allmainmenu"=>$front_mainmenu, "frnt_allsubmenu"=>$front_submainmenu, "frnt_allsubcount"=>$front_submenucount,"adm_allmainmenu"=>$admin_mainmenu, "adm_allsubmenu"=>$admin_submainmenu, "adm_allsubcount"=>$admin_submenucount);       

		 
         $view->with('menudata', $menudata);
        






            });

    }

}

