@extends('back.layout.master')



@section('breadcrum')

<section class="content-header">

  <div class="container-fluid">

    <div class="row mb-2">

      <div class="col-sm-6">

        <h1>Brand Management</h1>

      </div>

      <div class="col-sm-6">

        <ol class="breadcrumb float-sm-right">

          <li class="breadcrumb-item"><a href="{{route('admin.dashboard')}}">Home</a></li>

          <li class="breadcrumb-item"><a href="{{route('brand-list')}}">Brand Management</a></li>

          <li class="breadcrumb-item active">view</li>

        </ol>

      </div>

    </div>

  </div>

  <!-- /.container-fluid -->

</section>

@endsection







@section('content')

<section class="content">

  <div style="float:none; width:100%; text-align:right; position absolute; right:0;" class="btn-block"> <a href="{{url()->previous()}}" style="width:100px;" class="btn  bg-gradient-primary btn-sm"> Back </a> </div>

  <br>





{{-- @if($errors->any())

<div class="alert alert-danger">

  <ul>

      @foreach ($errors->all() as $error)

        <li>{{ $error }}</li>

      @endforeach

  </ul>

</div><br />

@endif --}}





<div class="row">

    <div class="col-md-12">

      <div class="card card-primary p-3">

        <table class="table table-bordered">

          <tbody>

            <tr>

              <td><strong>Title</strong></td>

              <td>{{$currentRecord->name}}</td>

            </tr>

            

            

             

            <tr>

              <td><strong>Image</strong></td>

              <td>@if($currentRecord->image != '') <img src="{{asset('public/storage/brand/'.$currentRecord->image)}}" style="max-width:100px; max-height:100px;"  /> @endif</td>

            </tr>   

            

            

                <tr>

              <td><strong>Link</strong></td>

              <td>{{$currentRecord->link}}</td>

            </tr>  

            

                    

         

            <tr>

              <td><strong>Status</strong></td>

              <td> @if($currentRecord->status == '1') Disable @endif

                @if($currentRecord->status == '2') Enable @endif </td>

            </tr>            

            
 <tr>
              <td><strong>Meta Title</strong></td>
              <td>{{$currentRecord->meta_title}}</td>
            </tr>
             <tr>
              <td><strong>Meta Keywords</strong></td>
              <td>{{$currentRecord->meta_keywords}}</td>
            </tr>
             <tr>
              <td><strong>Meta Description</strong></td>
              <td>{{$currentRecord->meta_description}}</td>
            </tr>       


            <tr>

                <td colspan="2" style="text-align:center;"><a href="{{url()->previous()}}" style="width:100px;" class="btn  bg-gradient-primary btn-sm"> Back </a></td>

              </tr>

          </tbody>

        </table>

      </div>

    </div>

  </div>

  





  

  <p>&nbsp;</p>

</section>

@endsection



@section('style')

<link href="{{asset('public/plugin/summernote/summernote.css') }}" rel="stylesheet">

<link href="{{asset('public/plugin/select2/select2.min.css') }}" rel="stylesheet">

<link href="{{asset('public/plugin/date_picker_jq/jquery-ui.css') }}" rel="stylesheet">

<link href="{{asset('public/plugin/date_picker_jq/select2.min.css') }}" rel="stylesheet">



@endsection





@section('script')

<script src="{{asset('public/plugin/summernote/summernote.js') }}"></script>

<script src="{{asset('public/plugin/select2/select2.min.js') }}"></script>

<script src="{{asset('public/plugin/validate/jquery.validate.js') }}"></script>

<script src="{{asset('public/plugin/validate/additional-methods.js') }}"></script>

<script src="{{asset('public/plugin/date_picker_jq/jquery-ui.js') }}"></script>





@endsection