@extends('back.layout.master')

@section('breadcrum')
<section class="content-header">
  <div class="container-fluid">
    <div class="row mb-2">
      <div class="col-sm-6">
        <h1>{{$catRow->name}}
        @if(count($parentLoop) > 0)
        @foreach($parentLoop as $key=>$lprow) &raquo; <a href="{{route('menu-list')}}?cid={{$key}}">{{$lprow['title']}}</a>@endforeach @endif </h1>
      </div>
      <div class="col-sm-6">
        <ol class="breadcrumb float-sm-right">
          <li class="breadcrumb-item"><a href="{{route('admin.dashboard')}}">Home</a></li>
          <li class="breadcrumb-item active">{{$catRow->name}}</li>
        </ol>
      </div>
    </div>
  </div>
  <!-- /.container-fluid -->
</section>

{{--  @if(session()->get('success'))

@endif  --}}

@endsection





@section('content')

<section class="content">
<div style="float:none; width:100%; text-align:right; position absolute; right:0;" class="btn-block">
    <a href="{{route('menu-add')}}?cid={{$querystring['cid']}}&page={{$recordList->currentPage()}}" style="width:100px;" class="btn  bg-gradient-primary btn-sm">+ Add</a>
  </div>
  <br>
  <!-- Default box -->
  <div class="card">
    {{-- <div class="card-header">
      <h3 class="card-title">Projects</h3>
      <div class="card-tools">
        <button type="button" class="btn btn-tool" data-card-widget="collapse" data-toggle="tooltip" title="Collapse"> <i class="fas fa-minus"></i></button>
      </div>
    </div> --}}
    <div class="card-body p-0">
      <table class="table table-striped projects" id="listTable">
        <thead>
          <tr>
            <th style="width: 30%"> S.No </th>
            <th style="width: 30%"> Title </th>
            <th style="width: 40%" class="text-center"> Status </th>
          </tr>
        </thead>
        <tbody>
         
          
          @php( $cnt = ((($recordList->currentPage()-1) * $recordList->perPage()) + 1))

          @if(!$recordList->isEmpty())
            @foreach ($recordList as $row)
              <tr id="currentRow_{{$row->id}}" class="resultRow">
                <td> {{$cnt++}}</td>
                <td>{{$row->title}}</td>
                <td class="text-center"><!--<span class="badge badge-success">Success</span>-->
                  @if($row->status==2)
                  <a data-id="{{$row->id}}" data-typ="1" id="statuschange_{{$row->id}}" class="btn btn-success btn-sm changeStatus" href="#" title="Click to disable"> <i class="fa fa-check"> </i> </a> 
                  @elseif($row->status==1)
                  <a data-id="{{$row->id}}" data-typ="2"  id="statuschange_{{$row->id}}"  class="btn btn-danger btn-sm changeStatus" href="#" title="Click to enable">&nbsp;<i class="fa fa-times"> </i>&nbsp;</a> 
                  @endif
                  <a class="btn btn-primary btn-sm" href="{{route('menu-view',$row->id)}}?page={{$recordList->currentPage()}}" title="View"> <i class="fas fa-eye"> </i> </a> 
                  <a class="btn btn-info btn-sm" href="{{route('menu-edit',$row->id)}}?page={{$recordList->currentPage()}}" title="Edit"> <i class="fas fa-pencil-alt"> </i> </a> 
                  <a  data-id="{{$row->id}}"  class="btn btn-danger btn-sm deleteRow" href="#" title="Delete"> <i class="fas fa-trash"> </i>  </a> </td>
              </tr> 
            @endforeach
          @else
          <tr>
            <td colspan='5' style="text-align:center">No Records Found</td>
          </tr>
          @endif



        </tbody>
      </table>

      <div style="width:auto; padding:10px;float:right; text-align:right; margin-0px auto;">
          {!!$recordList->appends(request()->except('page'))->render() !!}
      </div>
      
    </div>
    <!-- /.card-body -->
  </div>
  <!-- /.card -->
</section>
@endsection

@section('script')
    <script>
        $(document).ready(function() {

          $('table').on('click', '.changeStatus', function(e){
            e.preventDefault();
            $chId = $(this).data('id');
            $chTyp = $(this).data('typ');
            if($chTyp==1)
            {
              $cnfrmMsg = "Are you sure to Disable this record.";
              $removeClass = "btn-success";
              $addClass = "btn-danger";
              $changeicon = '&nbsp;<i class="fa fa-times"> </i>&nbsp;';
              $tochTyp=2;

            }else if($chTyp==2)
            {
              $cnfrmMsg = "Are you sure to Enable this record.";
              $removeClass = "btn-danger";
              $addClass = "btn-success";
              $changeicon = '<i class="fa fa-check"> </i>';
              $tochTyp=1;
            }

            var k = confirm($cnfrmMsg);

            if(k==true)
            {
              $.ajax({
                url : "{{route('menu-statuschange')}}",
                method: "PUT",
                data : { chid : $chId, chtyp : $chTyp, _token: '{{csrf_token()}}' },
                error: function(data){
                  toastr.error("Error Occured. Please Try Again Later.");
                },
                success : function(result){
                  result = JSON.stringify(result)
                  result = JSON.parse(result);
                  if(result.status==200)
                  {
                    toastr.success("Status Updated Successfully");
                    $('#statuschange_'+$chId).removeClass($removeClass).addClass($addClass);
                    $('#statuschange_'+$chId).html($changeicon);
                    $('#statuschange_'+$chId).data('typ',$tochTyp);

                  }else{
                    toastr.error("Error Occured. Please Try Again Later.");
                  }
                }
                
              });
            }

          });


 $('table').on('click', '.deleteRow', function(e){
            e.preventDefault();
            $chId = $(this).data('id');

            var k = confirm("Are you sure to Delete this record.");

            if(k==true)
            {
              $.ajax({
                url : "menu/"+ $chId ,
                method: "DELETE",
                data : { _token: '{{csrf_token()}}' },
                error: function(data){
                  toastr.error("Error Occured. Please Try Again Later.");
                },
                success : function(result){
                  result = JSON.stringify(result)
                  result = JSON.parse(result);
                  if(result.status==200)
                  {
                    toastr.success("Deleted Successfully");
                    $('#currentRow_'+$chId).remove();
                    $rowlength = $('#listTable tbody tr').length;
                    
                    if($rowlength == '0')
                    {
                      $('#listTable tbody').html('<tr><td colspan="5" style="text-align:center">No Records Found</td></tr>');
                    }

                  }else{
                    toastr.error("Error Occured. Please Try Again Later.");
                  }
                }
                
              });
            }

          });

        });
    </script>
@endsection