@extends('back.layout.master')



@section('breadcrum')

<section class="content-header">

  <div class="container-fluid">

    <div class="row mb-2">

      <div class="col-sm-6">

        <h1>Category Management</h1>

      </div>

      <div class="col-sm-6">

        <ol class="breadcrumb float-sm-right">

          <li class="breadcrumb-item"><a href="{{route('admin.dashboard')}}">Home</a></li>

          <li class="breadcrumb-item"><a href="{{route('subcategory-list')}}">Category Management</a></li>

          <li class="breadcrumb-item active">Add</li>

        </ol>

      </div>

    </div>

  </div>

  <!-- /.container-fluid -->

</section>

@endsection











@section('content')

<section class="content">

  <div style="float:none; width:100%; text-align:right; position absolute; right:0;" class="btn-block"> <a href="{{route('subcategory-list')}}" style="width:100px;" class="btn  bg-gradient-primary btn-sm"> Back </a> </div>

  <br>

  @if($errors->any())

  <div class="alert alert-danger">

    <ul>

      @foreach ($errors->all() as $error)

      <li>{{ $error }}</li>

      @endforeach

    </ul>

  </div>

  <br />

  @endif

  <form method="POST" name="subcategoryadd" id="subcategoryadd" enctype="multipart/form-data">

    @csrf

    @method('POST')

    <div class="row">

    <div class="col-md-12">

      <div class="card card-primary"> {{--

        <div class="card-header">

          <h3 class="card-title">General</h3>

          <div class="card-tools">

            <button type="button" class="btn btn-tool" data-card-widget="collapse" data-toggle="tooltip" title="Collapse"> <i class="fas fa-minus"></i></button>

          </div>

        </div>

        --}}

        <div class="card-body">

          <div class="row">

            

            

            </div>

            <div class="form-group">

              <label for="inputName">Category Name</label>

              <input type="text" id="subcategory_name" name="subcategory_name" class="form-control">

            </div>

            

           

              

           

          

            <div class="form-group">

              <label for="inputDescription">Category Description</label>

              <textarea  id="description" name="description"  class="summernote form-control" rows="4"></textarea>

            </div>

            

            

             <div class="form-group">

              <label for="inputDescription">Category Image</label>

              <input type="file"  id="subcategory_ev_banner" name="subcategory_ev_banner" class="form-control">

            </div>

            

            

            <div class="row">

            <div class="col-md-6">

              <div class="form-group">

                <label for="inputStatus">Status</label>

                <select class="form-control custom-select"  id="category_status" name="category_status" >

                  <option value="1">Disable</option>

                  <option value="2" selected="selected">Enable</option>

                </select>

              </div>

            </div>

            </div>

          </div>

          <!-- /.card-body -->

          <div class="form-group">

            <div class="col-12 text-center">

              <input type="submit" value="Save" name="subcategory_submit" id="subcategory_submit" class="btn btn-success ">

              <a href="{{route('subcategory-list')}}"  class="btn btn-secondary">Cancel</a> </div>

          </div>

        </div>

        <!-- /.card -->

      </div>

    </div>

  </form>

  <p>&nbsp;</p>

</section>

@endsection



@section('style')

<link href="{{asset('public/plugin/summernote/summernote.css') }}" rel="stylesheet">

<link href="{{asset('public/plugin/select2/select2.min.css') }}" rel="stylesheet">

<link href="{{asset('public/plugin/date_picker_jq/jquery-ui.css') }}" rel="stylesheet">

<link href="{{asset('public/plugin/date_picker_jq/select2.min.css') }}" rel="stylesheet">

@endsection





@section('script')

<script src="{{asset('public/plugin/summernote/summernote.js') }}"></script>

<script src="{{asset('public/plugin/select2/select2.min.js') }}"></script>

<script src="{{asset('public/plugin/validate/jquery.validate.js') }}"></script>

<script src="{{asset('public/plugin/validate/additional-methods.js') }}"></script>

<script src="{{asset('public/plugin/date_picker_jq/jquery-ui.js') }}"></script>

<script>

    $(document).ready(function() {







	$('#category').on('change',function(){

		$catval = $(this).val();

		

		if($catval > 0 )

		{

		$.ajax({

                url : "{{route('getcategorystatusbycat')}}",

                method: "POST",

                data : { catval : $catval, catcheck : 'evqf', _token: '{{csrf_token()}}' },

                beforeSend: function(){

					$('#categorytrackload').html('<img src="../public/front/images/ajax-loader.gif"/>');

				},

				error: function(data){

					$('#categorytrackload img').remove();

                  toastr.error("Error Occured. Please Try Again Later.");

                },

                success : function(result){

				  $('#categorytrackload img').remove();

                  result = JSON.stringify(result)

                  result = JSON.parse(result);

                  if(result.status==200)

                  {

                    //toastr.success("Status Updated Successfully");

					if(result.data.length > 0)

					{

						$options = "<option value=''>Select Category</option>";

						$.each(result.data, function(i, item){

							$options += "<option value='"+item.id+"'>"+item.category_name+"</option>";

						});

					}else

					{

						$options = "<option value=''>Category Not Found</option>";

					}

					$('#categorytrack').html($options);

					

                  }else{

                    toastr.error("Error Occured. Please Try Again Later.");

					$options = "<option value=''>Select Category</option>";

					$('#categorytrack').html($options);

                  }

                }

                

              });

		}else

		{

			$options = "<option value=''>Select Category</option>";

			$('#categorytrack').html($options);

		}  

	});

	

	



	$('#categorytrack').on('click',function(){

		$catval = $('#category').val();

		if($catval=="")

		{

			$options = "<option value=''>Select Category</option>";

			$('#categorytrack').html($options);

			

			$('.toast-top-right').remove();

			toastr.warning("Please Select Training Domain.");

			$('#category').focus();

		}

	});







      $( "#news_date" ).datepicker({

        dateFormat: 'dd-mm-yy',

        /*minDate: 1,*/

        changeMonth: true,

        changeYear: true,

        yearRange: "-10:+10",

        onSelect: function(dateText, inst){

        //mYt("#cal_start_date_2").datepicker("option","minDate",mYt("#cal_start_date_1").datepicker("getDate"));

        }

      });





  $('.summernote').summernote({

    height: 200,

    popover: {

              image: [],

              link: [],

              air: []

            },

	callbacks: {

    onPaste: function (e) {

      var bufferText = ((e.originalEvent || e).clipboardData || window.clipboardData).getData('text/html');

	  if(bufferText)

	  {

      e.preventDefault();

      var div = $('<div />');

      div.append(bufferText);

      div.find('*').removeAttr('style');

      setTimeout(function () {

        document.execCommand('insertHtml', false, div.html());

      }, 10);

    }

	}

  }

  });







 



$('#subcategoryadd').validate({

  rules:{

    subcategory_name : {

      required:true

    },
subcategory_ev_banner:{
	required:true
	},

	

 },



 messages:{

    subcategory_name : {

      required:'Please Enter Category Name'

    },
subcategory_ev_banner:{
	required:'Please Upload Category Image'
	},

	

 },



 errorPlacement: function(error, element){

     error.insertAfter(element);

   

 }



})



});

  </script>

@endsection