@extends('back.layout.master')

@section('breadcrum')
<section class="content-header">
  <div class="container-fluid">
    <div class="row mb-2">
      <div class="col-sm-6">
        <h1>Category Management</h1>
      </div>
      <div class="col-sm-6">
        <ol class="breadcrumb float-sm-right">
          <li class="breadcrumb-item"><a href="{{route('admin.dashboard')}}">Home</a></li>
          <li class="breadcrumb-item"><a href="{{route('subcategory-list')}}">Category Management</a></li>
          <li class="breadcrumb-item active">View</li>
        </ol>
      </div>
    </div>
  </div>
  <!-- /.container-fluid -->
</section>
@endsection



@section('content')
<section class="content">
  <div style="float:none; width:100%; text-align:right; position absolute; right:0;" class="btn-block"> <a href="{{url()->previous()}}" style="width:100px;" class="btn  bg-gradient-primary btn-sm"> Back </a> </div>
  <br>
  {{-- @if($errors->any())
  <div class="alert alert-danger">
    <ul>
      @foreach ($errors->all() as $error)
      <li>{{ $error }}</li>
      @endforeach
    </ul>
  </div>
  <br />
  @endif --}}
  <div class="row">
    <div class="col-md-12">
      <div class="card card-primary p-3">
        <table class="table table-bordered">
          <tbody>
          
          
              <td><strong>Category Name</strong></td>
              <td>{{$currentRecord->subcategory_name}}</td>
            </tr>
            
            <tr>
              <td><strong>category Image</strong></td>
              <td> @if($currentRecord->subcategory_ev_banner != '')
                <img src="{{asset('public/storage/category/'.$currentRecord->subcategory_ev_banner )}}" style="max-width:100px; max-height:100px;"  />
                @endif</td>
            </tr>
            
            <tr>
              <td><strong>Description</strong></td>
              <td>{!!$currentRecord->description!!}</td>
            </tr>
            <tr>
              <td><strong>Status</strong></td>
              <td> @if($currentRecord->status == '1') Disable @endif
                @if($currentRecord->status == '2') Enable @endif </td>
            </tr>
            <tr>
              <td colspan="2" style="text-align:center;"><a href="{{url()->previous()}}" style="width:100px;" class="btn  bg-gradient-primary btn-sm"> Back </a></td>
            </tr>
          </tbody>
        </table>
      </div>
    </div>
  </div>
  <p>&nbsp;</p>
</section>
@endsection

@section('style')
<link href="{{asset('public/plugin/summernote/summernote.css') }}" rel="stylesheet">
<link href="{{asset('public/plugin/select2/select2.min.css') }}" rel="stylesheet">
<link href="{{asset('public/plugin/date_picker_jq/jquery-ui.css') }}" rel="stylesheet">
<link href="{{asset('public/plugin/date_picker_jq/select2.min.css') }}" rel="stylesheet">
@endsection


@section('script')
<script src="{{asset('public/plugin/summernote/summernote.js') }}"></script>
<script src="{{asset('public/plugin/select2/select2.min.js') }}"></script>
<script src="{{asset('public/plugin/validate/jquery.validate.js') }}"></script>
<script src="{{asset('public/plugin/validate/additional-methods.js') }}"></script>
<script src="{{asset('public/plugin/date_picker_jq/jquery-ui.js') }}"></script>
<script>
    $(document).ready(function() {


      $( "#news_date" ).datepicker({
        dateFormat: 'mm-dd-yy',
        /*minDate: 1,*/
        changeMonth: true,
        changeYear: true,
        yearRange: "-10:+10",
        onSelect: function(dateText, inst){
        //mYt("#cal_start_date_2").datepicker("option","minDate",mYt("#cal_start_date_1").datepicker("getDate"));
        }
      });


  $('.summernote').summernote({
    height: 200,
    popover: {
              image: [],
              link: [],
              air: []
            },
	callbacks: {
    onPaste: function (e) {
      var bufferText = ((e.originalEvent || e).clipboardData || window.clipboardData).getData('text/html');
	  if(bufferText)
	  {
      e.preventDefault();
      var div = $('<div />');
      div.append(bufferText);
      div.find('*').removeAttr('style');
      setTimeout(function () {
        document.execCommand('insertHtml', false, div.html());
      }, 10);
    }
	}
  }
  });



  $("#news_category").select2({
    tags: true,
    tokenSeparators: [',']
})

$('#news_category').show();


$('#newsadd1').validate({
  rules:{
    'news_category[]' : {
      required:true
    },

    news_title : {
      required:true
    }
 },

 messages:{
    news_title : {
      required:'Please enter news title'
    },
 },

 errorPlacement: function(error, element){
    if(element.attr("name") == "news_category[]") {
      error.appendTo( element.parent(".form-group") );
    } else {
      error.insertAfter(element);
    }
 }

})

});
  </script>
@endsection