﻿<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="utf-8" />
    <title>CyberBahn - TAS <?php echo e($course_details->meta_title); ?></title>        
        <meta name="description" content="CyberBahn - TAS <?php echo e($course_details->description); ?>">
    <meta name="viewport" content="width=device-width, initial-scale=1.0" />
	<meta name="csrf-token" content="<?php echo e(csrf_token()); ?>">
    <!-- Google Fonts -->
    <link href="https://fonts.googleapis.com/css?family=Raleway:100,200,300,400,500,600,700,800,900" rel="stylesheet">

    <!-- Favicon -->
    <link rel="shortcut icon" href="<?php echo e(url('landingpage/img/favicon.ico')); ?>">

    <!-- Template CSS Files -->
    <link rel="stylesheet" type="text/css" href="<?php echo e(url('landingpage/css/bootstrap.min.css')); ?>" />
    <link rel="stylesheet" type="text/css" href="<?php echo e(url('landingpage/css/font-awesome.min.css')); ?>" />
    <link rel="stylesheet" type="text/css" href="<?php echo e(url('landingpage/css/magnific-popup.css')); ?>" />
    <link rel="stylesheet" type="text/css" href="<?php echo e(url('landingpage/css/style.css')); ?>" />
    <link rel="stylesheet" type="text/css" href="<?php echo e(url('landingpage/css/skins/orange.css')); ?>" />

    <!-- Revolution Slider CSS Files -->
    <link rel="stylesheet" type="text/css" href="<?php echo e(url('landingpage/js/plugins/revolution/css/settings.css')); ?>" />
    <link rel="stylesheet" type="text/css" href="<?php echo e(url('landingpage/js/plugins/revolution/css/layers.css')); ?>" />
    <link rel="stylesheet" type="text/css" href="<?php echo e(url('landingpage/js/plugins/revolution/css/navigation.css')); ?>" />

    <!-- Live Style Switcher - demo only -->
    <link rel="alternate stylesheet" type="text/css" title="blue" href="<?php echo e(url('landingpage/css/skins/blue.css')); ?>" />
    <link rel="alternate stylesheet" type="text/css" title="blueviolet" href="<?php echo e(url('landingpage/css/skins/blueviolet.css')); ?>" />
    <link rel="alternate stylesheet" type="text/css" title="goldenrod" href="<?php echo e(url('landingpage/css/skins/goldenrod.css')); ?>" />
    <link rel="alternate stylesheet" type="text/css" title="green" href="<?php echo e(url('landingpage/css/skins/green.css')); ?>" />
    <link rel="alternate stylesheet" type="text/css" title="magenta" href="<?php echo e(url('landingpage/css/skins/magenta.css')); ?>" />
    <link rel="alternate stylesheet" type="text/css" title="orange" href="<?php echo e(url('landingpage/css/skins/orange.css')); ?>" />
    <link rel="alternate stylesheet" type="text/css" title="purple" href="<?php echo e(url('landingpage/css/skins/purple.css')); ?>" />
    <link rel="alternate stylesheet" type="text/css" title="red" href="<?php echo e(url('landingpage/css/skins/blue.css')); ?>" />
    <link rel="alternate stylesheet" type="text/css" title="yellow" href="<?php echo e(url('landingpage/css/skins/yellow.css')); ?>" />
    <link rel="alternate stylesheet" type="text/css" title="yellowgreen" href="<?php echo e(url('landingpage/css/skins/yellowgreen.css')); ?>" />
    <link rel="stylesheet" type="text/css" href="<?php echo e(url('landingpage/css/styleswitcher.css')); ?>" />

    <!-- Template JS Files -->
    <script type="text/javascript" src="<?php echo e(url('landingpage/js/modernizr.js')); ?>"></script>
<style type="text/css">
#coursedescription p{ text-align:justify;}
#trainerdescription p{text-align:justify; color:#FFFFFF;}
.myimage{filter: blur(8px);
  -webkit-filter: blur(8px);}
  
  div#slide-1-layer-2 span, div#slide-1-layer-2 {
    font-size: 35px !important;
    line-height: 44px !important;
}

#projectmanager2 p {

    line-height: 0.5;

}
</style>
</head>


<body class="big-triangle">
    <!-- Preloader Starts -->
    <div class="preloader" id="preloader">
        <div class="logopreloader">
            <img src="<?php echo e(url('landingpage/img/logo-c.png')); ?>" alt="logo-black">
        </div>
        <div class="loader" id="loader"></div>
    </div>
    <!-- Preloader Ends -->
    <!-- Live Style Switcher Starts - demo only -->

    <!-- Live Style Switcher Ends - demo only -->
    <!-- Page Wrapper Starts -->
    <div class="wrapper">
        <!-- Header Starts -->
        <header id="header" class="header">
            <div class="header-inner">
                <!-- Navbar Starts -->
                <nav class="navbar navbar-expand-lg p-0" id="singlepage-nav">
					<!-- Logo Starts -->
                    <div class="logo">
                        <a data-toggle="collapse" data-target=".navbar-collapse.show" class="navbar-brand link-menu scroll-to-target" href="https://cyberbahntas.com/">
                            <!-- Logo White Starts -->
                            <img id="logo-light" class="logo-light" src="<?php echo e(url('landingpage/img/logo-w.png')); ?>" alt="logo-light" />
                            <!-- Logo White Ends -->
                            <!-- Logo Black Starts -->
                            <img id="logo-dark" class="logo-dark" src="<?php echo e(url('landingpage/img/logo-c.png')); ?>" alt="logo-dark" />
                            <!-- Logo Black Ends -->
                        </a>
                  </div>
					<!-- Logo Ends -->
					<!-- Hamburger Icon Starts -->
                   
					<!-- Hamburger Icon Ends -->
					<!-- Navigation Menu Starts -->
                    
					<!-- Navigation Menu Ends -->
                </nav>
                <!-- Navbar Ends -->
            </div>
        </header>
		<!-- Header Ends -->
        <!-- Main Slider Section Starts -->
        <section class="mainslider" id="mainslider">
            <!-- Slider Hero Starts -->
            <div class="rev_slider_wrapper fullwidthbanner-container" data-alias="classicslider1" style="margin:0px auto;background-color:transparent;padding:0px;margin-top:0px;margin-bottom:0px;">
                <!-- START REVOLUTION SLIDER 5.0.7 auto mode -->
                <div id="rev_slider" class="rev_slider fullwidthabanner" style="display:none;" data-version="5.0.7">
                    <ul>
                        <!-- SLIDE  -->
                        <li data-index="rs-1" data-transition="boxslide" data-slotamount="default" data-easein="default" data-easeout="default" data-masterspeed="default" data-thumb="<?php echo e(url('landingpage/img/revolution-slider/slideshow/thumb1.jpg')); ?>" data-rotate="0" data-fsmasterspeed="300" data-fsslotamount="7" data-saveperformance="off" data-title="Intro" data-description="">
                            <!-- MAIN IMAGE -->
                            <img src="<?php echo e(asset('public/storage/landingpage/banner/'.$course_details->banner_img )); ?>" alt="" data-bgposition="top center" data-bgfit="cover" data-bgrepeat="no-repeat" data-bgparallax="10" class="" data-no-retina >
                            <!-- LAYERS -->

                            <!-- LAYER NR. 1 -->
                            <div class="tp-caption NotGeneric-Title   tp-resizeme rs-parallaxlevel-0" data-x="['center','center','center','center']" data-hoffset="['0','0','0','0']" data-y="['middle','middle','middle','middle']" data-voffset="['0','0','0','0']" data-fontsize="['70','70','70','45']" data-lineheight="['70','70','70','50']" data-width="none" data-height="none" data-whitespace="nowrap" data-transform_idle="o:1;" data-transform_in="x:[105%];z:0;rX:45deg;rY:0deg;rZ:90deg;sX:1;sY:1;skX:0;skY:0;s:2000;e:Power4.easeInOut;" data-transform_out="y:[100%];s:1000;e:Power2.easeInOut;s:1000;e:Power2.easeInOut;" data-mask_in="x:0px;y:0px;s:inherit;e:inherit;" data-mask_out="x:inherit;y:inherit;s:inherit;e:inherit;" data-start="1000" data-splitin="chars" data-splitout="none" data-responsive_offset="on" data-elementdelay="0.05" style="z-index: 5; white-space: nowrap;"><?php echo e($course_details->title); ?> 
                            
                            
                            </div>
<div class="tp-caption NotGeneric-SubTitle   tp-resizeme rs-parallaxlevel-0 nowrap-normal text-center px-15" data-x="['center','center','center','center']" data-hoffset="['0','0','0','0']" data-y="['middle','middle','middle','middle']" data-voffset="['70','70','70','70']" data-width="none" data-height="none" data-whitespace="nowrap" data-transform_idle="o:1;" data-transform_in="y:[100%];z:0;rX:0deg;rY:0;rZ:0;sX:1;sY:1;skX:0;skY:0;opacity:0;s:2000;e:Power4.easeInOut;" data-transform_out="y:[100%];s:1000;e:Power2.easeInOut;s:1000;e:Power2.easeInOut;" data-mask_in="x:0px;y:[100%];s:inherit;e:inherit;" data-mask_out="x:inherit;y:inherit;s:inherit;e:inherit;" data-start="1500" data-splitin="none" data-splitout="none" data-responsive_offset="on" style="z-index: 6; white-space: nowrap;">
<i class="fa fa-calendar" aria-hidden="true"></i>&nbsp;<?php echo e(\Carbon\Carbon::parse($each_course_details->crs_date_start)->format('F d, Y')); ?> - <?php echo e(\Carbon\Carbon::parse($each_course_details->crs_date_end)->format('F d, Y')); ?>



                            </div>
                           

                            <!-- LAYER NR. 3 -->
                            <div class="tp-caption NotGeneric-Icon   tp-resizeme rs-parallaxlevel-0" data-x="['center','center','center','center']" data-hoffset="['0','0','0','0']" data-y="['middle','middle','middle','middle']" data-voffset="['-68','-68','-68','-68']" data-width="none" data-height="none" data-whitespace="nowrap" data-transform_idle="o:1;" data-style_hover="cursor:default;" data-transform_in="y:[100%];z:0;rX:0deg;rY:0;rZ:0;sX:1;sY:1;skX:0;skY:0;opacity:0;s:1500;e:Power4.easeInOut;" data-transform_out="y:[100%];s:1000;e:Power2.easeInOut;s:1000;e:Power2.easeInOut;" data-mask_in="x:0px;y:[100%];s:inherit;e:inherit;" data-mask_out="x:inherit;y:inherit;s:inherit;e:inherit;" data-start="2000" data-splitin="none" data-splitout="none" data-responsive_offset="on" style="z-index: 7; white-space: nowrap;"><i class="pe-7s-refresh"></i>
                            </div>
                            <!-- LAYER NR. 4 -->
                            <div class="tp-caption" data-x="['center','center','center','center']" data-hoffset="['0','0','0','0']" data-y="['middle','middle','middle','middle']" data-voffset="['150','210','210','180']" data-width="none" data-height="none" data-whitespace="nowrap" data-transform_idle="o:1;" data-transform_hover="o:1;rX:0;rY:0;rZ:0;z:0;s:300;e:Power1.easeInOut;" data-style_hover="c:rgba(255, 255, 255, 1.00);bc:rgba(255, 255, 255, 1.00);" data-transform_in="y:100px;sX:1;sY:1;opacity:0;s:2000;e:Power3.easeInOut;" data-transform_out="y:50px;opacity:0;s:1000;e:Power2.easeInOut;" data-start="750" data-splitin="none" data-splitout="none" data-responsive_offset="on" data-responsive="off" style="z-index: 11; white-space: nowrap;text-transform:left;outline:none;box-shadow:none;box-sizing:border-box;-moz-box-sizing:border-box;-webkit-box-sizing:border-box;cursor:pointer;"><a href="javascript:void(0);" data-toggle="modal" data-target="#downloadform" class="custom-button slider-button scroll-to-target">Download Brochure</a> <a href="<?php echo e($each_course_details->register_link); ?>" target="_blank" class="custom-button slider-button scroll-to-target" style="background-color:#279c43">REGISTER NOW!!</a></div>
                            
                            
                        </li>
                        <!-- SLIDE  -->

                        
                    </ul>
                   
                </div>
            </div>
            <!-- Slider Hero Ends -->
        </section>
        <!-- Main Slider Section Ends -->
        <!-- About Section Starts -->
        <section id="about" class="about">
            <!-- Container Starts -->
            <div class="container">
                <!-- Main Heading Starts -->
                
                <!-- Main Heading Ends -->
                <!-- Divider Starts -->
                
                <!-- Divider Ends -->
                <!-- About Content Starts -->
                <div class="row about-content">
                    <div class="col-sm-12 col-md-12 col-lg-6 about-left-side" id="coursedescription">
                        <h3 class="title-about"><strong>Description: </strong></h3>
                        <hr>
                        <?php echo $course_details->description; ?>

						<!-- Tabs Heading Starts -->
                        
                        <!-- Tabs Heading Ends -->
                        <!-- Tabs Content Starts -->
                        
                        <!-- Tabs Content Ends -->
                       
                    </div>
                    <div class="col-md-12 col-lg-6 about-right">
						<div class="about-right-side">
							<img class="img-fluid" src="<?php echo e(asset('public/storage/landingpage/badge/'.$course_details->badge_img )); ?>" alt="">
						</div>
                    </div>
                </div>
                <!-- About Content Ends -->
            </div>
            <!-- Container Ends -->
        </section>
        <!-- About Section Ends -->
        <!-- Project Manager Section Starts -->
        <section class="projectmanager" id="projectmanager">
            <!-- Section Overlay Starts -->
            <div class="section-overlay" id="projectmanager2">
                <!-- Container Starts -->
                <div class="container">
                    <div class="row">
                        <!-- Image Starts -->
                        <div class="col-md-12 col-lg-12 col-xl-3" style="padding-top:80px;">
                            <img class="img-fluid projectmanagerpicture" src="<?php echo e(url('landingpage/img/projectmanager.jpg')); ?>" alt="project manager">
                        </div>
                        <!-- Image Ends -->
                        <!-- Details Starts -->
                        <div class="col-md-12 col-lg-12 col-xl-8 offset-xl-1">
                            <h3>Audience</h3>
                            <?php echo $course_details->audience; ?>

                            <br><br>
                            <!-- Social Media Starts -->
                            
                            <!-- Social Media Ends -->
                        </div>
                    </div>
                    <!-- Details Ends -->
                </div>
                <!-- Container Ends -->
            </div>
        </section>
        <!-- Project Manager Section Ends -->
        
        <section id="about" class="about"  style="background-color:#efefef">
            <!-- Container Starts -->
            <div class="container">
                <!-- Main Heading Starts -->
                
              <div class="text-center top-text">
                    <h1><span>Topics </span> Covered</h1>
                  
                </div>
                <!-- Main Heading Starts -->
                <!-- Divider Starts -->
                <div class="divider text-center">
                    <span class="outer-line"></span>
                    <span class="fa fa-cogs" aria-hidden="true"></span>
                    <span class="outer-line"></span>
                </div>
                
                <!-- Divider Ends -->
                <!-- About Content Starts -->
                <div class="row about-content">
                    
                    <?php echo $course_details->topics_covered; ?>

                </div>
                <!-- About Content Ends -->
               
                <!-- Main Heading Starts -->
                <!-- Divider Starts -->
                
                
                <!-- Divider Ends -->
                <!-- About Content Starts -->
                
                
                
            </div>
            <!-- Container Ends -->
        </section>
        
        
        <section class="projectmanager" id="projectmanager" >
            <!-- Section Overlay Starts -->
            <div class="section-overlay" id="projectmanager2">
                <!-- Container Starts -->
                <div class="container">
                    <div class="row">
                        <!-- Image Starts -->
                       
                        <!-- Image Ends -->
                        <!-- Details Starts -->
                        <div class="col-md-12 col-lg-12 col-xl-10 offset-xl-1">
                            <h3>List of Classes</h3>
                            
                            <div class="table-responsive">
                            <table class="table  table-striped" id="order_table">
                  <thead>
                    <tr>
                      <th>Course Name</th>
                      <th>Date</th>
                      <th>Country/City</th>
                      <th class="no-sort">Register</th>
                    </tr>
                  </thead>
                  
                  <tbody>
                  <?php $__currentLoopData = $other_course_details; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $cdetail): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                  	<tr>
                    	<td><a href='<?php echo e(url('courses')); ?>/<?php echo e($cdetail->slug); ?>'><?php echo e($course_details->title); ?></a><br>
                        <a href='<?php echo e(url('courses')); ?>/<?php echo e($course_details->slug); ?>/<?php echo e($cdetail->crs_datestart); ?>/<?php echo e($cdetail->id); ?>'>new link</a>
                        </td>
                        <td><?php echo e(\Carbon\Carbon::parse($cdetail->crs_date_start)->format('m/d/Y')); ?> </td>
                        <td><?php if($cdetail->crs_class_mode == '1'): ?> Online <?php else: ?> 
                        <?php $__currentLoopData = $venues; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $v): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <?php if($v->id == $cdetail->crs_class_venue_id): ?> <?php echo e($v->city); ?>, <?php echo e($v->state); ?> <?php endif; ?>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                         <?php endif; ?></td>                       
                        <td><a href='<?php echo e($cdetail->register_link); ?>' target="_blank">REGISTER</a></td>                        
                    </tr>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                  </tbody>
                  
                </table></div>
                            <!-- Social Media Starts -->
                            
                            <!-- Social Media Ends -->
                        </div>
                    </div>
                    <!-- Details Ends -->
                </div>
                <!-- Container Ends -->
            </div>
        </section>
        
        
        <section id="about" class="about"  style="background-color:#efefef">
            <!-- Container Starts -->
            <div class="container">
                <!-- Main Heading Starts -->
                
              
                <!-- Main Heading Starts -->
                <!-- Divider Starts -->
                
                <!-- About Content Ends -->
                <div class="text-center top-text">
                    <h1><span>Course  </span> Information</h1>
                  
                </div>
                <!-- Main Heading Starts -->
                <!-- Divider Starts -->
                <div class="divider text-center">
                    <span class="outer-line"></span>
                    <span class="fa fa-cogs" aria-hidden="true"></span>
                    <span class="outer-line"></span>
                </div>
                
                <!-- Divider Ends -->
                <!-- About Content Starts -->
                <div class="row about-content">
					<?php echo $course_details->course_info; ?>

                    <?php echo $course_details->notes; ?>

                </div>
                
                
            </div>
            <!-- Container Ends -->
        </section>
        
        <!-- Services Section Starts -->
        
        <!-- Services Section Ends -->
        <!-- Testimonials Section Starts -->
        <section class="projectmanager" id="projectmanager">
            <!-- Section Overlay Starts -->
            <div class="section-overlay">
                <!-- Container Starts -->
                <div class="container">
                
                <div class="text-center top-text">
                        <h1><span>Trainer</span>  Detail:</h1>
                       
                    </div>
                    <div class="row">
                        <!-- Image Starts -->
                        <div class="col-md-12 col-lg-12 col-xl-3">
                            <img class="img-fluid projectmanagerpicture" src="<?php echo e(asset('public/storage/landingtraining/badge/'.$each_course_details->trainer_img )); ?>" alt="project manager">
                        </div>
                        <!-- Image Ends -->
                        <!-- Details Starts -->
                        <?php $__currentLoopData = $trainer_name; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $trainer): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <div class="col-md-12 col-lg-12 col-xl-8 offset-xl-1" id="trainerdescription">
                            <h5 style="color:#FFF"><strong><?php echo e($trainer->trainer_name); ?></strong></h5>
                                    <?php echo $trainer->description; ?>

                            <br>
                            
                            <!-- Social Media Starts -->
                            <div class="social-icons">
                    <ul class="social">
                       
                         <?php if($trainer->facebooklink!=""): ?>
                        <li>
                            <a class="facebook" href="<?php echo e($trainer->facebooklink); ?>" title="facebook" target="_blank"></a>
                        </li>
                        <?php endif; ?>
                        
                         <?php if($trainer->twitterlink!=""): ?>
                         <li>
                            <a class="twitter" href="<?php echo e($trainer->twitterlink); ?>" title="twitter"></a>
                        </li>
                         <?php endif; ?>
                         
                         <?php if($trainer->instagramlink!=""): ?>
                        <li>
                            <a class="instagram" href="<?php echo e($trainer->instagramlink); ?>" title="instagram"></a>
                        </li>
                         <?php endif; ?>
                      <?php if($trainer->youtubelink!=""): ?>
                        <li>
                            <a class="youtube" href="<?php echo e($trainer->youtubelink); ?>" title="youtube"></a>
                        </li>
                         <?php endif; ?>
                         
                         
                        <?php if($trainer->skypelink!=""): ?>
                        <li>
                            <a class="skype" href="<?php echo e($trainer->skypelink); ?>" title="skype"></a>
                        </li>
                        <?php endif; ?>
                      
                       
                    </ul>
                </div>
                            <!-- Social Media Ends -->
                        </div>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    </div>
                    <!-- Details Ends -->
                </div>
                <!-- Container Ends -->
            </div>
        </section>
        
        
        
        <section class="testimonials">
            <div class="section-overlay">
                <!-- Container Starts -->
                <div class="container">
                    <!-- Main Heading Starts -->
                    <div class="text-center top-text">
                        <h1><span>Professional Development Units </span>& Scrum Education Unit</h1>
                       
                    </div>
                    <!-- Main Heading Starts -->
                    <!-- Blockquotes Starts -->
                    <div  class="carousel slide" data-ride="carousel">
                        <!-- Wrapper For Sliders Starts -->
                        <!-- Indicators Starts -->
                        
                        <!-- Indicators Ends -->
                       
                            <!-- Quote #1 Starts -->
                            <div >
                              
                                   
                                    
                                    <p style="color:#FFF">Attendees may be eligible to apply for 30 PDUs toward their continuing education requirements with the Project Management Institute (PMI) for PMP, PgMP, and PMI-ACP certifications.</p>
                                    <p style="color:#FFF">
Attendees may be eligible to apply for SEUs under Category C, toward earning or renewing their CSP through Scrum Alliance.</p>

                                    <p align="center"><a href="<?php echo e($each_course_details->register_link); ?>" target="_blank" class="custom-button slider-button scroll-to-target" style="background-color:#279c43">REGISTER NOW!!</a></p>
                              
                       
                         
                            <!-- Quote #1 Ends -->
                        </div>
                        <!-- Wrapper For Sliders Ends -->
                    </div>
                    <!-- Blockquotes Ends -->
                </div>
                <!-- Container Ends -->
            </div>
        </section>
        
        
        <!-- Testimonials Section Ends -->

			<section class="contactform">
            <div class="section-overlay">
                <div class="container">
                <div class="row">
                
                
                <div class="col-md-12 col-lg-12 about-center">

                    <!-- Main Heading Starts -->
                    <div class="text-center top-text">
                    	<h1><span>Let's start a </span>  conversation:</h1>
                        
                    </div>
                    <!-- Main Heading Ends -->
                    <div class="form-container">
                        <!-- Contact Form Starts -->
                        <form class="formcontact2" method="post" action=""><?php echo e(csrf_field()); ?>

                            <div class="row form-inputs">
                                <!-- First Name Field Starts -->
                                <div class="col-md-6 form-group custom-form-group">
                                    <span class="input custom-input">
										<input placeholder="First Name" class="input-field custom-input-field" id="firstname" name="firstname" type="text" required data-error="NEW ERROR MESSAGE">
										<label class="input-label custom-input-label" >
											<i class="fa fa-user icon icon-field"></i>
										</label>
									</span>
                                </div>
                                <!-- First Name Field Ends -->
                                <!-- Last Name Field Starts -->
                                <div class="col-md-6 form-group custom-form-group">
                                    <span class="input custom-input">
										<input placeholder="Last Name" class="input-field custom-input-field" id="lastname" name="lastname" type="text" required>
										<label class="input-label custom-input-label" >
											<i class="fa fa-user-o icon icon-field"></i>
										</label>
									</span>
                                </div>
                                
                                <div class="col-md-6 form-group custom-form-group">
                                    <span class="input custom-input">
										<input placeholder="Email" class="input-field custom-input-field" id="email" name="email" type="text" required>
										<label class="input-label custom-input-label" >
											<i class="fa fa-envelope icon icon-field"></i>
										</label>
									</span>
                                </div>
                                <!-- First Name Field Ends -->
                                <!-- Last Name Field Starts -->
                                <div class="col-md-6 form-group custom-form-group">
                                    <span class="input custom-input">
										<input placeholder="Phone number" class="input-field custom-input-field" id="phonenumber" name="phonenumber" type="text" required>
										<label class="input-label custom-input-label" >
											<i class="fa fa-phone icon icon-field"></i>
										</label>
									</span>
                                </div>
                                
                                                                
                                <!-- Last Name Field Ends -->
                                <!-- Message Field Starts -->
                                <div class="form-group custom-form-group col-md-12">
                                    <textarea placeholder="Message" id="message" name="message" cols="45" rows="7" required></textarea>
                                </div>
                                <!-- Message Field Ends -->
                                <!-- Email Name Field Starts -->
                                
                                <!-- Email Name Field Ends -->
                                <!-- Submit Button Starts --><div class="col-md-3 submit-form"></div>
                                <div class="col-md-6 submit-form">
                                    <button id="form-submit" name="submit" type="submit" class="custom-button" title="Send">Send Message</button>
                                </div><div class="col-md-3 submit-form"></div>
                                <!-- Submit Button Ends -->
                                <!-- Form Submit Message Starts -->
                                <div class="col-sm-12 text-center output_message_holder d-none">
                                    <p class="output_message"></p>
                                </div>
                                <!-- Form Submit Message Ends -->
                            </div>
                        </form>
                        <!-- Contact Form Ends -->
                    </div>
                </div>
                </div>
                </div>
            </div>
        </section>

        <!-- Newsletter Section Starts -->
        
        <!-- Newsletter Section Ends -->
        <!-- Blog Section Starts -->
        
        <!-- Blog Section Ends -->
        <!-- Video Section Starts -->
        
        <!-- Video Section Ends -->
        <!-- Contact Section Starts -->
        <section id="contact" class="contact">
            <!-- Container Starts -->
            <div class="container">
                <!-- Main Heading Starts -->
                <div class="text-center top-text">
                    <h1><span>Contact</span> Us</h1>
                    <h4>Get in Touch</h4>
                </div>
                <!-- Main Heading Starts -->
                <!-- Divider Starts -->
                <div class="divider text-center">
                    <span class="outer-line"></span>
                    <span class="fa fa-envelope" aria-hidden="true"></span>
                    <span class="outer-line"></span>
                </div>
                <!-- Divider Ends -->
            </div>
            <!-- Container Ends -->
            <!-- Map Section Starts -->
            <div class="info-map">
                 <iframe id="cntiframe" src="https://www.google.com/maps/embed?pb=!1m18!1m12!1m3!1d3106.988516113413!2d-77.05108978465086!3d38.85561987957709!2m3!1f0!2f0!3f0!3m2!1i1024!2i768!4f13.1!3m3!1m2!1s0x89b7b72f6f8802b3%3A0x9c6f044b0d8b482f!2s2011%20Crystal%20Dr%20%23400%2C%20Arlington%2C%20VA%2022202%2C%20USA!5e0!3m2!1sen!2sin!4v1579321420424!5m2!1sen!2sin" width="100%" height="400" frameborder="0" style="border:0" allowfullscreen=""></iframe>
            </div>
            <!-- Info Map Boxes Starts -->
            <div class="container">
                <div class="row info-map-boxes">
                    <!-- Left Info Map Box Starts -->
                    <div class="col-md-6 col-sm-12">
                        <div class="info-map-boxes-item fa fa-address-card-o">
                            <h1>Our Office Location</h1>
                            <p>Cyberbahn Federal Solutions, LLC
                                <br>2011 Crystal Drive, Suite #400
                                <br>Arlington, VA 22202, USA</p>
                        </div>
                    </div>
                    <!-- Left Info Map Box Ends -->
                    <!-- Right Info Map Box Starts -->
                    <div class="col-md-6 col-sm-12">
                        <div class="info-map-boxes-item fa fa-phone">
                            <h1>Contact Number &amp; Email Address</h1>
                            <p>(703) 682-6832
                                <br>(443) 817-0817
                                <br>info@cyberbahnit.com</p>
                        </div>
                    </div>
                    <!-- Right Info Map Box Ends -->
                </div>
            </div>
            <!-- Info Map Boxes Ends -->
        </section>
        <!-- Contact Section Ends -->
        <!-- Contact Form Section Starts -->
        
        <!-- Contact Form Section Ends -->
        <!-- Logos Section Starts -->
        <section class="logos">
            <div class="container">
                <ul class="bxslider" id="bxslider">
                    <!-- Logos Items Starts -->
                     <?php $__currentLoopData = $section6; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $item3): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <li><a href="<?php echo e($item3->link); ?>" target="_blank"><img id="3docean" src="<?php echo e(asset('public/storage/client/'.$item3->logo)); ?>" alt=""></a></li>
					<?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    <!-- Logos Items Ends -->
                </ul>
            </div>
        </section>
        
        <section class="newsletter">
            <div class="section-overlay">
                <!-- Container Starts -->
                <div class="container">
                    <!-- Main Heading Starts -->
                    <div class="text-center top-text">
                        <h1><span>our</span> newsletter</h1>
                        <h4>Keep in touch</h4>
                    </div>
                    <!-- Main Heading Ends -->
                    <div class="newsletter-content">
                        <p class="text-center">Sign up to our newsletter subscription and be the first to know about<br> Important news <span> & </span> Amazing offers <span> & </span>Discounts</p>
                        <!-- Newsletter Form Starts -->
                        <form class="form-inputs">
                            <!-- Newsletter Form Input Field Starts -->
                            <div class="col-md-12 form-group custom-form-group p-0">
                                <span class="input custom-input">
									<input placeholder="Enter Your Email" class="input-field custom-input-field" type="text" />
									<label class="input-label custom-input-label" >
										<i class="fa fa-envelope-open-o icon icon-field"></i>
									</label>
								</span>
                            </div>
                            <!-- Newsletter Form Input Field Ends -->
                            <!-- Newsletter Form Submit Button Starts -->
                            <button id="submit" name="submit" type="submit" class="custom-button" title="Send">Subscribe Now</button>
                            <!-- Newsletter Form Submit Button Ends -->
                        </form>
                        <!-- Newsletter Form Ends -->
                    </div>
                </div>
                <!-- Container Ends -->
            </div>
        </section>
        
        
        <!-- Logos Section Ends -->
        <!-- Footer Section Starts -->
        <footer class="footer text-center">
            <!-- Container Starts -->
            <div class="container">
                <!-- Copyright Text Starts -->
              
                <p>Copyright  &copy;<?php echo date('Y'); ?> CyberBahn - TAS. All Rights Reserved
                </p>
                <!-- Copyright Text Ends -->
                <!-- Social Media Links Starts -->
                <div class="social-icons">
                    <ul class="social">
                       
                         <?php if($common->facebooklink!=""): ?>
                        <li>
                            <a class="facebook" href="<?php echo e($common->facebooklink); ?>" title="facebook" target="_blank"></a>
                        </li>
                        <?php endif; ?>
                        
                         <?php if($common->twitterlink!=""): ?>
                         <li>
                            <a class="twitter" href="<?php echo e($common->twitterlink); ?>" title="twitter"></a>
                        </li>
                         <?php endif; ?>
                         
                        
                       <?php if($common->youtubelink!=""): ?>
                        <li>
                            <a class="youtube" href="<?php echo e($common->youtubelink); ?>" title="youtube"></a>
                        </li>
                         <?php endif; ?>
                         
                          <?php if($common->linkedinlink!=""): ?>
                        <li>
                            <a class="linkedin" href="<?php echo e($common->linkedinlink); ?>" title="linkedin"></a>
                        </li>
                        <?php endif; ?>
                        <?php if($common->slidesharelink!=""): ?>
                        <li>
                            <a class="slideshare" href="<?php echo e($common->slidesharelink); ?>" title="slideshare"></a>
                        </li>
                        <?php endif; ?>
                       <?php if($common->instagramlink!=""): ?>
                        <li>
                            <a class="instagram" href="<?php echo e($common->instagramlink); ?>" title="instagram"></a>
                        </li>
                         <?php endif; ?>
                       
                    </ul>
                </div>
                <!-- Social Media Links Ends -->
            </div>
            <!-- Container Ends -->
        </footer>
        <!-- Footer Section Starts -->
        <!-- Back To Top Starts -->
        <div id="back-top-wrapper" class="d-none d-sm-block">
            <p id="back-top">
                <a href="#top"><span></span></a>
            </p>
        </div>
        <!-- Back To Top Ends -->
    </div>
    <!-- Wrapper Ends -->

    <!-- Template JS Files -->
    <script type="text/javascript" src="<?php echo e(url('landingpage/js/jquery-2.2.4.min.js')); ?>"></script>
    <script type="text/javascript" src="<?php echo e(url('landingpage/js/plugins/jquery.easing.1.3.js')); ?>"></script>
	<script src="https://maps.googleapis.com/maps/api/js?v=3.exp&amp;key=AIzaSyAFnEvJfyoQ8unR5hK1u87h73EdYP46-hE"></script>
    <script type="text/javascript" src="<?php echo e(url('landingpage/js/plugins/bootstrap.bundle.min.js')); ?>"></script>
    <script type="text/javascript" src="<?php echo e(url('landingpage/js/plugins/jquery.bxslider.min.js')); ?>"></script>
    <script type="text/javascript" src="<?php echo e(url('landingpage/js/plugins/jquery.filterizr.js')); ?>"></script>
    <script type="text/javascript" src="<?php echo e(url('landingpage/js/plugins/jquery.magnific-popup.min.js')); ?>"></script>
    <script type="text/javascript" src="<?php echo e(url('landingpage/js/plugins/jquery.singlePageNav.min.js')); ?>"></script>

    <!-- Revolution Slider Main JS Files -->
    <script type="text/javascript" src="<?php echo e(url('landingpage/js/plugins/revolution/js/jquery.themepunch.tools.min.js')); ?>"></script>
    <script type="text/javascript" src="<?php echo e(url('landingpage/js/plugins/revolution/js/jquery.themepunch.revolution.min.js')); ?>"></script>

    <!-- Revolution Slider Extensions -->

    <script type="text/javascript" src="<?php echo e(url('landingpage/js/plugins/revolution/js/extensions/revolution.extension.actions.min.js')); ?>"></script>
    <script type="text/javascript" src="<?php echo e(url('landingpage/js/plugins/revolution/js/extensions/revolution.extension.carousel.min.js')); ?>"></script>
    <script type="text/javascript" src="<?php echo e(url('landingpage/js/plugins/revolution/js/extensions/revolution.extension.kenburn.min.js')); ?>"></script>
    <script type="text/javascript" src="<?php echo e(url('landingpage/js/plugins/revolution/js/extensions/revolution.extension.layeranimation.min.js')); ?>"></script>
    <script type="text/javascript" src="<?php echo e(url('landingpage/js/plugins/revolution/js/extensions/revolution.extension.migration.min.js')); ?>"></script>
    <script type="text/javascript" src="<?php echo e(url('landingpage/js/plugins/revolution/js/extensions/revolution.extension.navigation.min.js')); ?>"></script>
    <script type="text/javascript" src="<?php echo e(url('landingpage/js/plugins/revolution/js/extensions/revolution.extension.parallax.min.js')); ?>"></script>
    <script type="text/javascript" src="<?php echo e(url('landingpage/js/plugins/revolution/js/extensions/revolution.extension.slideanims.min.js')); ?>"></script>
    <script type="text/javascript" src="<?php echo e(url('landingpage/js/plugins/revolution/js/extensions/revolution.extension.video.min.js')); ?>"></script>

    <!-- Live Style Switcher JS File - only demo -->
    <script type="text/javascript" src="<?php echo e(url('landingpage/js/styleswitcher.js')); ?>"></script>

    <!-- Main JS Initialization File -->
    <script type="text/javascript" src="<?php echo e(url('landingpage/js/custom.js')); ?>"></script>

    <!-- Revolution Slider Initialization Starts -->
    <script>
        (function() {
            "use strict";
			// REVOLUTION SLIDER
            var tpj = jQuery;
            var revapi4;
            tpj(document).ready(function() {
                if (tpj("#rev_slider").revolution == undefined) {
                    revslider_showDoubleJqueryError("#rev_slider");
                } else {
                    revapi4 = tpj("#rev_slider").show().revolution({
                        sliderType: "standard",
                        jsFileLocation: "js/plugins/revolution/js/",
                        dottedOverlay: "none",
                        sliderLayout: "fullscreen",
                        delay: 9000,
                        navigation: {
                            keyboardNavigation: "off",
                            keyboard_direction: "horizontal",
                            mouseScrollNavigation: "off",
                            onHoverStop: "off",
                            touch: {
                                touchenabled: "on",
                                swipe_threshold: 75,
                                swipe_min_touches: 1,
                                swipe_direction: "horizontal",
                                drag_block_vertical: false
                            },
                            arrows: {
                                style: "zeus",
                                enable: true,
                                hide_onmobile: true,
                                hide_under: 600,
                                hide_onleave: true,
                                hide_delay: 200,
                                hide_delay_mobile: 1200,
                                tmp: '<div class="tp-title-wrap">  	<div class="tp-arr-imgholder"></div> </div>',
                                left: {
                                    h_align: "left",
                                    v_align: "center",
                                    h_offset: 90,
                                    v_offset: 0
                                },
                                right: {
                                    h_align: "right",
                                    v_align: "center",
                                    h_offset: 90,
                                    v_offset: 0
                                }
                            },
                            bullets: {
                                enable: false,
                                hide_onmobile: true,
                                hide_under: 600,
                                style: "metis",
                                hide_onleave: true,
                                hide_delay: 200,
                                hide_delay_mobile: 1200,
                                direction: "horizontal",
                                h_align: "center",
                                v_align: "bottom",
                                h_offset: 0,
                                v_offset: 30,
                                space: 5,
                                tmp: '<span class="tp-bullet-img-wrap">  <span class="tp-bullet-image"></span></span>'
                            }
                        },
                        viewPort: {
                            enable: true,
                            outof: "pause",
                            visible_area: "80%"
                        },
                        responsiveLevels: [1240, 1024, 778, 480],
                        gridwidth: [1240, 1024, 778, 480],
                        gridheight: [600, 600, 500, 400],
                        lazyType: "none",
                        parallax: {
                            type: "mouse",
                            origo: "slidercenter",
                            speed: 2000,
                            levels: [2, 3, 4, 5, 6, 7, 12, 16, 10, 50],
                        },
                        shadow: 0,
                        spinner: "off",
                        stopLoop: "off",
                        stopAfterLoops: -1,
                        stopAtSlide: -1,
                        shuffle: "off",
                        hideThumbsOnMobile: "off",
                        autoHeight: "off",
                        hideSliderAtLimit: 0,
                        hideCaptionAtLimit: 0,
                        hideAllCaptionAtLilmit: 0,
                        debugMode: false,
                        fallbacks: {
                            simplifyAll: "off",
                            nextSlideOnWindowFocus: "off",
                            disableFocusListener: false,
                        }
                    });
                }
            });
			
			// GOOGLE MAP
			
			
        })(jQuery);
    </script>
    <!-- Revolution Slider Initialization Ends -->
</body>
</html>


<div id="downloadform" class="modal fade" role="dialog">
  <div class="modal-dialog">
    <!-- Modal content-->
    <div class="modal-content" style="background-color:#c1c1c1">
      <div class="modal-header">
        <h4 class="modal-title">Download Brochure</h4>
      </div>
      <div class="modal-body">
     
      <div class="form-container">
                        <!-- Contact Form Starts -->
                        <form class="formcontact" name="downloadbroucherform" id="downloadbroucherform" method="post" action=""><?php echo e(csrf_field()); ?>

                        <input type="text" name="courseid" id="courseid" value="<?php echo e($each_course_details->id); ?>" style="display:none">
                            <div class="row form-inputs">
                                <!-- First Name Field Starts -->
                                <div class="col-md-6 form-group custom-form-group">
                                    <span class="input custom-input">
										<input placeholder="First Name" class="input-field custom-input-field" id="firstname" name="firstname" type="text" required data-error="NEW ERROR MESSAGE">
										<label class="input-label custom-input-label" >
											<i class="fa fa-user icon icon-field"></i>
										</label>
									</span>
                                </div>
                                <!-- First Name Field Ends -->
                                <!-- Last Name Field Starts -->
                                <div class="col-md-6 form-group custom-form-group">
                                    <span class="input custom-input">
										<input placeholder="Last Name" class="input-field custom-input-field" id="lastname" name="lastname" type="text" required>
										<label class="input-label custom-input-label" >
											<i class="fa fa-user-o icon icon-field"></i>
										</label>
									</span>
                                </div>
                                <!-- Last Name Field Ends -->
                                <div class="col-md-12 form-group custom-form-group">
                                    <span class="input custom-input">
										<input placeholder="Phone" class="input-field custom-input-field" id="mobilenumber" name="mobilenumber" type="text" required data-error="NEW ERROR MESSAGE" maxlength="20">
										<label class="input-label custom-input-label" >
											<i class="fa fa-phone icon icon-field"></i>
										</label>
									</span>
                                </div>
                                <!-- Message Field Starts -->
                                <div class="form-group custom-form-group col-md-12">
                                    <textarea placeholder="Message" id="message" name="message" cols="45" rows="7" required></textarea>
                                </div>
                                <!-- Message Field Ends -->
                                <!-- Email Name Field Starts -->
                                <div class="col-md-6 form-group custom-form-group">
                                    <span class="input custom-input">
										<input placeholder="Email" class="input-field custom-input-field" id="email" name="email" type="email" required>
										<label class="input-label custom-input-label" >
											<i class="fa fa-envelope icon icon-field"></i>
										</label>
									</span>
                                </div>
                                <!-- Email Name Field Ends -->
                                <!-- Submit Button Starts -->
                                <div class="col-md-6 submit-form">
                                    <button name="downloadbroucher" id="downloadbroucher" type="submit" class="custom-button" title="Send">Send Message</button>
                                </div>
                                <!-- Submit Button Ends -->
                                <!-- Form Submit Message Starts -->
                                <div class="col-sm-12 text-center output_message_holder d-none">
                                    <p class="output_message_pdf" style="color:#FFFFFF"></p>
                                </div>
                                <!-- Form Submit Message Ends -->
                            </div>
                        </form>
                        <!-- Contact Form Ends -->
                    </div>
      </div>
      <div class="modal-footer">
        <button type="button" class="custom-button" data-dismiss="modal">CLOSE</button>
      </div>
    </div>
  </div>
</div>
<?php /**PATH /home/bwjqfxmy/public_html/shopcbdbrands/resources/views/landingpage/newcyberbahnlandingdetails.blade.php ENDPATH**/ ?>