<?php $__env->startSection('breadcrum'); ?>
<section class="content-header">
  <div class="container-fluid">
    <div class="row mb-2">
      <div class="col-sm-6">
        <h1>Landing Course List</h1>
      </div>
      <div class="col-sm-6">
        <ol class="breadcrumb float-sm-right">
          <li class="breadcrumb-item"><a href="<?php echo e(route('admin.dashboard')); ?>">Home</a></li>
          <li class="breadcrumb-item active">Landing Course List</li>
        </ol>
      </div>
    </div>
  </div>
  <!-- /.container-fluid -->
</section>



<?php $__env->stopSection(); ?>





<?php $__env->startSection('content'); ?>

<section class="content">
<div style="float:none; width:100%; text-align:right; position absolute; right:0;" class="btn-block">
    <a href="<?php echo e(route('landcourse-add')); ?>?cid=<?php echo e($querystring['cid']); ?>&page=<?php echo e($recordList->currentPage()); ?>" style="width:100px;" class="btn  bg-gradient-primary btn-sm">+ Add</a>
    
  </div>
  <br>
  <!-- Default box -->
  <div class="card">
    
    <div class="card-body p-0">
      <table class="table table-striped projects" id="listTable">
        <thead>
          <tr>
            <th style="width: 3%"> S.No </th>
            <th style="width: 45%"> Title </th>
            <th style="width: 120px;"> Training </th>
            <th style="width: 30%" class="text-center"> Status </th>
          </tr>
        </thead>
        <tbody>
         
          <?php ( $cnt = ((($recordList->currentPage()-1) * $recordList->perPage()) + 1)); ?>
          <?php if(!$recordList->isEmpty()): ?>
            <?php $__currentLoopData = $recordList; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $row): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
              <tr id="currentRow_<?php echo e($row->id); ?>" class="resultRow">
                <td> <?php echo e($cnt++); ?></td>
                <td><a href="<?php echo e(route('landcourse-list')); ?>?cid=<?php echo e($row->id); ?>"> <?php echo e(ucfirst($row->title)); ?></a><br />
                link to check: <br />
                <a href='<?php echo e(url('mycourses')); ?>/<?php echo e($row->slug); ?>' target="_blank"><?php echo e(url('mycourses')); ?>/<?php echo e($row->slug); ?></a>
                </td>
                <td><a class="btn btn-small btn-primary" href="<?php echo e(route('landtraining-list')); ?>?cid=<?php echo e($row->id); ?>">+ Add (<?php if(isset($training_assoc[$row->id])): ?><?php echo e($training_assoc[$row->id]); ?><?php else: ?> 0 <?php endif; ?>)</a></td>
                <td class="text-center"><!--<span class="badge badge-success">Success</span>-->
                  <?php if($row->status==2): ?>
                  <a  class="btn btn-success btn-sm changeStatus" href="#" title="Click to disable"> <i class="fa fa-check"> </i> </a> 
                  <?php elseif($row->status==1): ?>
                  <a  class="btn btn-danger btn-sm changeStatus" href="#" title="Click to enable">&nbsp;<i class="fa fa-times"> </i>&nbsp;</a> 
                  <?php endif; ?>
                  <a class="btn btn-primary btn-sm" href="<?php echo e(route('landcourse-view',$row->id)); ?>?page=<?php echo e($recordList->currentPage()); ?>" title="View"> <i class="fas fa-eye"> </i> </a> 
                  <a class="btn btn-info btn-sm" href="<?php echo e(route('landcourse-edit',$row->id)); ?>?page=<?php echo e($recordList->currentPage()); ?>" title="Edit"> <i class="fas fa-pencil-alt"> </i> </a> 
                  <a  data-id="<?php echo e($row->id); ?>"  class="btn btn-danger btn-sm deleteRow" href="#" title="Delete"> <i class="fas fa-trash"> </i>  </a> </td>
              </tr> 
            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
          <?php else: ?>
          <tr>
            <td colspan='5' style="text-align:center">No Records Found</td>
          </tr>
          <?php endif; ?>



        </tbody>
      </table>

      <div style="width:auto; padding:10px;float:right; text-align:right; margin-0px auto;">
          <?php echo $recordList->appends(request()->except('page'))->render(); ?>

      </div>
      
    </div>
    <!-- /.card-body -->
  </div>
  <!-- /.card -->
</section>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('script'); ?>
    <script>
        $(document).ready(function() {

          $('table').on('click', '.changeStatus', function(e){
            e.preventDefault();
            $chId = $(this).data('id');
            $chTyp = $(this).data('typ');
            if($chTyp==1)
            {
              $cnfrmMsg = "Are you sure to Disable this record.";
              $removeClass = "btn-success";
              $addClass = "btn-danger";
              $changeicon = '&nbsp;<i class="fa fa-times"> </i>&nbsp;';
              $tochTyp=2;

            }else if($chTyp==2)
            {
              $cnfrmMsg = "Are you sure to Enable this record.";
              $removeClass = "btn-danger";
              $addClass = "btn-success";
              $changeicon = '<i class="fa fa-check"> </i>';
              $tochTyp=1;
            }

            var k = confirm($cnfrmMsg);

            if(k==true)
            {
              $.ajax({
                url : "<?php echo e(route('landcourse-statuschange')); ?>",
                method: "PUT",
                data : { chid : $chId, chtyp : $chTyp, _token: '<?php echo e(csrf_token()); ?>' },
                error: function(data){
                  toastr.error("Error Occured. Please Try Again Later.");
                },
                success : function(result){
                  result = JSON.stringify(result)
                  result = JSON.parse(result);
                  if(result.status==200)
                  {
                    toastr.success("Status Updated Successfully");
                    $('#statuschange_'+$chId).removeClass($removeClass).addClass($addClass);
                    $('#statuschange_'+$chId).html($changeicon);
                    $('#statuschange_'+$chId).data('typ',$tochTyp);

                  }else{
                    toastr.error("Error Occured. Please Try Again Later.");
                  }
                }
                
              });
            }

          });


 $('table').on('click', '.deleteRow', function(e){
            e.preventDefault();
            $chId = $(this).data('id');

            var k = confirm("Are you sure to Delete this record.");

            if(k==true)
            {
              $.ajax({
                url : "landcourse/"+ $chId ,
                method: "DELETE",
                data : { _token: '<?php echo e(csrf_token()); ?>' },
                error: function(data){
                  toastr.error("Error Occured. Please Try Again Later.");
                },
                success : function(result){
                  result = JSON.stringify(result)
                  result = JSON.parse(result);
                  if(result.status==200)
                  {
                    toastr.success("Deleted Successfully");
                    $('#currentRow_'+$chId).remove();
                    $rowlength = $('#listTable tbody tr').length;
                    
                    if($rowlength == '0')
                    {
                      $('#listTable tbody').html('<tr><td colspan="5" style="text-align:center">No Records Found</td></tr>');
                    }

                  }else{
                    toastr.error("Error Occured. Please Try Again Later.");
                  }
                }
                
              });
            }

          });

        });
    </script>
<?php $__env->stopSection(); ?>
<?php echo $__env->make('back.layout.master', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/bwjqfxmy/public_html/shopcbdbrands/resources/views/back/landpage/course_list.blade.php ENDPATH**/ ?>