<?php $__env->startSection('breadcrum'); ?>
<section class="content-header">
  <div class="container-fluid">
    <div class="row mb-2">
      <div class="col-sm-6">
        <h1>Registrations for <?php echo e($eventList[0]->event_title); ?> - <?php echo e($eventList[0]->category_name); ?></h1>
      </div>
      <div class="col-sm-6">
        <ol class="breadcrumb float-sm-right">
          <li class="breadcrumb-item"><a href="<?php echo e(route('admin.dashboard')); ?>">Home</a></li>
          <li class="breadcrumb-item active">Registrations</li>
        </ol>
      </div>
    </div>
  </div>
  <!-- /.container-fluid -->
</section>




<?php $__env->stopSection(); ?>

<?php $__env->startSection('content'); ?>
<section class="content">
  <div style="float:none; width:100%; text-align:right; position absolute; right:0;" class="btn-block"> <a href="<?php echo e(route('event-list')); ?>" style="width:100px;" class="btn  bg-gradient-primary btn-sm"><< Back </a></div>
  <br>
  <!-- Default box -->
  <div class="card">
    <div class="card-body pt-4 table-responsive">
      <table class="table table-striped projects" id="rlistTable">
        <thead>
          <tr>
            <th style="width: 3%"> S.No </th>
            <th>Name</th>
            <th style="width: 10%"> Email </th>
            <th style="width: 10%"> Date </th>
            <th style="width: 10%"> Ticket Name </th>
            <th style="width: 10%"> Price </th>
            <th style="width: 10%"> No.of Tickets </th>
            <th style="width: 10%"> Total Amount</th>
            <th style="width: 10%"> Payment Reference</th>
            <th style="width: 10%"> Payment Status </th>
            <th style="width: 30%"> Invoice </th>
          </tr>
        </thead>
        <tbody>
        
        <?php ( $cnt = ((($regList->currentPage()-1) * $regList->perPage()) + 1)); ?>

        
        <?php if(!$regList->isEmpty()): ?>
        <?php $__currentLoopData = $regList; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $row): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
        <tr id="currentRow_<?php echo e($row->id); ?>" class="resultRow">
          <td> <?php echo e($cnt++); ?></td>
          <td><a> <?php echo e(ucfirst($row->firstname)); ?> <?php echo e(ucfirst($row->lastname)); ?></a></td>
          <td><?php echo e($row->email); ?></td>
          <td> <?php echo e(date('m/d/Y', strtotime($row->created_at))); ?></td>
          <td> <?php echo e($row->ticketname); ?></td>
          <td><?php echo e($row->price); ?></td>
          <td><?php echo e($row->ticketquantity); ?></td>
          <td><?php echo e($row->totalamount); ?></td>
          <td><?php echo e($row->payment_reference); ?></td>
          <td><?php echo e($row->payment_status); ?></td>
          <td><a id="viewinvoice1" class="btn btn-success btn-sm" href="<?php echo e(route('invoice_download',['filename'=>$row->invoice_filename])); ?>" title="Click to download invoice"> <i class="fa fa-download"> </i> </a> <a data-id="<?php echo e($row->invoice_filename); ?>" data-typ="<?php echo e($row->email); ?>" data-hyp="<?php echo e(ucfirst($row->firstname)); ?> <?php echo e(ucfirst($row->lastname)); ?>" id="emailinvoice" class="btn btn-success btn-sm" href="#" title="Click to email invoice"> <i class="fa fa-envelope"> </i> </a> </td>
        </tr>
        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
        <?php else: ?>
        <tr>
          <td colspan='11' style="text-align:center">No Records Found</td>
        </tr>
        <?php endif; ?>
        </tbody>
        
      </table>
      <div style="width:auto; padding:10px;float:right; text-align:right; margin:0px auto;"> <?php echo $regList->appends(request()->except('page'))->render(); ?> </div>
    </div>
    <!-- /.card-body -->
  </div>
  <!-- /.card -->
</section>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('style'); ?>
<link rel="stylesheet" href="<?php echo e(asset('public/front/plugins/datatables-bs4/css/dataTables.bootstrap4.css')); ?>">
<link rel="stylesheet" href="<?php echo e(asset('public/back/css/custom.css')); ?>">
<?php $__env->stopSection(); ?>



<?php $__env->startSection('script'); ?>
<script src="<?php echo e(asset('public/back/plugins/datatables/jquery.dataTables.js')); ?>"></script>
<script src="<?php echo e(asset('public/back/plugins/datatables-bs4/js/dataTables.bootstrap4.js')); ?>"></script>
<script src="https://cdn.datatables.net/buttons/1.6.1/js/dataTables.buttons.min.js"></script>
<script src="https://cdn.datatables.net/buttons/1.6.1/js/buttons.flash.min.js"></script>
<script src="https://cdnjs.cloudflare.com/ajax/libs/jszip/3.1.3/jszip.min.js"></script>
<script src="https://cdnjs.cloudflare.com/ajax/libs/pdfmake/0.1.53/pdfmake.min.js"></script>
<script src="https://cdnjs.cloudflare.com/ajax/libs/pdfmake/0.1.53/vfs_fonts.js"></script>
<script src="https://cdn.datatables.net/buttons/1.6.1/js/buttons.html5.min.js"></script>
<script src="https://cdn.datatables.net/buttons/1.6.1/js/buttons.print.min.js"></script>
<script>
        $(document).ready(function() {
    $('#rlistTable').DataTable({
      "paging": true,
      "lengthChange": false,
      "searching": true,
      "ordering": true,
      "info": true,
      "autoWidth": false,
              dom: 'Bfrtip',
        buttons: [
       // 'copy',
        // {
        //         extend: 'csv',
        //         messageTop: 'Registrations for <?php echo e($eventList[0]->event_title); ?> - <?php echo e($eventList[0]->category_name); ?>'
        //     },
            {
                extend: 'excel',
                messageTop: 'Registrations for <?php echo e($eventList[0]->event_title); ?> - <?php echo e($eventList[0]->category_name); ?>',
                title:'CyberBahn - TAS',
                className:'btn  bg-gradient-primary btn-sm'
            },
            {
                extend: 'pdf',
                messageTop: 'Registrations for <?php echo e($eventList[0]->event_title); ?> - <?php echo e($eventList[0]->category_name); ?>',
                title:'CyberBahn - TAS',
                className:'btn  bg-gradient-primary btn-sm'

            },
            // {
            //     extend: 'print',
            //     messageTop: 'Registrations for <?php echo e($eventList[0]->event_title); ?> - <?php echo e($eventList[0]->category_name); ?>',
            //     title:'CyberBahn - TAS',
            //    className:'btn  bg-gradient-primary btn-sm'
            // },
            
           
        ]

    });



$('table').on('click', '#emailinvoice', function(e){
            e.preventDefault();
            var invoice_filename = $(this).data('id');
            var email = $(this).data('typ');
            var name=$(this).data('hyp'); 
             $.ajax({
                url : "<?php echo e(route('invoice_email')); ?>",
                method: "POST",
                data : { filename:invoice_filename,email:email,name:name, _token: '<?php echo e(csrf_token()); ?>' },
                error: function(data){
                  toastr.error("Error Occured. Please Try Again Later.");
                },
                success : function(result){
                  result = JSON.stringify(result)
                  result = JSON.parse(result);
                  if(result.status==1)
                  {
                    toastr.success("Email Sent Successfully");
                  }else{
                    toastr.error("Error Occured. Please Try Again Later.");
                  }
                }
                
              });            

          });


        });
    </script>
<?php $__env->stopSection(); ?>
<?php echo $__env->make('back.layout.master', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/bwjqfxmy/public_html/shopcbdbrands/resources/views/back/registrations/registrations-list.blade.php ENDPATH**/ ?>