<?php
namespace App\Http\Controllers\Admin;

use App\Http\Controllers\Admin\ACommonController;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Facades\Session;

class PaymentManagementController extends ACommonController
{

    public function index(Request $request)
    {

        // Save filters to session if present in the request
        if ($request->hasAny(['from_date', 'to_date', 'driver_name', 'status1'])) {
            Session::put('payment_filter.from_date', $request->from_date);
            Session::put('payment_filter.to_date', $request->to_date);
            Session::put('payment_filter.driver_name', $request->driver_name);
            Session::put('payment_filter.status1', $request->status1);
        }

        // Load filter values from session (or set defaults)
        $from_date  = Session::get('payment_filter.from_date', '');
        $to_date    = Session::get('payment_filter.to_date', '');
        $drivername = Session::get('payment_filter.driver_name', '');
        $status     = Session::get('payment_filter.status1', 'all');

        $dataQuery1 = DB::table('trips')
            ->join('driver_management', 'trips.driver_id', '=', 'driver_management.id');

        // Apply status filter
        if ($status !== 'all') {
            if ($status === 'unpaid') {
                $dataQuery1->where('trips.payment_status', 0);
            } elseif ($status === 'partially_paid') {
                $dataQuery1->where('trips.payment_status', 1);
            } elseif ($status === 'paid') {
                $dataQuery1->where('trips.payment_status', 2);
            }
        }

        // Apply date filters
        if (! empty($from_date)) {
            $dataQuery1->whereDate('trips.trip_date', '>=', $from_date);
        }

        if (! empty($to_date)) {
            $dataQuery1->whereDate('trips.trip_date', '<=', $to_date);
        }

        // Apply driver name filter
        if (! empty($drivername)) {
            $dataQuery1->where('driver_management.driver_name', 'like', '%' . $drivername . '%');

            $dataQuery1->orWhere('driver_management.driver_code', 'like', '%' . $drivername . '%');
        }

        // Fetch the filtered data
        $datas = $dataQuery1->select(
            'driver_management.driver_name',
            'driver_management.driver_code',
            'trips.amount',
            'trips.commission_amount',
            'trips.paid_amount',
            'trips.pending_amount',
            'trips.payment_status',
            'trips.paid_at'
        )
            ->orderBy('trips.payment_status', 'asc')
            ->orderBy('trips.updated_at', 'asc')
            ->get();

        return view('admin.payment_management.list', compact('datas', 'from_date', 'to_date', 'drivername', 'status'));
    }

    public function approvalwaiting(Request $request)
    {
        $status = $request->input('status1', 'all');

        $dataQuery1 = DB::table('trip_payment_details')
            ->join('trips', 'trip_payment_details.trip_id', '=', 'trips.id')
            ->join('driver_management', 'trips.driver_id', '=', 'driver_management.id');

        if ($status == 'pending') {
            $dataQuery1->where('trip_payment_details.pay_status', 0);
        } elseif ($status == 'approved') {
            $dataQuery1->where('trip_payment_details.pay_status', 2);
        } elseif ($status == 'rejected') {
            $dataQuery1->where('trip_payment_details.pay_status', 3);

        }

        $datas = $dataQuery1->select(
            'trip_payment_details.id',
            'driver_management.driver_name',
            'driver_management.driver_code',
            'trip_payment_details.req_amount',
            'trip_payment_details.paid_amount',
            'trip_payment_details.payment_receipt',
            'trips.pending_amount',
            'trip_payment_details.pay_status'
        )
            ->orderBy('trip_payment_details.pay_status', 'asc')
            ->orderBy('trip_payment_details.created_at', 'asc')
            ->get();

        return view('admin.payment_management.approval_waiting', compact('datas'));
    }

    public function updatePayStatus(Request $request)
    {
        $id         = $request->input('id');
        $status     = $request->input('status'); // 2 for approved, 3 for rejected
        $tripDetail = DB::table('trip_payment_details')->where('id', $id)->where('pay_status', 2)->first();
        if (! $tripDetail) {
            return response()->json([
                'success' => false,
                'message' => 'No record found',
            ]);
        }
        $updated = DB::table('trip_payment_details')
            ->where('id', $id)
            ->where('pay_status', 2)
            ->update(['pay_status' => $status]);
        if ($updated) {

            $this->calculatetrippayment($tripDetail->trip_id);
            return response()->json([
                'success' => true,
                'message' => 'Status updated successfully',
            ]);

        } else {
            return response()->json([
                'success' => false,
                'message' => 'No rows affected',
            ]);
        }

    }
    public function calculatetrippayment($tripId)
    {
        // 1. Get sum of payments for this trip
        $sumAmount = DB::table('trip_payment_details')
            ->where('trip_id', $tripId)
            ->where('pay_status', 2)
            ->sum('paid_amount');

        // 2. Get commission amount for this trip
        $trip = DB::table('trips')->where('id', $tripId)->first();

        if (! $trip) {
            // return response()->json(['success' => false, 'message' => 'Trip not found']);
            return 0;
        }
        $pending_amount = $trip->pending_amount;
        $commission     = $trip->commission_amount;
        $paymentStatus  = 'unpaid';

        // 3. Determine payment status
        if ($sumAmount >= $commission) {
            $pending_amount = 0;
            $paymentStatus  = '2';
        } elseif ($sumAmount == 0) {
            $pending_amount = $commission;
            $paymentStatus  = '0';
        } elseif ($sumAmount < $commission) {
            $pending_amount = $commission - $sumAmount;
            $paymentStatus  = '1';
        }

        // 4. Update trip payment status
        DB::table('trips')->where('id', $tripId)->update([
            'payment_status' => $paymentStatus,
            'paid_amount'    => $sumAmount,
            'paid_at'        => now(),
            'pending_amount' => $pending_amount,

        ]);

        return response()->json([
            'success'        => true,
            'message'        => 'Payment status updated successfully',
            'total_paid'     => $sumAmount,
            'payment_status' => $paymentStatus,
        ]);
    }

}
