<?php
namespace App\Http\Controllers\Admin;

use App\Http\Controllers\Admin\ACommonController;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\DB;

class ReportManagementController extends ACommonController
{

    public function DriverReport(Request $request)
    {
        $query = DB::table('booking_management')
            ->join('driver_management', 'booking_management.driver_id', '=', 'driver_management.id')
            ->where('booking_management.trip_status', 0)
            ->select(
                'booking_management.id as booking_id',
                'booking_management.driver_id',
                'driver_management.driver_name',
                'booking_management.booking_date'
            );

        if ($request->from_date && $request->to_date) {
            $query->whereBetween('booking_date', [$request->from_date, $request->to_date]);
        }

        $bookings = $query->get();

        $driverReports = $bookings->groupBy('driver_id')->map(function ($trips, $driverId) {
            $bookingIds = $trips->pluck('booking_id');

            $totalAmount = DB::table('fare_summaries')
                ->whereIn('booking_id', $bookingIds)
                ->sum('total_price');

            // dd($totalAmount);

            return [
                'driver_id'    => $driverId,
                'driver_name'  => $trips->first()->driver_name,
                'trip_count'   => $trips->count(),
                'total_amount' => $totalAmount,
            ];
        });

        return view('admin.report_management.driver_report', compact('driverReports'));
    }

    public function CustomerReport(Request $request)
    {
        $query = DB::table('booking_management')
            ->where('trip_status', 0)
            ->whereNotNull('phone')
            ->select(
                'id as booking_id',
                'customer_name',
                'phone',
                'booking_date'
            );

        if ($request->from_date && $request->to_date) {
            $query->whereBetween('booking_date', [$request->from_date, $request->to_date]);
        }

        $bookings = $query->get();

        $customerReports = $bookings->groupBy('phone')->map(function ($trips, $phone) {
            $bookingIds = $trips->pluck('booking_id');

            $totalAmount = DB::table('fare_summaries')
                ->whereIn('booking_id', $bookingIds)
                ->sum('total_price');

            return [
                'customer_name' => $trips->first()->customer_name,
                'phone'         => $phone,
                'trip_count'    => $trips->count(),
                'total_amount'  => $totalAmount,
            ];
        });

        return view('admin.report_management.customer_report', compact('customerReports'));
    }

}
