<?php
namespace App\Http\Controllers\Admin;

use App\Http\Controllers\Admin\ACommonController;
use Google\Auth\Credentials\ServiceAccountCredentials;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Facades\Http;
use Illuminate\Support\Facades\Log;

class TestController extends ACommonController
{

    // public function test()
    // {

    //     // $message = "Hi John! Your OTP is 1234 & your code is @#2025";
    //     // $x       = $this->sendWelcomeSms('9790397339', 'text', $message);
    //     // dd($x);

    //     $RideDetails = BookingManagement::where('driver_id', 5)
    //         ->where('booking_status', 4)
    //         ->whereDate('booking_dateTime', Carbon::today())
    //         ->count();

    //     $credentialsPath = storage_path('app/public/firebase/service-account.json');

    //     $scopes = ['https://www.googleapis.com/auth/firebase.messaging'];

    //     $credentials = new ServiceAccountCredentials($scopes, $credentialsPath);

    //     $accessTokenData = $credentials->fetchAuthToken();

    //     if (! isset($accessTokenData['access_token'])) {
    //         return response()->json([
    //             'success'  => false,
    //             'message'  => 'Failed to retrieve access token',
    //             'response' => $accessTokenData,
    //         ], 500);
    //     }

    //     $accessToken = $accessTokenData['access_token'];

    //     $projectId = json_decode(file_get_contents($credentialsPath), true)['project_id'];

    //     $payload = [
    //         'message' => [
    //             'token'        => 'DB0ED72F-5798-4594-9130-1115A9386AC2', // Replace with real device token
    //             'notification' => [
    //                 'title' => 'Hello from Firebase',
    //                 'body'  => 'FCM v1 API working!',
    //             ],
    //         ],
    //     ];

    //     $response = Http::withToken($accessToken)
    //         ->post("https://fcm.googleapis.com/v1/projects/{$projectId}/messages:send", $payload);

    //     return response()->json([
    //         'success'  => $response->successful(),
    //         'message'  => $response->successful() ? 'Notification sent' : 'Failed to send notification',
    //         'response' => $response->json(),
    //     ]);
    // }

    public function test1()
    {
        $credentialsPath = storage_path('app/public/firebase/service-account.json'); // Path to your key file

        $credentials = new ServiceAccountCredentials(
            'https://www.googleapis.com/auth/firebase.messaging',
            json_decode(file_get_contents($credentialsPath), true)
        );

        $accessToken = $credentials->fetchAuthToken()['access_token'];

        $projectId = 'vaigaitaxi';

        $payload = [
            'message' => [
                'token'        => 'YOUR_DEVICE_TOKEN',
                'notification' => [
                    'title' => 'Hello from HTTP v1',
                    'body'  => 'This is using OAuth2 access token',
                ],
            ],
        ];

        $response = Http::withToken($accessToken)
            ->post("https://fcm.googleapis.com/v1/projects/{$projectId}/messages:send", $payload);

        return $response->json();

    }

    public function test2()
    {

        // Example Firebase token (replace with a real token from your device)
        $firebaseToken = 'DB0ED72F-5798-4594-9130-1115A9386AC2';

        $payload = [
            'to'           => $firebaseToken,
            'notification' => [
                'title' => 'Test Notification',
                'body'  => 'This is a test push notification from Laravel using Firebase',
                'sound' => 'default',
            ],
            'data'         => [
                'custom_key' => 'custom_value',
                'screen'     => 'test_screen',
            ],
        ];

        $response = Http::withHeaders([
            'Authorization' => 'key=' . config('services.fcm.server_key'),
            'Content-Type'  => 'application/json',
        ])->post('https://fcm.googleapis.com/fcm/send', $payload);

        if ($response->successful()) {
            return response()->json([
                'success'  => true,
                'message'  => 'Notification sent successfully',
                'response' => $response->json(),
            ]);
        } else {
            Log::error('FCM Push Failed', [
                'token'    => $firebaseToken,
                'response' => $response->body(),
            ]);

            return response()->json([
                'success'  => false,
                'message'  => 'Failed to send notification',
                'response' => $response->body(),
            ], 500);
        }
    }

    public function test3()
    {

        // $expoPushToken = 'ExponentPushToken[E4SNToLIke2OV1H6Jd6gt5]';

        $expoPushToken = 'ExponentPushToken[uyu7HkAzRLG83qysfH3Ier]';

        // $response = Http::post('https://exp.host/--/api/v2/push/send', [
        //     'to'    => $expoPushToken,
        //     'sound' => 'default',
        //     'title' => 'Test Notification from Laravel',
        //     'body'  => 'This is a test notification sent by ExpoPushTestController',
        //     // 'data'  => ['extraData' => 'Some extra data'],
        //     'data'  => [
        //         'customSound' => 'alert-33762.mp3',
        //     ],
        // ]);
        $response = Http::withHeaders([
            'Accept'       => 'application/json',
            'Content-Type' => 'application/json',
        ])->post('https://exp.host/--/api/v2/push/send', [
            'to'    => $expoPushToken,
            'sound' => 'default',
            'title' => 'Test Notification from Laravel',
            'body'  => 'This is a test notification sent by ExpoPushTestController',
            'data'  => [
                'customSound' => 'alert-33762.mp3',
            ],
        ]);

        if ($response->successful()) {
            return response()->json([
                'status'   => 'success',
                'message'  => 'Notification sent',
                'response' => $response->json(),
            ]);
        }

        return response()->json([
            'status'   => 'error',
            'message'  => 'Failed to send notification',
            'response' => $response->json(),
        ], 500);
    }

    public function test4()
    {
        $bookingId = 10;

        $booking = DB::table('booking_management')
            ->select('id', 'cartype_id', 'ac_type', 'traveltype_id', 'package_id', 'estimated_km')
            ->where('id', $bookingId)
            ->first();

        if (! $booking) {
            throw new \Exception('Booking not found for amount estimation');
        }

        $selectedPackage = DB::table('packages as p')
            ->join('outstation_package as op', function ($join) use ($booking) {
                $join->on('p.id', '=', 'op.package_id')
                    ->where('op.cartype_id', $booking->cartype_id)
                    ->where('op.inout_type', $booking->traveltype_id);
            })
            ->where('p.traveltype_id', $booking->traveltype_id)
            ->where('p.city_id', 0)
            ->where('p.km', '<=', $booking->estimated_km)
            ->orderBy('p.km', 'desc')
            ->select('p.id as package_id', 'p.km as included_km', 'op.ac_price', 'op.nonac_price')
            ->first();

        if (! $selectedPackage) {
            throw new \Exception('No matching package found for estimation.');
        }

        $rate = $booking->ac_type === 'AC' ? $selectedPackage->ac_price : $selectedPackage->nonac_price;

        $includedKm = $selectedPackage->included_km;
        $extraKm    = max(0, $booking->estimated_km - $includedKm);

        $baseFare  = $rate * $includedKm;
        $extraFare = $rate * $extraKm;
        $totalCost = $baseFare + $extraFare;

        // ✅ Update booking record
        DB::table('booking_management')
            ->where('id', $bookingId)
            ->update([
                'estimated_packageid' => $selectedPackage->package_id,
                'estimated_amount'    => $totalCost,
                'updated_at'          => now(),
            ]);

        return response()->json([
            'status'   => 'success',
            'message'  => 'Estimated amount updated',
            'response' => $totalCost,
        ], 200);
    }

    public function test()
    {
        $setting = DB::table('settings')->where('id', 1)->first();
        // $bookingId = $request->booking_id;
        $data = [
            'cartype_id'    => 2,
            'traveltype_id' => 1,
            'ac_type'       => 'AC',

        ];
        $bookingId  = 3;
        $actualKm   = 20;
        $actualTime = 1;
        $local_type = 1;
        if ($bookingId > 0) {
            $otpRecord = DB::table('otp_codes')
                ->where('booking_id', $bookingId)
                ->select('start_km', 'end_km', 'booking_id', 'start_date', 'end_date')
                ->first();

            if ($otpRecord && $otpRecord->start_km !== null && $otpRecord->end_km !== null) {
                $actualKm = floatval($otpRecord->end_km) - floatval($otpRecord->start_km);

            }
            if ($otpRecord && $otpRecord->start_date !== null && $otpRecord->end_date !== null) {
                $start = \Carbon\Carbon::parse($otpRecord->start_date);
                $end   = \Carbon\Carbon::parse($otpRecord->end_date);

                $actualTime = $end->diffInMinutes($start) / 60;

            }
            $package = DB::table('packages as p')
                ->join('outstation_package as op', function ($join) use ($data) {
                    $join->on('p.id', '=', 'op.package_id')
                        ->where('op.cartype_id', $data['cartype_id'])
                        ->where('op.inout_type', $data['traveltype_id']);
                })
                ->where('p.traveltype_id', $data['traveltype_id'])
                ->where('p.km', '<=', $actualKm)
                ->orderBy('p.km', 'desc')
                ->select('p.id as package_id', 'p.km as included_km', 'p.free_hours as free_hours', 'op.ac_price', 'op.additionalperkm_ac_price', 'op.additionalperkm_nonac_price', 'op.nonac_price', 'op.local_type')
                ->first();

            if (! $package) {

                $package = DB::table('packages as p')
                    ->join('outstation_package as op', function ($join) use ($data) {
                        $join->on('p.id', '=', 'op.package_id')
                            ->where('op.cartype_id', $data['cartype_id'])
                            ->where('op.inout_type', $data['traveltype_id']);
                    })
                    ->where('p.traveltype_id', $data['traveltype_id'])
                    ->orderBy('p.km', 'asc')
                    ->select('p.id as package_id', 'p.km as included_km', 'p.free_hours as free_hours', 'op.ac_price', 'op.additionalperkm_ac_price', 'op.additionalperkm_nonac_price', 'op.nonac_price', 'op.local_type')
                    ->first();

            }
            if ($package->local_type == 2 && $actualKm < 10) {
                $isMinutes = false;

                // Treat estimated_time as minutes if less than 1 hour
                $estimated_minutes = $actualTime;
                if ($actualTime < 1) {
                    $isMinutes         = true;
                    $estimated_minutes = $actualTime * 60; // Convert to minutes
                }

                $baseFare     = 100; // ₹100 up to 3km
                $additionalKm = max(0, $actualKm - 3);

                $additionalRate = $data['ac_type'] === 'AC' ? 22 : 20;
                $extraFare      = $additionalKm * $additionalRate;

                                                         // estimated_time is considered in minutes directly
                $waitingcharge = $estimated_minutes * 2; // ₹2 per minute

                $totalCost = $baseFare + $extraFare + $waitingcharge;

                return [
                    'package_id'          => $package->package_id,
                    'amount'              => $totalCost,
                    'additional_kmrate'   => $additionalRate,
                    'additionalperhrrate' => 0,
                    'extraKm'             => $additionalKm,
                    'waitingcharge'       => $waitingcharge,
                    'baseFare'            => $baseFare,
                    'extraFare'           => $extraFare,
                    'hrcharge'            => 0,

                ];
            }

            $rate             = $data['ac_type'] === 'AC' ? $package->ac_price : $package->nonac_price;
            $additionalKMrate = $data['ac_type'] === 'AC' ? $package->additionalperkm_ac_price : $package->additionalperkm_nonac_price;
            $additionalhrrate = $data['ac_type'] === 'AC' ? $package->additionalperkm_ac_price : $package->additionalperkm_nonac_price;
            $includedKm       = $package->included_km;
            $extraKm          = max(0, $actualKm - $includedKm);

            $baseFare  = $rate;
            $extraFare = $additionalKMrate * $extraKm;
            $hrcharge  = 0;
            if ($actualTime > $package->free_hours) {
                $extrahrs = max(0, $actualTime - $package->free_hours);
                if ($data['traveltype_id'] == 2) {
                    $hrcharge = 0;
                    if ($actualKm > 100) {
                        $hrcharge = $package->above100kmhrcharge;
                    } elseif ($actualKm >= 51) {
                        $hrcharge = $package->below100kmhrcharge;
                    } else {
                        $hrcharge = $package->below50kmhrcharge;
                    }
                } else {
                    $hrcharge = $package->per_hours_price;
                }
            }
            $waitingcharge = 0;
            if ($package->local_type == 2) {
                $allowedwaitingmin    = $includedKm * $setting->waitingminperkm;+
                $estimatedtime_to_min = $actualTime * 60;
                if ($estimatedtime_to_min > $allowedwaitingmin) {
                    $waitingcharge = max(0, $estimatedtime_to_min - $allowedwaitingmin) * $setting->waitingchargepermin;
                }
            }

            $totalCost = $baseFare + $extraFare + $hrcharge + $waitingcharge;

            return [
                'package_id'          => $package->package_id,
                'amount'              => $totalCost,
                'additional_kmrate'   => $additionalKMrate,
                'additionalperhrrate' => $additionalhrrate,
                'extraKm'             => $extraKm,
                'waitingcharge'       => $waitingcharge,
                'baseFare'            => $baseFare,
                'extraFare'           => $extraFare,
                'hrcharge'            => $hrcharge,
                'is_minutes'          => 0,
            ];
        }

    }
}
