<?php
namespace App\Http\Controllers\Admin;

use App\Http\Controllers\Admin\ACommonController;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Facades\Hash;
use Illuminate\Support\Facades\Validator;

class UserManagementController extends ACommonController
{

    private $page;
    private $querystring;

    public function __construct(Request $request)
    {
        $this->page        = $request->input('page', '1');
        $this->querystring = ['page' => $this->page];
    }

    public function dataexport(Request $request)
    {
        $recordList     = DB::table('users')->where('admin_show', '1')->where('deleted_status', '0')->get();
        $assoc_roleList = DB::table('roles')->pluck('name', 'id')->toArray();
        if (! $recordList->isEmpty()) {
            $users_array[] = ['First Name', 'Last Name', 'Email', 'Phone', 'Employee Id', 'Designation', 'User Role', 'Status'];

            foreach ($recordList as $key => $item) {
                $admin_roles  = "";
                $admnrole_arr = explode(",", $item->admin_roles);
                foreach ($admnrole_arr as $row) {
                    $admin_roles .= ($row > 0) ? ($admin_roles == "") ? $assoc_roleList[$row] : "," . $assoc_roleList[$row] : "";
                }
                $users_array[] = [
                    'First Name'  => (isset($item->name)) ? $this->MRES($item->name) : "",
                    'Last Name'   => (isset($item->last_name)) ? $this->MRES($item->last_name) : "",
                    'Email'       => (isset($item->contact_email)) ? $this->MRES($item->contact_email) : "",
                    'Phone'       => (isset($item->phone)) ? $this->MRES($item->phone) : "",
                    'Employee Id' => (isset($item->emp_id)) ? $this->MRES($item->emp_id) : "",
                    'Designation' => (isset($item->designation)) ? $this->MRES($item->designation) : "",
                    'User Role'   => $admin_roles,
                    'Status'      => ($item->status == 1) ? "Enabled" : "Disabled",
                ];
            }

            $serialize_data_arr = serialize($users_array);
            // to make csv
            $tinfo          = time();
            $exportfilename = "Users-List-" . $tinfo . '.csv';
            $filename       = 'public/csv/' . $exportfilename;
            $export_data    = unserialize($serialize_data_arr);
            // to make csv

            // file creation
            $file = fopen($filename, "w");

            foreach ($export_data as $line) {
                fputcsv($file, $line);
            }

            fclose($file);

            // download
            header("Content-Description: File Transfer");
            header("Content-Disposition: attachment; filename=" . $exportfilename);
            header("Content-Type: application/csv; ");
            readfile($filename);
            // deleting file
            unlink($filename);
            exit();

        } else {
            return redirect()->route('admin.UserManagement-index')->with('error', 'No Record Found.');
        }
    }

    public function MRES($data)
    {
        $data = trim($data);
        $data = preg_replace("/\s|&nbsp;/", ' ', $data);
        $data = str_replace("&nbsp;", " ", $data);
        $data = trim($data);
        return $data;
    }

    public function getColumn($prevColumn)
    {
        if (strlen($prevColumn) == 1 && $prevColumn != "Z") {$prevColumn++;return $prevColumn;}

        $colum = '';
        $list  = str_split($prevColumn);

        if (count($list) == 1 && $list[0] == 'Z') {
            $list[0] = "A";
            $list[1] = "A";
        } else if (count($list) == 2 && $list[1] != 'Z') {
            $list[1]++;
        } else if (count($list) == 2 && $list[1] == 'Z') {
            $list[0] = "B";
            $list[1] = "A";
        }
        return implode('', $list);
    }

    public function dataindex(Request $request)
    {
        $recordsTotal    = 0;
        $recordsFiltered = 0;
        $draw            = $request->input('draw', '1');
        $start           = $request->input('start', '0');
        $length          = $request->input('length', '0');
        $columnsall      = $request->input('columns', []);
        $orderall        = $request->input('order', []);
        $dataResult      = [];
        $recordQry       = DB::table('users')->where('admin_show', '1')->where('deleted_status', '0');

        foreach ($columnsall as $key => $column_row) {
            $isSearchable = $column_row['searchable'];
            $dbcolname    = $column_row['data'];
            $dbcolval     = $column_row['search']['value'];
            $dbcolval     = trim($dbcolval);

            if ($dbcolval != "" && $isSearchable && ! is_numeric($dbcolname)) {

                switch ($dbcolname) {
                    case 'name':
                        if ($dbcolval > 0) {

                            $recordQry->where(function ($query) use ($dbcolval) {

                                $query->orWhere('name', 'like', '%' . $dbcolval . '%');

                            });
                        }
                        break;

                    default:
                        $recordQry->where($dbcolname, 'like', '%' . $dbcolval . '%');
                        break;
                }

                //$recordListQry->where($dbcolname,$dbcolval);
            }
        }

        if ($orderall) {
            $ordtyp = $orderall[0]['dir'];
            if ($orderall[0]['column'] > 0) {
                $colsynt   = $orderall[0]['column'];
                $dbcolname = $columnsall[$colsynt]['data'];
                $recordQry->orderBy($dbcolname, $ordtyp);
            } else {
                $recordQry->orderBy('id', $ordtyp);
            }
        }

        $recordAllQry = $recordQry;
        $recordsTotal = $recordAllQry->count();

        $recordList = $recordQry->orderBy('id', 'desc')
            ->offset($start)->limit($length)->get();
        $recordsFiltered = $recordList->count();
        $dataResult      = $recordList;

        return response()->json(["draw" => $draw, "recordsTotal" => $recordsTotal, "recordsFiltered" => $recordsTotal, "data" => $dataResult]);
    }

    public function index(Request $request)
    {

        $recordToShow = 20;
        $querystring  = $this->querystring;

        $sel_roleList = DB::table('roles')->where('role_admin_show', '1')->pluck('name', 'id')->toArray();

        $assoc_roleList      = DB::table('roles')->pluck('name', 'id')->toArray();
        $assoc_roleList_json = json_encode($assoc_roleList);

        return view('admin.user_management.list', compact('querystring', 'assoc_roleList_json', 'sel_roleList'));
    }

    public function create(Request $request)
    {

        $querystring = $this->querystring;

        $assoc_roleList = DB::table('roles')->where('deleted_status', '0')
            ->where('role_admin_show', '1')->pluck('name', 'id')->toArray();
        // dd($assoc_roleList);
        return view('admin.user_management.add', compact('querystring', 'assoc_roleList'));
    }

    public function store(Request $request)
    {

        $dateTime    = date('Y-m-d H:i:s');
        $userId      = auth()->user()->id;
        $querystring = $this->querystring;

        $request->validate([
            'name'       => 'required',
            'phone'      => 'required',
            'user_roles' => 'required',
            'password'   => 'required|min:6|confirmed',
        ]);

        $name            = ($request->name != "") ? $request->name : "";
        $email           = ($request->email != "") ? $request->email : "";
        $phone           = ($request->phone != "") ? $request->phone : "";
        $user_roles      = ($request->user_roles) ? $request->user_roles : [];
        $user_roles_impl = implode(",", $user_roles);
        $status          = ($request->status != "") ? $request->status : 1;

        $password = ($request->password != "") ? $request->password : "";

        //$passwd = rand(1111111,99999999);
        // $passwd = '123456789';
        $passwd_hash = Hash::make($password);
        $insrec      = DB::table('users')->insertGetId(
            [
                'admin_show'  => 1,
                'admin_roles' => $user_roles_impl,
                'name'        => $name,
                'email'       => $email,
                'phone'       => $phone,

                'password'    => $passwd_hash,
                'other_code'  => $password,
                'status'      => $status,
                'created_at'  => $dateTime,
                'updated_at'  => $dateTime,
                'created_by'  => $userId,
                'updated_by'  => $userId,
            ]
        );

        if ($insrec > 0) {
            foreach ($user_roles as $key => $roleid) {
                $role_id    = $roleid;
                $model_type = "App\Models\User";
                $model_id   = $insrec;

                $model_has_roles = DB::table('model_has_roles')->insert(
                    [
                        'role_id'    => $role_id,
                        'model_type' => $model_type,
                        'model_id'   => $model_id,
                    ]
                );
            }

            $log_msg   = "User ID - " . $insrec . " - successfully created";
            $page_name = url()->current();
            $this->createlog($userId, $page_name, $log_msg);
            // for log

            $this->changeuserrole($user_roles, $insrec);

            // $this->sendUserCredential($insrec, $password);

            /*$notify_status = 1;
            $updaterec = DB::table('users')->where('id', $insrec)->update([
            'notify_status' => $notify_status
            ]);*/
            return redirect()->route('admin.UserManagement-index', ['page' => $querystring['page']])->with('success', 'Record added successfully.');
        } else {
            return redirect()->route('admin.UserManagement-index', ['page' => $querystring['page']])->with('error', 'Error occurred.Please Try Again Later.');
        }
    }

    public function edit($id, Request $request)
    {

        $querystring = $this->querystring;

        $getRow = DB::table('users')->where('deleted_status', '0')->where('id', $id)->first();

        $assoc_roleList = DB::table('roles')->where('deleted_status', '0')
            ->where('role_admin_show', '1')->pluck('name', 'id')->toArray();
        $selected_roles = explode(",", $getRow->admin_roles);
        return view('admin.user_management.edit', compact('getRow', 'assoc_roleList', 'querystring', 'selected_roles'));

    }

    public function update(Request $request, $id)
    {

        $request->validate([

            'password' => 'required|min:6|confirmed',
        ]);

        $querystring = $this->querystring;
        $getRow      = DB::table('users')->where('deleted_status', '0')->where('id', $id)->first();

        if (isset($getRow) && ! empty($getRow)) {

            $dateTime    = date('Y-m-d H:i:s');
            $userId      = auth()->user()->id;
            $querystring = $this->querystring;

            // $request->validate([
            //     'first_name' => 'required',
            //     'user_roles' => 'required',
            // ]);

            $name  = ($request->name != "") ? $request->name : "";
            $email = ($request->email != "") ? $request->email : "";
            $phone = ($request->phone != "") ? $request->phone : "";

            $user_roles = ($request->user_roles) ? $request->user_roles : [];
            // dd($getRow);
            // dd($user_roles);
            $user_roles_impl = implode(",", $user_roles);
            $status          = ($request->status != "") ? $request->status : 1;

            // dd($name, $email, $user_roles, $user_roles_impl, $status);
            $password    = ($request->password != "") ? $request->password : "";
            $passwd_hash = Hash::make($password);

            $updaterec = DB::table('users')->where('deleted_status', '0')->where('id', $getRow->id)->update(
                [
                    'admin_roles' => $user_roles_impl,
                    'name'        => $name,
                    'email'       => $email,
                    'phone'       => $phone,
                    'status'      => $status,
                    'password'    => $passwd_hash,
                    'other_code'  => $password,
                    'updated_at'  => $dateTime,
                    'updated_by'  => $userId,

                ]
            );

            // dd($updaterec);

            if ($updaterec > 0) {

                // for log
                $log_msg   = "User ID - " . $getRow->id . " - successfully updated";
                $page_name = url()->current();
                $this->createlog($userId, $page_name, $log_msg);
                // for log

                $this->changeuserrole($user_roles, $getRow->id);

                return redirect()->route('admin.UserManagement-index', ['page' => $querystring['page']])->withSuccess('Record added successfully.');
            } else {
                return redirect()->route('admin.UserManagement-index', ['page' => $querystring['page']])->witherror('Error occurred.Please Try Again Later.');
            }
        } else {
            return redirect()->route('admin.UserManagement-index', ['page' => $querystring['page']])->witherror('Record not found.');
        }
    }

    public function show($id)
    {

        $querystring = $this->querystring;

        $getRow = DB::table('users')->where('deleted_status', '0')->where('id', $id)->first();

        if (isset($getRow) && ! empty($getRow)) {
            $assoc_roleList = DB::table('roles')->where('deleted_status', '0')
                ->where('role_admin_show', '1')->pluck('name', 'id')->toArray();

            $selected_roles = explode(",", $getRow->admin_roles);

            return view('admin.user_management.view', compact('getRow', 'assoc_roleList', 'querystring', 'selected_roles'));
        } else {
            return redirect()->route('admin.user_management.view', ['page' => $querystring['page']])->with('error', 'Record not found.');
        }
    }

    public function destroy($id)
    {
        $dateTime = date('Y-m-d H:i:s');
        $userId   = auth()->user()->id;

        if ($id > 0) {
            $getRow = DB::table('users')->where('id', $id)->first();
            $delete = DB::table('users')->where('deleted_status', '0')->where('id', $getRow->id)->update(
                [
                    'deleted_status' => 1,
                    'status'         => 3,
                    'updated_at'     => $dateTime,
                    'updated_by'     => $userId,
                ]);

            if ($delete > 0) {

                // for log
                $log_msg   = "User ID - " . $id . " - successfully deleted";
                $page_name = url()->current();
                $this->createlog($userId, $page_name, $log_msg);
                // for log

                $msg = "Successfully updated";
                $sts = 200;
            } else {
                $msg = "Error occured.";
                $sts = 201;
            }
        } else {
            $msg = "Error occured.";
            $sts = 201;
        }
        $results = ["msg" => $msg, "status" => $sts];
        return response()->json($results);
    }

    public function check_Phone(Request $request)
    {
        $input        = $request->only(['phone']);
        $return       = false;
        $request_data = [
            'phone' => 'required',
        ];
        $validator = Validator::make($input, $request_data);

        if ($validator->fails()) {
            $errors = json_decode(json_encode($validator->errors()), 1);
        } else {
            $phone                 = trim($request->phone);
            $checkwebinarregisterd = DB::table('users')
                ->where('phone', $phone)
                ->count();
            if ($checkwebinarregisterd == 0) {
                $return = true;
            }
        }
        echo json_encode($return);
        exit;
    }
    public function edit_check_Phone(Request $request)
    {
        $input        = $request->only(['phone', 'ref_id']);
        $return       = false;
        $request_data = [
            'phone'  => 'required',
            'ref_id' => 'required|integer',
        ];
        $validator = Validator::make($input, $request_data);

        if ($validator->fails()) {
            $errors = json_decode(json_encode($validator->errors()), 1);
        } else {
            $phone                 = trim($request->phone);
            $ref_id                = (int) trim($request->ref_id);
            $checkwebinarregisterd = DB::table('users')
                ->where('phone', $phone)
                ->where('id', '!=', $ref_id)
                ->count();
            if ($checkwebinarregisterd == 0) {
                $return = true;
            }
        }
        echo json_encode($return);
        exit;
    }

//  public function emailexist(Request $request)
//     {
//         $input = $request->only(['email']);
//         $return =  false;
//         $request_data = [
//             'email' => 'required|email|unique:users,email',
//         ];

//         $validator = Validator::make($input, $request_data);

//         // json is null
//         if ($validator->fails()) {
//             $errors = json_decode(json_encode($validator->errors()), 1);
//             /*return response()->json([
//                 'success' => false,
//                 'message' => array_reduce($errors, 'array_merge', array()),
//             ]);*/

//         } else {
//             /*return response()->json([
//                 'success' => true,
//                 'message' => 'The email is available'
//             ]);*/
//             $return= true;
//         }
//         echo json_encode($return);
//         exit;
//     }

    public function changeuserrole($newroles, $userid)
    {

        $dateTime            = date('Y-m-d H:i:s');
        $exist_userroleids   = DB::table('role_user')->where('user_id', $userid)->count();
        $given_user_idscount = count($newroles);
        if ($exist_userroleids >= $given_user_idscount) {
            $allexistrolerecords = DB::table('role_user')->where('user_id', $userid)->get();
            foreach ($allexistrolerecords as $key => $allexistrow) {
                if ($key <= $given_user_idscount - 1) {
                    $updateroleuser = DB::table('role_user')->where('id', $allexistrow->id)->update(
                        ['role_id' => $newroles[$key], 'user_id' => $userid, 'updated_at' => $dateTime]);
                } else {
                    $deleteext = DB::table('role_user')->where('id', $allexistrow->id)->delete();
                }
            }

        } else {
            $finalkey = 0;

            if ($exist_userroleids > 0) {
                $allexistrolerecords = DB::table('role_user')->where('user_id', $userid)->get();
                foreach ($allexistrolerecords as $key => $allexistrow) {
                    if ($key <= $given_user_idscount - 1) {
                        $updateroleuser = DB::table('role_user')->where('id', $allexistrow->id)->update(
                            ['role_id' => $newroles[$key], 'user_id' => $userid, 'updated_at' => $dateTime]);
                    } else {
                        $deleteext = DB::table('role_user')->where('id', $allexistrow->id)->delete();
                    }
                }
                $finalkey = $key + 1;
            }

            for ($i = $finalkey; $i <= $given_user_idscount - 1; $i++) {
                $roleid = $newroles[$i];
                $insrec = DB::table('role_user')->insertGetId(['role_id' => $roleid, 'user_id' => $userid, 'created_at' => $dateTime, 'updated_at' => $dateTime]);
            }
        }

        return true;
    }

    // public function sendUserCredential($userid,$updatepassword="")
    // {

    //     $lgnuserId = auth()->user()->id;
    //     $dateTime = date('Y-m-d H:i:s');

    //     $getRow = DB::table('users')->where('deleted_status', '0')->where('id', $userid)->first();
    //     if (isset($getRow) && !empty($getRow)) {
    //         $assoc_roleList = DB::table('roles')->where('role_admin_show', '1')->pluck('name', 'id')->toArray();
    //         $selected_roles = explode(",",$getRow->admin_roles);

    //         $newpassword = rand(1111111,99999999);
    //         /*$newpassword = 111222333;*/
    //         $password = ($updatepassword!="")? $updatepassword : $newpassword;

    //         $details= array(
    //             'name' => trim($getRow->name)." ".trim($getRow->last_name),
    //             'email' =>  trim($getRow->email),
    //             'phonenumber' =>  trim($getRow->phone),
    //             'subject' =>  'Your CyberBahnTas account has been created!',
    //             'username' =>  trim($getRow->email),
    //             'password' =>  trim($password),
    //         );

    //         Mail::send('newusermail', ['details'=>$details], function($message) use ($details) {
    //         /*$bcc = array('ranjithjeyan@gmail.com' => 'Ranjith');*/
    //         $message->to($details["email"],$details["name"])->subject($details['subject']);
    //         $message->to('ranjith@cyberbahntas.com','ranjith')->subject($details['subject']);
    //         /*$message->to($details["email"],$details["name"])->bcc($bcc)->subject($details['subject']);*/
    //         $message->from('info@cyberbahnit.com', 'CyberBahn - TAS');
    //         });

    //         if(Mail::failures() && count(Mail::failures()) > 0 )
    //         {
    //          $updaterec = DB::table('users')->where('id', $getRow->id)->update(['notify_status' => 0,'updated_at' => $dateTime,'updated_by' => $lgnuserId]);
    //         return 0;
    //         }else
    //         {

    //         $passwd_hash = Hash::make($password);
    //         $updaterec = DB::table('users')->where('id', $getRow->id)->update(['password' => $passwd_hash,'notify_status' => 1,'updated_at' => $dateTime,'updated_by' => $lgnuserId]);             return 1;

    //         }

    //     }
    //     return 0;
    // }

}
