<?php
namespace App\Http\Controllers\Api;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\DB;
use Tymon\JWTAuth\Facades\JWTAuth;

class DriverAuthController extends Controller
{
    public function login1(Request $request)
    {
        $request->validate([
            'user_name' => 'required|string',
            'password'  => 'required|string',
        ]);

        if (! $token = auth('api_driver')->attempt($request->only('user_name', 'password'))) {
            return response()->json([
                'error'   => true,
                'message' => 'Invalid credentials',
            ], 401);
        }

        $driver = auth('api_driver')->user();

        return response()->json([
            'access_token' => $token,
            'token_type'   => 'bearer',
            'driver'       => [
                'driver_id'      => $driver->id,
                'driver_code'    => $driver->driver_code,
                'driver_name'    => $driver->driver_name,
                'photo'          => $driver->photo,
                'vehicle_number' => $driver->vehicle_number,
                'user_name'      => $driver->user_name,
            ],
        ]);
    }

    public function login(Request $request)
    {
        $request->validate([
            'user_name' => 'required|string',
            'password'  => 'required|string',
            // 'deviceId'  => 'required|string', // Expect device token from frontend
        ]);

        if (! $token = auth('api_driver')->attempt($request->only('user_name', 'password'))) {
            return response()->json([
                'error'   => true,
                'message' => 'Invalid credentials',
            ], 401);
        }

        $driver = auth('api_driver')->user();

        // Update the device token
        DB::table('driver_management')
            ->where('id', $driver->id)
            ->update([
                'device_id' => ($request->has('deviceId') && $request->deviceId) ? $request->deviceId : null,
            ]);

        // $refreshToken = JWTAuth::claims(['refresh' => true])->fromUser($driver);

        $refreshToken = $token;
        return response()->json([
            'access_token'  => $token,
            'refresh_token' => $refreshToken,
            'expires_in'    => auth('api_driver')->factory()->getTTL() * 60,
            'token_type'    => 'bearer',
            'driver'        => [
                'driver_id'      => $driver->id,
                'driver_code'    => $driver->driver_code,
                'driver_name'    => $driver->driver_name,
                'photo'          => $driver->photo,
                'vehicle_number' => $driver->vehicle_number,
                'user_name'      => $driver->user_name,
            ],
        ]);
    }

    public function refreshToken(Request $request)
    {
        try {
            // Refresh token using the expired token sent in Authorization header
            $refreshedToken = JWTAuth::parseToken()->refresh();

            return response()->json([
                'access_token' => $refreshedToken,
                'token_type'   => 'bearer',
                'expires_in'   => auth('api_driver')->factory()->make()()->getTTL() * 60, // in seconds
            ]);

        } catch (\Tymon\JWTAuth\Exceptions\TokenInvalidException $e) {
            return response()->json(['message' => 'Invalid token'], 401);
        } catch (\Tymon\JWTAuth\Exceptions\JWTException $e) {
            return response()->json(['message' => 'Token not provided'], 401);
        }
    }

}
