<?php
namespace App\Http\Controllers\Api;

use App\Http\Controllers\Controller;
use App\Models\DriverManagement;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Hash;
use Tymon\JWTAuth\Facades\JWTAuth;

class DriverAuthController extends Controller
{
    public function login(Request $request)
    {
        $request->validate([
            'user_name' => 'required',
            'password'  => 'required',
        ]);

        $driver = DriverManagement::where('user_name', $request->user_name)->first();

        // Username doesn't exist
        if (! $driver) {
            return response()->json([
                'error'   => true,
                'message' => 'The username is incorrect',
            ], 401);
        }

        // Password incorrect
        if (! Hash::check($request->password, $driver->password)) {
            return response()->json([
                'error'   => true,
                'message' => 'Invalid password',
            ], 401);
        }

        // Authentication successful
        $token = JWTAuth::fromUser($driver);

        return response()->json([
            'access_token' => $token,
            'token_type'   => 'bearer',
            'driver'       => [
                'driver_id'      => $driver->id,
                'driver_code'    => $driver->driver_code,
                'driver_name'    => $driver->driver_name,
                'photo'          => $driver->photo,
                'vehicle_number' => $driver->vehicle_number,
                'user_name'      => $driver->user_name,
            ],
        ]);
    }

}
