<?php
namespace App\Http\Controllers\Api;

use App\Http\Controllers\Controller;
use App\Models\BookingManagement;
use Illuminate\Http\Request;

class PendingRideController extends Controller
{
    public function pendingRides(Request $request)
    {
        $driver = auth('api_driver')->user();

        $pendingRide = BookingManagement::where(function ($query) use ($driver) {
            $query->where(function ($q) use ($driver) {
                $q->where('notify_driver', 'single')
                    ->where('driver_id', $driver->id);
            })->orWhere(function ($q) {
                $q->where('notify_driver', 'all');
            });
        })
            ->where('trip_status', 0)
            ->latest()
            ->first();

        return response()->json(['ride' => $pendingRide]);
    }

    // public function pendingRides(Request $request)
    // {
    //     $driver = auth('api_driver')->user();

    //     $pendingRide = BookingManagement::where(function ($query) use ($driver) {
    //         $query->where(function ($q) use ($driver) {
    //             $q->where('notify_driver', 'single')
    //                 ->where('driver_id', $driver->id);
    //         })->orWhere(function ($q) {
    //             $q->where('notify_driver', 'all');
    //         });
    //     })
    //         ->where('trip_status', 0)
    //         ->latest()
    //         ->first();

    //     if (! $pendingRide) {
    //         return response()->json(['ride' => null, 'message' => 'No pending rides']);
    //     }

    //     // Determine the drivers to notify
    //     // For example, if 'notify_driver' = 'all', notify all active drivers
    //     if ($pendingRide->notify_driver === 'all') {
    //         // Get all active driver IDs who have device tokens
    //         $driverIds = DB::table('driver_management')
    //             ->whereNotNull('device_id')
    //             ->pluck('id')
    //             ->toArray();
    //     } else {
    //         // Notify single driver (the driver assigned)
    //         $driverIds = [$pendingRide->driver_id];
    //     }

    //     // Get device tokens for those driver IDs
    //     $tokens = DB::table('driver_management')
    //         ->whereIn('id', $driverIds)
    //         ->whereNotNull('device_id')
    //         ->pluck('device_id')
    //         ->toArray();

    //     // Prepare Expo push messages (assuming you use Expo push service)
    //     $messages = [];

    //     foreach ($tokens as $token) {
    //         $messages[] = [
    //             'to'    => $token,
    //             'sound' => 'default',
    //             'title' => 'Pending Ride Alert',
    //             'body'  => 'You have a pending ride to attend.',
    //             'data'  => ['ride_id' => $pendingRide->id],
    //         ];
    //     }

    //     if (! empty($messages)) {
    //         $response = Http::withHeaders([
    //             'Accept'       => 'application/json',
    //             'Content-Type' => 'application/json',
    //         ])->post('https://exp.host/--/api/v2/push/send', $messages);

    //         // Optional: Log or handle the response
    //         // Log::info('Push notification response:', $response->json());
    //     }

    //     return response()->json(['ride' => $pendingRide, 'notification_response' => $response->json() ?? null]);
    // }

}
