@extends('admin.layout.adminmaster')

@section('style1')

        

        <style>
            .containerbutton {
                display: flex;
                justify-content: flex-end;
                /* Aligns button to the right */
                margin-bottom: 10px;
                /* Optional: Space between button and table */
            }
            .header-container {
                        display: flex;
                        justify-content: space-between;
                        align-items: center;
                    }


            table.dataTable thead th div.DataTables_sort_wrapper {
                position: relative;
                padding-right: 20px;
            }

            table.dataTable thead th div.DataTables_sort_wrapper span {
                position: absolute;
                top: 50%;
                margin-top: -8px;
                right: 0;
            }

            table.dataTable tbody th,
            table.dataTable tbody td {

                vertical-align: middle !important;
            }

            /* .datacolumnscontainer{display: flex;}*/
            .datacolumncollapse {
                background: #ecf0f5;
                border: 1px solid #ccc;
            }

            .datacolumnitem {
                padding: 5px 10px;
                border: 1px solid #ccc;
                margin: 5px 9px;
                border-radius: 10px;
                background: #fff;
                /* background: #e4eaf9; */
                color: #000;
            }

            .datacolumnitem label {
                margin-bottom: 0px !important;
            }

            .tblsearch {
                width: 100%;
                margin: 4px auto 0px auto;
                height: 30px;
                padding-left: 6px;
            }

            a {
                color: #5b5959;
            }
        </style>

@endsection











@section('contentarea')

<h4>User Management</h4>

<div class="row">
    <div class="header-container">

<div class="col-xl-8">
    <div class="typeahead__container mb-1">

        <div class="typeahead__field">
            <div class="typeahead__query input-group">
                <span class="input-group-text"><i class="fa fa-search"></i></span>
                <input class="form-control customsearch" id="customsearch" placeholder="search here.."
                    autocomplete="off">
            </div>
        </div>
    </div>
</div>

<div class="containerbutton">
    <a href="{{route('admin.UserManagement-create') }}" class="btn btn-warning">New User</a>
</div>
</div>
</div>



        <table id="listAjaxDataTable" class="table text-nowrap w-100  mb-3">
            <thead>
                <tr>
                    <th data-ftcol="sno" > S.No </th>
                    <th data-ftcol="name">Name</th>
                    <th data-ftcol="actions"> Action </th>
                </tr>
            </thead>
            <tbody>
            </tbody>
        </table>




   
   

@endsection

@section('script1')


<script src="{{ asset('public/admin_assets/js/jquery.min.js') }}"></script>
<script src="{{ asset('public/admin_assets/our_plugin/date_picker_jq/jquery-ui.js') }}"></script>




<script>
    $(document).ready(function() {


            // alert('aaa');
            var assoc_roleList_json = {!! $assoc_roleList_json !!};

            var reorderStart = -1; // Save start position
        $('th').on("click", function(event) {
            if ($(event.target).is("input") || $(event.target).is("select")) {
                event.stopImmediatePropagation();
            }
        });
        var sno = 1;
        var dataTablecol = [
            {
                "name": "serial_no",
                "searchable": false,
                "sortable": true,
                render: function(data, type, row, meta) {
                    return meta.row + meta.settings._iDisplayStart + 1;
                }
            },

            {
                    "searchable": true,
                    "sortable": false,
                    data: 'name',
                    name: 'name',


               },


            {
                "searchable": false,
                "sortable": false,
                data: 'id',
                render: function(data, type, row, meta) {
                    var url = "{{ route('admin.UserManagement') }}";
                  

                    var editLink = '<a class="" href="' + url + '/' + data + '/edit" title="Edit">' +
                        '<i class="mdi mdi-account-edit" style="color: rgb(0, 157, 255); font-size: 20px"></i>' +
                        '</a>';

                    var viewLink = '<a class="" href="' + url + '/' + data + '/view" title="View">' +
                        '<i class="mdi mdi-eye" style="color: #009378; font-size: 20px"></i>' +
                        '</a>';

                    var deleteLink = '<a data-id="' + data + '" class="deleteRow" href="#" title="Delete">' +
                        '<i class="mdi mdi-delete" style="color: red; font-size: 20px;"></i>' +
                        '</a>';

                    var result = editLink + '&nbsp;' + viewLink + '&nbsp;' + deleteLink;
                    return result;
                }
            },
            
        ];
        var listAjaxDataTable = $('#listAjaxDataTable').DataTable({
            // "order": [
            //     [0, "desc"]
            // ],
            "processing": true,
            "serverSide": true,
            "colReorder": true,
            "columns": dataTablecol,
            "ordering": false,
            "bAutoWidth": false,
            // "dom": 'ltpr',
            "dom": " <'row'<'col-sm-12 mt-3'tr>><'row'<'col-sm-2'l><'col-sm-6'i><'col-sm-4'p>>",
            "drawCallback": function(settings) {
                var response = settings.json;
                if (response.recordsTotal > 0) {
                    $('#exportreport').show();
                } else {
                    $('#exportreport').hide();
                }
            },
            "ajax": DataTable.pipeline({
                url: "{{ route('admin.UserManagement-dataindex') }}",
                method: 'POST',
                data: {
                    _token: '{{ csrf_token() }}'
                },
                pages: 5 // number of pages to cache
            }),
        });

       
        $(document).on('keyup change','.customsearch', function() {
            
            listAjaxDataTable.search('');
            
            listAjaxDataTable.column('name:name').search($('#customsearch').val())
            .draw();
            
            
            });
        // $('table').on('click', '.changeStatus', function(e) {
                                //     e.preventDefault();
                                //     $chId = $(this).data('id');
                                //     $chTyp = $(this).data('typ');
                                //     if ($chTyp == 2) {
                                //         $cnfrmMsg = "Are you sure to Disable this record.";
                                //         $removeClass = "btn-success";
                                //         $addClass = "btn-danger";
                                //         $changeicon = '<i class="fa fa-times"> </i>';
                                //         $tochTyp = 1;
                                //     } else if ($chTyp == 1) {
                                //         $cnfrmMsg = "Are you sure to Enable this record.";
                                //         $removeClass = "btn-danger";
                                //         $addClass = "btn-success";
                                //         $changeicon = '<i class="fa fa-check"> </i>';
                                //         $tochTyp = 2;
                                //     }
                                //     var k = confirm($cnfrmMsg);
                                //     if (k == true) {
                                //         $.ajax({
                                //             url: "",
                                //             method: "PUT",
                                //             data: {
                                //                 chid: $chId,
                                //                 chtyp: $chTyp,
                                //                 _token: '{{ csrf_token() }}'
                                //             },
                                //             error: function(data) {
                                //                 toastr.error("Error Occured. Please Try Again Later.");
                                //             },
                                //             success: function(result) {
                                //                 result = JSON.stringify(result)
                                //                 result = JSON.parse(result);
                                //                 if (result.status == 200) {
                                //                     toastr.success("Status Updated Successfully");
                                //                     $('#statuschange_' + $chId).removeClass($removeClass)
                                //                         .addClass(
                                //                             $addClass);
                                //                     $('#statuschange_' + $chId).html($changeicon);
                                //                     $('#statuschange_' + $chId).data('typ', $tochTyp);
                                //                 } else {
                                //                     toastr.error("Error Occured. Please Try Again Later.");
                                //                 }
                                //             }
                                //         });
                                //     }
        // });
        $('table').on('click', '.deleteRow', function(e) {
            e.preventDefault();
            $chId = $(this).data('id');
            var k = confirm("Are you sure to Delete this record.");
            if (k == true) {
                $.ajax({
                    url: "{{ route('admin.UserManagement') }}/" + $chId,
                    method: "DELETE",
                    data: {
                        _token: '{{ csrf_token() }}'
                    },
                    error: function(data) {
                        toastr.error("Error Occured. Please Try Again Later.");
                    },
                    success: function(result) {
                        result = JSON.stringify(result)
                        result = JSON.parse(result);
                        if (result.status == 200) {
                            toastr.success("Deleted Successfully");
                            listAjaxDataTable.clearPipeline().draw();
                        } else {
                            toastr.error("Error Occured. Please Try Again Later.");
                        }
                    }
                });
            }
        });
       
        
        });
</script>

@endsection