<?php

use App\Http\Controllers\Admin\DriverManagementController;
use App\Http\Controllers\Api\AcceptRideController;
use App\Http\Controllers\Api\ActiveRideController;
use App\Http\Controllers\Api\CancelRideController;
use App\Http\Controllers\Api\DriverLogDetailsController;
use App\Http\Controllers\Api\DriverReachController;
use App\Http\Controllers\Api\DriverReportController;
use App\Http\Controllers\Api\DriverStatusController;
use App\Http\Controllers\Api\ForgetPasswordController;
use App\Http\Controllers\Api\OtpController;
use App\Http\Controllers\Api\PendingRideController;
use App\Http\Controllers\Api\StartRideController;
use App\Http\Controllers\Api\UpcomingRideController;
use Illuminate\Support\Facades\Route;

/*
|--------------------------------------------------------------------------
| API Routes
|--------------------------------------------------------------------------
|
| Here is where you can register API routes for your application. These
| routes are loaded by the RouteServiceProvider and all of them will
| be assigned to the "api" middleware group. Make something great!
|
*/
Route::group(['middleware' => ['log.api']], function () {
    Route::post('/driver/login', [App\Http\Controllers\Api\DriverAuthController::class, 'login']);

    Route::post('/driver/forgot-password/send-otp', [ForgetPasswordController::class, 'sendForgotPasswordOtp']);
    Route::post('/driver/forgot-password/verify-otp', [ForgetPasswordController::class, 'verifyForgotPasswordOtp']);
    Route::post('/driver/forgot-password/reset', [ForgetPasswordController::class, 'resetDriverPassword']);
});

Route::post('/driver/refresh-token', [App\Http\Controllers\Api\DriverAuthController::class, 'refreshToken']);

//API Call Like this  -> https://cyberbahntas.com/vaigaitaxi/api/driver/end-ride

Route::group(['middleware' => ['log.api', 'auth:api_driver']], function () {
    Route::post('/driver-status', [DriverManagementController::class, 'updateLocation']);

    //forget_password

    //Driver Logs
    Route::post('/driver/login-log', [DriverLogDetailsController::class, 'driverLogin']);
    Route::post('/driver/logout-log', [DriverLogDetailsController::class, 'driverLogout']);
    Route::get('/driver/online-summary/{id}', [DriverLogDetailsController::class, 'getDriverOnlineSummary']);

    Route::post('/driver/pending-rides', [PendingRideController::class, 'pendingRides']);
    Route::get('/driver/upcoming-rides', [UpcomingRideController::class, 'upcomingRides']);
    Route::get('/driver/past-rides', [UpcomingRideController::class, 'pastRides']);
    Route::get('/driver/driver-ridedetails', [UpcomingRideController::class, 'DriverRideDetails']);
    Route::get('/driver/driver-earnings', [DriverReportController::class, 'driverEarningsReport']);

    Route::post('/driver/accept-ride', [AcceptRideController::class, 'acceptRide']);
    Route::post('/driver/verifyOtp', [OtpController::class, 'verifyOtp']);
    Route::post('/driver/start-ride', [StartRideController::class, 'StartRide']);
    Route::post('/driver/end-ride', [StartRideController::class, 'EndRide']);
    // Route::post('/driver/trip-details', [StartRideController::class, 'getTripDetails']);
    Route::post('/driver/driverdeparture', [DriverReachController::class, 'driverdeparture']);
    Route::post('/driver/driverreached/{id}', [DriverReachController::class, 'driverreached']);
    Route::get('/driver/activenow', [ActiveRideController::class, 'activenow']);
    Route::get('/driver/cancelride', [CancelRideController::class, 'cancelRide']);
    // routes/api.php

    Route::get('/driver/driver-status/{driver_id}', [DriverStatusController::class, 'getDriverStatus']);
    Route::get('/driver/tripdetail/{tripid}', [StartRideController::class, 'tripDetails']);
    Route::get('/driver/tripdetaildriver/{tripid}', [StartRideController::class, 'tripDetailsBydriverTripId']);

// payment proof

});
