<?php
namespace App\Http\Controllers\Admin;

use App\Http\Controllers\Admin\ACommonController;
use App\Models\BookingManagement;
use Carbon\Carbon;
use Google\Auth\Credentials\ServiceAccountCredentials;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Facades\Http;
use Illuminate\Support\Facades\Log;

class BookingManagementController extends ACommonController
{

    public function dataindex(Request $request)
    {
        $recordsTotal    = 0;
        $recordsFiltered = 0;
        $draw            = $request->input('draw', '1');
        $start           = $request->input('start', '0');
        $length          = $request->input('length', '0');
        $columnsall      = $request->input('columns', []);
        $orderall        = $request->input('order', []);
        $dataResult      = [];
        $recordQry       = DB::table('booking_management')
            ->leftJoin('driver_management', 'booking_management.driver_id', '=', 'driver_management.id')
            ->leftJoin('otp_codes', 'booking_management.id', '=', 'otp_codes.booking_id')
            ->select(
                'booking_management.*',
                'driver_management.driver_name as DriverName',
                'otp_codes.otp'
            );
        $searchValue = $request->input('search.value');
        if (! empty($searchValue)) {
            $recordQry->where('driver_management.driver_name', 'like', '%' . $searchValue . '%');
        }

        if ($orderall) {
            $ordtyp = $orderall[0]['dir'];
            if ($orderall[0]['column'] > 0) {
                $colsynt   = $orderall[0]['column'];
                $dbcolname = $columnsall[$colsynt]['data'];
                $recordQry->orderBy($dbcolname, $ordtyp);
            } else {
                $recordQry->orderBy('id', $ordtyp);
            }
        }
        $recordAllQry = $recordQry;
        $recordsTotal = $recordAllQry->count();
        $recordList   = $recordQry->orderBy('id', 'desc')
            ->offset($start)->limit($length)->get();
        $recordsFiltered = $recordList->count();
        $dataResult      = $recordList;

        return response()->json(["draw" => $draw, "recordsTotal" => $recordsTotal, "recordsFiltered" => $recordsTotal, "data" => $dataResult]);
    }

    public function index()
    {
        return view('admin.booking_management.list');
    }

    // public function test()
    // {
    //     $estimation = $this->getEndrideAmountAndNewPackage(245);
    //     // $estimation = $this->getEstimatedAmountAndPackage([
    //     //     'cartype_id'     => 2,
    //     //     'ac_type'        => 'AC',
    //     //     'traveltype_id'  => 1,
    //     //     'estimated_km'   => 35,
    //     //     'estimated_time' => 4,
    //     // ]);
    //     dd($estimation);

    // }
    public function create()
    {

        $googleMapsApiKey = env('NEW_GOOGLE_MAPS_API_KEY');
        $drivers          = DB::table('driver_management')->select('id', 'driver_name', 'latitude', 'longitude', 'user_name')
            ->where('online_status', '=', 'online')
            ->where('trip_status', 0)
            ->get();
        // dd($drivers);
        $traveltype = DB::table('travel_types')->get();
        $cartype    = DB::table('cartype_management')->get();

        return view('admin.booking_management.map
        ', compact('googleMapsApiKey', 'drivers', 'traveltype', 'cartype'));
    }

    public function store(Request $request)
    {
        $request->validate([
            'notify_driver'  => 'required|in:single,all',
            'cartype'        => 'required',
            'customer_name'  => 'required|string|max:255',
            'phone'          => 'required|string|max:20',
            'from_address'   => 'required|string',
            'to_address'     => 'required|string',
            'from_latitude'  => 'required|numeric',
            'from_longitude' => 'required|numeric',
            'to_latitude'    => 'required|numeric',
            'to_longitude'   => 'required|numeric',
            'driver_id'      => 'required_if:notify_driver,single|nullable|exists:driver_management,id',
        ]);

        $booktime = date("H:i:s", strtotime($request->booking_time));

        // ✅ Get estimated amount & package before create
        $estimation = $this->getEstimatedAmountAndPackage([
            'cartype_id'     => $request->cartype,
            'ac_type'        => $request->vehicle_ac_type,
            'traveltype_id'  => $request->traveltype,
            'estimated_km'   => $request->distance_km,
            'estimated_time' => $request->estimated_hours,
        ]);
        if (count($estimation) > 0) {
            $booking = BookingManagement::create([
                'driver_id'           => $request->notify_driver === 'single' ? $request->driver_id : 0,
                'radius_km'           => $request->radiuskm,
                'ac_type'             => $request->vehicle_ac_type,
                'cartype_id'          => $request->cartype,
                'notify_driver'       => $request->notify_driver,
                'customer_name'       => $request->customer_name,
                'traveltype_id'       => $request->traveltype,
                'phone'               => $request->phone,
                'from_address'        => $request->from_address,
                'to_address'          => $request->to_address,
                'start_latitude'      => $request->from_latitude,
                'start_longitude'     => $request->from_longitude,
                'end_latitude'        => $request->to_latitude,
                'end_longitude'       => $request->to_longitude,
                'estimated_km'        => $request->distance_km,
                'estimated_time'      => $request->estimated_hours,
                'estimated_amount'    => $estimation['amount'],
                'estimated_packageid' => $estimation['package_id'],
                'booking_date'        => $request->booking_date,
                'booking_time'        => $booktime,
                'booking_dateTime'    => $request->booking_date . " " . $booktime,
            ]);
            $pickupLat = $request->from_latitude;
            $pickupLng = $request->from_longitude;
            $radiusKm  = $request->radiuskm;
            if ($request->notify_driver === 'single') {

                // ✅ 1. Assign the booking directly to the selected driver
                DB::table('booking_management')
                    ->where('id', $booking->id)
                    ->update([
                        'driver_id'      => $request->driver_id,
                        'booking_status' => 0, // Example: Assigned
                        'updated_at'     => now(),
                    ]);

                //✅ 2. Send notification ONLY to that driver
                $driverTokens = DB::table('driver_management')
                    ->where('id', $request->driver_id)
                    ->whereNotNull('device_id')
                    ->where('device_id', 'not like', '%expo%')
                    ->pluck('device_id')
                    ->toArray();

                $otp       = rand(1000, 9999);
                $expiresAt = now()->addMinutes(30);

                // Insert OTP record
                DB::table('otp_codes')->insert([
                    'booking_id' => $booking->id,
                    'driver_id'  => $booking->driver_id,
                    'phone'      => $booking->phone,
                    'otp'        => $otp,
                    'expires_at' => $expiresAt,
                    'created_at' => now(),
                    'updated_at' => now(),
                ]);

                // Send OTP message
                $message = "Your ride OTP is: " . $otp;
                $this->sendWelcomeSms($booking->phone, 'text', $message); // Custom SMS handler

                $driverRow = DB::table('driver_management')->where('id', $booking->driver_id)->first();

                if ($driverRow && $driverRow->user_name) {
                    // WhatsApp message with plain phone number (clickable to call)
                    $driverMessage = "🚕 *Ride Assigned!*\n"
                        . "👤 *Customer name:* {$booking->customer_name}\n"
                        . "📞 Phone: +91{$booking->phone}\n"
                        . "📍 *Pickup:* {$booking->from_address}\n"
                        . "🏁 *Drop:* {$booking->to_address}";

                    $this->sendWelcomeSms($driverRow->user_name, 'text', $driverMessage);
                }

            } else {
                // Notify all available drivers (e.g., online status)

                $driverTokensQry = DB::table('driver_management')
                    ->join('vehicle_management', 'driver_management.vehicle_id', '=', 'vehicle_management.id');

                if ($request->cartype && $request->cartype > 0) {
                    $cartypeId = (int) $request->cartype;
                    $driverTokensQry->where('vehicle_management.cartype_id', $cartypeId);
                }

                $driverTokens = $driverTokensQry
                    ->whereNotNull('device_id')
                    ->where('device_id', '!=', '')
                    ->where('device_id', 'not like', '%expo%')
                    ->where('online_status', 'online')
                    ->pluck('device_id')
                    ->toArray();
            }

            try {
                $jsonPath = storage_path('app/public/firebase/vaigainammataxi-firebase-adminsdk-fbsvc-0298640d7a.json');

                $scopes      = ['https://www.googleapis.com/auth/firebase.messaging'];
                $credentials = new ServiceAccountCredentials($scopes, $jsonPath);
                $token       = $credentials->fetchAuthToken()['access_token'];
                $projectId   = json_decode(file_get_contents($jsonPath))->project_id;
                $fcmUrl      = "https://fcm.googleapis.com/v1/projects/{$projectId}/messages:send";

                foreach ($driverTokens as $deviceToken) {
                    $title = $request->notify_driver === 'single' ? 'Ride Assigned' : 'New Ride Request';
                    $body  = $request->notify_driver === 'single'
                    ? 'A ride has been assigned to you directly.'
                    : 'Tap to accept the new ride request.';

                    $message = [
                        'message' => [
                            'token'        => $deviceToken,
                            'notification' => [
                                'title' => $title,
                                'body'  => $body,
                            ],
                            'data'         => [
                                'screen'       => '/app/index',
                                'customSound'  => 'alert33762.mp3',
                                'booking_id'   => "" . $booking->id . "",
                                'from_address' => "" . $booking->from_address . "",
                                'to_address'   => "" . $booking->to_address . "",
                            ],
                            'android'      => [
                                'notification' => [
                                    'sound'      => 'alert33762',
                                    'channel_id' => 'high-priority',
                                ],
                            ],
                            'apns'         => [
                                'payload' => [
                                    'aps' => [
                                        'sound' => 'alert33762.caf',
                                    ],
                                ],
                            ],
                        ],
                    ];

                    $response = Http::withToken($token)
                        ->withHeaders(['Content-Type' => 'application/json'])
                        ->post($fcmUrl, $message);

                    if (! $response->successful()) {
                        Log::error('FCM Push Failed', [
                            'token'    => $deviceToken,
                            'response' => $response->body(),

                        ]);
                    } else {
                        // Log::success('FCM Push Success', [
                        //     'token'    => $deviceToken,
                        //     'response' => $response->json(),
                        // ]);
                        // dd($message);
                    }

                }
            } catch (\Exception $e) {
                Log::error('FCM Notification Exception', [
                    'error' => $e->getMessage(),
                ]);
            }

            event(new \App\Events\SendRideRequestEvent($booking));
            // SendExpoNotificationJob::dispatch($booking, $driverTokens);

            // SendRideTimeoutJob::dispatch($booking->id)->delay(now()->addSeconds(30));

            return redirect()->route('admin.BookingManagement-index')->with('success', 'Ride created successfully!');

        } else {
            return redirect()->route('admin.BookingManagement-index')->with('error', 'Error occurred');

        }

    }

    public function store1(Request $request)
    {
        $request->validate([
            'notify_driver'  => 'required|in:single,all',
            'customer_name'  => 'required|string|max:255',
            'phone'          => 'required|string|max:20',
            'from_address'   => 'required|string',
            'to_address'     => 'required|string',
            'from_latitude'  => 'required|numeric',
            'from_longitude' => 'required|numeric',
            'to_latitude'    => 'required|numeric',
            'to_longitude'   => 'required|numeric',
            'driver_id'      => 'required_if:notify_driver,single|nullable|exists:driver_management,id',
        ]);
        $booktime = date("H:i:s", strtotime($request->booking_time));
        $booking  = BookingManagement::create([
            'driver_id'        => $request->notify_driver === 'single' ? $request->driver_id : 0,
            'radius_km'        => $request->radiuskm,
            'ac_type'          => $request->vehicle_ac_type,
            'cartype_id'       => $request->cartype,
            'notify_driver'    => $request->notify_driver,
            'customer_name'    => $request->customer_name,
            'traveltype_id'    => $request->traveltype,
            'phone'            => $request->phone,
            'from_address'     => $request->from_address,
            'to_address'       => $request->to_address,
            'start_latitude'   => $request->from_latitude,
            'start_longitude'  => $request->from_longitude,
            'end_latitude'     => $request->to_latitude,
            'end_longitute'    => $request->to_longitude,
            'booking_date'     => $request->booking_date,
            'booking_time'     => $booktime,
            'booking_dateTime' => $request->booking_date . " " . $booktime,
        ]);

        // Get tokens
        if ($request->notify_driver === 'single') {
            $driverTokens = DB::table('driver_management')
                ->where('id', $request->driver_id)
                ->whereNotNull('device_id')
                ->pluck('device_id')
                ->toArray();
        } else {
            $driverTokens = DB::table('driver_management')
                ->whereNotNull('device_id')
                ->where('device_id', 'not like', '%expo%')
                ->where('online_status', 'online') // single =, not ==
                ->pluck('device_id')
                ->toArray();
        }

        // Send push notification via Firebase
        foreach ($driverTokens as $token) {
            $payload = [
                'to'           => $token,
                'notification' => [
                    'title' => 'New Ride Request',
                    'body'  => 'Tap to accept the new ride request',
                    'sound' => 'default',
                ],
                'data'         => [
                    'booking_id'   => $booking->id,
                    'from_address' => $booking->from_address,
                    'to_address'   => $booking->to_address,
                    'screen'       => '/app/index', // Adjust to your frontend route
                ],
            ];

            $response = Http::withHeaders([
                'Authorization' => 'key=' . config('services.firebase.server_key'),
                'Content-Type'  => 'application/json',
            ])->post('https://fcm.googleapis.com/fcm/send', $payload);

            if (! $response->successful()) {
                Log::error('FCM Push Failed', [
                    'token'    => $token,
                    'response' => $response->body(),
                ]);
            }
        }

        // Trigger backend events if needed
        event(new \App\Events\SendRideRequestEvent($booking));
        // SendRideTimeoutJob::dispatch($booking->id)->delay(now()->addSeconds(30));

        return redirect()->route('admin.BookingManagement-index')->with('success', 'Ride created and notification sent!');
    }

    public function edit(Request $request, $id)
    {
        $getRow     = DB::table('booking_management')->where('id', $id)->first();
        $get_driver = DB::table('driver_management')->where('id', $getRow->driver_id)->first();

        $googleMapsApiKey = env('NEW_GOOGLE_MAPS_API_KEY');
        $drivers          = DB::table('driver_management')->select('id', 'latitude', 'longitude')
            ->where('online_status', '=', 'online')
            ->where('trip_status', 0)
            ->get();

        return view('admin.booking_management.edit', compact('getRow', 'get_driver', 'googleMapsApiKey', 'drivers'));
    }
    public function edit1(Request $request, $id)
    {
        $getRow = DB::table('booking_management as bm')
            ->leftJoin('driver_management as dm', 'bm.driver_id', '=', 'dm.id')
            ->leftJoin('otp_codes as otp', 'otp.booking_id', '=', 'bm.id')
            ->leftJoin('outstation_package as op', 'op.cartype_id', '=', 'bm.cartype_id')
            ->leftJoin('driver_arrived as da', 'da.booking_id', '=', 'bm.id')
            ->leftJoin('fare_summaries as fs', 'fs.booking_id', '=', 'bm.id')
            ->where('bm.id', $id)
            ->select(
                'bm.*',
                'dm.driver_name',
                'otp.start_km as otp_start_km',
                'otp.end_km as otp_end_km',
                'otp.start_date as start_date',
                'otp.end_date as end_date',
                'otp.total_km as total_km',
                'op.hillsac_price',
                'op.hillsnonac_price',
                // 'da.total_km',
                'da.start_km',
                'da.end_km',
                'da.driver_arrived_at',
                'da.driver_departed_at',
                'fs.start_time',
                'fs.end_time',
                'fs.total_km_travelled',
                'fs.total_price',
                'fs.extra_discountamount',
                'fs.extra_fair',
                'fs.hills_fare',
                'fs.hills_km',

            )
            ->first();

        $statusOptions = [
            1 => 'Driver started to reach Destination',
            2 => 'Driver Reached customer location',
            3 => 'Driver pick up customer from location',
            4 => 'Driver completed Ride',
            5 => 'cancel ride',

        ];

        return view('admin.booking_management.editpayment', compact('getRow'));
    }

    public function update2(Request $request, $id)
    {
        DB::beginTransaction();
        try {
            $bookingRow = DB::table('booking_management')->where('id', $id)->first();

            // 1. Basic updates (name, phone, status)
            if ($request->hasAny(['customer_name', 'phone', 'booking_status'])) {
                $updateData = $request->only(['customer_name', 'phone', 'booking_status']);
                DB::table('booking_management')->where('id', $id)->update(array_filter($updateData));
            }

            // 2. Update driver_arrived
            if ($request->hasAny(['total_km', 'start_km', 'end_km', 'driver_departed_at', 'driver_arrived_at', 'otp_start_km']) && $bookingRow) {
                $startKm = $request->filled('start_km') ? $request->start_km : ($request->otp_start_km ?? null);
                $endKm   = $request->filled('end_km') ? $request->end_km : ($request->otp_start_km ?? null);

                $arrivedData = [
                    'start_km' => $startKm,
                    'end_km'   => $endKm,
                    'total_km' => is_numeric($startKm) && is_numeric($endKm) ? $endKm - $startKm : null,
                ];

                if ($request->filled('driver_departed_at')) {
                    $arrivedData['driver_departed_at'] = \Carbon\Carbon::createFromFormat('Y-m-d H:i:s', $request->driver_departed_at)->format('Y-m-d H:i:s');
                }

                if ($request->filled('start_time')) {
                    $arrivedData['driver_arrived_at'] = \Carbon\Carbon::createFromFormat('Y-m-d H:i:s', $request->start_time)->format('Y-m-d H:i:s');
                }

                DB::table('driver_arrived')->updateOrInsert(
                    ['booking_id' => $id, 'driver_id' => $bookingRow->driver_id],
                    array_filter($arrivedData)
                );
                DB::table('driver_management')
                    ->where('id', $bookingRow->driver_id)
                    ->update(['trip_status' => 1]);

            }

            // 3. Update OTP
            if ($request->hasAny(['otp_start_km', 'otp_end_km'])) {
                $otpData = $request->only(['otp_start_km', 'otp_end_km']);
                DB::table('otp_codes')->updateOrInsert(
                    ['booking_id' => $id, 'driver_id' => $bookingRow->driver_id],
                    ['start_km' => $otpData['otp_start_km'] ?? null, 'end_km' => $otpData['otp_end_km'] ?? null]
                );
            }
            if ($request->filled('booking_status')) {
                DB::table('booking_management')->where('id', $id)->update([
                    'booking_status' => $request->input('booking_status'),
                ]);
            }

            // 4. Full Fare Calculation Logic

            $otp = DB::table('otp_codes')->where('booking_id', $id)->first();
            if ($otp && $otp->start_km !== null && $otp->end_km !== null) {
                $traveledKm = round($otp->end_km - $otp->start_km, 2);
                $setting    = DB::table('settings')->where('id', 1)->first();

                $package = DB::table('packages as p')
                    ->join('outstation_package as op', function ($join) use ($bookingRow) {
                        $join->on('p.id', '=', 'op.package_id')
                            ->where('op.cartype_id', $bookingRow->cartype_id)
                            ->where('op.inout_type', $bookingRow->traveltype_id);
                    })
                    ->where('p.traveltype_id', $bookingRow->traveltype_id)
                    ->where('p.km', '<=', $traveledKm)
                    ->orderBy('p.km', 'desc')
                    ->first();

                if (! $package) {
                    $package = DB::table('packages as p')
                        ->join('outstation_package as op', function ($join) use ($bookingRow) {
                            $join->on('p.id', '=', 'op.package_id')
                                ->where('op.cartype_id', $bookingRow->cartype_id)
                                ->where('op.inout_type', $bookingRow->traveltype_id);
                        })
                        ->where('p.traveltype_id', $bookingRow->traveltype_id)
                        ->orderBy('p.km', 'asc')
                        ->first();
                }

                if (! $package) {
                    throw new \Exception('No package found.');
                }

                DB::table('booking_management')->where('id', $id)->update(['package_id' => $package->package_id]);

                $startTime  = Carbon::parse($otp->created_at);
                $endTime    = Carbon::parse($otp->updated_at);
                $durationHr = $endTime->diffInMinutes($startTime) / 60;

                $rate       = $bookingRow->ac_type === 'AC' ? $package->ac_price : $package->nonac_price;
                $perKmRate  = $bookingRow->ac_type === 'AC' ? $package->additionalperkm_ac_price : $package->additionalperkm_nonac_price;
                $includedKm = $package->km;
                $includedHr = $package->free_hours;

                $extraKm     = max(0, $traveledKm - $includedKm);
                $extraKmFare = $extraKm * $perKmRate;

                $extraHr     = max(0, $durationHr - $includedHr);
                $perHrRate   = $package->per_hours_price;
                $extraHrFare = $extraHr * $perHrRate;

                $totalPrice = $rate + $extraKmFare + $extraHrFare;

                // Add hills_fare and extra_fair and discount if any
                $totalPrice += $request->input('hills_fare') ?? 0;
                $totalPrice += $request->input('extra_fair') ?? 0;
                $totalPrice -= $request->input('extra_discountamount') ?? 0;

                // Reward logic (+2 for each ride)
                // $rewardPoints = DB::table('fare_summaries')
                //     ->join('booking_management', 'fare_summaries.booking_id', '=', 'booking_management.id')
                //     ->where('booking_management.phone', $bookingRow->phone)
                //     ->where('booking_management.customer_name', $bookingRow->customer_name)
                //     ->sum('fare_summaries.reward_points') + 2;
                $startTime = \Carbon\Carbon::parse($request->input('start_time'));
                $endTime   = \Carbon\Carbon::parse($request->input('end_time'));

                $fareSummaries = DB::table('fare_summaries')->updateOrInsert(
                    ['booking_id' => $id],
                    [
                        'driver_id'            => $bookingRow->driver_id,
                        'customer_name'        => $bookingRow->customer_name,
                        'phone'                => $bookingRow->phone,
                        'pickup_location'      => $bookingRow->from_address,
                        'drop_location'        => $bookingRow->to_address,
                        'total_km_travelled'   => $traveledKm,
                        'package_km'           => $includedKm,
                        'extra_km_charged'     => $extraKm,
                        'base_fare'            => $rate,
                        'per_km_charge'        => $perKmRate,
                        'distance_fare'        => $extraKmFare,
                        'hr_fare'              => $extraHrFare,
                        'extra_fair'           => $request->input('extra_fair') ?? 0,
                        'extra_discountamount' => $request->input('extra_discountamount') ?? 0,
                        'hills_fare'           => $request->input('hills_fare') ?? 0,
                        'total_price'          => $totalPrice,
                        'start_time'           => $startTime->format('H:i:s'),
                        'end_time'             => $endTime->format('H:i:s'),
                        'travel_minutes'       => $durationHr,
                        // 'reward_points'      => $rewardPoints,
                        'end_date'             => now()->format('Y-m-d'),
                    ]
                );

            }

            DB::table('driver_management')
                ->where('id', $bookingRow->driver_id)
                ->update(['trip_status' => 0]);
            $this->updateDriverTripSummary($bookingRow->driver_id, now()->format('Y-m-d'));

            DB::commit();

            if ($request->filled('summary_details') && $request->input('summary_details') == '1') {
                $booking     = DB::table('booking_management')->where('id', $id)->first();
                $fareSummary = DB::table('fare_summaries')->where('booking_id', $id)->first();
                $otpData     = DB::table('otp_codes')->where('booking_id', $id)->first();

                if ($booking && $fareSummary) {
                    $customerPhone = $booking->phone;
                    $driver        = DB::table('driver_management')->where('id', $booking->driver_id)->first();
                    $driverPhone   = $driver->user_name ?? null;

                    $message = "*Vaigai Namma Taxi Ride Summary*\n"
                        . "Customer: {$booking->customer_name}\n"
                        . "From: {$booking->from_address}\n"
                        . "To: {$booking->to_address}\n"
                        . "Trip Start KM: " . ($otpData->start_km ?? '-') . "\n"
                        . "Trip End KM: " . ($otpData->end_km ?? '-') . "\n"
                        . "Total KM Travelled: {$fareSummary->total_km_travelled} KM\n"
                        . "Extra Fare: ₹{$fareSummary->extra_fair}\n"
                        . "Discount: ₹{$fareSummary->extra_discountamount}\n"
                        . "Hills Fare: ₹{$fareSummary->hills_fare}\n"
                        . "Final Total: ₹{$fareSummary->total_price}\n\n"
                        . "Thank you for choosing VaigaiNamma Taxi!";

                    // Send to customer
                    if (! empty($customerPhone)) {
                        $this->sendWelcomeSms($customerPhone, 'text', $message);

                    }

                    // Send to driver
                    if (! empty($driverPhone)) {
                        $this->sendWelcomeSms($driverPhone, 'text', $message);

                    }
                }
            }

            return redirect()->route('admin.BookingManagement-index')->with('success', 'Booking updated and fare calculated.');
        } catch (\Exception $e) {
            DB::rollBack();
            Log::error('Update1 Error: ' . $e->getMessage());
            return back()->with('error', 'Update failed: ' . $e->getMessage());
        }
    }

    // public function update1(Request $request, $id)
    // {
    //     DB::beginTransaction();
    //     try {
    //         $bookingRow = DB::table('booking_management')->where('id', $id)->first();

    //         if (! $bookingRow) {
    //             throw new \Exception("Booking not found.");
    //         }

    //         // Basic booking fields
    //         if ($request->hasAny(['customer_name', 'phone', 'booking_status'])) {
    //             $updateData = $request->only(['customer_name', 'phone', 'booking_status']);
    //             DB::table('booking_management')->where('id', $id)->update(array_filter($updateData));
    //         }

    //         // Driver arrival update

    //         if ($request->hasAny(['total_km', 'start_km', 'driver_departed_at', 'driver_arrived_at', 'otp_start_km'])) {
    //             $dep_startKm = $request->filled('start_km') ? $request->start_km : ($request->otp_start_km ?? null);
    //             $dep_endKm   = $request->otp_start_km ? $request->otp_start_km : null;

    //             $arrivedData = [
    //                 'start_km' => $dep_startKm,
    //                 'end_km'   => $dep_endKm,

    //             ];

    //             if ($request->filled('driver_departed_at')) {
    //                 $arrivedData['driver_departed_at'] = \Carbon\Carbon::parse($request->driver_departed_at)->format('Y-m-d H:i:s');
    //             }

    //             if ($request->filled('start_time')) {
    //                 $arrivedData['driver_arrived_at'] = \Carbon\Carbon::parse($request->start_time)->format('Y-m-d H:i:s');
    //             }

    //             DB::table('driver_arrived')->updateOrInsert(
    //                 ['booking_id' => $id, 'driver_id' => $bookingRow->driver_id],
    //                 array_filter($arrivedData)
    //             );

    //             DB::table('driver_management')
    //                 ->where('id', $bookingRow->driver_id)
    //                 ->update(['trip_status' => 1]);

    //         }

    //         // OTP
    //         if ($request->hasAny(['otp_start_km', 'otp_end_km'])) {
    //             $trip_startKm = $request->otp_start_km ? $request->otp_start_km : null;
    //             $trip_endKm   = $request->otp_end_km ? $request->otp_end_km : null;

    //             $totalkm = DB::table('otp_codes')->updateOrInsert(
    //                 ['booking_id' => $id, 'driver_id' => $bookingRow->driver_id],
    //                 [
    //                     'start_km'   => $request->otp_start_km ?? null,
    //                     'end_km'     => $request->otp_end_km ?? null,
    //                     'start_date' => $request->start_time ?? null,
    //                     'end_date'   => $request->end_time ?? null,

    //                 ]
    //             );
    //         }

    //         // $trip_Totalkm = 0;
    //         // $trip_Totalkm = is_numeric($trip_startKm) && is_numeric($trip_endKm) ? $trip_endKm - $trip_startKm : null

    //         // Booking status update
    //         if ($request->filled('booking_status')) {
    //             DB::table('booking_management')->where('id', $id)->update([
    //                 'booking_status' => $request->input('booking_status'),
    //             ]);
    //         }

    //         $bookingRow = DB::table('booking_management')->where('id', $id)->first();

    //         $fareDetails = $this->getEndrideAmountAndNewPackage($id);

    //         if ($fareDetails && is_array($fareDetails)) {
    //             $otp       = DB::table('otp_codes')->where('booking_id', $id)->first();
    //             $startTime = \Carbon\Carbon::parse($request->input('start_time'));
    //             $endTime   = \Carbon\Carbon::parse($request->input('end_time'));

    //             // Travel duration in minutes
    //             $durationMinutes = $endTime->diffInMinutes($startTime);

    //             // Travel duration in HH:MM:SS format
    //             $durationFormatted = $endTime->diff($startTime)->format('%H:%I:%S');

    //             // Optional: duration in decimal hours (e.g., 0.6 hr)
    //             $durationHr = round($durationMinutes / 60, 2);

    //             $rate        = $fareDetails['baseFare'] ?? 0;
    //             $perKmRate   = $fareDetails['additional_kmrate'] ?? 0;
    //             $extraKm     = $fareDetails['extraKm'] ?? 0;
    //             $extraKmFare = $fareDetails['extraFare'] ?? 0;
    //             $extraHrFare = $fareDetails['hrcharge'] ?? 0;
    //             $totalPrice  = $fareDetails['amount'] ?? 0;

    //             DB::table('fare_summaries')->updateOrInsert(
    //                 ['booking_id' => $id],
    //                 [
    //                     'driver_id'            => $bookingRow->driver_id,
    //                     'customer_name'        => $bookingRow->customer_name,
    //                     'phone'                => $bookingRow->phone,
    //                     'pickup_location'      => $bookingRow->from_address,
    //                     'drop_location'        => $bookingRow->to_address,
    //                     'total_km_travelled'   => $trip_endKm - $trip_startKm,
    //                     'package_km'           => $fareDetails['package_km'] ?? 0,
    //                     'extra_km_charged'     => $fareDetails['extraKm'] ?? 0,
    //                     'base_fare'            => $fareDetails['baseFare'] ?? 0,
    //                     'per_km_charge'        => $fareDetails['additional_kmrate'] ?? 0,
    //                     'distance_fare'        => $fareDetails['extraFare'] ?? 0,
    //                     'hr_fare'              => $fareDetails['hrcharge'] ?? 0,
    //                     'waiting_charge'       => $fareDetails['waitingcharge'] ?? 0,
    //                     'extra_fair'           => $request->input('extra_fair') ?? 0,
    //                     'extra_discountamount' => $request->input('extra_discountamount') ?? 0,
    //                     'hills_fare'           => $request->input('hills_fare') ?? 0,
    //                     'total_price'          => round(($fareDetails['amount'] ?? 0) + floatval($request->input('extra_fair')) - floatval($request->input('extra_discountamount')) + floatval($request->input('hills_fare')), 2),
    //                     'start_time'           => $startTime->format('H:i:s'),
    //                     'end_time'             => $endTime->format('H:i:s'),
    //                     'travel_minutes'       => $durationFormatted,
    //                     'end_date'             => now()->format('Y-m-d'),
    //                 ]
    //             );
    //         }

    //         // Reset trip_status after end
    //         DB::table('driver_management')->where('id', $bookingRow->driver_id)->update(['trip_status' => 0]);

    //         // Optionally update driver summary
    //         $this->updateDriverTripSummary($bookingRow->driver_id, now()->format('Y-m-d'));

    //         DB::commit();

    //         // Send summary via SMS
    //         if ($request->filled('summary_details') && $request->input('summary_details') == '1') {
    //             $this->sendBookingSummary($id);
    //         }

    //         return redirect()->route('admin.BookingManagement-index')->with('success', 'Booking updated and fare calculated.');

    //     } catch (\Exception $e) {
    //         DB::rollBack();
    //         Log::error('Update1 Error: ' . $e->getMessage());
    //         return back()->with('error', 'Update failed: ' . $e->getMessage());
    //     }
    // }

    public function update1(Request $request, $id)
    {
        DB::beginTransaction();
        try {
            $bookingRow = DB::table('booking_management')->where('id', $id)->first();
            if (! $bookingRow) {
                throw new \Exception("Booking not found.");
            }

            // 1. Update basic booking fields
            if ($request->hasAny(['customer_name', 'phone', 'booking_status'])) {
                $updateData = $request->only(['customer_name', 'phone', 'booking_status']);
                DB::table('booking_management')->where('id', $id)->update(array_filter($updateData));
            }

            // 2. Update driver arrival (departure/start_km and arrival time)
            $arrivedUpdated = false;
            if ($request->hasAny(['total_km', 'start_km', 'driver_departed_at', 'driver_arrived_at', 'otp_start_km'])) {
                $dep_startKm = $request->filled('start_km') ? $request->start_km : ($request->otp_start_km ?? null);
                $dep_endKm   = $request->otp_start_km ?? null;

                $arrivedData = [
                    'start_km' => $dep_startKm,
                    'end_km'   => $dep_endKm,
                ];

                if ($request->filled('driver_departed_at')) {
                    $arrivedData['driver_departed_at'] = \Carbon\Carbon::parse($request->driver_departed_at)->format('Y-m-d H:i:s');
                }

                if ($request->filled('start_time')) {
                    $arrivedData['driver_arrived_at'] = \Carbon\Carbon::parse($request->start_time)->format('Y-m-d H:i:s');
                }

                if (! empty(array_filter($arrivedData))) {
                    DB::table('driver_arrived')->updateOrInsert(
                        ['booking_id' => $id, 'driver_id' => $bookingRow->driver_id],
                        array_filter($arrivedData)
                    );

                    DB::table('driver_management')
                        ->where('id', $bookingRow->driver_id)
                        ->update(['trip_status' => 1]);

                    $arrivedUpdated = true;
                }
            }

            // 3. Update OTP km and times
            $otpUpdated   = false;
            $trip_startKm = $trip_endKm = null;

            if ($request->hasAny(['otp_start_km', 'otp_end_km'])) {
                $trip_startKm = $request->otp_start_km ?? null;
                $trip_endKm   = $request->otp_end_km ?? null;
                $trip_totalKm = $trip_endKm - $trip_startKm;

                $otpData = [
                    'start_km'   => $trip_startKm,
                    'end_km'     => $trip_endKm,
                    'start_date' => $request->start_date ?? null,
                    'end_date'   => $request->end_date ?? null,
                    'total_km'   => $trip_totalKm ?? 0,
                ];

                DB::table('otp_codes')->updateOrInsert(
                    ['booking_id' => $id, 'driver_id' => $bookingRow->driver_id],
                    array_filter($otpData)
                );

                $otpUpdated = true;
            }

            // 4. Update booking status again if needed
            if ($request->filled('booking_status')) {
                DB::table('booking_management')->where('id', $id)->update([
                    'booking_status' => $request->input('booking_status'),
                ]);
            }

            // 5. Only call fare calculation if ALL required data was updated
            if ($arrivedUpdated && $otpUpdated && $request->filled('start_date') && $request->filled('end_date')) {

                $bookingRow = DB::table('booking_management')->where('id', $id)->first();

                $fareDetails = $this->getEndrideAmountAndNewPackage($id);

                if ($fareDetails && is_array($fareDetails)) {
                    $startTime = \Carbon\Carbon::parse($request->start_date);
                    $endTime   = \Carbon\Carbon::parse($request->end_date);

                    $durationMinutes   = $endTime->diffInMinutes($startTime);
                    $durationFormatted = $endTime->diff($startTime)->format('%H:%I:%S');

                    $result = DB::table('fare_summaries')->updateOrInsert(
                        ['booking_id' => $id],
                        [
                            'driver_id'            => $bookingRow->driver_id,
                            'customer_name'        => $bookingRow->customer_name,
                            'phone'                => $bookingRow->phone,
                            'pickup_location'      => $bookingRow->from_address,
                            'drop_location'        => $bookingRow->to_address,
                            'total_km_travelled'   => $trip_totalKm,
                            'package_km'           => $fareDetails['package_km'] ?? 0,
                            'extra_km_charged'     => $fareDetails['extraKm'] ?? 0,
                            'base_fare'            => $fareDetails['baseFare'] ?? 0,
                            'per_km_charge'        => $fareDetails['additional_kmrate'] ?? 0,
                            'distance_fare'        => $fareDetails['extraFare'] ?? 0,
                            'hr_fare'              => $fareDetails['hrcharge'] ?? 0,
                            'waiting_charge'       => $fareDetails['waitingcharge'] ?? 0,
                            'extra_fair'           => $request->input('extra_fair') ?? 0,
                            'extra_discountamount' => $request->input('extra_discountamount') ?? 0,
                            'hills_fare'           => $request->input('hills_fare') ?? 0,
                            'hills_km'             => $request->input('hills_km') ?? 0,
                            'total_price'          => round(($fareDetails['amount'] ?? 0) + floatval($request->input('extra_fair')) - floatval($request->input('extra_discountamount')) + floatval($request->input('hills_fare')), 2),
                            'start_time'           => $startTime->format('H:i:s'),
                            'end_time'             => $endTime->format('H:i:s'),
                            'travel_minutes'       => $durationFormatted,
                            'end_date'             => now()->format('Y-m-d'),

                        ]
                    );

                    // Reset trip status after ride ends
                    DB::table('driver_management')->where('id', $bookingRow->driver_id)->update(['trip_status' => 0]);

                    // Update driver trip summary
                    $this->updateDriverTripSummary($bookingRow->driver_id, now()->format('Y-m-d'));
                }
            }

            DB::commit();

            if ($request->filled('summary_details') && $request->input('summary_details') == '1') {
                $this->sendBookingSummary($id);
            }

            return redirect()->route('admin.BookingManagement-index')->with('success', 'Booking updated and fare calculated.');

        } catch (\Exception $e) {
            DB::rollBack();
            Log::error('Update1 Error: ' . $e->getMessage());
            return back()->with('error', 'Update failed: ' . $e->getMessage());
        }
    }

    public function getEndrideAmountAndNewPackage($id)
    {
        $setting = DB::table('settings')->where('id', 1)->first();
        $booking = DB::table('booking_management')->where('id', $id)->first();
        if ($booking) {
            $bookingId       = $booking->id;
            $actualKm        = 0;
            $actualTime      = 0;
            $actualTimeInMin = 0;
            $extraDiscount   = 0;
            $extraKmFare     = 0;
            $extraFare       = 0;

            $otp = DB::table('otp_codes')
                ->where('booking_id', $bookingId)
                ->select('start_km', 'end_km', 'driver_id', 'booking_id', 'start_date', 'end_date')
                ->first();

            if ($otp) {
                $traveledKm    = $totalKm    = round($otp->end_km - $otp->start_km, 2);
                $cartype_id    = $booking->cartype_id;
                $traveltype_id = $booking->traveltype_id;
                $extraDiscount = $booking->traveltype_id;
                $extraFare     = $booking->traveltype_id;
// Step 1: Get matching package
                $package = DB::table('packages as p')
                    ->join('outstation_package as op', function ($join) use ($cartype_id, $traveltype_id) {
                        $join->on('p.id', '=', 'op.package_id')
                            ->where('op.cartype_id', $cartype_id)
                            ->where('op.inout_type', $traveltype_id);
                    })
                    ->where('p.traveltype_id', $traveltype_id)
                    ->orderBy('p.km', 'asc')
                    ->select('p.id as package_id', 'p.km as included_km', 'p.free_hours as free_hours', 'op.ac_price', 'op.additionalperkm_ac_price', 'op.additionalperkm_nonac_price', 'op.nonac_price', 'op.local_type', 'op.per_hours_ac_price', 'op.per_hours_price', 'op.hillsac_price', 'op.hillsnonac_price')
                    ->first();

                // Step 2: Update package_id in booking_management
                if ($package) {
                    DB::table('booking_management')->where('id', $bookingId)->update([
                        'package_id'    => $package->package_id,
                        'traveltype_id' => $traveltype_id,
                    ]);
                }

                $tripInfo = DB::table('otp_codes as oc')
                    ->join('booking_management as bm', 'oc.booking_id', '=', 'bm.id')
                    ->join('driver_management as dm', 'bm.driver_id', '=', 'dm.id')
                    ->join('vehicle_management as vm', 'dm.vehicle_id', '=', 'vm.id')
                    ->join('cartype_management as cm', 'vm.cartype_id', '=', 'cm.id')
                    ->join('packages as pk', 'pk.id', '=', 'bm.package_id')
                    ->select(
                        'bm.customer_name',
                        'bm.phone',
                        'bm.from_address',
                        'bm.to_address',
                        'bm.package_id',
                        'oc.start_km',
                        'oc.end_km',
                        'pk.km as included_km',
                        'cm.car_type',
                        'oc.start_date as start_time',
                        'oc.end_date as end_time'
                    )
                    ->where('oc.booking_id', $bookingId)
                    ->first();

                if ($tripInfo) {
                    $startTime             = Carbon::parse($tripInfo->start_time);
                    $endTime               = Carbon::parse($tripInfo->end_time);
                    $travelled_time_in_min = $endTime->diffInMinutes($startTime);
                    $travelled_time_in_hr  = $travelled_time_in_min / 60;
                    $isMinutes             = false;

                    $package = DB::table('packages as p')
                        ->join('outstation_package as op', function ($join) use ($cartype_id, $traveltype_id) {
                            $join->on('p.id', '=', 'op.package_id')
                                ->where('op.cartype_id', $cartype_id)
                                ->where('op.inout_type', $traveltype_id);
                        })
                        ->where('p.traveltype_id', $traveltype_id)
                        ->where('p.km', '<=', $traveledKm)
                        ->orderBy('p.km', 'desc')
                        ->select('p.id as package_id', 'p.km as included_km', 'p.free_hours as free_hours', 'op.ac_price', 'op.additionalperkm_ac_price', 'op.additionalperkm_nonac_price', 'op.nonac_price', 'op.local_type', 'op.per_hours_ac_price', 'op.per_hours_price', 'op.hillsac_price', 'op.hillsnonac_price', 'op.below50kmhrcharge', 'op.below100kmhrcharge', 'op.above100kmhrcharge')
                        ->first();

                    if (! $package) {

                        $package = DB::table('packages as p')
                            ->join('outstation_package as op', function ($join) use ($cartype_id, $traveltype_id) {
                                $join->on('p.id', '=', 'op.package_id')
                                    ->where('op.cartype_id', $cartype_id)
                                    ->where('op.inout_type', $traveltype_id);
                            })
                            ->where('p.traveltype_id', $traveltype_id)
                            ->orderBy('p.km', 'asc')
                            ->select('p.id as package_id', 'p.km as included_km', 'p.free_hours as free_hours', 'op.ac_price', 'op.additionalperkm_ac_price', 'op.additionalperkm_nonac_price', 'op.nonac_price', 'op.local_type', 'op.per_hours_ac_price', 'op.per_hours_price', 'op.hillsac_price', 'op.hillsnonac_price', 'op.below50kmhrcharge', 'op.below100kmhrcharge', 'op.above100kmhrcharge')
                            ->first();

                    }

                    if ($package && $package->local_type == 2 && $travelled_time_in_min > $setting->localtripmaxmin) {
                        $package = DB::table('packages as p')
                            ->join('outstation_package as op', function ($join) use ($cartype_id, $traveltype_id) {
                                $join->on('p.id', '=', 'op.package_id')
                                    ->where('op.cartype_id', $cartype_id)
                                    ->where('op.inout_type', $traveltype_id);
                            })
                            ->where('p.traveltype_id', $traveltype_id)
                            ->where('op.local_type', '!=', 2)
                            ->orderBy('p.km', 'asc')
                            ->select('p.id as package_id', 'p.km as included_km', 'p.free_hours as free_hours', 'op.ac_price', 'op.additionalperkm_ac_price', 'op.additionalperkm_nonac_price', 'op.nonac_price', 'op.local_type', 'op.per_hours_ac_price', 'op.per_hours_price', 'op.hillsac_price', 'op.hillsnonac_price', 'op.below50kmhrcharge', 'op.below100kmhrcharge', 'op.above100kmhrcharge')
                            ->first();
                    } else if ($traveltype_id == 1) {
                        $maxindoorPack = DB::table('packages as p')
                            ->join('outstation_package as op', function ($join) use ($cartype_id, $traveltype_id) {
                                $join->on('p.id', '=', 'op.package_id')
                                    ->where('op.cartype_id', $cartype_id)
                                    ->where('op.inout_type', $traveltype_id);
                            })->max('p.km');
                        // dd($maxindoorPack);
                    }

                    DB::table('booking_management')->where('id', $bookingId)->update(['package_id' => $package->package_id, 'traveltype_id' => $traveltype_id]);

                    $rate             = $booking->ac_type === 'AC' ? $package->ac_price : $package->nonac_price;
                    $additionalKMrate = $booking->ac_type === 'AC' ? $package->additionalperkm_ac_price : $package->additionalperkm_nonac_price;
                    $additionalhrrate = $booking->ac_type === 'AC' ? $package->per_hours_ac_price : $package->per_hours_price;
                    $includedKm       = $package->included_km;
                    $includedHr       = $package->free_hours;
                    $extraKm          = max(0, $traveledKm - $includedKm);
                    $extrahrs         = 0;

                    $baseFare      = $rate;
                    $extraKmFare   = $additionalKMrate * $extraKm;
                    $hrcharge      = 0;
                    $extrahrcharge = 0;
                    $perhrcharge   = 0;
                    if ($travelled_time_in_hr > $includedHr) {
                        $extrahrs = max(0, $travelled_time_in_hr - $includedHr);

                        // $extrahrs = ceil($travelled_time_in_hr - $includedHr);

                        if ($traveltype_id == 2) {
                            if ($traveledKm > 100) {
                                $perhrcharge = $package->above100kmhrcharge;
                            } elseif ($traveledKm >= 51) {
                                $perhrcharge = $package->below100kmhrcharge;
                            } else {
                                $perhrcharge = $package->below50kmhrcharge;
                            }
                        } else {
                            $perhrcharge = $package->per_hours_price;
                        }
                        $extrahrcharge = $extrahrs * $perhrcharge;

                    }

                    $waitingcharge = 0;
                    if ($package->local_type == 2) {
                        $extrahrcharge        = 0;
                        $isMinutes            = true;
                        $allowedwaitingmin    = $traveledKm * $setting->waitingminperkm;
                        $estimatedtime_to_min = $travelled_time_in_hr * 60;
                        if ($estimatedtime_to_min > $allowedwaitingmin) {
                            $waitingcharge = max(0, $estimatedtime_to_min - $allowedwaitingmin) * $setting->waitingchargepermin;
                        }
                    }

                    // todo
                    /*
                    $hills calculate + price add
                    */
                    $totalCost = $baseFare + $extraKmFare + $extrahrcharge + $waitingcharge + $extraFare;

                    $totalCost = $totalCost - $extraDiscount;
                    $result    = ['package_id' => $package->package_id,
                        'package_km'               => $includedKm,
                        'amount'                   => $totalCost,
                        'additional_kmrate'        => $additionalKMrate,
                        'additionalperhrrate'      => $perhrcharge,
                        'totalKm'                  => $traveledKm,
                        'baseKm'                   => $includedKm,
                        'extraKm'                  => $extraKm,
                        'totalTime'                => $travelled_time_in_hr,
                        'freehours'                => $includedHr,
                        'baseFare'                 => $baseFare,
                        'extraFare'                => $extraFare,
                        'extraKmFare'              => $extraKmFare,
                        'extraHourFare'            => $extrahrcharge,
                        'waitingcharge'            => $waitingcharge,
                        'extraDiscount'            => $extraDiscount,
                        'is_minutes'               => $isMinutes ? 1 : 0,
                    ];
                    return $result;

                } else {
                    echo "tripInfo error";
                    exit();
                }

            } else {
                echo "otp error";
                exit();
            }

        } else {
            echo "otp error";
            exit();
        }

        //     if ($otpRecord && $otpRecord->start_km !== null && $otpRecord->end_km !== null) {
        //         $actualKm = floatval($otpRecord->end_km) - floatval($otpRecord->start_km);

        //     }
        //     if ($otpRecord && $otpRecord->start_date !== null && $otpRecord->end_date !== null) {
        //         $start           = \Carbon\Carbon::parse($otpRecord->start_date);
        //         $end             = \Carbon\Carbon::parse($otpRecord->end_date);
        //         $actualTimeInMin = $end->diffInMinutes($start);
        //         $actualTime      = $actualTimeInMin / 60;

        //     }
        //     $package = DB::table('packages as p')
        //         ->join('outstation_package as op', function ($join) use ($data) {
        //             $join->on('p.id', '=', 'op.package_id')
        //                 ->where('op.cartype_id', $data['cartype_id'])
        //                 ->where('op.inout_type', $data['traveltype_id']);
        //         })
        //         ->where('p.traveltype_id', $data['traveltype_id'])
        //         ->where('p.km', '<=', $actualKm)
        //         ->orderBy('p.km', 'desc')
        //         ->select('p.id as package_id', 'p.km as included_km', 'p.free_hours as free_hours', 'op.ac_price', 'op.additionalperkm_ac_price', 'op.additionalperkm_nonac_price', 'op.nonac_price', 'op.local_type')
        //         ->first();

        //     if (! $package) {

        //         $package = DB::table('packages as p')
        //             ->join('outstation_package as op', function ($join) use ($data) {
        //                 $join->on('p.id', '=', 'op.package_id')
        //                     ->where('op.cartype_id', $data['cartype_id'])
        //                     ->where('op.inout_type', $data['traveltype_id']);
        //             })
        //             ->where('p.traveltype_id', $data['traveltype_id'])
        //             ->orderBy('p.km', 'asc')
        //             ->select('p.id as package_id', 'p.km as included_km', 'p.free_hours as free_hours', 'op.ac_price', 'op.additionalperkm_ac_price', 'op.additionalperkm_nonac_price', 'op.nonac_price', 'op.local_type')
        //             ->first();

        //     }
        //     if ($package->local_type == 2 && $actualTime > $setting->localtripmaxmin) {
        //         $isMinutes = false;

        //         // Treat estimated_time as minutes if less than 1 hour
        //         $estimated_minutes = $actualTime;
        //         if ($actualTime < 1) {
        //             $isMinutes         = true;
        //             $estimated_minutes = $actualTime * 60; // Convert to minutes
        //         }

        //         $baseFare     = 100; // ₹100 up to 3km
        //         $additionalKm = max(0, $actualKm - 3);

        //         $additionalRate = $data['ac_type'] === 'AC' ? 22 : 20;
        //         $extraFare      = $additionalKm * $additionalRate;

        //                                                  // estimated_time is considered in minutes directly
        //         $waitingcharge = $estimated_minutes * 2; // ₹2 per minute

        //         $totalCost = $baseFare + $extraFare + $waitingcharge;

        //         return [
        //             'package_id'          => $package->package_id,
        //             'amount'              => $totalCost,
        //             'additional_kmrate'   => $additionalRate,
        //             'additionalperhrrate' => 0,
        //             'extraKm'             => $additionalKm,
        //             'waitingcharge'       => $waitingcharge,
        //             'baseFare'            => $baseFare,
        //             'extraFare'           => $extraFare,
        //             'hrcharge'            => 0,

        //         ];
        //     }

        //     $rate             = $data['ac_type'] === 'AC' ? $package->ac_price : $package->nonac_price;
        //     $additionalKMrate = $data['ac_type'] === 'AC' ? $package->additionalperkm_ac_price : $package->additionalperkm_nonac_price;
        //     $additionalhrrate = $data['ac_type'] === 'AC' ? $package->additionalperkm_ac_price : $package->additionalperkm_nonac_price;
        //     $includedKm       = $package->included_km;
        //     $extraKm          = max(0, $actualKm - $includedKm);

        //     $baseFare  = $rate;
        //     $extraFare = $additionalKMrate * $extraKm;
        //     $hrcharge  = 0;
        //     if ($actualTime > $package->free_hours) {
        //         $extrahrs = max(0, $actualTime - $package->free_hours);
        //         if ($data['traveltype_id'] == 2) {
        //             $hrcharge = 0;
        //             if ($actualKm > 100) {
        //                 $hrcharge = $package->above100kmhrcharge;
        //             } elseif ($actualKm >= 51) {
        //                 $hrcharge = $package->below100kmhrcharge;
        //             } else {
        //                 $hrcharge = $package->below50kmhrcharge;
        //             }
        //         } else {
        //             $hrcharge = $package->per_hours_price;
        //         }
        //     }
        //     $waitingcharge = 0;
        //     if ($package->local_type == 2) {
        //         $allowedwaitingmin    = $includedKm * $setting->waitingminperkm;+
        //         $estimatedtime_to_min = $actualTime * 60;
        //         if ($estimatedtime_to_min > $allowedwaitingmin) {
        //             $waitingcharge = max(0, $estimatedtime_to_min - $allowedwaitingmin) * $setting->waitingchargepermin;
        //         }
        //     }

        //     $totalCost = $baseFare + $extraFare + $hrcharge + $waitingcharge;

        //     return [
        //         'package_id'          => $package->package_id,
        //         'amount'              => $totalCost,
        //         'additional_kmrate'   => $additionalKMrate,
        //         'additionalperhrrate' => $additionalhrrate,
        //         'extraKm'             => $extraKm,
        //         'waitingcharge'       => $waitingcharge,
        //         'baseFare'            => $baseFare,
        //         'extraFare'           => $extraFare,
        //         'hrcharge'            => $hrcharge,
        //         'is_minutes'          => 0,
        //     ];

        // }
    }
    private function sendBookingSummary($bookingId)
    {
        $booking     = DB::table('booking_management')->where('id', $bookingId)->first();
        $fareSummary = DB::table('fare_summaries')->where('booking_id', $bookingId)->first();
        $otp         = DB::table('otp_codes')->where('booking_id', $bookingId)->first();

        if ($booking && $fareSummary) {
            $customerPhone = $booking->phone;
            $driver        = DB::table('driver_management')->where('id', $booking->driver_id)->first();
            $driverPhone   = $driver->user_name ?? null;

            $message = "*Vaigai Namma Taxi Ride Summary*\n"
                . "Customer: {$booking->customer_name}\n"
                . "From: {$booking->from_address}\n"
                . "To: {$booking->to_address}\n"
                . "Trip Start KM: " . ($otp->start_km ?? '-') . "\n"
                . "Trip End KM: " . ($otp->end_km ?? '-') . "\n"
                . "Total KM Travelled: {$fareSummary->total_km_travelled} KM\n"
                . "Travel Time: {$fareSummary->travel_minutes}\n"
                . "Extra Fare: ₹{$fareSummary->extra_fair}\n"
                . "Discount: ₹{$fareSummary->extra_discountamount}\n"
                . "Hills Fare: ₹{$fareSummary->hills_fare}\n"
                . "Final Total: ₹{$fareSummary->total_price}\n\n"
                . "Thank you for choosing VaigaiNamma Taxi!";

            if (! empty($customerPhone)) {
                $this->sendWelcomeSms($customerPhone, 'text', $message);
            }

            if (! empty($driverPhone)) {
                $this->sendWelcomeSms($driverPhone, 'text', $message);
            }
        }
    }

    public function calculateFare($bookingId, $driverId)
    {
        $otp     = DB::table('otp_codes')->where('booking_id', $bookingId)->first();
        $booking = DB::table('booking_management')
            ->select('id', 'cartype_id', 'ac_type', 'traveltype_id', 'driver_id', 'package_id', 'phone', 'customer_name')
            ->where('id', $bookingId)
            ->first();

        if (! $otp || ! $booking) {
            throw new \Exception('Booking or OTP not found.');
        }

        $traveledKm    = round($otp->end_km - $otp->start_km, 2);
        $cartype_id    = $booking->cartype_id;
        $traveltype_id = $booking->traveltype_id;

        $setting = DB::table('settings')->where('id', 1)->first();

        $package = DB::table('packages as p')
            ->join('outstation_package as op', function ($join) use ($cartype_id, $traveltype_id) {
                $join->on('p.id', '=', 'op.package_id')
                    ->where('op.cartype_id', $cartype_id)
                    ->where('op.inout_type', $traveltype_id);
            })
            ->where('p.traveltype_id', $traveltype_id)
            ->orderBy('p.km', 'desc')
            ->first();

        if (! $package) {
            throw new \Exception('No package found.');
        }

        DB::table('booking_management')->where('id', $bookingId)->update(['package_id' => $package->package_id]);

        $startTime             = Carbon::parse($otp->created_at);
        $endTime               = Carbon::parse($otp->updated_at);
        $travelled_time_in_min = $endTime->diffInMinutes($startTime);
        $travelled_time_in_hr  = $travelled_time_in_min / 60;

        $rate             = $booking->ac_type === 'AC' ? $package->ac_price : $package->nonac_price;
        $additionalKMrate = $booking->ac_type === 'AC' ? $package->additionalperkm_ac_price : $package->additionalperkm_nonac_price;
        $includedKm       = $package->km;
        $includedHr       = $package->free_hours;

        $extraKm       = max(0, $traveledKm - $includedKm);
        $extraFare     = $additionalKMrate * $extraKm;
        $extrahrs      = max(0, $travelled_time_in_hr - $includedHr);
        $perhrcharge   = $package->per_hours_price;
        $extrahrcharge = $extrahrs * $perhrcharge;

        $totalCost = $rate + $extraFare + $extrahrcharge;

        return [
            'totalKm'        => $traveledKm,
            'baseKm'         => $includedKm,
            'extraKm'        => $extraKm,
            'baseFare'       => $rate,
            'extraKmFare'    => $extraFare,
            'extraHourFare'  => $extrahrcharge,
            'total_price'    => $totalCost,
            'start_time'     => $startTime->format('H:i:s'),
            'end_time'       => $endTime->format('H:i:s'),
            'travel_minutes' => $travelled_time_in_hr,
        ];
    }
    public function updateDriverTripSummary($driverId, $date)
    {

        $baseQuery = DB::table('fare_summaries')
            ->where('driver_id', $driverId)
            ->whereDate('end_date', $date);

        $totalPrice   = (clone $baseQuery)->sum('total_price');
        $num_of_trips = (clone $baseQuery)->count();

        $commissionPercentage = DB::table('settings')->value('commission_percentage') ?? 0;
        $commissionAmount     = round(($totalPrice * $commissionPercentage) / 100, 2);

        $trip = DB::table('trips')
            ->where('driver_id', $driverId)
            ->whereDate('trip_date', $date)
            ->first();

        if (! $trip) {
            // Insert new trip
            DB::table('trips')->insert([
                'driver_id'             => $driverId,
                'trip_date'             => $date,
                'amount'                => $totalPrice,
                'commission_percentage' => $commissionPercentage,
                'commission_amount'     => $commissionAmount,
                'trips_count'           => $num_of_trips,
                'paid_amount'           => 0,
                'pending_amount'        => $commissionAmount,
                'payment_status'        => 0,
                'created_at'            => now(),
                'updated_at'            => now(),
            ]);
        } else {
            $newPaymentStatus = 0;

            if ($trip->paid_amount == $commissionAmount) {
                $newPaymentStatus = 2; // Fully Paid
            } elseif ($trip->paid_amount > 0 && $trip->paid_amount < $commissionAmount) {
                $newPaymentStatus = 1; // Partially Paid
            }

            DB::table('trips')
                ->where('id', $trip->id)
                ->update([
                    'amount'                => $totalPrice,
                    'commission_percentage' => $commissionPercentage,
                    'commission_amount'     => $commissionAmount,
                    'trips_count'           => $num_of_trips,
                    'payment_status'        => $newPaymentStatus,
                    'updated_at'            => now(),
                ]);
        }
    }

    public function update(Request $request, $id)
    {
        try {

            DB::beginTransaction();

            $driver = DB::table('vehicle_management')->where('id', $id)->first();

            $updateData = [
                'carbrand_id'   => $request->car_brand,
                'car_model'     => $request->car_model,
                'cartype_id'    => $request->car_type,
                'fuel_type'     => $request->fuel_type,
                'seat_capacity' => $request->seat_capacity,
                'status'        => $request->status,
                'updated_at'    => now(),
            ];

            DB::table('vehicle_management')->where('id', $id)->update($updateData);

            DB::commit();

            return redirect()->route('admin.VehicleManagement-index')
                ->with('success', 'Vehicle updated successfully');
        } catch (\Exception $e) {
            DB::rollBack();
            return redirect()->back()
                ->with('error', 'Error updating driver: ' . $e->getMessage())
                ->withInput();
        }
    }

    public function show($id)
    {
        $getRow     = DB::table('booking_management')->where('id', $id)->first();
        $get_driver = DB::table('driver_management')->where('id', $getRow->driver_id)->first();

        return view('admin.booking_management.view', compact('getRow', 'get_driver'));

    }

    public function destroy($id)
    {
        try {
            DB::beginTransaction();

            $driver = DB::table('vehicle_management')->where('id', $id)->first();
            if (! $driver) {
                return response()->json(['status' => 404, 'message' => 'Driver not found']);
            }

            DB::table('vehicle_management')->where('id', $id)->delete();

            DB::commit();
            return response()->json(['status' => 200, 'message' => 'Deleted successfully']);
        } catch (\Exception $e) {
            DB::rollBack();
            return response()->json(['status' => 500, 'message' => 'Error: ' . $e->getMessage()]);
        }
    }

    public function updateStatus(Request $request)
    {
        $request->validate([
            'id'     => 'required|integer|exists:vehicle_management,id',
            'status' => 'required|boolean',
        ]);

        DB::table('vehicle_management')
            ->where('id', $request->id)
            ->update(['status' => $request->status, 'updated_at' => now()]);

        return response()->json(['message' => 'Status updated successfully']);
    }

    // public function getNearbyDrivers(Request $request)
    // {
    //     $request->validate([
    //         'latitude'  => 'required|numeric',
    //         'longitude' => 'required|numeric',
    //         'radius_km' => 'nullable|numeric',
    //     ]);

    //     $latitude  = $request->latitude;
    //     $longitude = $request->longitude;
    //     $radius    = $request->radius_km ?? 3; // Default to 3 km if not provided

    //     $drivers = DB::table('driver_management')
    //         ->where('online_status', '=', 'online')
    //         ->where('trip_status', 0)
    //         ->select('id', 'driver_name', 'latitude', 'longitude')
    //         ->selectRaw('(6371 * acos(cos(radians(?)) * cos(radians(latitude)) * cos(radians(longitude) - radians(?)) + sin(radians(?)) * sin(radians(latitude)))) AS distance', [$latitude, $longitude, $latitude])
    //         ->having('distance', '<=', $radius)
    //         ->get();

    //     return response()->json($drivers);
    // }

    public function getNearbyDrivers(Request $request)
    {
        // Step 1: Validate incoming request
        $request->validate([
            'latitude'  => 'required|numeric',
            'longitude' => 'required|numeric',
            'radius_km' => 'nullable|numeric',
        ]);

        $latitude  = $request->latitude;
        $longitude = $request->longitude;
        $radius    = $request->radius_km ?? 3; // default to 3km

        $driversQry = DB::table('driver_management')
            ->join('vehicle_management', 'driver_management.vehicle_id', '=', 'vehicle_management.id')
            ->where('online_status', 'online');

        if ($request->cartype_id) {
            $cartypeId = (int) $request->cartype_id;
            $driversQry->where('vehicle_management.cartype_id', $cartypeId);
        }

        // Step 2: Get all online & free drivers within the radius
        $drivers = $driversQry->where('trip_status', 0)
            ->whereNotNull('latitude')
            ->whereNotNull('longitude')
            ->selectRaw('
            (6371 * acos(
                cos(radians(?)) * cos(radians(latitude)) *
                cos(radians(longitude) - radians(?)) +
                sin(radians(?)) * sin(radians(latitude))
            )) AS distance,driver_management.id, driver_name, latitude, longitude, user_name, vehicle_id, driver_code, car_model', [$latitude, $longitude, $latitude])
            ->having('distance', '<=', $radius)
            ->orderBy('distance')
            ->get();

        return response()->json($drivers);
    }

    public function getAllOnlineDrivers(Request $request)
    {
        // Step 1: Validate incoming request
        $request->validate([
            'radius_km' => 'nullable|numeric',
        ]);

        $driversQry = DB::table('driver_management')
            ->join('vehicle_management', 'driver_management.vehicle_id', '=', 'vehicle_management.id')
            ->where('online_status', 'online');

        if ($request->cartype_id) {
            $cartypeId = (int) $request->cartype_id;
            $driversQry->where('vehicle_management.cartype_id', $cartypeId);
        }

        // Step 2: Get all online
        $drivers = $driversQry->where('trip_status', 0)
            ->whereNotNull('latitude')
            ->whereNotNull('longitude')
            ->get();

        return response()->json($drivers);
    }

    public function getEstimatedAmountAndPackage(array $data): array
    {
        $setting = DB::table('settings')->where('id', 1)->first();
        $package = DB::table('packages as p')
            ->join('outstation_package as op', function ($join) use ($data) {
                $join->on('p.id', '=', 'op.package_id')
                    ->where('op.cartype_id', $data['cartype_id'])
                    ->where('op.inout_type', $data['traveltype_id']);
            })
            ->where('p.traveltype_id', $data['traveltype_id'])
            ->where('p.km', '<=', $data['estimated_km'])
            ->orderBy('p.km', 'desc')
            ->select('p.id as package_id', 'p.km as included_km', 'p.free_hours as free_hours', 'op.ac_price', 'op.additionalperkm_ac_price', 'op.additionalperkm_nonac_price', 'op.nonac_price', 'op.local_type', 'op.per_hours_ac_price', 'op.per_hours_price', 'op.below50kmhrcharge', 'op.below100kmhrcharge', 'op.above100kmhrcharge')
            ->first();

        if (! $package) {

            $package = DB::table('packages as p')
                ->join('outstation_package as op', function ($join) use ($data) {
                    $join->on('p.id', '=', 'op.package_id')
                        ->where('op.cartype_id', $data['cartype_id'])
                        ->where('op.inout_type', $data['traveltype_id']);
                })
                ->where('p.traveltype_id', $data['traveltype_id'])
                ->orderBy('p.km', 'asc')
                ->select('p.id as package_id', 'p.km as included_km', 'p.free_hours as free_hours', 'op.ac_price', 'op.additionalperkm_ac_price', 'op.additionalperkm_nonac_price', 'op.nonac_price', 'op.local_type', 'op.per_hours_ac_price', 'op.per_hours_price', 'op.below50kmhrcharge', 'op.below100kmhrcharge', 'op.above100kmhrcharge')
                ->first();

        }

        if (! $package) {
            return [];
        }

        $isMinutes = false;

        $rate             = $data['ac_type'] === 'AC' ? $package->ac_price : $package->nonac_price;
        $additionalKMrate = $data['ac_type'] === 'AC' ? $package->additionalperkm_ac_price : $package->additionalperkm_nonac_price;
        $additionalhrrate = $data['ac_type'] === 'AC' ? $package->per_hours_ac_price : $package->per_hours_price;
        $includedKm       = $package->included_km;
        $includedHr       = $package->free_hours;
        $extraKm          = max(0, $data['estimated_km'] - $includedKm);
        $extrahrs         = 0;

        $baseFare      = $rate;
        $extraFare     = $additionalKMrate * $extraKm;
        $hrcharge      = 0;
        $extrahrcharge = 0;
        $perhrcharge   = 0;
        if ($data['estimated_time'] > $includedHr) {
            $extrahrs = max(0, $data['estimated_time'] - $includedHr);
            if ($data['traveltype_id'] == 2) {
                if ($data['estimated_km'] > 100) {
                    $perhrcharge = $package->above100kmhrcharge;
                } elseif ($data['estimated_km'] >= 51) {
                    $perhrcharge = $package->below100kmhrcharge;
                } else {
                    $perhrcharge = $package->below50kmhrcharge;
                }
            } else {
                $perhrcharge = $package->per_hours_price;
            }
            $extrahrcharge = $extrahrs * $perhrcharge;
        }
        $waitingcharge = 0;
        if ($package->local_type == 2) {
            $extrahrcharge        = 0;
            $isMinutes            = true;
            $allowedwaitingmin    = $data['estimated_km'] * $setting->waitingminperkm;
            $estimatedtime_to_min = $data['estimated_time'] * 60;
            if ($estimatedtime_to_min > $allowedwaitingmin) {
                $waitingcharge = max(0, $estimatedtime_to_min - $allowedwaitingmin) * $setting->waitingchargepermin;
            }
        }

        $totalCost = $baseFare + $extraFare + $hrcharge + $waitingcharge;

        return [
            'package_id'          => $package->package_id,
            'amount'              => $totalCost,
            'additional_kmrate'   => $additionalKMrate,
            'additionalperhrrate' => $perhrcharge,
            'totalKm'             => $data['estimated_km'],
            'baseKm'              => $includedKm,
            'extraKm'             => $extraKm,
            'totalTime'           => $data['estimated_time'],
            'freehours'           => $includedHr,
            'baseFare'            => $baseFare,
            'extraKmFare'         => $extraFare,
            'extraHourFare'       => $extrahrcharge,
            'waitingcharge'       => $waitingcharge,
            'is_minutes'          => $isMinutes ? 1 : 0,
        ];
    }
    // For sending WhatsApp API

    public function sendOtp(Request $request)
    {
        $booking = DB::table('booking_management as bm')
            ->join('driver_management as dm', 'bm.driver_id', '=', 'dm.id')
            ->join('otp_codes as oc', 'bm.id', '=', 'oc.booking_id')
            ->where('bm.id', $request->booking_id)
            ->select('bm.phone', 'oc.otp')
            ->first();

        if (! $booking) {
            return response()->json(['status' => false, 'message' => 'Booking or OTP not found']);
        }

        $message = "Your ride OTP is: {$booking->otp}";

        // ✅ Send the message
        $x = $this->sendWelcomeSms($booking->phone, 'text', $message);

        // ✅ Optional: log or inspect $x if needed

        return response()->json(['status' => true, 'message' => 'OTP sent successfully']);
    }
    public function cancelRide1(Request $request)
    {
        $request->validate([
            'booking_id'    => 'required|exists:booking_management,id',
            'cancel_reason' => 'required|string|max:255',
        ]);

        DB::table('booking_management')
            ->where('id', $request->booking_id)
            ->update([
                'booking_status' => 5,
                'cancel_reason'  => $request->cancel_reason,
                'updated_at'     => now(),
            ]);

        return response()->json([
            'status'  => true,
            'message' => 'Ride has been cancelled successfully.',
        ]);
    }
    public function cancelRide(Request $request)
    {
        $request->validate([
            'booking_id'    => 'required|exists:booking_management,id',
            'cancel_reason' => 'required|string|max:255',
        ]);

        $booking = DB::table('booking_management')->where('id', $request->booking_id)->first();

        if (! $booking) {
            return response()->json([
                'status'  => false,
                'message' => 'Booking not found.',
            ], 404);
        }

        // Prevent double cancellation
        if ($booking->booking_status == 5) {
            return response()->json([
                'status'  => false,
                'message' => 'This ride is already cancelled.',
            ], 400);
        }

        // Update booking as cancelled
        DB::table('booking_management')
            ->where('id', $request->booking_id)
            ->update([
                'booking_status' => 5, // assuming 5 = Cancelled
                'cancel_reason'  => $request->cancel_reason,
                'updated_at'     => now(),
            ]);
        DB::table('driver_management')
            ->where('id', $booking->driver_id)
            ->update([
                'trip_status' => 0,

            ]);
        $driver = DB::table('driver_management')->where('id', $booking->driver_id)->first();

        if ($driver && $driver->firebase_token) {
            try {
                $this->sendPushNotification($driver->firebase_token, [
                    'title' => 'Ride Cancelled',
                    'body'  => 'Your ride has been cancelled by the admin.',
                    'data'  => [
                        'booking_id' => $request->booking_id,
                        'type'       => 'ride_cancelled',
                    ],
                ]);
            } catch (\Exception $e) {
                Log::error("FCM Error during cancelRide: " . $e->getMessage());
            }
        }

        return response()->json([
            'status'  => true,
            'message' => 'Ride has been cancelled successfully.',
        ]);
    }

    public function getSingleRow(Request $request)
    {
        $bookingId = $request->booking_id;

        $row = DB::table('booking_management')
            ->leftJoin('driver_management', 'booking_management.driver_id', '=', 'driver_management.id')
            ->leftJoin('otp_codes', 'booking_management.id', '=', 'otp_codes.booking_id')
            ->select(
                'booking_management.id',
                'driver_management.driver_name as DriverName',
                'driver_management.online_status',
                'otp_codes.otp'
            )
            ->where('booking_management.id', $bookingId)
            ->first();

        if ($row) {
            return response()->json(['status' => true, 'data' => $row]);
        } else {
            return response()->json(['status' => false, 'message' => 'Booking not found.']);
        }
    }

    public function getOnlineDrivers()
    {
        $drivers = DB::table('driver_management')
            ->where('online_status', true)
            ->where('trip_status', 0)
            ->select('id', 'driver_name', 'latitude', 'longitude')
            ->get();

        return response()->json($drivers);
    }

    // public function getEstimatedAmountAndPackage1(array $data): array
    // {
    //     $setting = DB::table('settings')->where('id', 1)->first();

    //     $package = DB::table('packages as p')
    //         ->join('outstation_package as op', function ($join) use ($data) {
    //             $join->on('p.id', '=', 'op.package_id')
    //                 ->where('op.cartype_id', $data['cartype_id'])
    //                 ->where('op.inout_type', $data['traveltype_id']);
    //         })
    //         ->where('p.traveltype_id', $data['traveltype_id'])
    //         ->where('p.km', '<=', $data['estimated_km'])
    //         ->orderBy('p.km', 'desc')
    //         ->select(
    //             'p.id as package_id',
    //             'p.km as included_km',
    //             'p.free_hours as free_hours',
    //             'op.ac_price',
    //             'op.additionalperkm_ac_price',
    //             'op.additionalperkm_nonac_price',
    //             'op.nonac_price',
    //             'op.local_type'
    //         )
    //         ->first();

    //     if (! $package) {
    //         $package = DB::table('packages as p')
    //             ->join('outstation_package as op', function ($join) use ($data) {
    //                 $join->on('p.id', '=', 'op.package_id')
    //                     ->where('op.cartype_id', $data['cartype_id'])
    //                     ->where('op.inout_type', $data['traveltype_id']);
    //             })
    //             ->where('p.traveltype_id', $data['traveltype_id'])
    //             ->orderBy('p.km', 'asc')
    //             ->select(
    //                 'p.id as package_id',
    //                 'p.km as included_km',
    //                 'p.free_hours as free_hours',
    //                 'op.ac_price',
    //                 'op.additionalperkm_ac_price',
    //                 'op.additionalperkm_nonac_price',
    //                 'op.nonac_price',
    //                 'op.local_type'
    //             )
    //             ->first();
    //     }

    //     // ✅ Custom rule for short local ride < 10 km
    //     if ($package->local_type == 2 && $data['estimated_km'] < 10) {
    //         $baseFare     = 100; // ₹100 up to 3km
    //         $additionalKm = max(0, $data['estimated_km'] - 3);

    //         $additionalRate = $data['ac_type'] === 'AC' ? 22 : 20;
    //         $extraFare      = $additionalKm * $additionalRate;

    //                                                       // estimated_time is considered in minutes directly
    //         $waitingcharge = $data['estimated_time'] * 2; // ₹2 per minute

    //         $totalCost = $baseFare + $extraFare + $waitingcharge;

    //         return [
    //             'package_id'          => $package->package_id,
    //             'amount'              => $totalCost,
    //             'additional_kmrate'   => $additionalRate,
    //             'additionalperhrrate' => 0,
    //             'extraKm'             => $additionalKm,
    //             'waitingcharge'       => $waitingcharge,
    //             'baseFare'           => $baseFare,
    //             'extraFare'           => $extraFare,
    //             'hrcharge'            => 0,
    //         ];
    //     }

    //     // ✅ Normal estimation logic (as in your original code)
    //     $rate             = $data['ac_type'] === 'AC' ? $package->ac_price : $package->nonac_price;
    //     $additionalKMrate = $data['ac_type'] === 'AC' ? $package->additionalperkm_ac_price : $package->additionalperkm_nonac_price;
    //     $additionalhrrate = $data['ac_type'] === 'AC' ? $package->additionalperkm_ac_price : $package->additionalperkm_nonac_price;
    //     $includedKm       = $package->included_km;
    //     $extraKm          = max(0, $data['estimated_km'] - $includedKm);

    //     $baseFare  = $rate;
    //     $extraFare = $additionalKMrate * $extraKm;
    //     $hrcharge  = 0;

    //     if ($data['estimated_time'] > $package->free_hours) {
    //         $extrahrs = max(0, $data['estimated_time'] - $package->free_hours);
    //         if ($data['traveltype_id'] == 2) {
    //             if ($data['estimated_km'] > 100) {
    //                 $hrcharge = $package->above100kmhrcharge ?? 0;
    //             } elseif ($data['estimated_km'] >= 51) {
    //                 $hrcharge = $package->below100kmhrcharge ?? 0;
    //             } else {
    //                 $hrcharge = $package->below50kmhrcharge ?? 0;
    //             }
    //         } else {
    //             $hrcharge = $package->per_hours_price ?? 0;
    //         }
    //     }

    //     $waitingcharge = 0;
    //     if ($package->local_type == 2) {
    //         $allowedwaitingmin    = $includedKm * $setting->waitingminperkm;
    //         $estimatedtime_to_min = $data['estimated_time'] * 60;
    //         if ($estimatedtime_to_min > $allowedwaitingmin) {
    //             $waitingcharge = max(0, $estimatedtime_to_min - $allowedwaitingmin) * $setting->waitingchargepermin;
    //         }
    //     }

    //     $totalCost = $baseFare + $extraFare + $hrcharge + $waitingcharge;

    //     return [
    //         'package_id'          => $package->package_id,
    //         'amount'              => $totalCost,
    //         'additional_kmrate'   => $additionalKMrate,
    //         'additionalperhrrate' => $additionalhrrate,
    //         'extraKm'             => $extraKm,
    //         'waitingcharge'       => $waitingcharge,
    //         'baseFare'           => $baseFare,
    //         'extraFare'           => $extraFare,
    //         'hrcharge'            => $hrcharge,
    //         'is_minutes'          => 0,
    //     ];
    // }

    public function getEndrideAmountAndPackage(Request $request, array $data)
    {
        $setting         = DB::table('settings')->where('id', 1)->first();
        $bookingId       = $request->booking_id;
        $bookingId       = $data['booking_id'];
        $actualKm        = 0;
        $actualTime      = 0;
        $actualTimeInMin = 0;
        if ($bookingId > 0) {
            $otpRecord = DB::table('otp_codes')
                ->where('booking_id', $bookingId)
                ->select('start_km', 'end_km', 'driver_id', 'booking_id', 'start_date', 'end_date')
                ->first();

            if ($otpRecord && $otpRecord->start_km !== null && $otpRecord->end_km !== null) {
                $actualKm = floatval($otpRecord->end_km) - floatval($otpRecord->start_km);

            }
            if ($otpRecord && $otpRecord->start_date !== null && $otpRecord->end_date !== null) {
                $start           = \Carbon\Carbon::parse($otpRecord->start_date);
                $end             = \Carbon\Carbon::parse($otpRecord->end_date);
                $actualTimeInMin = $end->diffInMinutes($start);
                $actualTime      = $actualTimeInMin / 60;

            }
            $package = DB::table('packages as p')
                ->join('outstation_package as op', function ($join) use ($data) {
                    $join->on('p.id', '=', 'op.package_id')
                        ->where('op.cartype_id', $data['cartype_id'])
                        ->where('op.inout_type', $data['traveltype_id']);
                })
                ->where('p.traveltype_id', $data['traveltype_id'])
                ->where('p.km', '<=', $actualKm)
                ->orderBy('p.km', 'desc')
                ->select('p.id as package_id', 'p.km as included_km', 'p.free_hours as free_hours', 'op.ac_price', 'op.additionalperkm_ac_price', 'op.additionalperkm_nonac_price', 'op.nonac_price', 'op.local_type')
                ->first();

            if (! $package) {

                $package = DB::table('packages as p')
                    ->join('outstation_package as op', function ($join) use ($data) {
                        $join->on('p.id', '=', 'op.package_id')
                            ->where('op.cartype_id', $data['cartype_id'])
                            ->where('op.inout_type', $data['traveltype_id']);
                    })
                    ->where('p.traveltype_id', $data['traveltype_id'])
                    ->orderBy('p.km', 'asc')
                    ->select('p.id as package_id', 'p.km as included_km', 'p.free_hours as free_hours', 'op.ac_price', 'op.additionalperkm_ac_price', 'op.additionalperkm_nonac_price', 'op.nonac_price', 'op.local_type')
                    ->first();

            }
            if ($package->local_type == 2 && $actualTime > $setting->localtripmaxmin) {
                $isMinutes = false;

                // Treat estimated_time as minutes if less than 1 hour
                $estimated_minutes = $actualTime;
                if ($actualTime < 1) {
                    $isMinutes         = true;
                    $estimated_minutes = $actualTime * 60; // Convert to minutes
                }

                $baseFare     = 100; // ₹100 up to 3km
                $additionalKm = max(0, $actualKm - 3);

                $additionalRate = $data['ac_type'] === 'AC' ? 22 : 20;
                $extraFare      = $additionalKm * $additionalRate;

                                                         // estimated_time is considered in minutes directly
                $waitingcharge = $estimated_minutes * 2; // ₹2 per minute

                $totalCost = $baseFare + $extraFare + $waitingcharge;

                return [
                    'package_id'          => $package->package_id,
                    'amount'              => $totalCost,
                    'additional_kmrate'   => $additionalRate,
                    'additionalperhrrate' => 0,
                    'extraKm'             => $additionalKm,
                    'waitingcharge'       => $waitingcharge,
                    'baseFare'            => $baseFare,
                    'extraFare'           => $extraFare,
                    'hrcharge'            => 0,

                ];
            }

            $rate             = $data['ac_type'] === 'AC' ? $package->ac_price : $package->nonac_price;
            $additionalKMrate = $data['ac_type'] === 'AC' ? $package->additionalperkm_ac_price : $package->additionalperkm_nonac_price;
            $additionalhrrate = $data['ac_type'] === 'AC' ? $package->additionalperkm_ac_price : $package->additionalperkm_nonac_price;
            $includedKm       = $package->included_km;
            $extraKm          = max(0, $actualKm - $includedKm);

            $baseFare  = $rate;
            $extraFare = $additionalKMrate * $extraKm;
            $hrcharge  = 0;
            if ($actualTime > $package->free_hours) {
                $extrahrs = max(0, $actualTime - $package->free_hours);
                if ($data['traveltype_id'] == 2) {
                    $hrcharge = 0;
                    if ($actualKm > 100) {
                        $hrcharge = $package->above100kmhrcharge;
                    } elseif ($actualKm >= 51) {
                        $hrcharge = $package->below100kmhrcharge;
                    } else {
                        $hrcharge = $package->below50kmhrcharge;
                    }
                } else {
                    $hrcharge = $package->per_hours_price;
                }
            }
            $waitingcharge = 0;
            if ($package->local_type == 2) {
                $allowedwaitingmin    = $includedKm * $setting->waitingminperkm;+
                $estimatedtime_to_min = $actualTime * 60;
                if ($estimatedtime_to_min > $allowedwaitingmin) {
                    $waitingcharge = max(0, $estimatedtime_to_min - $allowedwaitingmin) * $setting->waitingchargepermin;
                }
            }

            $totalCost = $baseFare + $extraFare + $hrcharge + $waitingcharge;

            return [
                'package_id'          => $package->package_id,
                'amount'              => $totalCost,
                'additional_kmrate'   => $additionalKMrate,
                'additionalperhrrate' => $additionalhrrate,
                'extraKm'             => $extraKm,
                'waitingcharge'       => $waitingcharge,
                'baseFare'            => $baseFare,
                'extraFare'           => $extraFare,
                'hrcharge'            => $hrcharge,
                'is_minutes'          => 0,
            ];
        }
    }

}
