<?php
namespace App\Http\Controllers\Admin;

use Carbon\Carbon;
use Illuminate\Support\Facades\DB;

class DashboardController extends ACommonController
{

    public function index()
    {
        $todayTrips = DB::table('trips')
            ->whereDate('trip_date', Carbon::today())
            ->count();

        // $totalAmount      = DB::table('trips')->sum('amount');
        // $commissionAmount = DB::table('trips')->sum('commission_amount');
        // $paidAmount       = DB::table('trips')->sum('paid_amount');

        $today = Carbon::today();

        $totalAmount = DB::table('trips')
            ->whereDate('trip_date', $today)
            ->sum('amount');

        $commissionAmount = DB::table('trips')
            ->whereDate('trip_date', $today)
            ->sum('commission_amount');

        $paidAmount = DB::table('trips')
            ->whereDate('trip_date', $today)
            ->sum('paid_amount');

        $upcomingTrips = DB::table('booking_management')
            ->whereDate('booking_date', '>', Carbon::today())
            ->count();

        $pastTrips = DB::table('trips')
            ->whereDate('trip_date', '<', Carbon::today())
            ->count();

        return view('admin.dashboard', compact(
            'todayTrips',
            'totalAmount',
            'commissionAmount',
            'paidAmount',
            'upcomingTrips',
            'pastTrips'
        ));
    }
}
