<?php
namespace App\Http\Controllers\Admin;

use App\Http\Controllers\Admin\ACommonController;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\DB;

class UserRoleController extends ACommonController
{

    private $page;
    private $querystring;

    public function __construct(Request $request)
    {
        $this->page        = $request->input('page', '1');
        $this->querystring = ['page' => $this->page];
    }

    public function list()
    {

        $recordToShow = 20;
        $querystring  = $this->querystring;

        $sel_roleList = DB::table('roles')->where('deleted_status', '0')->where('role_admin_show', '1')->pluck('name', 'id')->toArray();

        $assoc_roleList      = DB::table('roles')->pluck('name', 'id')->toArray();
        $assoc_roleList_json = json_encode($assoc_roleList);

        return view('admin.user_roles.list', compact('querystring', 'assoc_roleList_json', 'sel_roleList'));
    }

    public function add()
    {
        $menu_master_list = DB::table('backend_menu_managament')->whereRaw('FIND_IN_SET(?,role_ids)', ['3'])->where('show_menu', '1')->orderBy('title', 'asc')->get();

        return view('admin.user_roles.add', compact('menu_master_list'));
    }

    public function save(Request $request)
    {

        $dateTime    = date('Y-m-d H:i:s');
        $userId      = auth()->user()->id;
        $querystring = $this->querystring;

        $request->validate([
            'role_name' => 'required',
            'perm'      => 'required',
        ]);

        $role_name      = ($request->role_name != "") ? $request->role_name : "";
        $role_dashboard = ($request->role_dashboard > 0) ? $request->role_dashboard : 0;

        $perm   = ($request->perm) ? $request->perm : [];
        $status = ($request->status > 0) ? $request->status : 0;

        //$perm_impl = implode(",",$perm);

        $perm_serialize  = serialize($perm);
        $menu_master_arr = array_keys($perm);

        $new_menu_master_arr = $this->getParentMenuids($menu_master_arr);

        $menu_master_imp = implode(",", $new_menu_master_arr);

        /*$perm_table_arr = DB::table('permissions')->select('id',DB::raw("CONCAT(`menu_id`,'_',`type`) as type_id"))->pluck('id','type_id')->toArray();
        print_r($perm_table_arr);
        exit();*/
        $guard_name = "web";

        $insrec = DB::table('roles')->insertGetId(
            [

                'name'            => $role_name,
                'role_admin_show' => $status,
                'menu_perm'       => $menu_master_imp,
                'all_perm'        => $perm_serialize,
                'guard_name'      => $guard_name,
                'created_at'      => $dateTime,
                'updated_at'      => $dateTime,
                'created_by'      => $userId,
                'updated_by'      => $userId,
            ]
        );

        // dd($insrec);

        if ($insrec > 0) {

            // for log
            $log_msg   = "Role ID - " . $insrec . " - successfully created";
            $page_name = url()->current();
            $this->createlog($userId, $page_name, $log_msg);
            // for log

            $this->changerolepermission($perm, $insrec);
            return redirect()->route('admin.UserRoles-list', ['page' => $querystring['page']])->withSuccess('Record added successfully.');
        } else {
            return redirect()->route('admin.UserRoles-list', ['page' => $querystring['page']])->witherror('Error occurred.Please Try Again Later.');
        }

    }

    public function edit($id, Request $request)
    {

        $querystring = $this->querystring;

        $getRow = DB::table('roles')->where('deleted_status', '0')->where('id', $id)->first();

        if (isset($getRow) && ! empty($getRow)) {
            $assoc_roleList   = DB::table('roles')->where('role_admin_show', '1')->pluck('name', 'id')->toArray();
            $menu_master_list = DB::table('backend_menu_managament')->whereRaw('FIND_IN_SET(?,role_ids)', ['3'])->where('show_menu', '1')->orderBy('title', 'asc')->get();

            $selected_permarr     = explode(",", $getRow->menu_perm);
            $all_selected_permarr = unserialize($getRow->all_perm);

            // $dashboards_list = DB::table('roles_dashboards')->where('deleted_status', '0')->where('status', '1')->orderBy('table_order', 'asc')->get();

            return view('admin.user_roles.edit', compact('getRow', 'assoc_roleList', 'querystring', 'selected_permarr', 'all_selected_permarr', 'menu_master_list'));
        }

    }

    public function update(Request $request, $id)
    {

        $querystring = $this->querystring;
        $getRow      = DB::table('roles')->where('deleted_status', '0')->where('id', $id)->first();

        if (isset($getRow) && ! empty($getRow)) {

            $dateTime    = date('Y-m-d H:i:s');
            $userId      = auth()->user()->id;
            $querystring = $this->querystring;

            $request->validate([
                'role_name' => 'required',
                'perm'      => 'required',
            ]);

            $role_name      = ($request->role_name != "") ? $request->role_name : "";
            $role_dashboard = ($request->role_dashboard > 0) ? $request->role_dashboard : 0;
            $perm           = ($request->perm) ? $request->perm : [];
            $status         = ($request->status > 0) ? $request->status : 0;

            $perm_serialize = serialize($perm);

            $menu_master_arr = array_keys($perm);

            $new_menu_master_arr = $this->getParentMenuids($menu_master_arr);
            $menu_master_imp     = implode(",", $new_menu_master_arr);

            $updaterec = DB::table('roles')->where('deleted_status', '0')->where('id', $getRow->id)->update(
                [
                    'name'            => $role_name,
                    'role_dashboard'  => $role_dashboard,
                    'role_admin_show' => $status,
                    'menu_perm'       => $menu_master_imp,
                    'all_perm'        => $perm_serialize,
                    'updated_at'      => $dateTime,
                    'updated_by'      => $userId,
                ]
            );

            if ($updaterec > 0) {

                // for log
                $log_msg   = "Role ID - " . $getRow->id . " - successfully updated";
                $page_name = url()->current();
                $this->createlog($userId, $page_name, $log_msg);
                // for log

                $this->changerolepermission($perm, $getRow->id);

                return redirect()->route('admin.UserRoles-list', ['page' => $querystring['page']])->withSuccess('success', 'Record added successfully.');
            } else {
                return redirect()->route('admin.UserRoles-list', ['page' => $querystring['page']])->witherror('Error occurred.Please Try Again Later.');
            }
        } else {
            return redirect()->route('admin.UserRoles-list', ['page' => $querystring['page']])->witherror('Record not found.');
        }
    }

    public function view($id)
    {
        $getRow = DB::table('roles')->where('id', $id)->first();
        // dd($getRow);

        $assoc_roleList   = DB::table('roles')->where('role_admin_show', '1')->pluck('name', 'id')->toArray();
        $menu_master_list = DB::table('backend_menu_managament')->whereRaw('FIND_IN_SET(?,role_ids)', ['3'])->where('show_menu', '1')->orderBy('title', 'asc')->get();

        $selected_permarr     = explode(",", $getRow->menu_perm);
        $all_selected_permarr = unserialize($getRow->all_perm);

        return view('admin.user_roles.view', compact('getRow', 'assoc_roleList', 'selected_permarr', 'all_selected_permarr', 'menu_master_list'));

    }

    public function destroy($id)
    {
        $dateTime = date('Y-m-d H:i:s');
        $userId   = auth()->user()->id;

        if ($id > 0) {
            $getRow = DB::table('roles')->where('id', $id)->first();
            $delete = DB::table('roles')->where('deleted_status', '0')->where('id', $getRow->id)->update(
                [
                    'deleted_status' => 1,
                    'deleted_at'     => $dateTime,
                    'updated_at'     => $dateTime,
                    'updated_by'     => $userId,
                    'deleted_by'     => $userId,
                ]);

            // dd($delete);

            if ($delete > 0) {

                $msg = "Successfully updated";
                $sts = 200;
            } else {
                $msg = "Error occured.";
                $sts = 201;
            }
        } else {
            $msg = "Error occured.";
            $sts = 201;
        }
        $results = ["msg" => $msg, "status" => $sts];

        return response()->json($results);
    }

    public function changerolepermission($permissions, $roleid)
    {

        $dateTime = date('Y-m-d H:i:s');

        $perm_to_single_arr     = [];
        $perm_to_single_arr_def = [];
        foreach ($permissions as $menukey => $innrarray) {
            foreach ($innrarray as $processperm) {

                $menurow = DB::table('permissions')->where('menu_id', $menukey)->where('type', $processperm)->first();
                $newkey  = $menukey . "_" . $processperm;
                if ($menurow && $menurow->id) {
                    $perm_to_single_arr[$newkey] = $menurow->id;
                    $perm_to_single_arr_def[]    = $menurow->id;
                }

                if ($processperm == 2) {
                    $menurow = DB::table('permissions')->where('menu_id', $menukey)->where('type', 3)->first();
                    $newkey  = $menukey . "_3";
                    if ($menurow && $menurow->id) {
                        $perm_to_single_arr[$newkey] = $menurow->id;
                        $perm_to_single_arr_def[]    = $menurow->id;
                    }
                }
            }
        }

        $exist_rolepermids   = DB::table('roles_has_permissions')->where('role_id', $roleid)->count();
        $given_perm_idscount = count($perm_to_single_arr);

        if ($exist_rolepermids >= $given_perm_idscount) {

            $allexistpermrecords = DB::table('roles_has_permissions')->where('role_id', $roleid)->get();

            // echo "<pre>";
            // print_r($allexistpermrecords);
            // exit();

            foreach ($allexistpermrecords as $key => $allexistrow) {
                if ($key <= $given_perm_idscount - 1) {
                    $updateroleuser = DB::table('roles_has_permissions')->where('id', $allexistrow->id)->update(['permission_id' => $perm_to_single_arr_def[$key], 'role_id' => $roleid, 'updated_at' => $dateTime]);
                } else {
                    $deleteext = DB::table('roles_has_permissions')->where('id', $allexistrow->id)->delete();
                }
            }

        } else {
            $finalkey = 0;

            if ($exist_rolepermids > 0) {
                $allexistpermrecords = DB::table('roles_has_permissions')->where('role_id', $roleid)->get();

                // echo "<pre>";
                // print_r($allexistpermrecords);

                foreach ($allexistpermrecords as $key => $allexistrow) {
                    if ($key <= $given_perm_idscount - 1) {
                        $updateroleuser = DB::table('roles_has_permissions')->where('id', $allexistrow->id)->update(
                            ['permission_id' => $perm_to_single_arr_def[$key], 'role_id' => $roleid, 'updated_at' => $dateTime]);
                    } else {
                        $deleteext = DB::table('roles_has_permissions')->where('id', $allexistrow->id)->delete();
                    }
                }
                $finalkey = $key + 1;
            }

            for ($i = $finalkey; $i <= $given_perm_idscount - 1; $i++) {

                $insrec = DB::table('roles_has_permissions')->insertGetId(['permission_id' => $perm_to_single_arr_def[$i], 'role_id' => $roleid, 'created_at' => $dateTime, 'updated_at' => $dateTime]);
                // echo "<pre>";
                // print_r($insrec);
                // exit();

            }
        }

        return true;
    }

    public function getParentMenuids($arr)
    {
        $newarray = [];
        if (count($arr) > 0) {
            foreach ($arr as $arr_id) {
                $newarray[] = $arr_id;
                $parentarr  = $this->getParentsIdArrays($arr_id);
                if (count($parentarr) > 0) {
                    $newarray = array_merge($newarray, $parentarr);
                }
            }
        }
        return array_unique($newarray);
    }

    public function getParentsIdArrays($id, $frwdarray = [])
    {

        $getRow = DB::table('backend_menu_managament')->where('id', $id)->first();
        if ($getRow && $getRow->id && $getRow->id > 0) {

            if (($getRow->slug == null || $getRow->slug = "") || ($getRow->add_slug == null || $getRow->add_slug = "") || ($getRow->edit_slug == null || $getRow->edit_slug = "") || ($getRow->delete_slug == null || $getRow->delete_slug = "") || ($getRow->view_slug == null || $getRow->view_slug = "") || ($getRow->extra_slug == null || $getRow->extra_slug = "")) {
                $frwdarray[] = $getRow->id;
            }

            if ($getRow->p_id > 0) {

                return $this->getParentsIdArrays($getRow->p_id, $frwdarray);
            }
        }

        return array_unique($frwdarray);
    }

    public function dataindex(Request $request)
    {

        $recordsTotal    = 0;
        $recordsFiltered = 0;
        $draw            = $request->input('draw', '1');
        $start           = $request->input('start', '0');
        $length          = $request->input('length', '0');
        $columnsall      = $request->input('columns', []);
        $orderall        = $request->input('order', []);
        $dataResult      = [];
        $recordQry       = DB::table('roles')->where('role_admin_show', '1')->where('deleted_status', '0')->where('id', '>', '0');

        // dd($recordQry);

        foreach ($columnsall as $key => $column_row) {
            $isSearchable = $column_row['searchable'];
            $dbcolname    = $column_row['data'];
            $dbcolval     = $column_row['search']['value'];
            $dbcolval     = trim($dbcolval);

            if ($dbcolval != "" && $isSearchable && ! is_numeric($dbcolname)) {

                switch ($dbcolname) {
                    case 'name':
                        if ($dbcolval > 0) {

                            $recordQry->where(function ($query) use ($dbcolval) {

                                $query->orWhere('name', 'like', '%' . $dbcolval . '%');

                            });
                        }
                        break;

                    default:
                        $recordQry->where($dbcolname, 'like', '%' . $dbcolval . '%');
                        break;
                }

                //$recordListQry->where($dbcolname,$dbcolval);
            }
        }

        if ($orderall) {
            $ordtyp = $orderall[0]['dir'];
            if ($orderall[0]['column'] > 0) {
                $colsynt   = $orderall[0]['column'];
                $dbcolname = $columnsall[$colsynt]['data'];
                $recordQry->orderBy($dbcolname, $ordtyp);
            } else {
                $recordQry->orderBy('roles.id', $ordtyp);
            }
        }
        $recordAllQry = $recordQry;
        $recordsTotal = $recordAllQry->count();
        $recordList   = $recordQry->orderBy('roles.id', 'desc')
            ->offset($start)->limit($length)->get();
        $recordsFiltered = $recordList->count();
        $dataResult      = $recordList;
        return response()->json(["draw" => $draw, "recordsTotal" => $recordsTotal, "recordsFiltered" => $recordsTotal, "data" => $dataResult]);

    }

    public function listindex()
    {

        $recordToShow        = 20;
        $querystring         = $this->querystring;
        $sel_roleList        = DB::table('roles')->where('role_admin_show', '1')->pluck('name', 'id')->toArray();
        $assoc_roleList      = DB::table('roles')->pluck('name', 'id')->toArray();
        $assoc_roleList_json = json_encode($assoc_roleList);

        return view('admin.user_roles.example_list', compact('querystring', 'assoc_roleList_json', 'sel_roleList'));
    }

}
