<?php
namespace App\Http\Controllers\Admin;

use App\Http\Controllers\Admin\ACommonController;
use Carbon\Carbon;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Facades\Log;

class DriverTripsManagementController extends ACommonController
{
    public function dataindex(Request $request)
    {
        $recordsTotal    = 0;
        $recordsFiltered = 0;
        $draw            = $request->input('draw', '1');
        $start           = $request->input('start', '0');
        $length          = $request->input('length', '0');
        $columnsall      = $request->input('columns', []);
        $orderall        = $request->input('order', []);
        $dataResult      = [];
        $recordQry       = DB::table('booking_management')
            ->leftJoin('driver_management', 'booking_management.driver_id', '=', 'driver_management.id')
            ->leftJoin('otp_codes', 'booking_management.id', '=', 'otp_codes.booking_id')
            ->select(
                'booking_management.*',
                'driver_management.driver_name as DriverName',
            )
            ->whereNotIn('booking_management.booking_status', [4, 5]);
        $searchValue = $request->input('search.value');
        if (! empty($searchValue)) {
            $recordQry->where('driver_management.driver_name', 'like', '%' . $searchValue . '%');
        }
        if ($orderall) {
            $ordtyp = $orderall[0]['dir'];
            if ($orderall[0]['column'] > 0) {
                $colsynt   = $orderall[0]['column'];
                $dbcolname = $columnsall[$colsynt]['data'];
                $recordQry->orderBy($dbcolname, $ordtyp);
            } else {
                $recordQry->orderBy('id', $ordtyp);
            }
        }
        $recordAllQry    = $recordQry;
        $recordsTotal    = $recordAllQry->count();
        $recordList      = $recordQry->orderBy('id', 'desc')->offset($start)->limit($length)->get();
        $recordsFiltered = $recordList->count();
        $dataResult      = $recordList;

        return response()->json(["draw" => $draw, "recordsTotal" => $recordsTotal, "recordsFiltered" => $recordsTotal, "data" => $dataResult]);
    }

    public function index()
    {
        return view('admin.driver_trips.list');
    }
    public function edit1(Request $request, $id)
    {
        $getRow = DB::table('booking_management as bm')
            ->leftJoin('driver_management as dm', 'bm.driver_id', '=', 'dm.id')
            ->leftJoin('otp_codes as otp', 'otp.booking_id', '=', 'bm.id')
            ->leftJoin('outstation_package as op', 'op.cartype_id', '=', 'bm.cartype_id')
            ->leftJoin('driver_arrived as da', 'da.booking_id', '=', 'bm.id')
            ->leftJoin('fare_summaries as fs', 'fs.booking_id', '=', 'bm.id')
            ->where('bm.id', $id)
            ->select(
                'bm.*',
                'dm.driver_name',
                'otp.start_km as otp_start_km',
                'otp.end_km as otp_end_km',
                'op.hillsac_price',
                'op.hillsnonac_price',
                'da.total_km',
                'da.start_km',
                'da.end_km',
                'da.driver_arrived_at',
                'da.driver_departed_at',
                'fs.start_time',
                'fs.end_time',
                'fs.total_km_travelled',
                'fs.total_price',
                'fs.extra_discountamount',
                'fs.extra_fair',
                'fs.hills_fare',
                'fs.hills_km',

            )
            ->first();

        $statusOptions = [
            1 => 'Driver started to reach Destination',
            2 => 'Driver Reached customer location',
            3 => 'Driver pick up customer from location',
            4 => 'Driver completed Ride',
            5 => 'cancel ride',

        ];

        return view('admin.driver_trips.editpayment', compact('getRow'));
    }
    public function update1(Request $request, $id)
    {
        DB::beginTransaction();
        try {
            $bookingRow = DB::table('booking_management')->where('id', $id)->first();

            // 1. Basic updates (name, phone, status)
            if ($request->hasAny(['customer_name', 'phone', 'booking_status'])) {
                $updateData = $request->only(['customer_name', 'phone', 'booking_status']);
                DB::table('booking_management')->where('id', $id)->update(array_filter($updateData));
            }

            // 2. Update driver_arrived
            if ($request->hasAny(['total_km', 'start_km', 'end_km', 'driver_departed_at', 'driver_arrived_at', 'otp_start_km']) && $bookingRow) {
                $startKm = $request->filled('start_km') ? $request->start_km : ($request->otp_start_km ?? null);
                $endKm   = $request->filled('end_km') ? $request->end_km : ($request->otp_start_km ?? null);

                $arrivedData = [
                    'start_km' => $startKm,
                    'end_km'   => $endKm,
                    'total_km' => is_numeric($startKm) && is_numeric($endKm) ? $endKm - $startKm : null,
                ];

                if ($request->filled('driver_departed_at')) {
                    $arrivedData['driver_departed_at'] = \Carbon\Carbon::createFromFormat('H:i:s', $request->driver_departed_at)->format('H:i:s');
                }

                if ($request->filled('start_time')) {
                    $arrivedData['driver_arrived_at'] = \Carbon\Carbon::createFromFormat('H:i:s', $request->start_time)->format('H:i:s');
                }

                DB::table('driver_arrived')->updateOrInsert(
                    ['booking_id' => $id, 'driver_id' => $bookingRow->driver_id],
                    array_filter($arrivedData)
                );
            }

            // 3. Update OTP
            if ($request->hasAny(['otp_start_km', 'otp_end_km'])) {
                $otpData = $request->only(['otp_start_km', 'otp_end_km']);
                DB::table('otp_codes')->updateOrInsert(
                    ['booking_id' => $id, 'driver_id' => $bookingRow->driver_id],
                    ['start_km' => $otpData['otp_start_km'] ?? null, 'end_km' => $otpData['otp_end_km'] ?? null]
                );
            }
            if ($request->filled('booking_status')) {
                DB::table('booking_management')->where('id', $id)->update([
                    'booking_status' => $request->input('booking_status'),
                ]);
            }

            // 4. Full Fare Calculation Logic

            $otp = DB::table('otp_codes')->where('booking_id', $id)->first();
            if ($otp && $otp->start_km !== null && $otp->end_km !== null) {
                $traveledKm = round($otp->end_km - $otp->start_km, 2);
                $setting    = DB::table('settings')->where('id', 1)->first();

                $package = DB::table('packages as p')
                    ->join('outstation_package as op', function ($join) use ($bookingRow) {
                        $join->on('p.id', '=', 'op.package_id')
                            ->where('op.cartype_id', $bookingRow->cartype_id)
                            ->where('op.inout_type', $bookingRow->traveltype_id);
                    })
                    ->where('p.traveltype_id', $bookingRow->traveltype_id)
                    ->where('p.km', '<=', $traveledKm)
                    ->orderBy('p.km', 'desc')
                    ->first();

                if (! $package) {
                    $package = DB::table('packages as p')
                        ->join('outstation_package as op', function ($join) use ($bookingRow) {
                            $join->on('p.id', '=', 'op.package_id')
                                ->where('op.cartype_id', $bookingRow->cartype_id)
                                ->where('op.inout_type', $bookingRow->traveltype_id);
                        })
                        ->where('p.traveltype_id', $bookingRow->traveltype_id)
                        ->orderBy('p.km', 'asc')
                        ->first();
                }

                if (! $package) {
                    throw new \Exception('No package found.');
                }

                DB::table('booking_management')->where('id', $id)->update(['package_id' => $package->package_id]);

                $startTime       = Carbon::parse($otp->created_at);
                $endTime         = Carbon::parse($otp->updated_at);
                $durationSeconds = $endTime->diffInSeconds($startTime);
                $durationMinutes = number_format($durationSeconds / 60, 2);
                $durationHr      = $durationMinutes / 60;

                $rate       = $bookingRow->ac_type === 'AC' ? $package->ac_price : $package->nonac_price;
                $perKmRate  = $bookingRow->ac_type === 'AC' ? $package->additionalperkm_ac_price : $package->additionalperkm_nonac_price;
                $includedKm = $package->km;
                $includedHr = $package->free_hours;

                $extraKm     = max(0, $traveledKm - $includedKm);
                $extraKmFare = $extraKm * $perKmRate;

                $extraHr     = max(0, $durationHr - $includedHr);
                $perHrRate   = $package->per_hours_price;
                $extraHrFare = $extraHr * $perHrRate;

                $totalPrice = $rate + $extraKmFare + $extraHrFare;

                // Add hills_fare and extra_fair and discount if any
                $totalPrice += $request->input('hills_fare') ?? 0;
                $totalPrice += $request->input('extra_fair') ?? 0;
                $totalPrice -= $request->input('extra_discountamount') ?? 0;

                // Reward logic (+2 for each ride)
                // $rewardPoints = DB::table('fare_summaries')
                //     ->join('booking_management', 'fare_summaries.booking_id', '=', 'booking_management.id')
                //     ->where('booking_management.phone', $bookingRow->phone)
                //     ->where('booking_management.customer_name', $bookingRow->customer_name)
                //     ->sum('fare_summaries.reward_points') + 2;
                $startTime = \Carbon\Carbon::parse($request->input('start_time'));
                $endTime   = \Carbon\Carbon::parse($request->input('end_time'));

                DB::table('fare_summaries')->updateOrInsert(
                    ['booking_id' => $id],
                    [
                        'driver_id'            => $bookingRow->driver_id,
                        'customer_name'        => $bookingRow->customer_name,
                        'phone'                => $bookingRow->phone,
                        'pickup_location'      => $bookingRow->from_address,
                        'drop_location'        => $bookingRow->to_address,
                        'total_km_travelled'   => $traveledKm,
                        'package_km'           => $includedKm,
                        'extra_km_charged'     => $extraKm,
                        'base_fare'            => $rate,
                        'per_km_charge'        => $perKmRate,
                        'distance_fare'        => $extraKmFare,
                        'hr_fare'              => $extraHrFare,
                        'extra_fair'           => $request->input('extra_fair') ?? 0,
                        'extra_discountamount' => $request->input('extra_discountamount') ?? 0,
                        'hills_fare'           => $request->input('hills_fare') ?? 0,
                        'total_price'          => $totalPrice,
                        'start_time'           => $startTime->format('H:i:s'),
                        'end_time'             => $endTime->format('H:i:s'),
                        'travel_minutes'       => $durationHr,
                        // 'reward_points'      => $rewardPoints,
                        'end_date'             => now()->format('Y-m-d'),
                    ]
                );

            }

            DB::commit();

            if ($request->filled('summary_details') && $request->input('summary_details') == '1') {
                $booking     = DB::table('booking_management')->where('id', $id)->first();
                $fareSummary = DB::table('fare_summaries')->where('booking_id', $id)->first();
                $otpData     = DB::table('otp_codes')->where('booking_id', $id)->first();

                if ($booking && $fareSummary) {
                    $customerPhone = $booking->phone;
                    $driver        = DB::table('driver_management')->where('id', $booking->driver_id)->first();
                    $driverPhone   = $driver->user_name ?? null;

                    $message = "*Vaigai Namma Taxi Ride Summary*\n"
                        . "Customer: {$booking->customer_name}\n"
                        . "From: {$booking->from_address}\n"
                        . "To: {$booking->to_address}\n"
                        . "Trip Start KM: " . ($otpData->start_km ?? '-') . "\n"
                        . "Trip End KM: " . ($otpData->end_km ?? '-') . "\n"
                        . "Total KM Travelled: {$fareSummary->total_km_travelled} KM\n"
                        . "Extra Fare: ₹{$fareSummary->extra_fair}\n"
                        . "Discount: ₹{$fareSummary->extra_discountamount}\n"
                        . "Hills Fare: ₹{$fareSummary->hills_fare}\n"
                        . "Final Total: ₹{$fareSummary->total_price}\n\n"
                        . "Thank you for choosing VaigaiNamma Taxi!";

                    // Send to customer
                    if (! empty($customerPhone)) {
                        $this->sendWelcomeSms($customerPhone, 'text', $message);

                    }

                    // Send to driver
                    if (! empty($driverPhone)) {
                        $this->sendWelcomeSms($driverPhone, 'text', $message);

                    }
                }
            }

            return redirect()->route('admin.DriverTripsManagement-index')->with('success', 'Booking updated and fare calculated.');
        } catch (\Exception $e) {
            DB::rollBack();
            Log::error('Update1 Error: ' . $e->getMessage());
            return back()->with('error', 'Update failed: ' . $e->getMessage());
        }
    }

    public function calculateFare($bookingId, $driverId)
    {
        $otp     = DB::table('otp_codes')->where('booking_id', $bookingId)->first();
        $booking = DB::table('booking_management')
            ->select('id', 'cartype_id', 'ac_type', 'traveltype_id', 'driver_id', 'package_id', 'phone', 'customer_name')
            ->where('id', $bookingId)
            ->first();

        if (! $otp || ! $booking) {
            throw new \Exception('Booking or OTP not found.');
        }

        $traveledKm    = round($otp->end_km - $otp->start_km, 2);
        $cartype_id    = $booking->cartype_id;
        $traveltype_id = $booking->traveltype_id;

        $setting = DB::table('settings')->where('id', 1)->first();

        $package = DB::table('packages as p')
            ->join('outstation_package as op', function ($join) use ($cartype_id, $traveltype_id) {
                $join->on('p.id', '=', 'op.package_id')
                    ->where('op.cartype_id', $cartype_id)
                    ->where('op.inout_type', $traveltype_id);
            })
            ->where('p.traveltype_id', $traveltype_id)
            ->orderBy('p.km', 'desc')
            ->first();

        if (! $package) {
            throw new \Exception('No package found.');
        }

        DB::table('booking_management')->where('id', $bookingId)->update(['package_id' => $package->package_id]);

        $startTime = Carbon::parse($otp->created_at);
        $endTime   = Carbon::parse($otp->updated_at);

        $durationSeconds       = $endTime->diffInSeconds($startTime);
        $travelled_time_in_min = number_format($durationSeconds / 60, 2);
        $travelled_time_in_hr  = $travelled_time_in_min / 60;

        $rate             = $booking->ac_type === 'AC' ? $package->ac_price : $package->nonac_price;
        $additionalKMrate = $booking->ac_type === 'AC' ? $package->additionalperkm_ac_price : $package->additionalperkm_nonac_price;
        $includedKm       = $package->km;
        $includedHr       = $package->free_hours;

        $extraKm       = max(0, $traveledKm - $includedKm);
        $extraFare     = $additionalKMrate * $extraKm;
        $extrahrs      = max(0, $travelled_time_in_hr - $includedHr);
        $perhrcharge   = $package->per_hours_price;
        $extrahrcharge = $extrahrs * $perhrcharge;

        $totalCost = $rate + $extraFare + $extrahrcharge;

        return [
            'totalKm'        => $traveledKm,
            'baseKm'         => $includedKm,
            'extraKm'        => $extraKm,
            'baseFare'       => $rate,
            'extraKmFare'    => $extraFare,
            'extraHourFare'  => $extrahrcharge,
            'total_price'    => $totalCost,
            'start_time'     => $startTime->format('H:i:s'),
            'end_time'       => $endTime->format('H:i:s'),
            'travel_minutes' => $travelled_time_in_hr,
        ];
    }

}
