<?php
namespace App\Http\Controllers\Admin;

use App\Http\Controllers\Admin\ACommonController;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\DB;

class ReportManagementController extends ACommonController
{

    // public function DriverReport(Request $request)
    // {
    //     $query = DB::table('booking_management as bm')
    //         ->join('driver_management as dm', 'bm.driver_id', '=', 'dm.id')
    //         ->leftJoin('otp_codes as oc', 'oc.booking_id', '=', 'bm.id')
    //         ->leftJoin('fare_summaries as fs', 'fs.booking_id', '=', 'bm.id')
    //         ->where('bm.trip_status', 0)
    //         ->where('bm.booking_status', 4)

    //         ->select(
    //             'bm.id as booking_id',
    //             'bm.driver_id',
    //             'dm.driver_name',
    //             'bm.booking_date',
    //             'oc.start_km as otp_start_km',
    //             'oc.end_km as otp_end_km',
    //             'fs.total_km_travelled',
    //             'fs.total_price'
    //         );

    //     // Filter by date range if provided
    //     // if ($request->from_date && $request->to_date) {
    //     //     $query->whereBetween('bm.booking_date', [$request->from_date, $request->to_date]);
    //     // }

    //     $bookings = $query->get();

    //     // Group data per driver
    //     $driverReports = $bookings->groupBy('driver_id')->map(function ($trips, $driverId) {
    //         $totalAmount = $trips->total_price;
    //         $openingKm   = $trips->otp_start_km;
    //         $closingKm   = $trips->otp_end_km;

    //         $tripDetails = $trips->map(function ($trip) {
    //             return [
    //                 'booking_id'   => $trip->booking_id,
    //                 'booking_date' => $trip->booking_date,
    //             ];
    //         });

    //         return [
    //             'driver_id'    => $driverId,
    //             'driver_name'  => $trips->first()->driver_name,
    //             'opening_km'   => $openingKm,
    //             'closing_km'   => $closingKm,
    //             'total_amount' => round($totalAmount, 2),
    //             'trips'        => $tripDetails,
    //         ];
    //     })->values();

    //     // Generate PDF if requested
    //     if ($request->has('download') && $request->download === 'pdf') {
    //         $pdf = Pdf::loadView('admin.report_management.driver_report_pdf', [
    //             'driverReports' => $driverReports,
    //             'from_date'     => $request->from_date,
    //             'to_date'       => $request->to_date,
    //         ]);
    //         return $pdf->download('driver_report.pdf');
    //     }

    //     return view('admin.report_management.driver_report', compact('driverReports'));
    // }
    public function index(Request $request)
    {
        $query = DB::table('booking_management as b')
            ->join('driver_management as d', 'b.driver_id', '=', 'd.id')
            ->select(
                'b.driver_id',
                'd.driver_name',
                DB::raw('MIN(b.start_km) as start_km'),
                DB::raw('MAX(b.end_km) as end_km'),
                DB::raw('SUM(b.total_price) as total_price'),
                DB::raw('DATE(b.booking_date) as trip_date')
            )
            ->groupBy('b.driver_id', 'd.driver_name', DB::raw('DATE(b.booking_date)'));

        // ✅ Filter by from/to date
        if ($request->filled('from_date')) {
            $query->whereDate('b.booking_date', '>=', $request->from_date);
        }

        if ($request->filled('to_date')) {
            $query->whereDate('b.booking_date', '<=', $request->to_date);
        }

        $bookings = $query->get();

        return view('admin.report_management.driver_report', compact('bookings'));
    }

    public function DriverReport(Request $request)
    {
        // Step 1: Fetch all active drivers
        $drivers = DB::table('driver_management')
            ->select('id as driver_id', 'driver_name')
            ->get();

        // Step 2: Fetch all booking data
        $bookings = DB::table('booking_management as bm')
            ->join('driver_management as dm', 'bm.driver_id', '=', 'dm.id')
            ->leftJoin('otp_codes as oc', 'oc.booking_id', '=', 'bm.id')
            ->leftJoin('fare_summaries as fs', 'fs.booking_id', '=', 'bm.id')
            ->leftJoin('trips as t', 't.driver_id', '=', 'bm.driver_id') // use booking_id to get correct trip_date
            ->where('bm.trip_status', 0)
            ->where('bm.booking_status', 4)
            ->select(
                'bm.id as booking_id',
                'bm.driver_id',
                'dm.driver_name',
                't.trip_date',
                'oc.start_km',
                'oc.end_km',
                'fs.total_price'
            )
            ->get();

        // Totals
        $totalAmount = $bookings->sum('total_price');
        $openingKm   = $bookings->min('start_km');
        $closingKm   = $bookings->max('end_km');
        $travelledKm = (is_numeric($openingKm) && is_numeric($closingKm))
        ? max(0, $closingKm - $openingKm)
        : 'N/A';

        // Send all data to blade
        return view('admin.report_management.driver_report', compact(
            'drivers',
            'bookings',
            'totalAmount',
            'openingKm',
            'closingKm',
            'travelledKm'
        ));
    }

    public function CustomerReport(Request $request)
    {
        $query = DB::table('booking_management as bm')
            ->leftJoin('fare_summaries as fs', 'fs.booking_id', '=', 'bm.id')
            ->where('bm.booking_status', 4)
            ->select(
                'bm.id as booking_id',
                'bm.customer_name',
                'bm.phone',
                'bm.from_address',
                'bm.to_address',
                'bm.booking_date',
                'fs.total_km_travelled',
                'fs.total_price'
            )
            ->get();

        return view('admin.report_management.customer_report', compact('query'));
    }

    public function recalculatePayment(Request $request, $driver_id)
    {
        $tripDate = $request->input('trip_date');
        // Get all bookings for the driver
        $bookingData = DB::table('booking_management as bm')
            ->join('packages as p', 'bm.package_id', '=', 'p.id')
            ->where('bm.driver_id', $driver_id)
            ->where('bm.booking_status', 4)
            ->whereDate('bm.booking_date', $tripDate)
            ->select('bm.id as booking_id', 'p.id as package_id')
            ->get();
        $bookingIds = $bookingData->pluck('booking_id');
        $packageIds = $bookingData->pluck('package_id');

        if ($bookingIds->isEmpty()) {
            return back()->with('warning', 'No completed trips found for this driver.');
        }

        // Get KM info from otp_codes
        $otp = DB::table('otp_codes')
            ->whereIn('booking_id', $bookingIds)
            ->select(DB::raw('MIN(start_km) as opening_km'), DB::raw('MAX(end_km) as closing_km'))
            ->first();

        // Get summary values
        $summaries   = DB::table('fare_summaries')->whereIn('booking_id', $bookingIds)->get();
        $extracharge = DB::table('outstation_package')
            ->whereIn('package_id', $packageIds)
            ->select(DB::raw('SUM(hill_km) as total_hill_km'))
            ->first();
        $summary = [
            'driver_id'               => $driver_id,
            'opening_km'              => $otp->opening_km ?? 0,
            'closing_km'              => $otp->closing_km ?? 0,
            'total_km_travelled'      => $summaries->sum('total_km_travelled'),
            'indoor_outdoor'          => $summaries->pluck('indoor_outdoor')->first(),
            'hill_km'                 => $extracharge->total_hill_km ?? 0,
            'waiting_charge'          => $summaries->sum('waiting_charge'),
            'nightfair_amount'        => $summaries->sum('nightfair_amount'),
            'total_price'             => $summaries->sum('total_price'),
            'extra_fair'              => $summaries->sum('extra_fair'),
            'extra_discountamount'    => $summaries->sum('extra_discountamount'),
            'recalculate_finalamount' => (
                $summaries->sum('total_price')
                 + $summaries->sum('extra_fair')
                 - $summaries->sum('extra_discountamount')
            ),
        ];

        $summary['final_amount'] = $summary['base_fare'] + $summary['distance_fare'] + $summary['hr_fare'] + $summary['waiting_charge'] + $summary['nightfair_amount'];

        return view('admin.report_management.recalculate', compact('summary'));
    }

}
