<?php
namespace App\Http\Controllers\Admin;

use App\Http\Controllers\Admin\ACommonController;
use Google\Auth\Credentials\ServiceAccountCredentials;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Facades\Http;

class TestController extends ACommonController
{

    // public function test()
    // {

    //     // $message = "Hi John! Your OTP is 1234 & your code is @#2025";
    //     // $x       = $this->sendWelcomeSms('9790397339', 'text', $message);
    //     // dd($x);

    //     $RideDetails = BookingManagement::where('driver_id', 5)
    //         ->where('booking_status', 4)
    //         ->whereDate('booking_dateTime', Carbon::today())
    //         ->count();

    //     $credentialsPath = storage_path('app/public/firebase/service-account.json');

    //     $scopes = ['https://www.googleapis.com/auth/firebase.messaging'];

    //     $credentials = new ServiceAccountCredentials($scopes, $credentialsPath);

    //     $accessTokenData = $credentials->fetchAuthToken();

    //     if (! isset($accessTokenData['access_token'])) {
    //         return response()->json([
    //             'success'  => false,
    //             'message'  => 'Failed to retrieve access token',
    //             'response' => $accessTokenData,
    //         ], 500);
    //     }

    //     $accessToken = $accessTokenData['access_token'];

    //     $projectId = json_decode(file_get_contents($credentialsPath), true)['project_id'];

    //     $payload = [
    //         'message' => [
    //             'token'        => 'DB0ED72F-5798-4594-9130-1115A9386AC2', // Replace with real device token
    //             'notification' => [
    //                 'title' => 'Hello from Firebase',
    //                 'body'  => 'FCM v1 API working!',
    //             ],
    //         ],
    //     ];

    //     $response = Http::withToken($accessToken)
    //         ->post("https://fcm.googleapis.com/v1/projects/{$projectId}/messages:send", $payload);

    //     return response()->json([
    //         'success'  => $response->successful(),
    //         'message'  => $response->successful() ? 'Notification sent' : 'Failed to send notification',
    //         'response' => $response->json(),
    //     ]);
    // }

    public function test()
    {
        {
            $pickupLat    = "9.8957869";
            $pickupLng    = "78.0609138";
            $radiusKm     = 3;
            $driverTokens = DB::table('driver_management')
                ->whereNotNull('device_id')
                ->where('device_id', '!=', '')
                ->where('device_id', 'not like', '%expo%')
                ->where('online_status', 'online')
                ->whereRaw("
        (
            6371 * acos(
                cos(radians(?)) *
                cos(radians(latitude)) *
                cos(radians(longitude) - radians(?)) +
                sin(radians(?)) *
                sin(radians(latitude))
            )
        ) <= ?
    ", [$pickupLat, $pickupLng, $pickupLat, $radiusKm])
                ->pluck('device_id')
                ->toArray();

            dd($driverTokens);
            exit();
            // Step 1: Define device token and service account path
            $deviceToken        = 'fyI9Z-lcT6iM6eIt71xUjk:APA91bE5NSiMw1tIFMxN91YRnsnxh11PMTWeO9FIKA67UQwXnc0up4N2wcgtd2TDqyIDZ62xruSe_RLeafesUvj1O-Xq21yueSBh0CSBYcXj7iNl07gi5bU';
            $serviceAccountPath = storage_path('app/public/firebase/service-account.json');

            if (! file_exists($serviceAccountPath)) {
                return response()->json([
                    'success' => false,
                    'message' => 'Service account file not found',
                    'path'    => $serviceAccountPath,
                ], 404);
            }

            // Step 2: Get OAuth2 access token
            $credentials = new ServiceAccountCredentials(
                'https://www.googleapis.com/auth/firebase.messaging',
                json_decode(file_get_contents($serviceAccountPath), true)
            );

            $accessToken = $credentials->fetchAuthToken()['access_token'] ?? null;

            if (! $accessToken) {
                return response()->json([
                    'success' => false,
                    'message' => 'Unable to fetch access token',
                ], 500);
            }

            // Step 3: Read project_id from JSON
            $projectId = json_decode(file_get_contents($serviceAccountPath), true)['project_id'];

            // Step 4: Build FCM payload
            $payload = [
                'message' => [
                    'token'        => $deviceToken,
                    'notification' => [
                        'title' => 'Hello from Laravel',
                        'body'  => 'This is a test push using HTTP v1 API 🎉',
                    ],
                    'data'         => [
                        'custom_key' => 'custom_value',
                        'screen'     => 'test_screen',
                    ],
                ],
            ];

            // Step 5: Send FCM request
            $url = "https://fcm.googleapis.com/v1/projects/{$projectId}/messages:send";

            $response = Http::withToken($accessToken)
                ->acceptJson()
                ->post($url, $payload);

            // Step 6: Return result
            if ($response->successful()) {
                return response()->json([
                    'success'  => true,
                    'message'  => 'Notification sent successfully',
                    'response' => $response->json(),
                ]);
            } else {
                return response()->json([
                    'success'  => false,
                    'message'  => 'Failed to send notification',
                    'response' => $response->json(),
                ], 500);
            }
        }
    }

    public function test1()
    {
        $deviceToken = 'dxEPO341QIKV59brVBSMW4:APA91bE3n-9mils4BEbGkjd25ptsUzJlHHeWmfETKocUzMXBrH4sz9QzsjZmISkRALlL0ImgIJ4bmnhqfNJ-la6cKBbPl6wz9o06tK7JgAKLkY5XTQW_SsY'; // must be a valid token from Firebase SDK
        $jsonPath    = storage_path('app/public/firebase/vaigainammataxi-firebase-adminsdk-fbsvc-0298640d7a.json');
        // Load credentials and get OAuth2 token
        $scopes      = ['https://www.googleapis.com/auth/firebase.messaging'];
        $credentials = new ServiceAccountCredentials($scopes, $jsonPath);
        $token       = $credentials->fetchAuthToken()['access_token'];

        // Get your Firebase project ID from the JSON
        $projectId = json_decode(file_get_contents($jsonPath))->project_id;

        $url = "https://fcm.googleapis.com/v1/projects/{$projectId}/messages:send";

        // Notification payload
        $message = [
            'message' => [
                'token'        => $deviceToken,
                'notification' => [
                    // "sound"     => 'alert33762',
                    // "channelId" => 'high-priority',
                    'title' => 'Laravel V1 Push',
                    'body'  => 'Sent using Firebase HTTP v1 API directly!',
                ], 'data' => [
                    'custom_key'  => 'custom_value',
                    'customSound' => 'alert33762.mp3',
                ],
                'android'      => [
                    'notification' => [
                        'sound'      => 'alert33762',
                        'channel_id' => 'high-priority',
                    ],
                ],
                'apns'         => [
                    'payload' => [
                        'aps' => [
                            'sound' => 'alert33762.caf',
                        ],
                    ],
                ],
            ],
        ];

        // Send push
        $response = Http::withToken($token)
            ->withHeaders(['Content-Type' => 'application/json'])
            ->post($url, $message);

        return response()->json([
            'status'   => $response->successful() ? 'success' : 'failed',
            'response' => $response->json(),
        ]);
    }

    public function testolda()
    {

        $firebaseToken = 'dxEPO341QIKV59brVBSMW4:APA91bE3n-9mils4BEbGkjd25ptsUzJlHHeWmfETKocUzMXBrH4sz9QzsjZmISkRALlL0ImgIJ4bmnhqfNJ-la6cKBbPl6wz9o06tK7JgAKLkY5XTQW_SsY'; // Ex: from mobile app
        $serverKey     = 'BAbHFqM95fXZbs4lhsNjNVGg9d9xZIn1jgiuvQoMGWCUOcnM7gLt3FMJckwjLbyIGHWFy4L8gNbnHsfTKEb5ic0';                                                        // From Firebase project settings

        $data = [
            "to"           => $firebaseToken,
            "notification" => [
                "sound"     => 'alert33762',
                "channelId" => 'high-priority',
                "title"     => "Test Notification",
                "body"      => "Hello! This is a test push notification from Laravel.",
            ],
            'data'         => [
                'custom_key'  => 'custom_value',
                'customSound' => 'alert33762.mp3',
            ],
            "priority"     => "high",
        ];

        $response = Http::withHeaders([
            'Authorization' => 'key=' . $serverKey,
            'Content-Type'  => 'application/json',
        ])->post('https://fcm.googleapis.com/fcm/send', $data);

        return response()->json([
            'status'   => 'Notification Sent',
            'response' => $response->json(),
        ]);

        exit();

        $firebaseToken = 'dxEPO341QIKV59brVBSMW4:APA91bE3n-9mils4BEbGkjd25ptsUzJlHHeWmfETKocUzMXBrH4sz9QzsjZmISkRALlL0ImgIJ4bmnhqfNJ-la6cKBbPl6wz9o06tK7JgAKLkY5XTQW_SsY';

        $payload = [
            'to'           => $firebaseToken,
            'notification' => [
                'title' => 'Test Notification',
                'body'  => 'This is a test push notification using Firebase Legacy API',
                'sound' => 'default',
            ],
            'data'         => [
                'custom_key' => 'custom_value',
                'screen'     => 'test_screen',
            ],
        ];

        $response = Http::withHeaders([
            'Authorization' => 'key=' . $serverKey,
            'Content-Type'  => 'application/json',
        ])->post('https://fcm.googleapis.com/fcm/send', $payload); // ✅ Legacy endpoint

        if ($response->successful()) {
            return response()->json([
                'success'  => true,
                'message'  => 'Notification sent successfully',
                'response' => $response->json(),
            ]);
        } else {
            // Log::error('FCM Push Failed', [
            //     'token'    => $firebaseToken,
            //     'response' => $response->body(),
            // ]);
            dd($response);
            return response()->json([
                'success'  => false,
                'message'  => 'Failed to send notification',
                'response' => $response->body(),
            ], 500);
        }
    }

    // public function test()
    // {
    //     $firebaseToken = 'fyI9Z-lcT6iM6eIt71xUjk:APA91bE5NSiMw1tIFMxN91YRnsnxh11PMTWeO9FIKA67UQwXnc0up4N2wcgtd2TDqyIDZ62xruSe_RLeafesUvj1O-Xq21yueSBh0CSBYcXj7iNl07gi5bU';

    //     $payload = [
    //         'to'           => $firebaseToken,
    //         'notification' => [
    //             'title' => 'Test Notification',
    //             'body'  => 'This is a test push notification using Firebase Legacy API',
    //             'sound' => 'default',
    //         ],
    //         'data'         => [
    //             'custom_key' => 'custom_value',
    //             'screen'     => 'test_screen',
    //         ],
    //     ];

    //     $serverKey = config('services.fcm.server_key');

    //     // $response = Http::withHeaders([
    //     //     'Authorization' => 'key=' . $serverKey,
    //     // ])->acceptJson()->asJson()
    //     //     ->post('https://fcm.googleapis.com/v1/projects/vaigainammataxi/messages:send', $payload); // ✅ Correct endpoint

    //     $response = Http::withHeaders([
    //         'Authorization' => 'key=' . $serverKey,
    //     ])->acceptJson()->asJson()
    //         ->post('https://fcm.googleapis.com/fcm/send', $payload); // ✅ Correct endpoint

    //     if ($response->successful()) {
    //         return response()->json([
    //             'success'  => true,
    //             'message'  => 'Notification sent successfully',
    //             'response' => $response->json(),
    //         ]);
    //     } else {
    //         Log::error('FCM Push Failed', [
    //             'token'    => $firebaseToken,
    //             'response' => $response->body(),
    //         ]);

    //         return response()->json([
    //             'success'  => false,
    //             'message'  => 'Failed to send notification',
    //             'response' => $response->body(),
    //         ], 500);
    //     }
    // }

    // public function test()
    // {
    //     $deviceToken = 'fyI9Z-lcT6iM6eIt71xUjk:APA91bE5NSiMw1tIFMxN91YRnsnxh11PMTWeO9FIKA67UQwXnc0up4N2wcgtd2TDqyIDZ62xruSe_RLeafesUvj1O-Xq21yueSBh0CSBYcXj7iNl07gi5bU'; // e.g., dkkdf83...:APA91bHxxxxxxx

    //     // Load your service account JSON
    //     $pathToServiceAccount = storage_path('app/public/firebase/service-account.json');

    //     if (! file_exists($pathToServiceAccount)) {
    //         return response()->json(['error' => 'File not found', 'path' => $pathToServiceAccount], 404);
    //     }

    //     $serviceAccount = json_decode(file_get_contents($pathToServiceAccount), true);

    //     $projectId = $serviceAccount['project_id'];

    //     // Get access token
    //     $client = new GoogleClient();
    //     $client->setAuthConfig($pathToServiceAccount);
    //     $client->addScope('https://www.googleapis.com/auth/firebase.messaging');
    //     $client->fetchAccessTokenWithAssertion();
    //     $accessToken = $client->getAccessToken()['access_token'];

    //     // Construct the FCM message
    //     $message = [
    //         'message' => [
    //             'token'        => $deviceToken,
    //             'notification' => [
    //                 'title' => 'Hello from Laravel',
    //                 'body'  => 'This is a native FCM notification.',
    //             ],
    //             'data'         => [
    //                 'custom_key' => 'custom_value',
    //             ],
    //         ],
    //     ];

    //     // Send the message to FCM HTTP v1 API
    //     $response = Http::withToken($accessToken)
    //         ->post("https://fcm.googleapis.com/v1/projects/{$projectId}/messages:send", $message);

    //     if ($response->successful()) {
    //         return response()->json([
    //             'status'   => 'success',
    //             'message'  => 'Notification sent successfully!',
    //             'response' => $response->json(),
    //         ]);
    //     } else {
    //         return response()->json([
    //             'status'   => 'error',
    //             'message'  => 'Failed to send notification',
    //             'response' => $response->json(),
    //         ]);
    //     }
    // }

    public function test3()
    {

        // $expoPushToken = 'ExponentPushToken[E4SNToLIke2OV1H6Jd6gt5]';

        $expoPushToken = 'ExponentPushToken[UesayyMrgCek6kQm2pHnqj]';

        // $response = Http::post('https://exp.host/--/api/v2/push/send', [
        //     'to'    => $expoPushToken,
        //     'sound' => 'default',
        //     'title' => 'Test Notification from Laravel',
        //     'body'  => 'This is a test notification sent by ExpoPushTestController',
        //     // 'data'  => ['extraData' => 'Some extra data'],
        //     'data'  => [
        //         'customSound' => 'alert-33762.mp3',
        //     ],
        // ]);
        $response = Http::withHeaders([
            'Accept'       => 'application/json',
            'Content-Type' => 'application/json',
        ])->post('https://exp.host/--/api/v2/push/send', [
            'to'       => $expoPushToken,
            'sound'    => 'alert-33762.mp3',
            'priority' => "high",
            'title'    => 'Test Notification from Laravel',
            'body'     => 'This is a test notification sent by ExpoPushTestController',
            'data'     => [
                'customSound' => 'alert-33762.mp3',
            ],
        ]);

        if ($response->successful()) {
            return response()->json([
                'status'   => 'success',
                'message'  => 'Notification sent',
                'response' => $response->json(),
            ]);
        }

        return response()->json([
            'status'   => 'error',
            'message'  => 'Failed to send notification',
            'response' => $response->json(),
        ], 500);
    }

    // public function test3()
    // {
    //     $fcmToken = 'dxEPO341QIKV59brVBSMW4:APA91bE3n-9mils4BEbGkjd25ptsUzJlHHeWmfETKocUzMXBrH4sz9QzsjZmISkRALlL0ImgIJ4bmnhqfNJ-la6cKBbPl6wz9o06tK7JgAKLkY5XTQW_SsY';

    //     $serverKey = config('services.fcm.server_key'); // Make sure this is set in your .env

    //     $response = Http::withHeaders([
    //         'Authorization' => 'key=' . $serverKey,
    //         'Content-Type'  => 'application/json',
    //     ])->post('https://fcm.googleapis.com/fcm/send', [
    //         'to'           => $fcmToken,
    //         'priority'     => 'high',
    //         'notification' => [
    //             'title'              => 'Test Notification from Laravel',
    //             'body'               => 'This is a test notification sent to FCM token',
    //             'sound'              => 'alert33762', // must match android_channel_id
    //             'android_channel_id' => 'high-priority',
    //         ],
    //         'data'         => [
    //             'customSound' => 'alert33762.mp3',
    //             'type'        => 'ride_request',
    //         ],
    //     ]);

    //     if ($response->successful()) {
    //         return response()->json([
    //             'status'   => 'success',
    //             'message'  => 'Notification sent via FCM',
    //             'response' => $response->json(),
    //         ]);
    //     }

    //     return response()->json([
    //         'status'   => 'error',
    //         'message'  => 'Failed to send notification',
    //         'response' => $response->json(),
    //     ], 500);
    // }

    public function test4()
    {
        $bookingId = 10;

        $booking = DB::table('booking_management')
            ->select('id', 'cartype_id', 'ac_type', 'traveltype_id', 'package_id', 'estimated_km')
            ->where('id', $bookingId)
            ->first();

        if (! $booking) {
            throw new \Exception('Booking not found for amount estimation');
        }

        $selectedPackage = DB::table('packages as p')
            ->join('outstation_package as op', function ($join) use ($booking) {
                $join->on('p.id', '=', 'op.package_id')
                    ->where('op.cartype_id', $booking->cartype_id)
                    ->where('op.inout_type', $booking->traveltype_id);
            })
            ->where('p.traveltype_id', $booking->traveltype_id)
            ->where('p.city_id', 0)
            ->where('p.km', '<=', $booking->estimated_km)
            ->orderBy('p.km', 'desc')
            ->select('p.id as package_id', 'p.km as included_km', 'op.ac_price', 'op.nonac_price')
            ->first();

        if (! $selectedPackage) {
            throw new \Exception('No matching package found for estimation.');
        }

        $rate = $booking->ac_type === 'AC' ? $selectedPackage->ac_price : $selectedPackage->nonac_price;

        $includedKm = $selectedPackage->included_km;
        $extraKm    = max(0, $booking->estimated_km - $includedKm);

        $baseFare  = $rate * $includedKm;
        $extraFare = $rate * $extraKm;
        $totalCost = $baseFare + $extraFare;

        // ✅ Update booking record
        DB::table('booking_management')
            ->where('id', $bookingId)
            ->update([
                'estimated_packageid' => $selectedPackage->package_id,
                'estimated_amount'    => $totalCost,
                'updated_at'          => now(),
            ]);

        return response()->json([
            'status'   => 'success',
            'message'  => 'Estimated amount updated',
            'response' => $totalCost,
        ], 200);
    }

    public function test8()
    {
        $setting = DB::table('settings')->where('id', 1)->first();
        // $bookingId = $request->booking_id;
        $data = [
            'cartype_id'    => 2,
            'traveltype_id' => 1,
            'ac_type'       => 'AC',

        ];
        $bookingId  = 3;
        $actualKm   = 20;
        $actualTime = 1;
        $local_type = 1;
        if ($bookingId > 0) {
            $otpRecord = DB::table('otp_codes')
                ->where('booking_id', $bookingId)
                ->select('start_km', 'end_km', 'booking_id', 'start_date', 'end_date')
                ->first();

            if ($otpRecord && $otpRecord->start_km !== null && $otpRecord->end_km !== null) {
                $actualKm = floatval($otpRecord->end_km) - floatval($otpRecord->start_km);

            }
            if ($otpRecord && $otpRecord->start_date !== null && $otpRecord->end_date !== null) {
                $start = \Carbon\Carbon::parse($otpRecord->start_date);
                $end   = \Carbon\Carbon::parse($otpRecord->end_date);

                $actualTime = $end->diffInMinutes($start) / 60;

            }
            $package = DB::table('packages as p')
                ->join('outstation_package as op', function ($join) use ($data) {
                    $join->on('p.id', '=', 'op.package_id')
                        ->where('op.cartype_id', $data['cartype_id'])
                        ->where('op.inout_type', $data['traveltype_id']);
                })
                ->where('p.traveltype_id', $data['traveltype_id'])
                ->where('p.km', '<=', $actualKm)
                ->orderBy('p.km', 'desc')
                ->select('p.id as package_id', 'p.km as included_km', 'p.free_hours as free_hours', 'op.ac_price', 'op.additionalperkm_ac_price', 'op.additionalperkm_nonac_price', 'op.nonac_price', 'op.local_type')
                ->first();

            if (! $package) {

                $package = DB::table('packages as p')
                    ->join('outstation_package as op', function ($join) use ($data) {
                        $join->on('p.id', '=', 'op.package_id')
                            ->where('op.cartype_id', $data['cartype_id'])
                            ->where('op.inout_type', $data['traveltype_id']);
                    })
                    ->where('p.traveltype_id', $data['traveltype_id'])
                    ->orderBy('p.km', 'asc')
                    ->select('p.id as package_id', 'p.km as included_km', 'p.free_hours as free_hours', 'op.ac_price', 'op.additionalperkm_ac_price', 'op.additionalperkm_nonac_price', 'op.nonac_price', 'op.local_type')
                    ->first();

            }
            if ($package->local_type == 2 && $actualKm < 10) {
                $isMinutes = false;

                // Treat estimated_time as minutes if less than 1 hour
                $estimated_minutes = $actualTime;
                if ($actualTime < 1) {
                    $isMinutes         = true;
                    $estimated_minutes = $actualTime * 60; // Convert to minutes
                }

                $baseFare     = 100; // ₹100 up to 3km
                $additionalKm = max(0, $actualKm - 3);

                $additionalRate = $data['ac_type'] === 'AC' ? 22 : 20;
                $extraFare      = $additionalKm * $additionalRate;

                                                         // estimated_time is considered in minutes directly
                $waitingcharge = $estimated_minutes * 2; // ₹2 per minute

                $totalCost = $baseFare + $extraFare + $waitingcharge;

                return [
                    'package_id'          => $package->package_id,
                    'amount'              => $totalCost,
                    'additional_kmrate'   => $additionalRate,
                    'additionalperhrrate' => 0,
                    'extraKm'             => $additionalKm,
                    'waitingcharge'       => $waitingcharge,
                    'baseFare'            => $baseFare,
                    'extraFare'           => $extraFare,
                    'hrcharge'            => 0,

                ];
            }

            $rate             = $data['ac_type'] === 'AC' ? $package->ac_price : $package->nonac_price;
            $additionalKMrate = $data['ac_type'] === 'AC' ? $package->additionalperkm_ac_price : $package->additionalperkm_nonac_price;
            $additionalhrrate = $data['ac_type'] === 'AC' ? $package->additionalperkm_ac_price : $package->additionalperkm_nonac_price;
            $includedKm       = $package->included_km;
            $extraKm          = max(0, $actualKm - $includedKm);

            $baseFare  = $rate;
            $extraFare = $additionalKMrate * $extraKm;
            $hrcharge  = 0;
            if ($actualTime > $package->free_hours) {
                $extrahrs = max(0, $actualTime - $package->free_hours);
                if ($data['traveltype_id'] == 2) {
                    $hrcharge = 0;
                    if ($actualKm > 100) {
                        $hrcharge = $package->above100kmhrcharge;
                    } elseif ($actualKm >= 51) {
                        $hrcharge = $package->below100kmhrcharge;
                    } else {
                        $hrcharge = $package->below50kmhrcharge;
                    }
                } else {
                    $hrcharge = $package->per_hours_price;
                }
            }
            $waitingcharge = 0;
            if ($package->local_type == 2) {
                $allowedwaitingmin    = $includedKm * $setting->waitingminperkm;+
                $estimatedtime_to_min = $actualTime * 60;
                if ($estimatedtime_to_min > $allowedwaitingmin) {
                    $waitingcharge = max(0, $estimatedtime_to_min - $allowedwaitingmin) * $setting->waitingchargepermin;
                }
            }

            $totalCost = $baseFare + $extraFare + $hrcharge + $waitingcharge;

            return [
                'package_id'          => $package->package_id,
                'amount'              => $totalCost,
                'additional_kmrate'   => $additionalKMrate,
                'additionalperhrrate' => $additionalhrrate,
                'extraKm'             => $extraKm,
                'waitingcharge'       => $waitingcharge,
                'baseFare'            => $baseFare,
                'extraFare'           => $extraFare,
                'hrcharge'            => $hrcharge,
                'is_minutes'          => 0,
            ];
        }

    }
}
