<?php
namespace App\Http\Controllers\Admin;

use App\Http\Controllers\Admin\ACommonController;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\DB;

class VehicleManagementController extends ACommonController
{

    public function dataindex(Request $request)
    {

        $recordsTotal    = 0;
        $recordsFiltered = 0;
        $draw            = $request->input('draw', '1');
        $start           = $request->input('start', '0');
        $length          = $request->input('length', '0');
        $columnsall      = $request->input('columns', []);
        $orderall        = $request->input('order', []);
        $dataResult      = [];
        $recordQry       = DB::table('vehicle_management')
            ->join('carbrand_management', 'carbrand_management.id', '=', 'vehicle_management.carbrand_id')
            ->join('cartype_management', 'cartype_management.id', '=', 'vehicle_management.cartype_id')
            ->select(
                'vehicle_management.*',
                'carbrand_management.brand_name as BrandName',
                'cartype_management.car_type as CarType',
            );

        $searchValue = $request->input('search.value');

        if (! empty($searchValue)) {
            $carbrandIds = DB::table('carbrand_management')
                ->where('brand_name', 'like', '%' . $searchValue . '%')
                ->pluck('id');
            $cartypeIds = DB::table('cartype_management')
                ->where('car_type', 'like', '%' . $searchValue . '%')
                ->pluck('id');

            $recordQry->where(function ($query) use ($searchValue, $carbrandIds, $cartypeIds) {
                $query->orWhere('vehicle_management.car_model', 'like', '%' . $searchValue . '%')
                    ->orWhereIn('vehicle_management.cartype_id', $cartypeIds)
                    ->orWhere('vehicle_management.fuel_type', 'like', '%' . $searchValue . '%')
                    ->orWhere('vehicle_management.seat_capacity', 'like', '%' . $searchValue . '%')
                    ->orWhereIn('vehicle_management.carbrand_id', $carbrandIds);
            });
        }

        if ($orderall) {
            $ordtyp = $orderall[0]['dir'];
            if ($orderall[0]['column'] > 0) {
                $colsynt   = $orderall[0]['column'];
                $dbcolname = $columnsall[$colsynt]['data'];
                $recordQry->orderBy($dbcolname, $ordtyp);
            } else {
                $recordQry->orderBy('id', $ordtyp);
            }
        }

        $recordAllQry = $recordQry;
        $recordsTotal = $recordAllQry->count();

        $recordList = $recordQry->orderBy('id', 'desc')
            ->offset($start)->limit($length)->get();
        $recordsFiltered = $recordList->count();
        $dataResult      = $recordList;

        return response()->json(["draw" => $draw, "recordsTotal" => $recordsTotal, "recordsFiltered" => $recordsTotal, "data" => $dataResult]);
    }

    public function index()
    {
        return view('admin.vehicle_management.list');
    }

    public function create()
    {
        $get_carbrand = DB::table('carbrand_management')->get();
        $get_cartype  = DB::table('cartype_management')->get();

        // dd($get_cartype);
        return view('admin.vehicle_management.add', compact('get_carbrand', 'get_cartype'));
    }

    public function store(Request $request)
    {

        try {
            DB::beginTransaction();

            $driverId = DB::table('vehicle_management')->insertGetId([
                'carbrand_id'   => $request->car_brand,
                'car_model'     => $request->car_model,
                'cartype_id'    => $request->car_type,
                'fuel_type'     => $request->fuel_type,
                'seat_capacity' => $request->seat_capacity,
                'status'        => $request->status,
                'created_at'    => now(),
                'updated_at'    => now(),

            ]);

            DB::commit();

            return redirect()->route('admin.VehicleManagement-index')
                ->with('success', 'Vehicle created successfully');

        } catch (\Exception $e) {
            DB::rollBack();
            return redirect()->back()
                ->with('error', 'Error creating driver: ' . $e->getMessage())
                ->withInput();
        }
    }

    public function edit(Request $request, $id)
    {
        $get_carbrand = DB::table('carbrand_management')->get();
        $get_cartype  = DB::table('cartype_management')->get();
        $getRow       = DB::table('vehicle_management')->where('id', $id)->first();

        return view('admin.vehicle_management.edit', compact('getRow', 'get_carbrand', 'get_cartype'));
    }

    public function update(Request $request, $id)
    {
        try {

            DB::beginTransaction();

            $driver = DB::table('vehicle_management')->where('id', $id)->first();

            $updateData = [
                'carbrand_id'   => $request->car_brand,
                'car_model'     => $request->car_model,
                'cartype_id'    => $request->car_type,
                'fuel_type'     => $request->fuel_type,
                'seat_capacity' => $request->seat_capacity,
                'status'        => $request->status,
                'updated_at'    => now(),
            ];

            DB::table('vehicle_management')->where('id', $id)->update($updateData);

            DB::commit();

            return redirect()->route('admin.VehicleManagement-index')
                ->with('success', 'Vehicle updated successfully');
        } catch (\Exception $e) {
            DB::rollBack();
            return redirect()->back()
                ->with('error', 'Error updating driver: ' . $e->getMessage())
                ->withInput();
        }
    }

    public function show($id)
    {
        $getRow       = DB::table('vehicle_management')->where('id', $id)->first();
        $get_carbrand = DB::table('carbrand_management')->where('id', $getRow->carbrand_id)->first();

        return view('admin.vehicle_management.view', compact('getRow', 'get_carbrand'));

    }

    public function destroy($id)
    {
        try {
            DB::beginTransaction();

            $driver = DB::table('vehicle_management')->where('id', $id)->first();
            if (! $driver) {
                return response()->json(['status' => 404, 'message' => 'Driver not found']);
            }

            DB::table('vehicle_management')->where('id', $id)->delete();

            DB::commit();
            return response()->json(['status' => 200, 'message' => 'Deleted successfully']);
        } catch (\Exception $e) {
            DB::rollBack();
            return response()->json(['status' => 500, 'message' => 'Error: ' . $e->getMessage()]);
        }
    }

    public function updateStatus(Request $request)
    {
        $request->validate([
            'id'     => 'required|integer|exists:vehicle_management,id',
            'status' => 'required|boolean',
        ]);

        DB::table('vehicle_management')
            ->where('id', $request->id)
            ->update(['status' => $request->status, 'updated_at' => now()]);

        return response()->json(['message' => 'Status updated successfully']);
    }

}
