<?php
namespace App\Http\Controllers\Api;

use App\Http\Controllers\Controller;
use App\Models\BookingManagement;
use Carbon\Carbon;
use Illuminate\Http\Request;

class ActiveRideController extends Controller
{
    public function activenow(Request $request)
    {

        if ($driver = auth('api_driver')->user()) {

            // Step 1: Update today's active rides to next day
            $activeRides = BookingManagement::where('driver_id', $driver->id)
                ->where('trip_status', 1)
                ->whereDate('booking_dateTime', Carbon::today())
                ->first();

            return response()->json([
                'status' => true,
                'role'   => 'driver',
                'rides'  => $activeRides,
            ]);
        }

        return response()->json([
            'status'  => false,
            'message' => 'Unauthenticated',
        ], 401);

    }
}
