<?php
namespace App\Http\Controllers\Api;

use App\Http\Controllers\Controller;
use Carbon\Carbon;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\DB;

class DriverReportController extends Controller
{

    public function driverEarningsReport(Request $request)
    {
        $driver = auth('api_driver')->user();

        // Get commission percentage from settings
        $commissionSetting = DB::table('settings')->where('id', 1)->value('commission_percentage');
        $commissionRate    = $commissionSetting ? floatval($commissionSetting) : 0;

        // Define periods
        $today      = Carbon::today();
        $startWeek  = Carbon::now()->startOfWeek(); // Monday
        $startMonth = Carbon::now()->startOfMonth();

        // Helper function
        $calculate = function ($fromDate) use ($driver, $commissionRate) {

            $totalTrips = DB::table('booking_management')
                ->where('driver_id', $driver->id)
                ->where('booking_status', 4)
                ->where('deleted_status', 0)
                ->whereDate('booking_date', '>=', $fromDate)->count();

            $query         = DB::table('trips')->where('driver_id', $driver->id)->whereDate('trip_date', '>=', $fromDate);
            $totalEarnings = (clone $query)->sum('amount');
            $commission    = (clone $query)->sum('commission_amount');
            $rowCount      = (clone $query)->sum('trips_count');
            $netAmount     = round($totalEarnings - $commission, 2);

            return [
                'total_trips' => $totalTrips,
                'earnings'    => round($totalEarnings, 2),
                'commission'  => $commission,
                'net_amount'  => number_format((float) $netAmount, 2, '.', ''),
                'rowCount'    => $rowCount,
            ];
        };

        // Calculate for each period
        $daily   = $calculate($today);
        $weekly  = $calculate($startWeek);
        $monthly = $calculate($startMonth);

        return response()->json([
            'status' => true,
            'data'   => [
                'dailyEarnings'   => $daily,
                'weeklyEarnings'  => $weekly,
                'monthlyEarnings' => $monthly,
            ],
        ]);
    }

}
