<?php
namespace App\Http\Controllers\Api;

use App\Http\Controllers\Controller;
use Carbon\Carbon;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\DB;

class DriverLogDetailsController extends Controller
{
    public function driverLogin(Request $request)
    {
        $driverId = auth('api_driver')->id(); // Or use ID from credentials

        // Insert a new login record
        DB::table('driver_logdetails')->insert([
            'driver_id'        => $driverId,
            'driver_logintime' => now(),
            'type'             => 'auto', // or manual
            'created_at'       => now(),
            'updated_at'       => now(),
        ]);

        return response()->json([
            'status'  => true,
            'message' => 'Driver login logged.',

        ]);
    }

    public function driverLogout(Request $request)
    {
        $driverId = auth('api_driver')->id();

        $log = DB::table('driver_logdetails')
            ->where('driver_id', $driverId)
            ->whereNull('driver_logouttime')
            ->latest('driver_logintime')
            ->first();

        if (! $log) {
            return response()->json([
                'status'  => false,
                'message' => 'No active login session found.',
            ]);
        }

        $logoutTime    = Carbon::now();
        $loginTime     = Carbon::parse($log->driver_logintime);
        $diffInSeconds = $loginTime->diffInSeconds($logoutTime);

        $formattedDuration = gmdate('H:i:s', $diffInSeconds); // "02:45:00"
        $decimalHours      = round($diffInSeconds / 3600, 2); // 2.75

        // Update the log record
        DB::table('driver_logdetails')
            ->where('id', $log->id)
            ->update([
                'driver_logouttime'  => $logoutTime,
                'difference_of_logs' => $formattedDuration, // store HH:MM:SS format
                'updated_at'         => now(),
            ]);

        return response()->json([
            'status'        => true,
            'message'       => 'Driver logged out successfully.',
            'duration_time' => $formattedDuration,
            'decimal_hours' => $decimalHours,
        ]);
    }
    // public function getDriverOnlineSummary($driverId, $date = null)
    // {
    //     $query = DB::table('driver_logdetails')
    //         ->where('driver_id', $driverId)
    //         ->whereNotNull('driver_logouttime');

    //     if ($date) {
    //         $query->whereDate('driver_logintime', $date);
    //     }

    //     $logs         = $query->get();
    //     $totalSeconds = 0;

    //     foreach ($logs as $log) {
    //         $login  = Carbon::parse($log->driver_logintime);
    //         $logout = Carbon::parse($log->driver_logouttime);
    //         $totalSeconds += $login->diffInSeconds($logout);
    //     }

    //     return response()->json([
    //         'driver_id'     => $driverId,
    //         'total_time'    => gmdate('H:i:s', $totalSeconds),
    //         'decimal_hours' => round($totalSeconds / 3600, 2),
    //     ]);
    // }

}
