<?php
namespace App\Http\Controllers\Api;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use Illuminate\Support\Carbon;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Facades\Hash;

class ForgetPasswordController extends Controller
{

    public function sendForgotPasswordOtp(Request $request)
    {
        $request->validate([
            'phone' => 'required|digits:10|exists:driver_management,user_name']);

        $otp   = rand(1000, 9999);
        $phone = $request->phone;

        DB::table('driver_forgetpassword')->updateOrInsert(
            ['phone' => $phone],
            [
                'driver_otp' => $otp,
                'expires_at' => Carbon::now()->addMinutes(10),
                'created_at' => now(),
                'updated_at' => now(),
            ]

        );
        $message = "Your ride OTP is: " . $otp;
        $x       = $this->sendWelcomeSms($phone, 'text', $message);

        return response()->json([
            'status'  => true,
            'message' => 'OTP sent to your phone number',
        ]);
    }

    public function verifyForgotPasswordOtp(Request $request)
    {
        $request->validate([
            'phone' => 'required|digits:10',
            'otp'   => 'required|digits:6',
        ]);

        $record = DB::table('driver_forgetpassword')
            ->where('phone', $request->phone)
            ->where('driver_otp', $request->otp)
            ->first();

        if (! $record) {
            return response()->json(['status' => false, 'message' => 'Invalid OTP.']);
        }

        if (Carbon::now()->gt(Carbon::parse($record->expires_at))) {
            return response()->json(['status' => false, 'message' => 'OTP has expired.']);
        }

        return response()->json([
            'status'  => true,
            'message' => 'OTP verified successfully.',
        ]);
    }

    public function resetDriverPassword(Request $request)
    {
        $request->validate([
            'phone'    => 'required|digits:10|exists:driver_management,user_name',
            'password' => 'required|string|min:6|confirmed',
        ]);

        DB::table('driver_management')
            ->where('user_name', $request->phone)
            ->update([
                'password'   => Hash::make($request->password),
                'updated_at' => now(),
            ]);

        DB::table('driver_forgetpassword')->where('phone', $request->phone)->delete();

        return response()->json([
            'status'  => true,
            'message' => 'Password has been successfully updated.',
        ]);
    }
}
