<?php
namespace App\Http\Controllers;

use Carbon\Carbon;
use Illuminate\Foundation\Auth\Access\AuthorizesRequests;
use Illuminate\Foundation\Validation\ValidatesRequests;
use Illuminate\Routing\Controller as BaseController;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Facades\Http;
use Illuminate\Support\Facades\Log;

class Controller extends BaseController
{
    use AuthorizesRequests, ValidatesRequests;

    public $KG_ID          = "21";
    private $whatsAppUrl   = "https://api.qikchat.in/v1/messages";
    private $whatsAppToken = "9VJg-iVtz-4aAd";

    public function sendWelcomeSms($mobileNumber, $type = 'text', $message = '')
    {
        $username = 'MyTagTesting';
        $password = 'MyTagTesting';
        // $type     = 'text';

        $mobileNumber = preg_replace('/\D/', '', $mobileNumber);

        if (! preg_match('/^91\d{10}$/', $mobileNumber)) {
            // If it's exactly 10 digits, add 91
            if (preg_match('/^\d{10}$/', $mobileNumber)) {
                $mobileNumber = '91' . $mobileNumber;
            } else {
                // Invalid format (not 10 digits or not starting with 91)
                Log::warning('Invalid mobile number format: ' . $mobileNumber);
                return false;
            }
        }

        if ($message && $mobileNumber != "") {
            $message = urlencode($message);

            $response = Http::get('https://wchat.mytag.in/send.php', [
                'username' => $username,
                'password' => $password,
                'type'     => $type,
                'message'  => $message,
                'number'   => $mobileNumber,
            ]);
            if ($response->successful()) {
                return true;

            }

        } else {
            Log::error('SMS sending failed', ['response' => 'no mobile / message']);
            return false;
        }

    }
    // $this->sendWelcomeSms($user->phone, 'Hi ' . $user->name . ', your account has been created!');

    public function driverTripDetails($driverId, $date)
    {
        $totalPrice = DB::table('fare_summaries')
            ->where('driver_id', $driverId)
            ->whereDate('end_date', $date)
            ->sum('total_price');

        $commissionPercentage = DB::table('settings')->value('commission_percentage') ?? 0;
        $commissionAmount     = round(($totalPrice * $commissionPercentage) / 100, 2);

        $trip = DB::table('trips')
            ->where('driver_id', $driverId)
            ->whereDate('trip_date', $date)
            ->first();

        if (! $trip) {
            // Insert new trip
            DB::table('trips')->insert([
                'driver_id'             => $driverId,
                'trip_date'             => $date,
                'amount'                => $totalPrice,
                'commission_percentage' => $commissionPercentage,
                'commission_amount'     => $commissionAmount,
                'payment_status'        => 0,
                'created_at'            => now(),
                'updated_at'            => now(),
            ]);
            $tripInserted = true;
        } else {
            // Step 4: Update existing trip
            $newPaymentStatus = 0;

            if ($trip->paid_amount == $commissionAmount) {
                $newPaymentStatus = 2;
            } elseif ($trip->paid_amount > 0 && $trip->paid_amount < $commissionAmount) {
                $newPaymentStatus = 1;
            }

            DB::table('trips')
                ->where('id', $trip->id)
                ->update([
                    'amount'                => $totalPrice,
                    'commission_percentage' => $commissionPercentage,
                    'commission_amount'     => $commissionAmount,
                    'payment_status'        => $newPaymentStatus,
                    'updated_at'            => now(),
                ]);

            $tripInserted = false;
        }

        return response()->json([
            'driver_id'             => $driverId,
            'date'                  => $date,
            'total_price'           => round($totalPrice, 2),
            'commission_percentage' => $commissionPercentage,
            'commission_amount'     => $commissionAmount,
            'trip_inserted'         => $tripInserted,
        ]);
    }

    public function getEndrideAmountAndNewPackage($id)
    {
        $setting = DB::table('settings')->where('id', 1)->first();
        $booking = DB::table('booking_management')->where('id', $id)->where('deleted_status', 0)->first();
        if ($booking) {
            $bookingId       = $booking->id;
            $actualKm        = 0;
            $actualTime      = 0;
            $actualTimeInMin = 0;
            $extraDiscount   = 0;
            $extraKmFare     = 0;
            $extraFare       = 0;
			$WaitingChargeEdit = 0;
            $otp             = DB::table('otp_codes')
                ->where('booking_id', $bookingId)
                ->select('start_km', 'end_km', 'driver_id', 'booking_id', 'start_date', 'end_date')
                ->first();
            if ($otp) {
                $traveledKm    = $totalKm    = round($otp->end_km - $otp->start_km, 2);
                $cartype_id    = $booking->cartype_id;
                $traveltype_id = $booking->traveltype_id;
                $extraDiscount = $booking->extra_discountamount;
                $extraFare     = $booking->extra_fair;
				$WaitingChargeEdit =$booking->waiting_charge_edit;
                // Step 1: Get matching package
                $package = DB::table('packages as p')
                    ->join('outstation_package as op', function ($join) use ($cartype_id, $traveltype_id) {
                        $join->on('p.id', '=', 'op.package_id')
                            ->where('op.cartype_id', $cartype_id)
                            ->where('op.inout_type', $traveltype_id);
                    })
                    ->where('p.traveltype_id', $traveltype_id)
                    ->orderBy('p.km', 'asc')
                    ->select('p.id as package_id', 'op.id as outstation_packid', 'p.km as included_km', 'p.free_hours as free_hours', 'op.ac_price', 'op.additionalperkm_ac_price', 'op.additionalperkm_nonac_price', 'op.nonac_price', 'op.local_type', 'op.per_hours_ac_price', 'op.per_hours_price', 'op.hillsac_price', 'op.hillsnonac_price')
                    ->first();
                // Step 2: Update package_id in booking_management
                if ($package) {
                    DB::table('booking_management')->where('id', $bookingId)->where('deleted_status', 0)->update([
                        'package_id'    => $package->package_id,
                        'traveltype_id' => $traveltype_id,
                    ]);
                }
                $tripInfo = DB::table('otp_codes as oc')
                    ->join('booking_management as bm', 'oc.booking_id', '=', 'bm.id')
                    ->join('driver_management as dm', 'bm.driver_id', '=', 'dm.id')
                    ->join('vehicle_management as vm', 'dm.vehicle_id', '=', 'vm.id')
                    ->join('cartype_management as cm', 'vm.cartype_id', '=', 'cm.id')
                    ->join('packages as pk', 'pk.id', '=', 'bm.package_id')
                    ->select(
                        'bm.customer_name',
                        'bm.phone',
                        'bm.from_address',
                        'bm.to_address',
                        'bm.package_id',
                        'oc.start_km',
                        'oc.end_km',
                        'pk.km as included_km',
                        'cm.car_type',
                        'oc.start_date as start_time',
                        'oc.end_date as end_time'
                    )
                    ->where('oc.booking_id', $bookingId)
                    ->first();
                if ($tripInfo) {
                    $startTime       = Carbon::parse($tripInfo->start_time);
                    $endTime         = Carbon::parse($tripInfo->end_time);
                    $durationSeconds = $endTime->diffInSeconds($startTime);

                    $travelled_time_in_min = number_format($durationSeconds / 60, 2, '.', '');
                    $travelled_time_in_hr  = $travelled_time_in_min / 60;
                    $isMinutes             = false;
                    $package               = DB::table('packages as p')
                        ->join('outstation_package as op', function ($join) use ($cartype_id, $traveltype_id) {
                            $join->on('p.id', '=', 'op.package_id')
                                ->where('op.cartype_id', $cartype_id)
                                ->where('op.inout_type', $traveltype_id);
                        })
                        ->where('p.traveltype_id', $traveltype_id)
                        ->where('p.km', '<=', $traveledKm)
                        ->orderBy('p.km', 'desc')
                        ->select('p.id as package_id', 'op.id as outstation_packid', 'p.km as included_km', 'p.free_hours as free_hours', 'op.ac_price', 'op.additionalperkm_ac_price', 'op.additionalperkm_nonac_price', 'op.nonac_price', 'op.local_type', 'op.per_hours_ac_price', 'op.per_hours_price', 'op.hillsac_price', 'op.hillsnonac_price', 'op.below50kmhrcharge', 'op.below100kmhrcharge', 'op.above100kmhrcharge')
                        ->first();
                    if (! $package) {
                        $package = DB::table('packages as p')
                            ->join('outstation_package as op', function ($join) use ($cartype_id, $traveltype_id) {
                                $join->on('p.id', '=', 'op.package_id')
                                    ->where('op.cartype_id', $cartype_id)
                                    ->where('op.inout_type', $traveltype_id);
                            })
                            ->where('p.traveltype_id', $traveltype_id)
                            ->orderBy('p.km', 'asc')
                            ->select('p.id as package_id', 'op.id as outstation_packid', 'p.km as included_km', 'p.free_hours as free_hours', 'op.ac_price', 'op.additionalperkm_ac_price', 'op.additionalperkm_nonac_price', 'op.nonac_price', 'op.local_type', 'op.per_hours_ac_price', 'op.per_hours_price', 'op.hillsac_price', 'op.hillsnonac_price', 'op.below50kmhrcharge', 'op.below100kmhrcharge', 'op.above100kmhrcharge')
                            ->first();
                    }
                    if ($package && $package->local_type == 2 && $travelled_time_in_min > $setting->localtripmaxmin) {
                        $package = DB::table('packages as p')
                            ->join('outstation_package as op', function ($join) use ($cartype_id, $traveltype_id) {
                                $join->on('p.id', '=', 'op.package_id')
                                    ->where('op.cartype_id', $cartype_id)
                                    ->where('op.inout_type', $traveltype_id);
                            })
                            ->where('p.traveltype_id', $traveltype_id)
                            ->where('op.local_type', '!=', 2)
                            ->orderBy('p.km', 'asc')
                            ->select('p.id as package_id', 'op.id as outstation_packid', 'p.km as included_km', 'p.free_hours as free_hours', 'op.ac_price', 'op.additionalperkm_ac_price', 'op.additionalperkm_nonac_price', 'op.nonac_price', 'op.local_type', 'op.per_hours_ac_price', 'op.per_hours_price', 'op.hillsac_price', 'op.hillsnonac_price', 'op.below50kmhrcharge', 'op.below100kmhrcharge', 'op.above100kmhrcharge')
                            ->first();
                    } else if ($traveltype_id == 1) {
                        $maxindoorPack = DB::table('packages as p')
                            ->join('outstation_package as op', function ($join) use ($cartype_id, $traveltype_id) {
                                $join->on('p.id', '=', 'op.package_id')
                                    ->where('op.cartype_id', $cartype_id)
                                    ->where('op.inout_type', $traveltype_id);
                            })->max('p.km');
                        // dd($maxindoorPack);
                    }
                    DB::table('booking_management')->where('id', $bookingId)->where('deleted_status', 0)->update(['package_id' => $package->package_id, 'traveltype_id' => $traveltype_id]);
                    $rate             = $booking->ac_type === 'AC' ? $package->ac_price : $package->nonac_price;
                    $additionalKMrate = $booking->ac_type === 'AC' ? $package->additionalperkm_ac_price : $package->additionalperkm_nonac_price;
                    $additionalhrrate = $booking->ac_type === 'AC' ? $package->per_hours_ac_price : $package->per_hours_price;
                    $includedKm       = $package->included_km;
                    $includedHr       = $package->free_hours;
                    $extraKm          = max(0, $traveledKm - $includedKm);
                    $extrahrs         = 0;
                    $baseFare         = $rate;
                    $extraKmFare      = $additionalKMrate * $extraKm;
                    $hrcharge         = 0;
                    $extrahrcharge    = 0;
                    $perhrcharge      = 0;
                    if ($travelled_time_in_hr > $includedHr) {
                        $extrahrs = max(0, $travelled_time_in_hr - $includedHr);
                        // $extrahrs = ceil($travelled_time_in_hr - $includedHr);
                        if ($traveltype_id == 2) {
                            if ($traveledKm > 100) {
                                $perhrcharge = $package->above100kmhrcharge;
                            } elseif ($traveledKm >= 51) {
                                $perhrcharge = $package->below100kmhrcharge;
                            } else {
                                $perhrcharge = $package->below50kmhrcharge;
                            }
                        } else {
                            $perhrcharge = $package->per_hours_price;
                        }
                        $extrahrcharge = $extrahrs * $perhrcharge;
                    }
                    $waitingcharge = 0;
                    if ($package->local_type == 2) {
                        $extrahrcharge        = 0;
                        $isMinutes            = true;
                        $allowedwaitingmin    = $traveledKm * $setting->waitingminperkm;
                        $estimatedtime_to_min = $travelled_time_in_hr * 60;
                        if ($estimatedtime_to_min > $allowedwaitingmin) {
                            $extramins     = max(0, $estimatedtime_to_min - $allowedwaitingmin);
                            $extrahrs      = $extramins / 60;
                            $waitingcharge = $extramins * $setting->waitingchargepermin;
                        }
                    }
                    // todo
                    /*
                    $hills calculate + price add
                    */

                    $totalCost = $baseFare + $extraKmFare + $extrahrcharge + $waitingcharge + $extraFare + $WaitingChargeEdit;
                    $totalCost = $totalCost - $extraDiscount;

                    if ($package) {
                        {
                            DB::table('booking_management')->where('id', $id)->update(['trip_status' => $package->package_id, 'outstation_packid' => $package->outstation_packid]);
                        }
                        $result = [
                            'package_id'          => $package->package_id,
                            'outstation_packid'   => $package->outstation_packid,
                            'package_km'          => $includedKm,
                            'amount'              => $totalCost,
                            'additional_kmrate'   => $additionalKMrate,
                            'additionalperhrrate' => $perhrcharge,
                            'totalKm'             => $traveledKm,
                            'baseKm'              => $includedKm,
                            'extraKm'             => $extraKm,
                            'totalTime'           => $travelled_time_in_hr,
                            'freehours'           => $includedHr,
                            'baseFare'            => $baseFare,
                            'extraFare'           => $extraFare,
                            'extraKmFare'         => $extraKmFare,
                            'extraHour'           => $extrahrs,
                            'extraHourFare'       => $extrahrcharge,
                            'waitingcharge'       => $waitingcharge,
                            'extraDiscount'       => $extraDiscount,
                            'is_minutes'          => $isMinutes ? 1 : 0,
                        ];
                    }

                    return $result;
                } else {
                    echo "tripInfo error";
                    exit();
                }
            } else {
                echo "otp error";
                exit();
            }
        } else {
            echo "otp error";
            exit();
        }

    }

    public function updateDriverTripSummary($driverId, $date)
    {
        $baseQuery = DB::table('fare_summaries')
            ->where('driver_id', $driverId)
            ->whereDate('end_date', $date);
        $totalPrice           = (clone $baseQuery)->sum('total_price');
        $num_of_trips         = (clone $baseQuery)->count();
        $commissionPercentage = DB::table('settings')->value('commission_percentage') ?? 0;
        $commissionAmount     = round(($totalPrice * $commissionPercentage) / 100, 2);
        $trip                 = DB::table('trips')
            ->where('driver_id', $driverId)
            ->whereDate('trip_date', $date)
            ->first();
        if (! $trip) {
            // Insert new trip
            DB::table('trips')->insert([
                'driver_id'             => $driverId,
                'trip_date'             => $date,
                'amount'                => $totalPrice,
                'commission_percentage' => $commissionPercentage,
                'commission_amount'     => $commissionAmount,
                'trips_count'           => $num_of_trips,
                'paid_amount'           => 0,
                'pending_amount'        => $commissionAmount,
                'payment_status'        => 0,
                'created_at'            => now(),
                'updated_at'            => now(),
            ]);
        } else {
            $newPaymentStatus = 0;
            if ($trip->paid_amount == $commissionAmount) {
                $newPaymentStatus = 2; // Fully Paid
            } elseif ($trip->paid_amount > 0 && $trip->paid_amount < $commissionAmount) {
                $newPaymentStatus = 1; // Partially Paid
            }
            DB::table('trips')
                ->where('id', $trip->id)
                ->update([
                    'amount'                => $totalPrice,
                    'commission_percentage' => $commissionPercentage,
                    'commission_amount'     => $commissionAmount,
                    'trips_count'           => $num_of_trips,
                    'payment_status'        => $newPaymentStatus,
                    'updated_at'            => now(),
                ]);
        }
    }

    public function formatMinutesToHours($totalMinutes)
    {
        $hours   = floor($totalMinutes / 60);
        $minutes = $totalMinutes % 60;

        $hrText  = $hours > 0 ? $hours . 'hr' : '';
        $minText = $minutes > 0 ? ' ' . $minutes . 'min' : '';

        return trim($hrText . $minText);
    }

/*
    function formatMinutesToHours(totalMinutes) {
    const hours = Math.floor(totalMinutes / 60);
    const minutes = totalMinutes % 60;

    const hrText = hours > 0 ? hours + ' hr' : '';
    const minText = minutes > 0 ? ' ' + minutes + ' min' : '';

    return (hrText + minText).trim();
}*/

    public function sendWhatsAppCustomerOtp($msgdata)
    {   

        $templateName = 'customer_booking_num';
        $parameters   = [];

        $parameters[] = [
            'type' => 'text',
            'text' => (isset($msgdata['otp']) && $msgdata['otp']) ? $msgdata['otp'] : "",
        ];

        $parameters[] = [
            'type' => 'text',
            'text' => (isset($msgdata['driver_name']) && $msgdata['driver_name']) ? $msgdata['driver_name'] : "",
        ];

        $parameters[] = [
            'type' => 'text',
            'text' => (isset($msgdata['driver_phone']) && $msgdata['driver_phone']) ? $msgdata['driver_phone'] : "",
        ];

        $parameters[] = [
            'type' => 'text',
            'text' => (isset($msgdata['vehicle_num']) && $msgdata['vehicle_num']) ? $msgdata['vehicle_num'] : "",
        ];

        if (isset($msgdata['to_mobile']) && $msgdata['to_mobile'] != "") {
            $data = [
                "to_contact" => "+91" . $msgdata['to_mobile'],
                "type"       => "template",
                "template"   => [
                    "name"       => $templateName,
                    "language"   => "en",
                    "components" => [
                        [
                            "type"       => "body",
                            'parameters' => $parameters,
                        ],
                    ],
                ],
            ];

            $payload = json_encode($data);

            $ch = curl_init($this->whatsAppUrl);
            curl_setopt($ch, CURLOPT_HTTPHEADER, [
                'Content-Type: application/json',
                'QIKCHAT-API-KEY: ' . $this->whatsAppToken,
            ]);
            curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
            curl_setopt($ch, CURLOPT_POSTFIELDS, $payload);
            curl_setopt($ch, CURLOPT_POST, true);

            $response = curl_exec($ch);

            if (curl_errno($ch)) {
                return ['msg' => curl_error($ch), 'status' => 0];
                //return 'Curl error: ' . curl_error($ch);
            }

            curl_close($ch);
            return ['msg' => 'success', 'status' => 1, 'data' => json_decode($response, true)];

        } else {
            return ['msg' => 'No Contact Number', 'status' => 0];
        }

    }

    public function sendWhatsAppDriverRideDetailOutstation($msgdata)
    {

        $templateName = 'driver_ride_detail_outstation';
        $parameters   = [];

        $parameters[] = [
            'type' => 'text',
            'text' => (isset($msgdata['customer_name']) && $msgdata['customer_name']) ? $msgdata['customer_name'] : "",
        ];

        $parameters[] = [
            'type' => 'text',
            'text' => (isset($msgdata['phone']) && $msgdata['phone']) ? $msgdata['phone'] : "",
        ];

        $parameters[] = [
            'type' => 'text',
            'text' => (isset($msgdata['from_address']) && $msgdata['from_address']) ? $msgdata['from_address'] : "",
        ];

        $parameters[] = [
            'type' => 'text',
            'text' => (isset($msgdata['to_address']) && $msgdata['to_address']) ? $msgdata['to_address'] : "",
        ];

        if (isset($msgdata['to_mobile']) && $msgdata['to_mobile'] != "") {
            $data = [
                "to_contact" => "+91" . $msgdata['to_mobile'],
                "type"       => "template",
                "template"   => [
                    "name"       => $templateName,
                    "language"   => "en",
                    "components" => [
                        [
                            "type"       => "body",
                            'parameters' => $parameters,
                        ],
                    ],
                ],
            ];

            $payload = json_encode($data);

            $ch = curl_init($this->whatsAppUrl);
            curl_setopt($ch, CURLOPT_HTTPHEADER, [
                'Content-Type: application/json',
                'QIKCHAT-API-KEY: ' . $this->whatsAppToken,
            ]);
            curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
            curl_setopt($ch, CURLOPT_POSTFIELDS, $payload);
            curl_setopt($ch, CURLOPT_POST, true);

            $response = curl_exec($ch);

            if (curl_errno($ch)) {
                return ['msg' => curl_error($ch), 'status' => 0];
                //return 'Curl error: ' . curl_error($ch);
            }

            curl_close($ch);
            return ['msg' => 'success', 'status' => 1, 'data' => json_decode($response, true)];

        } else {
            return ['msg' => 'No Contact Number', 'status' => 0];
        }

    }
    public function sendWhatsAppDriverRideDetailIndoor($msgdata)
    {

        $templateName = 'driver_ride_detail_indoor';
        $parameters   = [];

        $parameters[] = [
            'type' => 'text',
            'text' => (isset($msgdata['customer_name']) && $msgdata['customer_name']) ? $msgdata['customer_name'] : "",
        ];

        $parameters[] = [
            'type' => 'text',
            'text' => (isset($msgdata['phone']) && $msgdata['phone']) ? $msgdata['phone'] : "",
        ];

        $parameters[] = [
            'type' => 'text',
            'text' => (isset($msgdata['from_address']) && $msgdata['from_address']) ? $msgdata['from_address'] : "",
        ];

        $parameters[] = [
            'type' => 'text',
            'text' => (isset($msgdata['to_address']) && $msgdata['to_address']) ? $msgdata['to_address'] : "",
        ];

        if (isset($msgdata['to_mobile']) && $msgdata['to_mobile'] != "") {
            $data = [
                "to_contact" => "+91" . $msgdata['to_mobile'],
                "type"       => "template",
                "template"   => [
                    "name"       => $templateName,
                    "language"   => "en",
                    "components" => [
                        [
                            "type"       => "body",
                            'parameters' => $parameters,
                        ],
                    ],
                ],
            ];

            $payload = json_encode($data);

            $ch = curl_init($this->whatsAppUrl);
            curl_setopt($ch, CURLOPT_HTTPHEADER, [
                'Content-Type: application/json',
                'QIKCHAT-API-KEY: ' . $this->whatsAppToken,
            ]);
            curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
            curl_setopt($ch, CURLOPT_POSTFIELDS, $payload);
            curl_setopt($ch, CURLOPT_POST, true);

            $response = curl_exec($ch);

            if (curl_errno($ch)) {
                return ['msg' => curl_error($ch), 'status' => 0];
                //return 'Curl error: ' . curl_error($ch);
            }

            curl_close($ch);
            return ['msg' => 'success', 'status' => 1, 'data' => json_decode($response, true)];

        } else {
            return ['msg' => 'No Contact Number', 'status' => 0];
        }

    }
    public function sendWhatsAppDriverAndCustomerRideSummary($msgdata)
    {

        $templateName = 'ride_summary_detail_num1';
        $parameters   = [];

        $parameters[] = [
            'type' => 'text',
            'text' => (isset($msgdata['customer_name']) && $msgdata['customer_name']) ? $msgdata['customer_name'] : " ",
        ];

        $parameters[] = [
            'type' => 'text',
            'text' => (isset($msgdata['from_address']) && $msgdata['from_address']) ? $msgdata['from_address'] : " ",
        ];

        $parameters[] = [
            'type' => 'text',
            'text' => (isset($msgdata['to_address']) && $msgdata['to_address']) ? $msgdata['to_address'] : " ",
        ];

        $parameters[] = [
            'type' => 'text',
            'text' => (isset($msgdata['start_km']) && $msgdata['start_km']) ? $msgdata['start_km'] : " ",
        ];
        $parameters[] = [
            'type' => 'text',
            'text' => (isset($msgdata['end_km']) && $msgdata['end_km']) ? $msgdata['end_km'] : " ",
        ];
        $parameters[] = [
            'type' => 'text',
            'text' => (isset($msgdata['total_km_travelled']) && $msgdata['total_km_travelled']) ? $msgdata['total_km_travelled'] : " ",
        ];

		$parameters[] = [
            'type' => 'text',
            'text' => (isset($msgdata['start_time']) && $msgdata['start_time']) ? $msgdata['start_time'] : " ",
        ];
		$parameters[] = [
            'type' => 'text',
            'text' => (isset($msgdata['end_time']) && $msgdata['end_time']) ? $msgdata['end_time'] : " ",
        ];
        $parameters[] = [
            'type' => 'text',
            'text' => (isset($msgdata['travel_minutes']) && $msgdata['travel_minutes']) ? $msgdata['travel_minutes'] : " ",
        ];
        $parameters[] = [
            'type' => 'text',
            'text' => (isset($msgdata['extra_fair']) && $msgdata['extra_fair']) ? $msgdata['extra_fair'] : " ",
        ];
        $parameters[] = [
            'type' => 'text',
            'text' => (isset($msgdata['extra_discountamount']) && $msgdata['extra_discountamount']) ? $msgdata['extra_discountamount'] : " ",
        ];
        $parameters[] = [
            'type' => 'text',
            'text' => (isset($msgdata['hills_fare']) && $msgdata['hills_fare']) ? $msgdata['hills_fare'] : " ",
        ];
        $parameters[] = [
            'type' => 'text',
            'text' => (isset($msgdata['total_price']) && $msgdata['total_price']) ? $msgdata['total_price'] : " ",
        ];
        $parameters[] = [
            'type' => 'text',
            'text' => (isset($msgdata['reward_points']) && $msgdata['reward_points']) ? $msgdata['reward_points'] : " ",
        ];

        // echo "<pre>";
        // print_r($parameters);
        // exit();

        if (isset($msgdata['to_mobile']) && $msgdata['to_mobile'] != "") {
            $data = [
                "to_contact" => "+91" . $msgdata['to_mobile'],
                "type"       => "template",
                "template"   => [
                    "name"       => $templateName,
                    "language"   => "en",
                    "components" => [
                        [
                            "type"       => "body",
                            'parameters' => $parameters,
                        ],
                    ],
                ],
            ];

            $payload = json_encode($data);

            $ch = curl_init($this->whatsAppUrl);
            curl_setopt($ch, CURLOPT_HTTPHEADER, [
                'Content-Type: application/json',
                'QIKCHAT-API-KEY: ' . $this->whatsAppToken,
            ]);
            curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
            curl_setopt($ch, CURLOPT_POSTFIELDS, $payload);
            curl_setopt($ch, CURLOPT_POST, true);

            $response = curl_exec($ch);

            if (curl_errno($ch)) {
                return ['msg' => curl_error($ch), 'status' => 0];
                //return 'Curl error: ' . curl_error($ch);
            }

            curl_close($ch);
            return ['msg' => 'success', 'status' => 1, 'data' => json_decode($response, true)];

        } else {
            return ['msg' => 'No Contact Number', 'status' => 0];
        }

    }

    public function sendWhatsAppDriverPaymentDetail($msgdata)
    {

        $templateName = 'driver_new_trip_alert';
        $parameters   = [];

        $parameters[] = [
            'type' => 'text',
            'text' => (isset($msgdata['otp']) && $msgdata['otp']) ? $msgdata['otp'] : "",
        ];

        $parameters[] = [
            'type' => 'text',
            'text' => (isset($msgdata['driver_name']) && $msgdata['driver_name']) ? $msgdata['driver_name'] : "",
        ];

        $parameters[] = [
            'type' => 'text',
            'text' => (isset($msgdata['driver_phone']) && $msgdata['driver_phone']) ? $msgdata['driver_phone'] : "",
        ];

        // $parameters[] = [
        //     'type' => 'text',
        //     'text' => (isset($msgdata['vehicle_num']) && $msgdata['vehicle_num']) ? $msgdata['vehicle_num'] : "",
        // ];

        if (isset($msgdata['to_mobile']) && $msgdata['to_mobile'] != "") {
            $data = [
                "to_contact" => "+91" . $msgdata['to_mobile'],
                "type"       => "template",
                "template"   => [
                    "name"       => $templateName,
                    "language"   => "en",
                    "components" => [
                        [
                            "type"       => "body",
                            'parameters' => $parameters,
                        ],
                    ],
                ],
            ];

            $payload = json_encode($data);

            $ch = curl_init($this->whatsAppUrl);
            curl_setopt($ch, CURLOPT_HTTPHEADER, [
                'Content-Type: application/json',
                'QIKCHAT-API-KEY: ' . $this->whatsAppToken,
            ]);
            curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
            curl_setopt($ch, CURLOPT_POSTFIELDS, $payload);
            curl_setopt($ch, CURLOPT_POST, true);

            $response = curl_exec($ch);

            if (curl_errno($ch)) {
                return ['msg' => curl_error($ch), 'status' => 0];
                //return 'Curl error: ' . curl_error($ch);
            }

            curl_close($ch);
            return ['msg' => 'success', 'status' => 1, 'data' => json_decode($response, true)];

        } else {
            return ['msg' => 'No Contact Number', 'status' => 0];
        }

    }

}
