<?php
namespace App\Http\Controllers;

use Illuminate\Foundation\Auth\Access\AuthorizesRequests;
use Illuminate\Foundation\Validation\ValidatesRequests;
use Illuminate\Routing\Controller as BaseController;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Facades\Http;
use Illuminate\Support\Facades\Log;

class Controller extends BaseController
{
    use AuthorizesRequests, ValidatesRequests;

    public $KG_ID = "21";

    public function sendWelcomeSms($mobileNumber, $type = 'text', $message = '')
    {
        $username = 'MyTagTesting';
        $password = 'MyTagTesting';
        // $type     = 'text';

        $mobileNumber = preg_replace('/\D/', '', $mobileNumber);

        if (! preg_match('/^91\d{10}$/', $mobileNumber)) {
            // If it's exactly 10 digits, add 91
            if (preg_match('/^\d{10}$/', $mobileNumber)) {
                $mobileNumber = '91' . $mobileNumber;
            } else {
                // Invalid format (not 10 digits or not starting with 91)
                Log::warning('Invalid mobile number format: ' . $mobileNumber);
                return false;
            }
        }

        if ($message && $mobileNumber != "") {
            $message = urlencode($message);

            $response = Http::get('https://wchat.mytag.in/send.php', [
                'username' => $username,
                'password' => $password,
                'type'     => $type,
                'message'  => $message,
                'number'   => $mobileNumber,
            ]);
            if ($response->successful()) {
                return true;

            }

        } else {
            Log::error('SMS sending failed', ['response' => 'no mobile / message']);
            return false;
        }

    }
    // $this->sendWelcomeSms($user->phone, 'Hi ' . $user->name . ', your account has been created!');

    public function driverTripDetails($driverId, $date)
    {
        $totalPrice = DB::table('fare_summaries')
            ->where('driver_id', $driverId)
            ->whereDate('end_date', $date)
            ->sum('total_price');

        $commissionPercentage = DB::table('settings')->value('commission_percentage') ?? 0;
        $commissionAmount     = round(($totalPrice * $commissionPercentage) / 100, 2);

        $trip = DB::table('trips')
            ->where('driver_id', $driverId)
            ->whereDate('trip_date', $date)
            ->first();

        if (! $trip) {
            // Insert new trip
            DB::table('trips')->insert([
                'driver_id'             => $driverId,
                'trip_date'             => $date,
                'amount'                => $totalPrice,
                'commission_percentage' => $commissionPercentage,
                'commission_amount'     => $commissionAmount,
                'payment_status'        => 0,
                'created_at'            => now(),
                'updated_at'            => now(),
            ]);
            $tripInserted = true;
        } else {
            // Step 4: Update existing trip
            $newPaymentStatus = 0;

            if ($trip->paid_amount == $commissionAmount) {
                $newPaymentStatus = 2;
            } elseif ($trip->paid_amount > 0 && $trip->paid_amount < $commissionAmount) {
                $newPaymentStatus = 1;
            }

            DB::table('trips')
                ->where('id', $trip->id)
                ->update([
                    'amount'                => $totalPrice,
                    'commission_percentage' => $commissionPercentage,
                    'commission_amount'     => $commissionAmount,
                    'payment_status'        => $newPaymentStatus,
                    'updated_at'            => now(),
                ]);

            $tripInserted = false;
        }

        return response()->json([
            'driver_id'             => $driverId,
            'date'                  => $date,
            'total_price'           => round($totalPrice, 2),
            'commission_percentage' => $commissionPercentage,
            'commission_amount'     => $commissionAmount,
            'trip_inserted'         => $tripInserted,
        ]);
    }
}
