<?php
namespace App\Http\Middleware;

use App\Helpers\LogHelper;
use Closure;
use Illuminate\Http\Request;

class LogApiHit
{
    public function handle(Request $request, Closure $next)
    {
        $startTime = microtime(true); // ⏱ Start time

        // Proceed with the request and get response
        $response = $next($request);

        $endTime  = microtime(true);                          // ⏱ End time
        $duration = round(($endTime - $startTime) * 1000, 2); // in ms

        // Get response data safely
        $responseData = method_exists($response, 'getContent') ? json_decode($response->getContent(), true) : null;

        LogHelper::logApiHit('API Hit', [
            'url'           => $request->fullUrl(),
            'method'        => $request->method(),
            'ip'            => $request->ip(),
            'user'          => auth()->user()?->id,
            'request_data'  => $request->all(),
            'response_data' => $responseData,
            'duration_ms'   => $duration,
        ]);

        return $response;
    }
}
