@extends('admin.layout.adminmaster')

@section('style1')
<style>
    .form-section {
        margin-bottom: 20px;
    }
</style>
@endsection

@section('contentarea')
<div class="container mt-4">
    <h4>Edit Booking</h4>

    <form action="{{ route('admin.BookingManagement-update1', [$getRow->id]) }}" method="POST" enctype="multipart/form-data">
        @csrf
        @method('PUT')

        {{-- Customer Info --}}
        <div class="row g-3 form-section">
            <div class="col-md-3">
                <label class="form-label">Customer Name</label>
                <input type="text" name="customer_name" class="form-control" value="{{ $getRow->customer_name ?? '' }}">
            </div>
            <div class="col-md-3">
                <label class="form-label">Phone</label>
                <input type="text" name="phone" class="form-control" value="{{ $getRow->phone ?? '' }}">
            </div>
 <div class="mb-3 col-md-3">
    <label class="form-label">Vehicle A/C Type</label>
    <div class="mt-2 d-flex align-items-center gap-4">
        <div class="form-check form-check-inline">
            <input 
                type="radio" 
                class="form-check-input" 
                id="Ac" 
                name="ac_type" 
                value="AC"
                {{ (isset($getRow) && $getRow->ac_type == 'AC') ? 'checked' : '' }}>
            <label class="form-check-label" for="Ac">A/C</label>
        </div>

        <div class="form-check form-check-inline">
            <input 
                type="radio" 
                class="form-check-input" 
                id="NonAc" 
                name="ac_type" 
                value="Non-AC"
                {{ (isset($getRow) && $getRow->ac_type == 'Non-AC') ? 'checked' : '' }}>
            <label class="form-check-label" for="NonAc">Non A/C</label>
        </div>
    </div>
</div>
<div class="mb-3 col-md-3">
    <label for="traveltype" class="form-label">Package Type</label>
    <select id="traveltype" class="form-select" name="traveltype_id">
        <option value="" disabled selected>--- Select travel type ---</option>
        <option value="1" {{ isset($getRow) && $getRow->traveltype_id == 1 ? 'selected' : '' }}>Indoor Package</option>
        <option value="2" {{ isset($getRow) && $getRow->traveltype_id == 2 ? 'selected' : '' }}>Outdoor Package</option>
    </select>
</div>

        </div>

          <div class="row g-3 form-section">
           
               <div class="col-md-4">
                <label class="form-label">Departure Start KM</label>
                <input type="number" name="start_km" class="form-control" value="{{ $getRow->start_km ?? '' }}">
            </div>
           


            <div class="col-md-4">
                <label class="form-label">Trip Start KM</label>
                <input type="number" name="otp_start_km" class="form-control" value="{{ $getRow->otp_start_km ?? '' }}">
            </div>
  

             <div class="col-md-4">
                <label class="form-label">Trip End KM</label>
                <input type="number" name="otp_end_km" class="form-control" value="{{ $getRow->otp_end_km ?? '' }}">
            </div>
              </div>
         <div class="row g-3 form-section">
          
     <div class="col-md-4">
    <label class="form-label">Departure Start Time</label>
    <input type="datetime-local" name="driver_departed_at" step="1" class="form-control"   value="{{ isset($getRow->driver_departed_at) ? \Carbon\Carbon::parse($getRow->driver_departed_at)->format('Y-m-d\TH:i:s') : '' }}">
</div>
<div class="col-md-4">
    <label class="form-label">Trip Start Date & Time</label>
    <input type="datetime-local" name="start_date" class="form-control"
        value="{{ isset($getRow->start_date) ? \Carbon\Carbon::parse($getRow->start_date)->format('Y-m-d\TH:i:s') : '' }}">
</div>

<div class="col-md-4">
    <label class="form-label">Trip End Date & Time</label>
    <input type="datetime-local" name="end_date" class="form-control"
        value="{{ isset($getRow->end_date) ? \Carbon\Carbon::parse($getRow->end_date)->format('Y-m-d\TH:i:s') : '' }}">
</div>

          
            <div class="row g-3 form-section">
            <div class="col-md-3">
                <label class="form-label">Trip Total KM</label>
                <input type="number" name="total_km" class="form-control" value="{{ $getRow->total_km  ?? '' }}">
            </div>
             <div class="col-md-3">
                <label class="form-label">Extra Discount</label>
                <input type="number" name="extra_discountamount" class="form-control" value="{{ $getRow->extra_discountamount ?? '' }}">
            </div>
            <div class="col-md-3">
                <label class="form-label">Extra Fare</label>
                <input type="number" name="extra_fair" class="form-control" value="{{ $getRow->extra_fair ?? '' }}">
            </div>
 			<div class="col-md-3">
                <label class="form-label">Waiting Charge</label>
                <input type="number" name="waiting_charge_edit" class="form-control" value="{{ $getRow->waiting_charge_edit ?? '' }}">
            </div>
            </div>
      
     
                   
        <div class="row g-3 form-section">
       <div class="col-md-4">
                <label class="form-label">Total Price</label>
                <input type="number" name="total_price" class="form-control" value="{{ $getRow->total_price ?? '' }}"  >
            </div>

            <div class="col-md-4">
                <label class="form-label">Hills Price Type</label>
                <select name="hills_price_type" class="form-select">
                    <option value="" disabled selected>-- Select --</option>
                    <option value="ac" {{ $getRow->hillsac_price === 'ac' ? 'selected' : '' }}>Hills AC</option>
                    <option value="nonac" {{ $getRow->hillsnonac_price === 'nonac' ? 'selected' : '' }}>Hills Non-AC</option>
                </select>
            </div>

             <div class="col-md-4">
                <label class="form-label">Hills KM</label>
                <input type="number" name="hills_km" class="form-control" value="{{ $getRow->hills_km ?? '' }}"  >
            </div>
        </div>
          <div class="row g-3 form-section">
    
            <div class="col-md-4">
                <label class="form-label">Hills Fare</label>
                <input type="number" name="hills_fare" class="form-control" value="{{ $getRow->hills_fare ?? '' }}">
            </div>

            <div class="col-md-4 form-label" style="padding-top:35px;">
        <input class="form-check-input" type="checkbox" id="Summary_details" name="summary_details" value="1">
        <label class="form-check-label form-label" for="Summary_details">
            Summary Details send to Customer
        </label>
    
      </div>
      <div class="col-md-4">
                <label class="form-label">Status</label>	 
        <select name="booking_status" class="form-select">
            <option value="0" {{ $getRow->booking_status == '0' ? 'selected' : '' }}>Not Yet Started</option>
            <option value="1" {{ $getRow->booking_status == '1' ? 'selected' : '' }}>Driver started to reach Destination</option>
            <option value="2" {{ $getRow->booking_status == '2' ? 'selected' : '' }}>Driver Reached customer location</option>
            <option value="3" {{ $getRow->booking_status == '3' ? 'selected' : '' }}>Driver pick up customer from location</option>
            <option value="4" {{ $getRow->booking_status == '4' ? 'selected' : '' }}>Driver completed Ride</option>
            <option value="5" {{ $getRow->booking_status == '5' ? 'selected' : '' }}>Cancel Ride</option>
        </select>
      </div>
         
            </div>
  
        <div class="form-section text-end">
            <button type="submit" class="btn btn-primary">Update Payment</button>
        </div>
 
    </form>
</div>
@endsection
